package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class AddnewQuotationJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5109816447061463208L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private String quotationDateTime;
	private String quotationNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private String addSideBarJs;

	private Map<String,String> rateTypeList = new LinkedHashMap<String,String>();
	private String rateType;
	 private String discountType;
		
		private Map<String,String> discountTypeList = new HashMap<String,String>();
		
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	quotationDateTime = dateFormat.format(d);
	         	
	         	this.getRateTypeList().put("INCLUDEGST", "WITH GST");
	        	this.getRateTypeList().put("EXCLUDEGST", "WITH-OUT GST");
	        	
	        	this.setRateType("EXCLUDEGST");
	        	
	        	this.setDefaultValue("CREDIT");
	        	this.setAddSideBarJs("FALSE");
	        	
	        	discountTypeList.put("", "Select Discount Type");
			      discountTypeList.put("By Quantity", "By Quantity");
			      discountTypeList.put("By Percentage", "By Percentage");
			      discountTypeList.put("By Direct Amount", "By Direct Amount");
					this.setDiscountType((String) this.getSessionMap().get("discountTypeForBilling"));
					
	        	
	        	try {
					taxList = GetListResource.GetTaxList();
					
				} catch (IOException e) {
					
				}
	        	
	        	unitList = GetListResource.GetUnitList();
	        	quotationNumber = "1";
	        	
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    		session=ServletActionContext.getRequest().getSession(false); 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		 String crusherId = (String) session.getAttribute("crusherId");
					String crusherCode = (String) session.getAttribute("crusherCode");

	    		try
	    		{
	    			connection = GetDBConnection.getDBConnection(db);
	    			sql = "select customer_name "
	    					+ "from crusher_customer_master where customer_name like '%CASH%' "
	    					+ "AND crusher_id = ? "
	    			        + "AND crusher_code = ?";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId); 
	    			preparedStatement.setString(2, crusherCode); 

	    			resultSet = preparedStatement.executeQuery();
	    			
	    			while(resultSet.next())
	    			{
	    				setCustomerName(resultSet.getString(1));
	    			}
	    			
	    			
	    				setQuotationNumber("NA");
	    				
	    				
	    			result = "success";
	    			
	    		} catch (SQLException e) {
	    			
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
	    		} catch (IOException e) {
	    			result = "error";
	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close();} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close();}catch (SQLException e) {}
	    			}
	    			
	    		}
	        		      
	        	
	        }

	        return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	

	public String getQuotationDateTime() {
		return quotationDateTime;
	}

	public void setQuotationDateTime(String quotationDateTime) {
		this.quotationDateTime = quotationDateTime;
	}


	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	


	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}

	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateType() {
		return rateType;
	}

	public void setRateType(String rateType) {
		this.rateType = rateType;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getQuotationNumber() {
		return quotationNumber;
	}

	public void setQuotationNumber(String quotationNumber) {
		this.quotationNumber = quotationNumber;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public String getDiscountType() {
		return discountType;
	}

	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}

	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}

	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}

	
	
	
	
	
	
	
	
}

