package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class AddVehicleTripEntryJsp extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7179161895044085231L;
	private HttpSession session;
	private String tripDate;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	

	
	private String vehicleId;
	private String customerName;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private Float transportationCharges;
	private String tripDateHidden;
	private String addSideBarJs;
	private SessionMap<String,Object> sessionMap;  
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	
	        	this.setAddSideBarJs("FALSE");
	        	if(this.getTripDateHidden()== null || this.getTripDateHidden().equals(""))
	        	{
	        		Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
		        	this.setTripDate(dateFormat.format(d));
	        		
	        	}
	        	else
	        	{
	        		this.setTripDate(this.getTripDateHidden());
	        	
	        	}
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    		session=ServletActionContext.getRequest().getSession(false); 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "crusher_vehicle_details_master "
	    					+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	    			
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					
					resultSet = preparedStatement.executeQuery();


	    			while(resultSet.next())
	    			{
	    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
	    			}
	    			
	    			
	    			if(resultSet != null)
	    			{
	    				resultSet.close();
	    				resultSet = null;
	    			}
	    			
	    			if(preparedStatement != null)
	    			{
	    				preparedStatement.close();
	    				preparedStatement = null;
	    				
	    			}
	    			
	    			sql = "SELECT "
	    					+ "vt.trip_entry_id,"
	    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
	    					+ "vt.vehicle_id,"
	    					+ "vd.vehicle_make,"
	    					+ "vd.vehicle_registration_number,"
	    					+ "vt.customer_id,"
	    					+ "vt.customer_name,"
	    					+ "vt.product_name,"
	    					+ "vt.product_quantity,"
	    					+ "vt.vehicle_km_start,"
	    					+ "vt.vehicle_km_end,"
	    					+ "vt.trip_total_km,"
	    					+ "vt.trip_start_from,"
	    					+ "vt.trip_end_to,"
	    					+ "vt.total_trip_count "
	    					+ "FROM "
	    					+ "crusher_vehicle_trip_master as vt "
	    					+ "INNER JOIN "
	    					+ "crusher_vehicle_details_master as vd "
	    					+ "ON "
	    					+ "vd.vehicle_id = vt.vehicle_id "
	    					+ "WHERE "
	    					+ "trip_date = STR_TO_DATE(?,'%d-%m-%Y') "
	    					+ "AND "
	    					+ "vd.crusher_id = ? "
							+ "AND "
							+ "vd.crusher_code = ? "
							+ "AND "
	    					+ "vt.crusher_id = ? "
							+ "AND "
							+ "vt.crusher_code = ? "
	    			        + "ORDER BY "
	    					+ "vt.trip_entry_id";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			
	    			preparedStatement.setString(1, tripDate);
	    			preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					
	    			resultSet = preparedStatement.executeQuery();
	    			
	    			int rowCount = 0;
	    			
	    			resultSet.last();
	    			
	    			rowCount = resultSet.getRow();
	    			
	    			resultSet.beforeFirst();
	    			
	    			if(rowCount > 0)
	    			{
	    				while(resultSet.next())
	    				{
	    				
	    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
	    					
	    					entryDAO.setTripId(resultSet.getString(1));
	    					entryDAO.setTripDate(resultSet.getString(2));
	    					entryDAO.setTripVehicleMake(resultSet.getString(4));
	    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
	    					entryDAO.setCustomerId(resultSet.getString(6));
	    					entryDAO.setCustomerName(resultSet.getString(7));
	    					entryDAO.setMaterialName(resultSet.getString(8));
	    					entryDAO.setMaterialVolume(resultSet.getString(9));
	    					entryDAO.setVehicleKmStart(resultSet.getString(10));
	    					entryDAO.setVehicleKmEnd(resultSet.getString(11));
	    					entryDAO.setTripTotalKm(resultSet.getString(12));
	    					entryDAO.setTripFrom(resultSet.getString(13));	    					
	    					entryDAO.setTripTo(resultSet.getString(14));	    					
	    					entryDAO.setTotalTrips(resultSet.getString(15));
	    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
	    					this.getVehicleTripEntryInfoList().add(entryDAO);
	    					
	    				}
	    				
	    				
	    			}
	    			else
	    			{
	    				
	    				sql = "SELECT "
		    					+ "vt.trip_entry_id,"
		    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
		    					+ "vt.vehicle_id,"
		    					+ "vd.vehicle_make,"
		    					+ "vd.vehicle_registration_number,"
		    					+ "vt.customer_id,"
		    					+ "vt.customer_name,"
		    					+ "vt.product_name,"
		    					+ "vt.product_quantity,"
		    					+ "vt.vehicle_km_start,"
		    					+ "vt.vehicle_km_end,"
		    					+ "vt.trip_total_km,"
		    					+ "vt.trip_start_from,"
		    					+ "vt.trip_end_to,"
		    					+ "vt.total_trip_count "
		    					+ "FROM "
		    					+ "crusher_vehicle_trip_other_master as vt "
		    					+ "INNER JOIN "
		    					+ "crusher_vehicle_details_master as vd "
		    					+ "ON "
		    					+ "vd.vehicle_id = vt.vehicle_id "
		    					+ "WHERE "
		    					+ "trip_date = STR_TO_DATE(?,'%d-%m-%Y') "
		    					+ "AND "
		    					+ "vd.crusher_id = ? "
								+ "AND "
								+ "vd.crusher_code = ? "
								+ "AND "
		    					+ "vt.crusher_id = ? "
								+ "AND "
								+ "vt.crusher_code = ? "
		    			        + "ORDER BY "
		    					+ "vt.trip_entry_id";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, tripDate);
		    			preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						
		    			resultSet = preparedStatement.executeQuery();
		    			
		    			 rowCount = 0;
		    			
		    			resultSet.last();
		    			
		    			rowCount = resultSet.getRow();
		    			
		    			resultSet.beforeFirst();
		    			
		    			if(rowCount > 0)
		    			{
		    				while(resultSet.next())
		    				{
		    				
		    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
		    					
		    					entryDAO.setTripId(resultSet.getString(1));
		    					entryDAO.setTripDate(resultSet.getString(2));
		    					entryDAO.setTripVehicleMake(resultSet.getString(4));
		    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
		    					entryDAO.setCustomerId(resultSet.getString(6));
		    					entryDAO.setCustomerName(resultSet.getString(7));
		    					entryDAO.setMaterialName(resultSet.getString(8));
		    					entryDAO.setMaterialVolume(resultSet.getString(9));
		    					entryDAO.setVehicleKmStart(resultSet.getString(10));
		    					entryDAO.setVehicleKmEnd(resultSet.getString(11));
		    					entryDAO.setTripTotalKm(resultSet.getString(12));
		    					entryDAO.setTripFrom(resultSet.getString(13));	    					
		    					entryDAO.setTripTo(resultSet.getString(14));	    					
		    					entryDAO.setTotalTrips(resultSet.getString(15));
		    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
		    				
		    					this.getVehicleTripEntryInfoList().add(entryDAO);
		    					
		    				}
		    				
		    				
		    			}
		    			else
		    			{
		    				addActionError(this.getText("message.error.vehicleTripEntryListIsEmpty"));
		    			}
	    				
	    				
	    			}
	    			
	    			
	    			this.setVehicleId("");
       				this.setCustomerName("");
       				this.setMaterialName("");
       				this.setMaterialVolume(0.0F);
       				this.setKmStart(0.0F);
       				this.setKmEnd(0.0F);
       				this.setTotalKm(0.0F);
       				this.setTripFrom("");
       				this.setTripTo("");
       				this.setTotalTrips(0);
       				this.setTransportationCharges(0.0F);
       				this.setAddSideBarJs("FALSE");
	    			result = "success";
	    		}
	        catch (SQLException e) {
    			
    			result = "error";
    			e.printStackTrace();
    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.SomethingWentWrong"));
    		} catch (IOException e) {
    			result = "error";
    			e.printStackTrace();
    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.SomethingWentWrong"));
    		}finally {
    			if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet = null;
					} catch (SQLException e) {
						
					}
				}
    			if(preparedStatement != null)
    			{
    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
    			}
    			if(connection != null)
    			{
    				
    				try {connection.close(); connection = null;}catch (SQLException e) {}
    			}
    			
    		}
        		      
        	
        }

	      
	        
	   return result;
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getTripDate() {
		return tripDate;
	}
	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public Map<String, String> getVehicleList() {
		return vehicleList;
	}
	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}
	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}
	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}
	
	public String getVehicleId() {
		return vehicleId;
	}
	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}
	public String getCustomerName() {
		return customerName;
	}
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
	public String getMaterialName() {
		return materialName;
	}
	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}
	public Float getMaterialVolume() {
		return materialVolume;
	}
	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}
	public Float getKmStart() {
		return kmStart;
	}
	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}
	public Float getKmEnd() {
		return kmEnd;
	}
	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}
	public Float getTotalKm() {
		return totalKm;
	}
	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}
	public String getTripFrom() {
		return tripFrom;
	}
	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}
	public String getTripTo() {
		return tripTo;
	}
	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}
	public Integer getTotalTrips() {
		return totalTrips;
	}
	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}
	
	
	public Float getTransportationCharges() {
		return transportationCharges;
	}
	public void setTransportationCharges(Float transportationCharges) {
		this.transportationCharges = transportationCharges;
	}
	public String getTripDateHidden() {
		return tripDateHidden;
	}
	public void setTripDateHidden(String tripDateHidden) {
		this.tripDateHidden = tripDateHidden;
	}
	
	
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0; 
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}


	
}
