package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class AddSuppPaymentDetailsJsp  extends ActionSupport  implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 7347721420936177311L;
	private HttpSession session;
	private String key;
	private String paymentDate;
	private String supplierId;
	private String supplierName;
	private String supplierMobile;
	private String debtAmount;
	private SessionMap<String,Object> sessionMap;
	
	
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	
	
	
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	private String addSideBarJs;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	this.setAddSideBarJs("FALSE");
	        	
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	        	setPaymentDate(dateFormat.format(d));
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		paymentTypeList.add("CASH");
	        	paymentTypeList.add("UPI");
	        	paymentTypeList.add("RTGS");
	        	paymentTypeList.add("NEFT");
	        	paymentTypeList.add("CHEQUE");
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       	
					connection = GetDBConnection.getDBConnection(db);
					this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
		       		
	       			
	       			String supplierId = EncryptionDecryption.decrypt(key);
	       			
	       			float openingBal = 0.0F;
	       			PreparedStatement getOpeningBalPSMT = null;
       				ResultSet getOpeningBalRs = null;
       				String getOpeningBalSQL = "SELECT "
       						+ "opening_balance "
       						+ "FROM "
       						+ "crusher_supplier_close_open_bal_master "
       						+ "WHERE "
       						+ "supplier_id = ? "
       						+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
       				
       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
       				
       				getOpeningBalPSMT.setString(1, supplierId);
       				getOpeningBalPSMT.setString(2, crusherId);
       				getOpeningBalPSMT.setString(3, crusherCode);
    				
       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
       				
       				if(getOpeningBalRs.next())
       				{
       					openingBal = getOpeningBalRs.getFloat(1);
       				}
       				else
       				{
       					openingBal = 0.0F;
       				}
       				
       				if(getOpeningBalRs != null)
       				{
       					getOpeningBalRs.close();
       					getOpeningBalRs = null;
       				}
       				if(getOpeningBalPSMT != null)
       				{
       					getOpeningBalPSMT.close();
       					getOpeningBalPSMT = null;
       				}

	       		
	       			
	       			sql = "SELECT "
	       					+ "supplier_id,"
	       					+ "supplier_name,"
	       					+ "contact_number,"
	       					+ "supplier_address "
	       					+ "FROM "
	       					+ "crusher_supplier_master "
	       					+ "WHERE "
	       					+ "supplier_id =  ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			resultSet.last();
	       			
	       			int rowCount = resultSet.getRow();
	       			
	       			resultSet.beforeFirst();
	       			
	       			if(rowCount > 0)
	       			{
	       				if(resultSet.next())
	       					
	       				{
	       				this.setSupplierId(resultSet.getString(1));
	       				this.setSupplierName(resultSet.getString(2));
	       				this.setSupplierMobile(resultSet.getString(3));
	       				this.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
	       				
	       				

						float floatTotalPurchaseAmt = 0.0F;
	       				float floatTotalAmountPaid = 0.0F;
	       				float floatTotalBalanceAmt = 0.0F;
	       				
	       				PreparedStatement getTotalPurchasePSMT = null;
	       				ResultSet getTotalPurchaseRS = null;
	       				
	       				String getTotalPurchaseSQL = "SELECT "
	       						+ "SUM(purchase_total_amount),"
	       						+ "SUM(purchase_amount_paid) "
	       						+ "FROM "
	       						+ "crusher_purchase_master "
	       						+ "WHERE "
	       						+ "supplier_id = ? "
	       						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				getTotalPurchasePSMT = connection.prepareStatement(getTotalPurchaseSQL);
	       				
	       				getTotalPurchasePSMT.setString(1, resultSet.getString(1));
	       				getTotalPurchasePSMT.setString(2, crusherId);
	       				getTotalPurchasePSMT.setString(3, crusherCode);
        				
	       				getTotalPurchaseRS = getTotalPurchasePSMT.executeQuery();
	       				
	       				if(getTotalPurchaseRS.next())
	       				{
	       					floatTotalPurchaseAmt = getTotalPurchaseRS.getFloat(1);
	       					floatTotalAmountPaid = getTotalPurchaseRS.getFloat(2);
	       					
	       					
	       				}
	       				
	       				
	       				PreparedStatement getSuppAmtPaidPSMT = null;
	       				ResultSet getSuppAmtPaidRS = null;
	       				String getSuppAmtPaidSQL = "SELECT "
	       						+ "SUM(amount) "
	       						+ "FROM "
	       						+ "crusher_supplier_payment_details_master "
	       						+ "WHERE "
	       						+ "supplier_id = ? "
	       						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				getSuppAmtPaidPSMT = connection.prepareStatement(getSuppAmtPaidSQL);
	       				
	       				
	       				
	       				getSuppAmtPaidPSMT.setString(1, resultSet.getString(1));
	       				getSuppAmtPaidPSMT.setString(2, crusherId);
	       				getSuppAmtPaidPSMT.setString(3, crusherCode);
        				
	       				getSuppAmtPaidRS = getSuppAmtPaidPSMT.executeQuery();
	       				
	       				
	       				
	       				if(getSuppAmtPaidRS.next())
	       				{
	       					floatTotalAmountPaid = floatTotalAmountPaid + getSuppAmtPaidRS.getFloat(1);
	       				}
	       				
	       				floatTotalBalanceAmt = floatTotalPurchaseAmt - floatTotalAmountPaid;
	       				
	       			
	       				
	       				this.setDebtAmount(""+(floatTotalBalanceAmt+openingBal));
	       				if(getSuppAmtPaidRS != null)
	       				{
	       					getSuppAmtPaidRS.close();
	       					getSuppAmtPaidRS = null;
	       				}
	       				
	       				if(getSuppAmtPaidPSMT != null)
	       				{
	       					getSuppAmtPaidPSMT.close();
	       					getSuppAmtPaidPSMT = null;
	       				}
	       				
	       				
	       				
	       				if(getTotalPurchaseRS != null)
	       				{
	       					getTotalPurchaseRS.close();
	       					getTotalPurchaseRS = null;
	       				}
	       				
	       				if(getTotalPurchasePSMT != null)
	       				{
	       					getTotalPurchasePSMT.close();
	       					getTotalPurchasePSMT = null;
	       				}
	       				
	       				result = "success";
	       				
	       			}
	       			else
	       			{
	       				result = "error";
	       				
	       				addActionError(this.getText("message.error.urlTemperedDetailsNotFoundForSpecifiedInformation"));
	       			}
	       			
	       			}else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.endOfResultset"));
	       			}
	       			
			        } catch (SQLException e) {
		    			e.printStackTrace();
		    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
		    		} catch (IOException e) {
		    			
		    			e.printStackTrace();
		    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
				    }finally {
		    			if(resultSet != null)
						{
							try {
								resultSet.close(); resultSet= null;
							} catch (SQLException e) {
								
							}
						}
		    			if(preparedStatement != null)
		    			{
		    				try {preparedStatement.close();preparedStatement = null;} catch (SQLException e) {}
		    			}
		    			if(connection != null)
		    			{
		    				
		    				try {connection.close(); connection = null;}catch (SQLException e) {}
		    			}
    			
    		}
        	
        }
        
        return result;
}


public HttpSession getSession() {
	return session;
}


public void setSession(HttpSession session) {
	this.session = session;
}


public String getKey() {
	return key;
}


public void setKey(String key) {
	this.key = key;
}


public String getPaymentDate() {
	return paymentDate;
}


public void setPaymentDate(String paymentDate) {
	this.paymentDate = paymentDate;
}


public String getSupplierId() {
	return supplierId;
}


public void setSupplierId(String supplierId) {
	this.supplierId = supplierId;
}


public String getSupplierName() {
	return supplierName;
}


public void setSupplierName(String supplierName) {
	this.supplierName = supplierName;
}


public String getSupplierMobile() {
	return supplierMobile;
}


public void setSupplierMobile(String supplierMobile) {
	this.supplierMobile = supplierMobile;
}


public String getDebtAmount() {
	return debtAmount;
}


public void setDebtAmount(String debtAmount) {
	this.debtAmount = debtAmount;
}


public static long getSerialversionuid() {
	return serialVersionUID;
}




public Map<String, String> getAccountList() {
	return accountList;
}


public void setAccountList(Map<String, String> accountList) {
	this.accountList = accountList;
}


public List<String> getPaymentTypeList() {
	return paymentTypeList;
}


public void setPaymentTypeList(List<String> paymentTypeList) {
	this.paymentTypeList = paymentTypeList;
}


public String getAddSideBarJs() {
	return addSideBarJs;
}


public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}


public List<String> getBankList() {
	return bankList;
}


public void setBankList(List<String> bankList) {
	this.bankList = bankList;
}


public List<String> getBranchList() {
	return branchList;
}


public void setBranchList(List<String> branchList) {
	this.branchList = branchList;
}


public List<String> getChequeList() {
	return chequeList;
}


public void setChequeList(List<String> chequeList) {
	this.chequeList = chequeList;
}

}
