package com.stonecrusher.jspRedirect;


import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.SiteDetailsDAO;
import com.stonecrusher.db.GetDBConnection;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;


public class AddNewSiteJsp extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 9183790911519546384L;
	private SessionMap<String,Object> sessionMap; 
	private ArrayList<SiteDetailsDAO> siteList = new ArrayList<SiteDetailsDAO>();
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null)
			{ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        
	         	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "site_code,"
							+ "site_name,"
							+ "site_address,"
							+ "DATE_FORMAT(site_created_on_date,'%d-%m-%Y') "
							+ "FROM "
							+ "side_details_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					
					resultSet = preparedStatement.executeQuery();
					
					int k = 1;
					
					while(resultSet.next())
					{
						SiteDetailsDAO dao = new SiteDetailsDAO();
						
						dao.setSiteCode(resultSet.getString(1));
						dao.setSiteName(resultSet.getString(2));
						dao.setSiteAddress(resultSet.getString(3));
						dao.setSiteSrNo(""+k);
						
						
						k++;
						
						
						this.getSiteList().add(dao);
					}
					
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
				
	        	result = SUCCESS;
	        }
	        return result;
	}
	
	
	public ArrayList<SiteDetailsDAO> getSiteList() {
		return siteList;
	}


	public void setSiteList(ArrayList<SiteDetailsDAO> siteList) {
		this.siteList = siteList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



