package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;

public class AddNewPurchaseJsp extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7394269699056188612L;
	private HttpSession session;
	private String purchaseId;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private String purchaseDateTime;
	private boolean addToStock;
	private String addSideBarJs;
	private String paymentDefaultValue;
	private String accountId;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private SessionMap<String,Object> sessionMap;

	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
	       		
	        	
	        	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        	this.setRateTyprDefaultValue("INCLUDINGGST");
	       
	        	this.setPaymentDefaultValue("CREDIT");
	        	
	        	try {
					taxList = GetListResource.GetTaxList();
					
				} catch (IOException e) {
					
				}
	        	
	        	unitList = GetListResource.GetUnitList();
	        
	    		
	    			
	    			Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
		        	setPurchaseDateTime(dateFormat.format(d));
		        	
	    		
	    			setPurchaseId("NA");
	    				
	    				
	    			this.setAddSideBarJs("FALSE");
	    			
	    			setAddToStock(true);
	    			result  = "success";
	    		
	        	
	        }
	        
	        return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getPurchaseId() {
		return purchaseId;
	}

	public void setPurchaseId(String purchaseId) {
		this.purchaseId = purchaseId;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public String getPurchaseDateTime() {
		return purchaseDateTime;
	}

	public void setPurchaseDateTime(String purchaseDateTime) {
		this.purchaseDateTime = purchaseDateTime;
	}

	public boolean isAddToStock() {
		return addToStock;
	}

	public void setAddToStock(boolean addToStock) {
		this.addToStock = addToStock;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	
	public String getPaymentDefaultValue() {
		return paymentDefaultValue;
	}

	public void setPaymentDefaultValue(String paymentDefaultValue) {
		this.paymentDefaultValue = paymentDefaultValue;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}

	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0; 
	}

	
	
	
	

}
