package com.stonecrusher.jspRedirect;


import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;


public class AddLaborPaymentDetailsFromViewJsp extends ActionSupport implements SessionAware, ServletResponseAware, ServletRequestAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 3608496783707850193L;
	private String fromDate;
	private String toDate;
	private Boolean isFromView;
	
	
	
	
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	
	
	private SessionMap<String,Object> sessionMap;  
	private String key;
	private String laborPaymentDate;
	private String laborId;
	private String laborName;
	private String laborMobile;
	private Float laborOutstandingAmount;
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private String addSideBarJs;
	private HttpSession session;
	
	
	
	public String execute() {
		 
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		      
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    		  
		    	  }
		      }
		      String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	    			
	    		paymentTypeList.add("CASH");
	        	paymentTypeList.add("UPI");
	        	paymentTypeList.add("RTGS");
	        	paymentTypeList.add("NEFT");
	        	paymentTypeList.add("CHEQUE");
	        	
				String laborId = EncryptionDecryption.decrypt(this.getKey());
				
				
				this.setAddSideBarJs("FALSE");
				
				this.setIsFromView(true);
				this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));       
				
				Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			connection = GetDBConnection.getDBConnection(db);
	       			
	       			sql = "SELECT "
							+ "employee_name,"
							+ "employee_mobile_number "
							+ "FROM "
							+ "crusher_employee_master "
							+ "WHERE "
							+ "employee_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, laborId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						this.setLaborName(resultSet.getString(1));
						this.setLaborMobile(resultSet.getString(2));
						
						
						Date d = new Date();
			        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			        	this.setLaborPaymentDate(dateFormat.format(d));
			        	paymentTypeList.add("CASH");
			        	paymentTypeList.add("UPI");
			        	paymentTypeList.add("RTGS");
			        	paymentTypeList.add("NEFT");
			        	paymentTypeList.add("CHEQUE");
			        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));      
						result = SUCCESS;
						this.setAddSideBarJs("FALSE");
					}
					else
					{
						addActionError(this.getText("message.error.detailsNotFoundUrlTemperedPlzTryAgain"));
						result = ERROR;
					}
	       		} catch (SQLException e) {
	    			e.printStackTrace();
	       			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
	    		} catch (Exception e) {
	    			result = "error";
	    			e.printStackTrace();
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        	
	        }
	        return result;
	}
	
	
	
	public String getKey() {
		return key;
	}



	public void setKey(String key) {
		this.key = key;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	



	public Map<String, String> getAccountList() {
		return accountList;
	}



	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}



	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}



	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	@Override
	public void setServletRequest(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		this.request = arg0;
	}



	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub
		this.response = arg0;
	}



	public HttpServletRequest getRequest() {
		return request;
	}



	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}



	public HttpServletResponse getResponse() {
		return response;
	}



	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}



	public Boolean getIsFromView() {
		return isFromView;
	}



	public void setIsFromView(Boolean isFromView) {
		this.isFromView = isFromView;
	}



	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public HttpSession getSession() {
		return session;
	}



	public void setSession(HttpSession session) {
		this.session = session;
	}



	public String getLaborPaymentDate() {
		return laborPaymentDate;
	}



	public void setLaborPaymentDate(String laborPaymentDate) {
		this.laborPaymentDate = laborPaymentDate;
	}



	public String getLaborId() {
		return laborId;
	}



	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}



	public String getLaborName() {
		return laborName;
	}



	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}



	public String getLaborMobile() {
		return laborMobile;
	}



	public void setLaborMobile(String laborMobile) {
		this.laborMobile = laborMobile;
	}



	public Float getLaborOutstandingAmount() {
		return laborOutstandingAmount;
	}



	public void setLaborOutstandingAmount(Float laborOutstandingAmount) {
		this.laborOutstandingAmount = laborOutstandingAmount;
	}



	public List<String> getBankList() {
		return bankList;
	}



	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}



	public List<String> getBranchList() {
		return branchList;
	}



	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}



	public List<String> getChequeList() {
		return chequeList;
	}



	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}




	

}



