package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;

public class AddCustPaymentDetailsJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3799538907460674543L;
	
	private HttpSession session;
	private String key;
	private String paymentDate;
	private String custName;
	private String custMobile;
	private String outstandingAmount;
	private Float custOpeningBalnce = 0.0F;
	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	private SessionMap<String,Object> sessionMap;
	private String addSideBarJs;
	private String typeOfPayment1;
	private boolean paymentSaved;
	private boolean sendSMS;
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	    		this.setSendSMS(true);
	    		
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	        	setPaymentDate(dateFormat.format(d));
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap())); 
	       			this.setPaymentTypeList(GetTypeOfPaymentList.getPaymentTypeList());
		        	this.setTypeOfPayment1("CASH");
	       			
	       			connection = GetDBConnection.getDBConnection(db);
	       			
					this.setPaymentSaved(false);
       				
	       			String custId = EncryptionDecryption.decrypt(key);
	       			
	       			setKey(EncryptionDecryption.encrypt(custId));
	       			
	       			
	       			
	       			PreparedStatement getOpeningBalPSMT = null;
       				ResultSet getOpeningBalRs = null;
       				String getOpeningBalSQL = "SELECT "
       						+ "opening_balance,"
       						+ "DATE_FORMAT(opening_balance_date,'%d-%M-%Y'),"
       						+ "updated_by "
       						+ "FROM "
       						+ "crusher_cust_close_open_bal_master "
       						+ "WHERE "
       						+ "customer_id = ? "
       						+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
       				
       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
       				
       				getOpeningBalPSMT.setString(1, custId);
       				getOpeningBalPSMT.setString(2, crusherId);
       				getOpeningBalPSMT.setString(3, crusherCode);
    				
       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
       				
       				if(getOpeningBalRs.next())
       				{
       					this.setCustOpeningBalnce(getOpeningBalRs.getFloat(1));
       					this.setOpeingBalanceUpdateDate(getOpeningBalRs.getString(2));
       					this.setOpeingBalancUpdatedBy(getOpeningBalRs.getString(3));
       				}
       				else
       				{
       					this.setCustOpeningBalnce(0.0F);
       				}
       				if(getOpeningBalRs != null)
       				{
       					getOpeningBalRs.close();
       					getOpeningBalRs = null;
       				}
       				if(getOpeningBalPSMT != null)
       				{
       					getOpeningBalPSMT.close();
       					getOpeningBalPSMT = null;
       				}
       				
	       				       			
	       			sql = "SELECT "
	       					+ "customer_name,"
	       					+ "mobile_number,"
	       					+ "gst_number "
	       					+ "FROM "
	       					+ "crusher_customer_master "
	       					+ "where "
	       					+ "customer_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, custId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
	       			
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			
	       			
	       			if(rowCount>0)
	       			{
	       				
	       				this.setAddSideBarJs("FALSE");
	       				result = "success";
		       			while(resultSet.next())
		       			{	       				
		       				this.setCustName(resultSet.getString(1));
		       				this.setCustMobile(resultSet.getString(2));    
		       				
		       			}
		       		
		       			if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
		       			
	       				float floatTotalAmt = 0.0F;
	       				float floatAmtReceived = 0.0F;
	       				float floatBalanceAmt = 0.0F;
	       				float totalBalanceAmt = 0.0F;
	       				float totalPaymentDone = 0.0F;
	       				
	       				sql = "SELECT "	           					
	           					+ "bill_total_amount,"
	           					+ "bill_amount_received,"
	           					+ "bill_amount_return "
	           					+ "FROM "
	           					+ "crusher_bill_info_master "
	           					+ "WHERE "		           					
	           					+ "customer_id = ? "
	           					+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	           				
	       				
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				preparedStatement.setString(1, custId);
	       				preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
	       				
	       				ResultSet resultSetBillInfo = preparedStatement.executeQuery();
	       				
	       				while(resultSetBillInfo.next())
	       				{
	       					try
	       					{
		       					floatTotalAmt = Float.parseFloat(resultSetBillInfo.getString(1));
		           				floatAmtReceived = Float.parseFloat(resultSetBillInfo.getString(2));
		           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
		           				
		           				if(floatBalanceAmt > 0)
		           				{
		           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 	           					
		           				}
		           				
	       					}catch(NumberFormatException nfe)
	       					{
	       						result = "error";
	       						addActionError(this.getText("message.error.errorWhileFormattingWhileCalculatingBalanceAmount")+nfe.getMessage());
	       					}
	       				}
	       				if(resultSetBillInfo != null)
	       				{
	       					resultSetBillInfo.close();
	       					resultSetBillInfo = null;
	       				}
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       				
	       				sql = "SELECT "	           					
	           					+ "bill_total_amount,"
	           					+ "bill_amount_received,"
	           					+ "amount_return "
	           					+ "FROM "
	           					+ "crusher_rmc_billinfo "
	           					+ "WHERE "		           					
	           					+ "customer_id = ? "
	           					+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	           				
	       				
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				preparedStatement.setString(1, custId);
	       				preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
	    				
	    				
	       				ResultSet resultSetRMCBillInfo = preparedStatement.executeQuery();
	       				while(resultSetRMCBillInfo.next())
	       				{
	       					
	       					try
	       					{
		       					floatTotalAmt = Float.parseFloat(resultSetRMCBillInfo.getString(1));
		           				floatAmtReceived = Float.parseFloat(resultSetRMCBillInfo.getString(2));
		           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
		           				
		           				if(floatBalanceAmt > 0)
		           				{
		           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 
		           					
		           				}
		           				
	       					}catch(NumberFormatException nfe)
	       					{
	       						result = "error";
	       						addActionError("Error While Formatting while calculating balance amount!"+nfe.getMessage());
	       					}
	       				}
	       				
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				sql = "SELECT "
	       						+ "SUM(amount) "
	       						+ "FROM "
	       						+ "crusher_customer_payment_details_master "
	       						+ "WHERE "
	       						+ "customer_id = ? "
	       						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       			
	       				preparedStatement = connection.prepareStatement(sql);
	       				preparedStatement.setString(1, custId);
	       				preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
	       				
	       				ResultSet resultSetTotalPayment = preparedStatement.executeQuery();
	       				
	       				resultSetTotalPayment.last();
	       				int rowCount2 = resultSetTotalPayment.getRow();
	       				resultSetTotalPayment.beforeFirst();
	       				
	       				if(rowCount2>0)
	       				{
	       				
		       				while(resultSetTotalPayment.next())
		       				{
		       					try
		       					{
		       						if(resultSetTotalPayment.getString(1) != null)
		       						{		       						
		       							totalPaymentDone = Float.parseFloat(resultSetTotalPayment.getString(1));
		       						}
		       					}
		       					catch(NumberFormatException nfe)
		       					{
		       						result = "error";
		       						addActionError(this.getText("message.error.errorWhileFormattingWhileCalculatingTotalPaymentAmount")+nfe.getMessage());
		       					}
		       				}
		       						
		       				
		       				totalBalanceAmt = (totalBalanceAmt+this.getCustOpeningBalnce()) - totalPaymentDone;
	       				}
	       				setOutstandingAmount(""+totalBalanceAmt);
	       				
	       				if(resultSetTotalPayment != null)
	       				{
	       					resultSetTotalPayment.close();
	       					resultSetTotalPayment = null;
	       				}
	       				
	       			}else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.somethingWentWrongPlzTryAgain"));
	       			}
	   				
	       		} catch (SQLException e) {
	    			e.printStackTrace();
	       			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
	    		} catch (IOException e) {
	    			result = "error";
	    			e.printStackTrace();
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        	
	        }
	        
	        return result;
}


public HttpSession getSession() {
	return session;
}


public void setSession(HttpSession session) {
	this.session = session;
}


public String getKey() {
	return key;
}


public void setKey(String key) {
	this.key = key;
}


public String getPaymentDate() {
	return paymentDate;
}


public void setPaymentDate(String paymentDate) {
	this.paymentDate = paymentDate;
}


public String getCustName() {
	return custName;
}


public void setCustName(String custName) {
	this.custName = custName;
}


public String getCustMobile() {
	return custMobile;
}


public void setCustMobile(String custMobile) {
	this.custMobile = custMobile;
}


public String getOutstandingAmount() {
	return outstandingAmount;
}


public void setOutstandingAmount(String outstandingAmount) {
	this.outstandingAmount = outstandingAmount;
}


public Float getCustOpeningBalnce() {
	return custOpeningBalnce;
}


public void setCustOpeningBalnce(Float custOpeningBalnce) {
	this.custOpeningBalnce = custOpeningBalnce;
}


public String getOpeingBalancUpdatedBy() {
	return opeingBalancUpdatedBy;
}


public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
	this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
}


public String getOpeingBalanceUpdateDate() {
	return opeingBalanceUpdateDate;
}


public Map<String, String> getAccountList() {
	return accountList;
}


public List<String> getPaymentTypeList() {
	return paymentTypeList;
}


public void setPaymentTypeList(List<String> paymentTypeList) {
	this.paymentTypeList = paymentTypeList;
}


public void setAccountList(Map<String, String> accountList) {
	this.accountList = accountList;
}


public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
	this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
}


public static long getSerialversionuid() {
	return serialVersionUID;
}



public String getAddSideBarJs() {
	return addSideBarJs;
}


public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}




public String getTypeOfPayment1() {
	return typeOfPayment1;
}

  
public void setTypeOfPayment1(String typeOfPayment1) {
	this.typeOfPayment1 = typeOfPayment1;
}


public boolean isPaymentSaved() {
	return paymentSaved;
}


public boolean isSendSMS() {
	return sendSMS;
}


public void setSendSMS(boolean sendSMS) {
	this.sendSMS = sendSMS;
}


public void setPaymentSaved(boolean paymentSaved) {
	this.paymentSaved = paymentSaved;
}


}
