package com.stonecrusher.jspRedirect;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;

public class AddAccountCreditEntryJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4405687819904381489L;

	private HttpSession session;
	private String entryDate;
	Map<String,String> accountList = new LinkedHashMap<String,String>();
	List<String> paymentTypeList = new ArrayList<String>();
	private SessionMap<String,Object> sessionMap;  
	private String addSideBarJs;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	this.setAddSideBarJs("FALSE");
	        	this.setEntryDate(dateFormat.format(d));	        	
	        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));        	
	        	this.setPaymentTypeList(GetTypeOfPaymentList.getTypeOfPaymentList());
	        	result = "success";
	        }
        
        return result;
}
	
	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getEntryDate() {
		return entryDate;
	}
	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}


}
