package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleConsumptionInfoDAO;
import com.stonecrusher.DAO.VehicleMaintenanceInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DownloadVehicleMaintenanceReport extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -2457831209388549560L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;
      
	private String fromDate;
	private String toDate;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private String addSideBarJs;
	private String vehicleId;
	
	private ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList = new ArrayList<VehicleMaintenanceInfoDAO>();
	private Float totalMaintenanceAmount = 0.0F;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();
			
			downloadTypeList.add("pdf");
	    	downloadTypeList.add("xl");
		
	    	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		

        	Connection connection = null;
    		PreparedStatement preparedStatement= null;
    		ResultSet resultSet = null;
    	 
    		String sql = "";
    		String db = (String) session.getAttribute("db");
    		
    		try
			{
				connection = GetDBConnection.getDBConnection(db);
				if(!this.getVehicleId().equals("ALL"))
				{
					sql = "SELECT "
							+ "maininfo.vehicle_expense_entry_id,"
							+ "maininfo.vehicle_id,"
							+ "vinfo.vehicle_make,"
							+ "vinfo.vehicle_registration_number,"
							+ "maininfo.exepense_date,"
							+ "maininfo.exepense_time,"
							+ "maininfo.exepense_amount,"
							+ "maininfo.entry_by,"
							+ "maininfo.consupmtion_details,"
							+ "maininfo.expence_image "
							+ "FROM "
							+ "crusher_vehicle_expense_master AS maininfo "
							+ "INNER JOIN "
							+ "crusher_vehicle_details_master AS vinfo "
							+ "ON maininfo.vehicle_id = vinfo.vehicle_id "
							+ "WHERE "
							+ "maininfo.vehicle_id = ? "
							+ "AND "
							+ "(maininfo.exepense_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
    						+ "maininfo.crusher_id = ? "
							+ "AND "
							+ "maininfo.crusher_code = ? "
							+ "AND "
							+ "vinfo.crusher_id = ? "
							+ "AND "
							+ "vinfo.crusher_code = ?";
					
					
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, this.getVehicleId());
						preparedStatement.setString(2, this.getFromDate());
						preparedStatement.setString(3, this.getToDate());
						preparedStatement.setString(4, crusherId);
        				preparedStatement.setString(5, crusherCode);
        				preparedStatement.setString(6, crusherId);
        				preparedStatement.setString(7, crusherCode);
        				
				}
				else
				{

					sql = "SELECT "
							+ "maininfo.vehicle_expense_entry_id,"
							+ "maininfo.vehicle_id,"
							+ "vinfo.vehicle_make,"
							+ "vinfo.vehicle_registration_number,"
							+ "DATE_FORMAT(maininfo.exepense_date,'%d-%m-%Y'),"
							+ "maininfo.exepense_time,"
							+ "maininfo.exepense_amount,"
							+ "maininfo.entry_by,"
							+ "maininfo.consupmtion_details,"
							+ "maininfo.expence_image "
							+ "FROM "
							+ "crusher_vehicle_expense_master AS maininfo "
							+ "INNER JOIN "
							+ "crusher_vehicle_details_master AS vinfo "
							+ "ON maininfo.vehicle_id = vinfo.vehicle_id "
							+ "WHERE "
							+ "(maininfo.exepense_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
    						+ "maininfo.crusher_id = ? "
							+ "AND "
							+ "maininfo.crusher_code = ? "
							+ "AND "
							+ "vinfo.crusher_id = ? "
							+ "AND "
							+ "vinfo.crusher_code = ?";
					
						preparedStatement = connection.prepareStatement(sql);
					
						preparedStatement.setString(1, this.getFromDate());
						preparedStatement.setString(2, this.getToDate());
						preparedStatement.setString(3, crusherId);
        				preparedStatement.setString(4, crusherCode);
        				preparedStatement.setString(5, crusherId);
        				preparedStatement.setString(6, crusherCode);
        				
        				
				
				}
				
				
				resultSet = preparedStatement.executeQuery();
				
				while(resultSet.next())
				{
					VehicleMaintenanceInfoDAO infoDAO = new VehicleMaintenanceInfoDAO();
					infoDAO.setEntryId(resultSet.getString(1));
					infoDAO.setVehicleId(resultSet.getString(2));
					infoDAO.setVehicleMake(resultSet.getString(3));
					infoDAO.setVehicleRegNumber(resultSet.getString(4));
					infoDAO.setEntryDate(resultSet.getString(5));
					infoDAO.setEntryTime(resultSet.getString(6));
					infoDAO.setAmount(resultSet.getFloat(7));
					infoDAO.setEntryBy(resultSet.getString(8));
					infoDAO.setComments(resultSet.getString(9));
					if(resultSet.getBlob(10) != null)
					{
						infoDAO.setImageAvailable(true);
					}
					else
					{
						infoDAO.setImageAvailable(false);
					}
					
					infoDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(2)+"#"+resultSet.getString(5)));
					
					this.setTotalMaintenanceAmount(this.getTotalMaintenanceAmount() + resultSet.getFloat(7));
					
					this.getVehicleMainInfoList().add(infoDAO);
					
					
				}
				
				if(this.getVehicleMainInfoList().size() == 0)
				{
					
					
					addActionError("Details not found for given inputs!");
					
				}else {
				   
				    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
				    Collections.sort(this.getVehicleMainInfoList(), new Comparator<VehicleMaintenanceInfoDAO>() {
				        @Override
				        public int compare(VehicleMaintenanceInfoDAO o1, VehicleMaintenanceInfoDAO o2) {
				            try {
				                Date date1 = dateFormat.parse(o1.getEntryDate());
				                Date date2 = dateFormat.parse(o2.getEntryDate());
				                return date1.compareTo(date2); 
				            } catch (ParseException e) {
				                e.printStackTrace();
				                return 0; 
				            }
				        }
				    });
				}
    			
				@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
				if(this.getDownloadType().equals("pdf"))
				{
					
				
    			
    			String path=	request.getSession().getServletContext().getRealPath("/images/");
    			PDDocument document = new PDDocument(); 
				PDPage page = null;
				
				
					 page = new PDPage(PDRectangle.A4);
				
				
			        document.addPage(page);
			         PDPageContentStream contentStream = new PDPageContentStream(document, page);
			         int pageCount = 1;
		    			 Table header;
		    			 Table creditDetails;
		    			 
		    			
		    			  TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row info1 = Row.builder()
					                .add(TextCell.builder().text("Vehicle Maintenance Report  "
					                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info2 = Row.builder()
					                .add(TextCell.builder().text("From Date : "
					                		+ ""+this.getFromDate()
					                		+ " and To Date :"+this.getToDate() +" Vehicle Id : " + this.getVehicleId()).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				          
				          tableHeaderBuilder.addRow(headerName);
				          tableHeaderBuilder.addRow(info1);
				          tableHeaderBuilder.addRow(info2);
				          header = tableHeaderBuilder.build();
				          
				          
				          TableBuilder tableDebtDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(80, 100, 50, 50, 130)		                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				          
				          Row tableHeader = Row.builder()
				        		  	.add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          tableDebtDetailsBuilder.addRow(tableHeader);
				       
				        
				     
				        	  int size = this.getVehicleMainInfoList().size();
				        	  
				        	  
					          float startY = page.getMediaBox().getHeight() - PADDING20;
					          float currentY = startY;
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
					          
					          
					          
					    	  for(int s=0;s<size;s++)
				        	  {
				        		  
				        		  if(currentY < 50)
				        		  {
				        			  pageCount++;
				        			  creditDetails = tableDebtDetailsBuilder.build();
				        			  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(creditDetails)
						                .startX(PADDING30)
						                .startY(startY-50)
						                .build()
						                .draw();
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			 
						    			 
						    			
						    			  tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(550)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								           headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								           info1 = Row.builder()
									                .add(TextCell.builder().text("Vehicle Maintenance Report  "
								                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
								           info2 = Row.builder()
									                .add(TextCell.builder().text("From Date : "
									                		+ ""+this.getFromDate()
									                		+ " and To Date :"+this.getToDate() +" Vehicle Id : " + this.getVehicleId()).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								          header = tableHeaderBuilder.build();
				        			  
				        			  creditDetails = null;
				        			   tableDebtDetailsBuilder = Table.builder()
				        					   .addColumnsOfWidth(80, 100, 80, 50, 50, 50, 50, 130)			                
								                .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							           tableHeader = Row.builder()
							        		   .add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          tableDebtDetailsBuilder.addRow(tableHeader);
							          
				        			  
				        				PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
				        		  }
				        		  
				        		  VehicleMaintenanceInfoDAO dao2 = this.getVehicleMainInfoList().get(s);
				        		  
				        			Row supplierInfo = Row.builder()
					        			  	.add(TextCell.builder().text(dao2.getEntryDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getVehicleMake() + " | " +  dao2.getVehicleRegNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getEntryBy()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getComments()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableDebtDetailsBuilder.addRow(supplierInfo);
					        	 
					        	  currentY = currentY -25;
				        	  }
					          
					    	  Row custInfo = Row.builder()
					    			   .add(TextCell.builder().text("Total Maintenance Amount").colSpan(2).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			   .add(TextCell.builder().text("" + this.getTotalMaintenanceAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			    .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build()) // Empty cell for column 6
					    			    .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build()) // Empty cell for column 7
					    			    .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD)
						                .fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .height(15F)					                
						                .build();
				        	  
				        	  tableDebtDetailsBuilder.addRow(custInfo);
				        	  creditDetails = tableDebtDetailsBuilder.build();
				         
				          
				          TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(creditDetails)
			                .startX(PADDING30)
			                .startY(startY-50)
			                .build()
			                .draw();
				          contentStream.close();
					          
					          
					          
					          document.save(path+"/vehicle-maintenance-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-VehicleId-"+this.getVehicleId()+"-report.pdf");
						        document.close();
						        
						        response.setHeader("Content-disposition", "inline; filename=vehicle-maintenance-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-VehicleId-"+this.getVehicleId()+"-report.pdf");
								response.setContentType("application/pdf");
								
								FileInputStream fileInputStream = new FileInputStream(path+"/vehicle-maintenance-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-VehicleId-"+this.getVehicleId()+"-report.pdf");
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.flush();
								out.close();
								
				}
				
				if(this.getDownloadType().equals("xl"))
				{

					String fileName = "vehicle-maintenance-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-vehiclId-"+this.getVehicleId()+".xls";
					 HSSFWorkbook workbook = new HSSFWorkbook();
					  HSSFSheet mySheet = workbook.createSheet("vehicle-maintenance-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-vehiclId-"+this.getVehicleId());  
					
					  mySheet.setColumnWidth(0, 10 * 256); 
					  mySheet.setColumnWidth(1, 30 * 256); 
					  mySheet.setColumnWidth(2, 50 * 256); 
					  mySheet.setColumnWidth(3, 25 * 256); 
					  mySheet.setColumnWidth(4, 40 * 256); 
					  mySheet.setColumnWidth(5, 30 * 256); 
 

					
					 
					 	Font font = workbook.createFont();
				       
				        font.setBold(true);
				       
					 final HSSFCellStyle cellStyle = workbook.createCellStyle();

					 cellStyle.setBorderBottom(BorderStyle.THIN);
					 cellStyle.setBorderRight(BorderStyle.THIN);
					 cellStyle.setBorderLeft(BorderStyle.THIN);
					 cellStyle.setBorderTop(BorderStyle.THIN);
					 cellStyle.setFont(font);
					 cellStyle.setWrapText(true);
					 
					 final HSSFCellStyle cellStyleNonBold = workbook.createCellStyle();

					 cellStyleNonBold.setBorderBottom(BorderStyle.THIN);
					 cellStyleNonBold.setBorderRight(BorderStyle.THIN);
					 cellStyleNonBold.setBorderLeft(BorderStyle.THIN);
					 cellStyleNonBold.setBorderTop(BorderStyle.THIN);
					 
					 short s = 255-0-0;
					 final HSSFCellStyle cellStyleBoldRed = workbook.createCellStyle();	 
					 
					 cellStyleBoldRed.setBorderBottom(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderRight(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderLeft(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderTop(BorderStyle.THIN);
					 cellStyleBoldRed.setFillForegroundColor(s);
					 cellStyleBoldRed.setFont(font);								 
					 cellStyleBoldRed.setWrapText(true);
					 
					 HSSFRow rowHead = mySheet.createRow(0);							 
					 
					 Cell cellHead1 = rowHead.createCell(0);
					 cellHead1.setCellValue("Entry Date");
					 cellHead1.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead2 = rowHead.createCell(1);
					 cellHead2.setCellValue("Vehicle");
					 cellHead2.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead3 = rowHead.createCell(2);
					 cellHead3.setCellValue("Amount");
					 cellHead3.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead4 = rowHead.createCell(3);
					 cellHead4.setCellValue("Entry By");
					 cellHead4.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead5 = rowHead.createCell(4);
					 cellHead5.setCellValue("Details");
					 cellHead5.setCellStyle(cellStyleBoldRed);
					 
					
					 
					 int rowCount = 1;
					   for(VehicleMaintenanceInfoDAO dao:this.getVehicleMainInfoList())
				       {
								 HSSFRow rowData = mySheet.createRow(rowCount);
								  
								 
								 
								 Cell cell1 = rowData.createCell(0);
								 cell1.setCellValue(dao.getEntryDate());
								 cell1.setCellStyle(cellStyleNonBold);
								 
								 Cell cell2 = rowData.createCell(1);
								 cell2.setCellValue(dao.getVehicleMake() +"|"+ dao.getVehicleRegNumber());
								 cell2.setCellStyle(cellStyleNonBold);
								 
								  
								Cell cell3 = rowData.createCell(2);
								 cell3.setCellValue(dao.getAmount());
								 cell3.setCellStyle(cellStyleNonBold);
								 
								 Cell cell4 = rowData.createCell(3);
								 cell4.setCellValue(dao.getEntryBy());
								 cell4.setCellStyle(cellStyleNonBold);
								 
								 
								 Cell cell5 = rowData.createCell(4);
								 cell5.setCellValue(dao.getComments());
								 cell5.setCellStyle(cellStyleNonBold);
								 
								 
								

								
								
								 
								 
								 rowCount++;
								 
				       }
					   
					   HSSFRow totalRow = mySheet.createRow(rowCount);

					Cell totalLabelCell = totalRow.createCell(1);
					totalLabelCell.setCellValue("Total Maintenance Amount");
					totalLabelCell.setCellStyle(cellStyleBoldRed); 

					Cell totalAmountCell = totalRow.createCell(2);
					totalAmountCell.setCellValue(this.getTotalMaintenanceAmount());
					totalAmountCell.setCellStyle(cellStyleBoldRed); 

					Cell emptyCell1 = totalRow.createCell(0);
					emptyCell1.setCellValue("");
					emptyCell1.setCellStyle(cellStyleNonBold);

					Cell emptyCell2 = totalRow.createCell(3);
					emptyCell2.setCellValue("");
					emptyCell2.setCellStyle(cellStyleNonBold);

					Cell emptyCell3 = totalRow.createCell(4);
					emptyCell3.setCellValue("");
					emptyCell3.setCellStyle(cellStyleNonBold);

					
					   
					
					   
					   FileOutputStream fileOut = new FileOutputStream(fileName);
					   workbook.write(fileOut);
			            fileOut.close();
			            workbook.close();
			            
			    		response.setHeader("Content-disposition", "inline; filename="+""+fileName);
						response.setContentType("application/xls");
						FileInputStream fileInputStream = new FileInputStream(fileName);
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.close();
				}
    			
    		}
    		catch (SQLException e) 
    		{
	    		 e.printStackTrace();
	    				    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    			
	    	} catch (Exception e) {
	    		
	    		e.printStackTrace();	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || Something Went Wrong!");
	    	}
    			finally {
    				if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
        }
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public Map<String, String> getVehicleList() {
		return vehicleList;
	}


	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}


	public ArrayList<VehicleMaintenanceInfoDAO> getVehicleMainInfoList() {
		return vehicleMainInfoList;
	}


	public void setVehicleMainInfoList(ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList) {
		this.vehicleMainInfoList = vehicleMainInfoList;
	}


	public Float getTotalMaintenanceAmount() {
		return totalMaintenanceAmount;
	}


	public void setTotalMaintenanceAmount(Float totalMaintenanceAmount) {
		this.totalMaintenanceAmount = totalMaintenanceAmount;
	}
	

}
