package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ItemwisePurchaseReportDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadPurchaseReport extends ActionSupport implements SessionAware{

	
	

		/**
		 * 
		 */
		private static final long serialVersionUID = 2231894051386352138L;
		public HttpServletRequest request;
		public HttpServletResponse response;
		private SessionMap<String,Object> sessionMap;
		
			private final static Color BLUE_DARK = new Color(76, 129, 190);
		    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
		    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

		    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
		    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
		    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
		    private static final float PADDING10 = 10f;
		    private static final float PADDING20 = 20f;
		    private static final float PADDING30 = 30f;
		    private static final float PADDING40 = 40f;
		    private static final float PADDING50 = 50f;

		private String fromDate;
		private String toDate;
		private List<ItemwisePurchaseReportDAO> itemWisePurchaseList = new  ArrayList<ItemwisePurchaseReportDAO>();
		private HttpSession session;
		
			public void downloadPurchaseReport()
			{
				session=ServletActionContext.getRequest().getSession(false); 
				 
		        if(session==null || session.getAttribute("login")==null){ 
		        	addActionMessage("Please Login First !!!");
		        	
		        }  
		        else{
		        	response = ServletActionContext.getResponse();
					request = ServletActionContext.getRequest();
					
					
					
			
			//System.out.println("Bill Number : "+billNumber);
			
					Connection connection = null;
					PreparedStatement preparedStatement= null;
					ResultSet resultSet = null;
					
					String sql = "";
					String db = (String) session.getAttribute("db");
		    		String billDateTime = "";
					
					Map<String, Object> session = ActionContext.getContext().getSession();
					
					String crusherId = (String) this.getSessionMap().get("crusherId");
		    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
		    	
					try
		        	{
						
						
						connection = GetDBConnection.getDBConnection(db);
						sql = "SELECT "
								+ "DATE_FORMAT(cpi.purchase_date,'%d-%m-%Y'),"					
								+ "cpp.purchase_id,"
								+ "cpp.product_name,"
								+ "cpp.purchase_unit,"
								+ "SUM(cpp.purchase_quantity),"
								+ "SUM(cpp.purchase_total_amount_after_discount),"							
								+ "SUM(cpp.purchase_gross_amount),"
								+ "SUM(cpp.purchase_igst_amount),"
								+ "SUM(cpp.purchase_cgst_amount),"
								+ "SUM(cpp.purchase_sgst_amount),"
								+ "cpp.purchase_rate "
								+ "FROM "
								+ "crusher_purchase_master AS cpi "
								+ "INNER JOIN "
								+ "crusher_purchase_product_info_master AS cpp "
								+ "ON "
								+ "cpi.purchase_id = cpp.purchase_id "
								+ "AND "
								+ "cpp.crusher_id = ? "
								+ "AND "
								+ "cpp.crusher_code = ? "
								+ "AND "
								+ "cpi.crusher_id = ? "
								+ "AND "
								+ "cpi.crusher_code = ? "
								+ "AND "						
								+ "(cpi.purchase_date "
								+ "BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
								+ "AND "
								+ "STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "GROUP BY "
								+ "cpp.product_name";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						preparedStatement.setString(5, this.getFromDate());
						preparedStatement.setString(6, this.getToDate());
						
						//System.out.println(preparedStatement.toString());
						resultSet = preparedStatement.executeQuery();
						DecimalFormat df = new DecimalFormat();
						df.setMaximumFractionDigits(2);
						while(resultSet.next())
						{
							ItemwisePurchaseReportDAO purchaseReportDAO =  new ItemwisePurchaseReportDAO();
							purchaseReportDAO.setProductName(resultSet.getString(3));
							purchaseReportDAO.setUnits(resultSet.getString(4));
							purchaseReportDAO.setQuantity(df.format(resultSet.getFloat(5)));
							purchaseReportDAO.setTotalAmount(df.format(resultSet.getFloat(6)));
							purchaseReportDAO.setRate(resultSet.getString(11));
							
							
							this.getItemWisePurchaseList().add(purchaseReportDAO);
							
							
						}
						
						
						if(this.getItemWisePurchaseList().size()>0)
						{
							
							
							try
							{
								String crusherName = (String) this.getSessionMap().get("crushernameenglish");
								String crusheraddresseng = (String) this.getSessionMap().get("crusheraddresseng");
							    String path=	request.getSession().getServletContext().getRealPath("/images/");
				    			
								
								 java.util.Date date = new java.util.Date();
					        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
					        	String reportDate = dateFormat.format(date);
								
								
					       	     long t = date.getTime();	        	     
					       	     java.sql.Time time = new java.sql.Time(t);
					       	     
								PDDocument document = new PDDocument(); 
								PDPage page = null;
								
								 page = new PDPage(PDRectangle.A4);
								
								 
								 document.addPage(page);
								 
								 
						         PDPageContentStream contentStream = new PDPageContentStream(document, page);
								 
						         int pageCount = 1;
						         
						         Table header;
						         
						         
						         
						         
						         TableBuilder tableHeaderBuilder = Table.builder()
							                .addColumnsOfWidth(550)				                
							                .font(HELVETICA)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);
						         
						         Row dairyNameHeader = Row.builder()
							                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(16)				              
							                .horizontalAlignment(CENTER)
							                .build();
						         
						         Row addressRow = Row.builder()
							                .add(TextCell.builder().text(crusheraddresseng).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .build();
						         
						         
						         Row reportInfo1 = Row.builder()
							                .add(TextCell.builder()
							                		.text("Purchase Details Report From Date : "+this.getFromDate()+" to Date: "+this.getToDate()+" "+time)
							                		.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(12)				              
							                .horizontalAlignment(CENTER)
							                .build();
						         
						         
						         
						         
						         tableHeaderBuilder.addRow(dairyNameHeader);
						         tableHeaderBuilder.addRow(addressRow);
						         tableHeaderBuilder.addRow(reportInfo1);
						        
						         
						         header = tableHeaderBuilder.build();
						         
						         float startY = page.getMediaBox().getHeight() - PADDING20;
						         TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(header)
					                .startX(PADDING30)
					                .startY(startY)
					                .build()
					                .draw();
								
						         
						         Table stockReportHeaderInfo;
						         TableBuilder tableStockInfoBuilder = Table.builder()
							                .addColumnsOfWidth(50,160,130,70,120)				                
							                .font(HELVETICA)
							                .borderWidth(0.5F)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);
						         
						         
						         Row stockTableHeader = Row.builder()
						        		  	.add(TextCell.builder().text("SrNo").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())					              
							                .add(TextCell.builder().text("Product Name").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				               
							                .add(TextCell.builder().text("Quantity").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Rate").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Purchase Amount").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())
							               .backgroundColor(Color.LIGHT_GRAY)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .build();
						         
						         tableStockInfoBuilder.addRow(stockTableHeader);
						         stockReportHeaderInfo = tableStockInfoBuilder.build();
						        		
						        		 TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(stockReportHeaderInfo)
							                .startX(PADDING20)
							                .startY(startY-50)
							                .build()
							                .draw();
						         
						        		 float currentY =  75.0F;
						        		 
						        		 int srNo = 1;
						        		 
						        		 Table stockInfoRowTable = null;
							        	 
								         TableBuilder tableStockInfoRowBuilder = Table.builder()
									                .addColumnsOfWidth(50,160,130,70,120)				                
									                .font(HELVETICA)
									                .borderWidth(0.5F)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
						
						        		 for(ItemwisePurchaseReportDAO detailsDAO :  this.getItemWisePurchaseList())
						        		 {
						        			 
						        			
								        	 
								        	 
									         if(currentY > 750)
									         {
									        	 pageCount++;
									        	 contentStream.close();
									        	PDPage newPage = new PDPage(PDRectangle.A4);
									        	 contentStream = new PDPageContentStream(document,newPage);
									        	currentY = 20.0F;
									             document.addPage( newPage );
									             
									             
									             
									             Table headerOtherPage;
									             
									             
									             TableBuilder tableHeaderBuilderOtherPage = Table.builder()
											                .addColumnsOfWidth(550)				                
											                .font(HELVETICA)
											                .borderColor(Color.BLACK)
											                .horizontalAlignment(CENTER);
										         
										         Row dairyNameHeaderOtherPage = Row.builder()
											                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(16)				              
											                .horizontalAlignment(CENTER)
											                .build();
										         
										         Row addressRowOtherPage = Row.builder()
											                .add(TextCell.builder().text(crusheraddresseng).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
											                .horizontalAlignment(CENTER)
											                .build();
										         
										         
										         Row reportInfo1OtherPage = Row.builder()
											                .add(TextCell.builder()
											                  		.text("Purchase Details Report From Date : "+this.getFromDate()+" to Date: "+this.getToDate()+" "+time)
															        .horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(12)				              
											                .horizontalAlignment(CENTER)
											                .build();
										         
										         
										         
										         
										         tableHeaderBuilderOtherPage.addRow(dairyNameHeaderOtherPage);
										         tableHeaderBuilderOtherPage.addRow(addressRowOtherPage);
										         tableHeaderBuilderOtherPage.addRow(reportInfo1OtherPage);
										        
										         
										         headerOtherPage = tableHeaderBuilderOtherPage.build();
										         
										         TableDrawer.builder()
									                .contentStream(contentStream)
									                .table(headerOtherPage)
									                .startX(PADDING30)
									                .startY(startY)
									                .build()
									                .draw();
										         
										         
									             
									             TableDrawer.builder()
									                .contentStream(contentStream)
									                .table(stockReportHeaderInfo)
									                .startX(PADDING20)
									                .startY(startY-50)
									                .build()
									                .draw();
									             currentY = currentY + 55;
												
									         }
						        			 
									         
									         Row collectionTableInfoRow = Row.builder()
										                .add(TextCell.builder().text(""+srNo).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(20F).build())				               
										                .add(TextCell.builder().text(detailsDAO.getProductName()).fontSize(9).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(20F).build())
										                .add(TextCell.builder().text(detailsDAO.getQuantity()+" "+detailsDAO.getUnits()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(20F).build())
										                .add(TextCell.builder().text(detailsDAO.getRate()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(20F).build())
										                .add(TextCell.builder().text(detailsDAO.getTotalAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(20F).build())
										                .backgroundColor(Color.WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA).fontSize(12)				              
										                .horizontalAlignment(CENTER)
										                .height(25F)
										                .build();
									         
								        	 tableStockInfoRowBuilder.addRow(collectionTableInfoRow);
								        	  currentY = (float) (currentY + 25.0F);
									         
									         srNo++;
									         
						        		 }
						        		   
							        	 stockInfoRowTable = tableStockInfoRowBuilder.build();
								         
								         
								        // float currentY = 
								         TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(stockInfoRowTable)
							                .startX(PADDING20)
							                .startY(startY-63)
							                .build()
							                .draw();
								       
						        		 
						        		 contentStream.close();
										 	document.save(path+"/purchase-report-"+crusherCode+".pdf");
									        document.close();
									        
									        

											response.setHeader("Content-disposition", "inline; filename=purchase-report-"+crusherCode+".pdf");
											response.setContentType("application/pdf");
											FileInputStream fileInputStream = new FileInputStream(path+"/purchase-report-"+crusherCode+".pdf");
											PrintWriter out = response.getWriter();  
											int bytes;
											while ((bytes = fileInputStream.read()) != -1) {
												out.write(bytes);
											}
											fileInputStream.close();
											out.flush();
											out.close();
						
							
		        	}catch (Exception e) {
						e.printStackTrace();
					}finally {
						if(resultSet != null)
	    				{
	    					try {
	    						resultSet.close();resultSet = null;
	    					} catch (SQLException e) {
	    						
	    					}
	    				}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
					
					}
		
				}
						
		   }catch (SQLException | IOException e) {
				e.printStackTrace();
			}finally {
				if(resultSet != null)
				{
					try {
						resultSet.close();resultSet = null;
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
			}
			}
}
		@Override  
		public void setSession(Map<String, Object> map) {  
		    sessionMap=(SessionMap<String, Object>)map;  
		}

		public SessionMap<String, Object> getSessionMap() {
			return sessionMap;
		}

		public void setSessionMap(SessionMap<String, Object> sessionMap) {
			this.sessionMap = sessionMap;
		}
		public HttpServletRequest getRequest() {
			return request;
		}

		public void setRequest(HttpServletRequest request) {
			this.request = request;
		}

		public HttpServletResponse getResponse() {
			return response;
		}

		public void setResponse(HttpServletResponse response) {
			this.response = response;
		}


		
	

		public HttpSession getSession() {
			return session;
		}
		public void setSession(HttpSession session) {
			this.session = session;
		}
		public List<ItemwisePurchaseReportDAO> getItemWisePurchaseList() {
			return itemWisePurchaseList;
		}

		public void setItemWisePurchaseList(List<ItemwisePurchaseReportDAO> itemWisePurchaseList) {
			this.itemWisePurchaseList = itemWisePurchaseList;
		}

		public static long getSerialversionuid() {
			return serialVersionUID;
		}

		public String getFromDate() {
			return fromDate;
		}

		public void setFromDate(String fromDate) {
			this.fromDate = fromDate;
		}

		public String getToDate() {
			return toDate;
		}

		public void setToDate(String toDate) {
			this.toDate = toDate;
		}
		
		
	}
