package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.RMCBillIngredientsUsedDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadProductWiseMaterialUsedReport extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8292337304631426465L;
	public HttpServletRequest request;
	public HttpServletResponse response;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;

	private String fromDate;
	private String toDate;
	private Float totalTenMMUsed;
	private Float totalTwentyMMUsed;
	private Float totalWashSandUsed;
	private Float totalCrushSandUsed;
	private Float totalAddMixtureUsed;
	private Float totalOPCUsed;
	private Float totalPPCUsed;
	private Float totalWaterUsed;
	
	private SessionMap<String,Object> sessionMap;  
	
	private List<RMCBillIngredientsUsedDAO> rmcUsedIngreDAOList = new ArrayList<RMCBillIngredientsUsedDAO>();
    
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();


        	Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			String sql = "";
			String db = (String) this.getSession().getAttribute("db");
			
			
			
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				
				sql = "SELECT "
    					+ "rmcused.rmc_bill_number,"
    					+ "rmcused.10mm,"
    					+ "rmcused.20mm,"
    					+ "rmcused.crushsand,"
    					+ "rmcused.washsand,"
    					+ "rmcused.water,"
    					+ "rmcused.addmixture,"
    					+ "rmcused.cementopc,"
    					+ "rmcused.cementppc,"
    					+ "rmcused.bill_type "
    					+ "FROM "
    					+ "rmc_bill_ingredients_used_details_master AS rmcused "    					
    					+ "WHERE (rmcused.entry_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND STR_TO_DATE(?,'%d-%m-%Y')) "
						+ "AND rmcused.crusher_id = ? "
        		        + "AND rmcused.crusher_code = ? "
        		        + "ORDER BY rmcused.entry_date,rmcused.entry_time,rmcused.rmc_bill_number,rmcused.bill_type" ;
    			
    			

    			preparedStatement = connection.prepareStatement(sql);
    			preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId); 
        		preparedStatement.setString(4, crusherCode); 
        		
        		
        		
        		resultSet = preparedStatement.executeQuery();
        		
        		
        		this.setTotalTenMMUsed(0.0f);
        		this.setTotalTwentyMMUsed(0.0f);
        		this.setTotalWashSandUsed(0.0f);
        		this.setTotalCrushSandUsed(0.0f);
        		this.setTotalWaterUsed(0.0f);
        		this.setTotalAddMixtureUsed(0.0f);
        		this.setTotalOPCUsed(0.0f);
        		this.setTotalPPCUsed(0.0f);
        		
        		
        		Map<String, RMCBillIngredientsUsedDAO> productWiseMap = new LinkedHashMap<>();

        		while (resultSet.next()) {
        		    String billNumber = resultSet.getString(1);
        		    float tenmm = resultSet.getFloat(2);
        		    float twentymm = resultSet.getFloat(3);
        		    float crushsand = resultSet.getFloat(4);
        		    float washsand = resultSet.getFloat(5);
        		    float water = resultSet.getFloat(6);
        		    float addmixture = resultSet.getFloat(7);
        		    float cementopc = resultSet.getFloat(8);
        		    float cementppc = resultSet.getFloat(9);

        		    String getRMCProductName = "SELECT product_name FROM crusher_rmc_productbillinfo "
        		                             + "WHERE crusher_id = ? AND crusher_code = ? AND bill_number = ?";
        		    PreparedStatement getRMCProductNamePSMT = connection.prepareStatement(getRMCProductName);
        		    getRMCProductNamePSMT.setString(1, crusherId);
        		    getRMCProductNamePSMT.setString(2, crusherCode);
        		    getRMCProductNamePSMT.setString(3, billNumber);

        		    ResultSet getRMCPRoductNameRS = getRMCProductNamePSMT.executeQuery();
        		    String productName = null;

        		    if (getRMCPRoductNameRS.next()) {
        		        productName = getRMCPRoductNameRS.getString(1);
        		    }

        		    getRMCPRoductNameRS.close();
        		    getRMCProductNamePSMT.close();

        		    if (productName == null) continue;

        		    RMCBillIngredientsUsedDAO existing = productWiseMap.get(productName);
        		    if (existing == null) {
        		        existing = new RMCBillIngredientsUsedDAO();
        		        existing.setProductName(productName);
        		        existing.setTenmm(tenmm);
        		        existing.setTwentymm(twentymm);
        		        existing.setCrushsand(crushsand);
        		        existing.setWashsand(washsand);
        		        existing.setWater(water);
        		        existing.setAddmixture(addmixture);
        		        existing.setCementOPC(cementopc);
        		        existing.setCementPPC(cementppc);

        		        productWiseMap.put(productName, existing);
        		    } else {
        		        existing.setTenmm(existing.getTenmm() + tenmm);
        		        existing.setTwentymm(existing.getTwentymm() + twentymm);
        		        existing.setCrushsand(existing.getCrushsand() + crushsand);
        		        existing.setWashsand(existing.getWashsand() + washsand);
        		        existing.setWater(existing.getWater() + water);
        		        existing.setAddmixture(existing.getAddmixture() + addmixture);
        		        existing.setCementOPC(existing.getCementOPC() + cementopc);
        		        existing.setCementPPC(existing.getCementPPC() + cementppc);
        		    }

        		   
        		    this.setTotalTenMMUsed(this.getTotalTenMMUsed() + tenmm);
        		    this.setTotalTwentyMMUsed(this.getTotalTwentyMMUsed() + twentymm);
        		    this.setTotalCrushSandUsed(this.getTotalCrushSandUsed() + crushsand);
        		    this.setTotalWashSandUsed(this.getTotalWashSandUsed() + washsand);
        		    this.setTotalWaterUsed(this.getTotalWaterUsed() + water);
        		    this.setTotalAddMixtureUsed(this.getTotalAddMixtureUsed() + addmixture);
        		    this.setTotalOPCUsed(this.getTotalOPCUsed() + cementopc);
        		    this.setTotalPPCUsed(this.getTotalPPCUsed() + cementppc);
        		}

        		
        		this.getRmcUsedIngreDAOList().addAll(productWiseMap.values());

				
				
				 String path=	request.getSession().getServletContext().getRealPath("/images/");

				PDDocument document = new PDDocument(); 
		      	PDPage pageItemDetails = null;
					
		      	@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
		     
		      	pageItemDetails = new PDPage(PDRectangle.A4);
					int pageCount = 1;
					
		        document.addPage(pageItemDetails);
		         PDPageContentStream contentStream = new PDPageContentStream(document, pageItemDetails);
          
		         Table materialUsedDetailsPageheader;
	    			
	    			
    			  TableBuilder materialUsedDetailsTableHeaderBuilder = Table.builder()
			                .addColumnsOfWidth(530)				                
			                .font(HELVETICA)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		         
		          Row materialUsedheaderName = Row.builder()
			                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          
		          
		          Row materialUsedinfo1 = Row.builder()
			                .add(TextCell.builder().text("RMC Product Wise Material Used Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
		    
		          
		          Row materialUsedinfo2 = Row.builder()
		                .add(TextCell.builder().text("From Date: "
		                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
		                .backgroundColor(WHITE)
		                .textColor(Color.BLACK)
		                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
		                .horizontalAlignment(CENTER)
		                .build();
		          
		       
		          materialUsedDetailsTableHeaderBuilder.addRow(materialUsedheaderName);
		          materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo1);
		          materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo2);
		       
		          materialUsedDetailsPageheader = materialUsedDetailsTableHeaderBuilder.build();
		          
		          
		          float startY = pageItemDetails.getMediaBox().getHeight() - PADDING20;
		          float currentY = startY;
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(materialUsedDetailsPageheader)
	                .startX(PADDING50)
	                .startY(currentY)
	                .build()
	                .draw();
		          
		          Table materialUsedDetails ;
		          
		          TableBuilder materialUsedDetailsBuilder = Table.builder()
		        		  .addColumnsOfWidth(80,55,55,55,55,55,55,55,55)				                
			              .font(HELVETICA)
			                .borderWidth(0.5F)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		          
		          
		          Row materialUseddetailsTableHeader = Row.builder()
		        		  	.add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("10 MM").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("20 MM").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("CRUSH SAND").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("SILICA SAND").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("WATER").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("ADD MIXTURE").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("CEMENT OPC").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("CEMENT PPC").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .backgroundColor(Color.LIGHT_GRAY)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          materialUsedDetailsBuilder.addRow(materialUseddetailsTableHeader);
		          
		          
		         
		         
		          int listSize = this.getRmcUsedIngreDAOList().size();
		          
		          for(int s=0;s<listSize;s++)
	        	  {
		        	  
	        		  if(currentY < 130)
	        		  {
	        			  pageCount++;
	        			  materialUsedDetails = materialUsedDetailsBuilder.build();
	        			  TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(materialUsedDetails)
			                .startX(PADDING30)
			                .startY(startY-70)
			                .build()
			                .draw();
	        			  
	        			  contentStream.close();
	        			  
	        			  contentStream = null;
				          
				      	PDPage materialUsedDetailsNewPage = new PDPage(new PDRectangle(830,580));
		        	 contentStream = new PDPageContentStream(document,materialUsedDetailsNewPage);
		        	 currentY =  materialUsedDetailsNewPage.getMediaBox().getHeight() - PADDING20;
		             document.addPage( materialUsedDetailsNewPage );
		            
		             
		             materialUsedDetailsPageheader = null;
		             materialUsedDetailsTableHeaderBuilder = null;
        			  
        			  
		             materialUsedDetailsTableHeaderBuilder = Table.builder()
				                .addColumnsOfWidth(530)				                
				                .font(HELVETICA)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			         
		             materialUsedheaderName = Row.builder()
				                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
				                .horizontalAlignment(CENTER)
				                .build();
			          
		             materialUsedinfo1 = Row.builder()
				                .add(TextCell.builder().text("RMC Product Wise Material Used Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
				                .horizontalAlignment(CENTER)
				                .build();
			       
			          
		             materialUsedinfo2 = Row.builder()
			                .add(TextCell.builder().text("From Date: "
			                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
			          
			       
		             materialUsedDetailsTableHeaderBuilder.addRow(materialUsedheaderName);
		             materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo1);
		             materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo2);
			       
		             materialUsedDetailsPageheader = materialUsedDetailsTableHeaderBuilder.build();
			          
		             materialUsedDetails = null;
			          
			          
			          
		             materialUsedDetailsBuilder = Table.builder()
		            		 .addColumnsOfWidth(80,55,55,55,55,55,55,55,55)				                
				               .font(HELVETICA)
				                .borderWidth(0.5F)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			          
			          
		             materialUseddetailsTableHeader = Row.builder()
		            		    .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("10 MM").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("20 MM").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("CRUSH SAND").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("WASH SAND").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("WATER").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("ADD MIXTURE").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("CEMENT OPC").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .add(TextCell.builder().text("CEMENT PPC").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
				                .backgroundColor(Color.LIGHT_GRAY)
  			                .textColor(Color.BLACK)
  			                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
  			                .horizontalAlignment(CENTER)
  			                .build();
		             materialUsedDetailsBuilder.addRow(materialUseddetailsTableHeader);
        			  
			          TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(materialUsedDetailsPageheader)
		                .startX(PADDING50)
		                .startY(currentY)
		                .build()
		                .draw();
		             
		          
	        		  }
	        		  
	        		  
	        		  RMCBillIngredientsUsedDAO dao = this.getRmcUsedIngreDAOList().get(s);
	        		  
	        	
	        		Row itemInfoRow = Row.builder()
	        					.add(TextCell.builder().text(dao.getProductName()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getTenmm()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getTwentymm()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getCrushsand()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getWashsand()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getWater()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getAddmixture()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getCementOPC()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getCementPPC()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .height(25F)					                
				                .build();
	        		  
	        		materialUsedDetailsBuilder.addRow(itemInfoRow);
		        	 
	        			currentY = currentY -25;
	        		  
	        	  }
	        	  
	        	

	        		Row totalInfoRow = Row.builder()
		        			  	.add(TextCell.builder().text("Total").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalTenMMUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalTwentyMMUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalCrushSandUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalWashSandUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalWaterUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalAddMixtureUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalOPCUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalPPCUsed()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(25F)					                
				                .build();
	        		materialUsedDetailsBuilder.addRow(totalInfoRow);
	        	  
	        		materialUsedDetails = materialUsedDetailsBuilder.build();
	        	  
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(materialUsedDetails)
	                .startX(PADDING30)
	                .startY(startY-70)
	                .build()
	                .draw();
		          
		     
		          contentStream.close();
		         
			       // System.out.println(path);
							
			        
			        document.save(path+"/product-wise-material-used-report.pdf");
			        document.close();
			        
			        response.setHeader("Content-disposition", "inline; filename=product-wise-material-used-report.pdf");
					response.setContentType("application/pdf");
					FileInputStream fileInputStream = new FileInputStream(path+"/product-wise-material-used-report.pdf");
					PrintWriter out = response.getWriter();  
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						out.write(bytes);
					}
					fileInputStream.close();
					out.flush();
					out.close();
				
				
				
				
			}catch (SQLException e) {
				//e.printStackTrace();
			
				addActionError("Records not found for specified dates!");
				
				
			} catch (IOException e) {
			
			
				//e.printStackTrace();
				addActionError("Records not found for specified dates!");
			}finally
			{
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
        }
	}
	public HttpServletRequest getRequest() {
		return request;
	}
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	public HttpServletResponse getResponse() {
		return response;
	}
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	
	public String getFromDate() {
		return fromDate;
	}
	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}
	public String getToDate() {
		return toDate;
	}
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	public Float getTotalTenMMUsed() {
		return totalTenMMUsed;
	}
	public void setTotalTenMMUsed(Float totalTenMMUsed) {
		this.totalTenMMUsed = totalTenMMUsed;
	}
	public Float getTotalTwentyMMUsed() {
		return totalTwentyMMUsed;
	}
	public void setTotalTwentyMMUsed(Float totalTwentyMMUsed) {
		this.totalTwentyMMUsed = totalTwentyMMUsed;
	}
	
	public Float getTotalWashSandUsed() {
		return totalWashSandUsed;
	}
	public void setTotalWashSandUsed(Float totalWashSandUsed) {
		this.totalWashSandUsed = totalWashSandUsed;
	}
	public Float getTotalCrushSandUsed() {
		return totalCrushSandUsed;
	}
	public void setTotalCrushSandUsed(Float totalCrushSandUsed) {
		this.totalCrushSandUsed = totalCrushSandUsed;
	}
	public Float getTotalAddMixtureUsed() {
		return totalAddMixtureUsed;
	}
	public void setTotalAddMixtureUsed(Float totalAddMixtureUsed) {
		this.totalAddMixtureUsed = totalAddMixtureUsed;
	}
	public Float getTotalOPCUsed() {
		return totalOPCUsed;
	}
	public void setTotalOPCUsed(Float totalOPCUsed) {
		this.totalOPCUsed = totalOPCUsed;
	}
	public Float getTotalPPCUsed() {
		return totalPPCUsed;
	}
	public void setTotalPPCUsed(Float totalPPCUsed) {
		this.totalPPCUsed = totalPPCUsed;
	}
	public Float getTotalWaterUsed() {
		return totalWaterUsed;
	}
	public void setTotalWaterUsed(Float totalWaterUsed) {
		this.totalWaterUsed = totalWaterUsed;
	}
	public List<RMCBillIngredientsUsedDAO> getRmcUsedIngreDAOList() {
		return rmcUsedIngreDAOList;
	}
	public void setRmcUsedIngreDAOList(List<RMCBillIngredientsUsedDAO> rmcUsedIngreDAOList) {
		this.rmcUsedIngreDAOList = rmcUsedIngreDAOList;
	}
	
	

}
