package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ItemWiseSaleReportDAO;
import com.stonecrusher.DAO.laborBalanceDetailsDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadEmployeeBalalnceReport extends ActionSupport implements SessionAware{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 4677590747781249146L;
	public HttpServletRequest request;
	public HttpServletResponse response;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	
	private String fromDate;
	private String toDate;
	
	private List<laborBalanceDetailsDAO> laborBalanceDetailsList = new ArrayList<laborBalanceDetailsDAO>();
	

	private Float totalSalaryAmount = 0.0f;
	private Float totalAmount = 0.0f;
	private String addSideBarJs;
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();


			this.setAddSideBarJs("FALSE");
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	

        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       		
       		String sql = "";
       		String db = (String) this.getSessionMap().get("db");
       		try {
       			
       			
       			
				connection = GetDBConnection.getDBConnection(db);
       			
       			
   			
       			
				Map<String, laborBalanceDetailsDAO> employeeMap = new HashMap<>();

				
				sql = "SELECT "
				        + "entry_id,"
				        + "employee_id,"
				        + "DATE_FORMAT(payment_date, '%d/%m/%Y'),"
				        + "payment_amount,"
				        + "employee_name "
				        + "FROM crusher_employee_payment_details "
				        + "WHERE (payment_date BETWEEN STR_TO_DATE(?, '%d-%m-%Y') "
				        + "AND STR_TO_DATE(?, '%d-%m-%Y')) "
				        + "AND crusher_id = ? "
				        + "AND crusher_code = ? ";

				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);

				resultSet = preparedStatement.executeQuery();
				while (resultSet.next()) {
				    String employeeId = resultSet.getString(2);
				    
				   
				    laborBalanceDetailsDAO dao = employeeMap.getOrDefault(employeeId, new laborBalanceDetailsDAO());
				    
				    dao.setEntryId(resultSet.getString(1));
				    dao.setEmployeeName(resultSet.getString(5));
				    dao.setDate(resultSet.getString(3));
				    dao.setAmount(dao.getAmount() + resultSet.getFloat(4)); // Accumulate payment amount

				    employeeMap.put(employeeId, dao);
				}

				
				if (resultSet != null) resultSet.close();
				if (preparedStatement != null) preparedStatement.close();

				
				sql = "SELECT "
				        + "entry_id,"
				        + "DATE_FORMAT(salary_from_date, '%d/%m/%Y'),"
				        + "DATE_FORMAT(salary_to_date, '%d/%m/%Y'),"
				        + "total_calculated_salary_amount,"
				        + "employee_id,"
				        + "employee_name "
				        + "FROM crusher_employee_salary_calculation_details "
				        + "WHERE (salary_to_date BETWEEN STR_TO_DATE(?, '%d-%m-%Y') "
				        + "AND STR_TO_DATE(?, '%d-%m-%Y')) "
				        + "AND crusher_id = ? "
				        + "AND crusher_code = ? ";

				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);

				resultSet = preparedStatement.executeQuery();
				while (resultSet.next()) {
				    String employeeId = resultSet.getString(5);
				    
				    
				    laborBalanceDetailsDAO dao = employeeMap.getOrDefault(employeeId, new laborBalanceDetailsDAO());

				    dao.setEntryId(resultSet.getString(1));
				    dao.setEmployeeName(resultSet.getString(6));
				    dao.setDate(resultSet.getString(2) + " - TO -" + resultSet.getString(3));
				    dao.setSalaryAmount(dao.getSalaryAmount() + resultSet.getFloat(4)); // Accumulate salary amount

				    employeeMap.put(employeeId, dao);
				}

				
				if (resultSet != null) resultSet.close();
				if (preparedStatement != null) preparedStatement.close();

				
				this.getLaborBalanceDetailsList().clear();
				this.getLaborBalanceDetailsList().addAll(employeeMap.values());

				
				
				this.setTotalSalaryAmount((float) employeeMap.values().stream().mapToDouble(laborBalanceDetailsDAO::getSalaryAmount).sum());
				this.setTotalAmount((float) employeeMap.values().stream().mapToDouble(laborBalanceDetailsDAO::getAmount).sum());

				
				
				
				 String path=	request.getSession().getServletContext().getRealPath("/images/");

				PDDocument document = new PDDocument(); 
		      	PDPage pageItemDetails = null;
					
		      	@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
		     
		      	pageItemDetails = new PDPage(PDRectangle.A4);
					int pageCount = 1;
					
		        document.addPage(pageItemDetails);
		         PDPageContentStream contentStream = new PDPageContentStream(document, pageItemDetails);
          
		         Table itemWiseSalesDetailsPageheader;
	    			
	    			
    			  TableBuilder itemWiseSaleDetailsTableHeaderBuilder = Table.builder()
			                .addColumnsOfWidth(530)				                
			                .font(HELVETICA)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		         
		          Row itemWiseSaleheaderName = Row.builder()
			                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          
		          
		          Row itemWiseSaleinfo1 = Row.builder()
			                .add(TextCell.builder().text("Employee Balance Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
		    
		          
		          Row itemWiseSaleinfo2 = Row.builder()
		                .add(TextCell.builder().text("From Date: "
		                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
		                .backgroundColor(WHITE)
		                .textColor(Color.BLACK)
		                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
		                .horizontalAlignment(CENTER)
		                .build();
		          
		       
		          itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleheaderName);
		          itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo1);
		          itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo2);
		       
		          itemWiseSalesDetailsPageheader = itemWiseSaleDetailsTableHeaderBuilder.build();
		          
		          
		          float startY = pageItemDetails.getMediaBox().getHeight() - PADDING20;
		          float currentY = startY;
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(itemWiseSalesDetailsPageheader)
	                .startX(PADDING50)
	                .startY(currentY)
	                .build()
	                .draw();
		          
		          Table itemSaleDetails ;
		          
		          TableBuilder itemSaleDetailsBuilder = Table.builder()
		        		  .addColumnsOfWidth(150,150,100,100)			                
				              .font(HELVETICA)
			                .borderWidth(0.5F)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		          
		          
		          Row itemWisrSaledetailsTableHeader = Row.builder()
		        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        	.add(TextCell.builder().text("Employee Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
			                .add(TextCell.builder().text("Amount to Be Paid/Salary").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("Amount Paid").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .backgroundColor(Color.LIGHT_GRAY)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          itemSaleDetailsBuilder.addRow(itemWisrSaledetailsTableHeader);
		          
		          
		         
		         
		          int listSize = this.getLaborBalanceDetailsList().size();
		          
		          for(int s=0;s<listSize;s++)
	        	  {
		        	  
	        		  if(currentY < 130)
	        		  {
	        			  pageCount++;
	        			  itemSaleDetails = itemSaleDetailsBuilder.build();
	        			  TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(itemSaleDetails)
			                .startX(PADDING50)
			                .startY(startY-70)
			                .build()
			                .draw();
	        			  
	        			  contentStream.close();
	        			  
	        			  contentStream = null;
				          
				      	PDPage itemDetailsNewPage = new PDPage(new PDRectangle(830,580));
		        	 contentStream = new PDPageContentStream(document,itemDetailsNewPage);
		        	 currentY =  itemDetailsNewPage.getMediaBox().getHeight() - PADDING20;
		             document.addPage( itemDetailsNewPage );
		            
		             
		             itemWiseSalesDetailsPageheader = null;
		             itemWiseSaleDetailsTableHeaderBuilder = null;
        			  
        			  
		             itemWiseSaleDetailsTableHeaderBuilder = Table.builder()
				                .addColumnsOfWidth(530)				                
				                .font(HELVETICA)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			         
		             itemWiseSaleheaderName = Row.builder()
				                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
				                .horizontalAlignment(CENTER)
				                .build();
			          
		             itemWiseSaleinfo1 = Row.builder()
				                .add(TextCell.builder().text("Employee Balance Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
				                .horizontalAlignment(CENTER)
				                .build();
			       
			          
		             itemWiseSaleinfo2 = Row.builder()
			                .add(TextCell.builder().text("From Date: "
			                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
			          
			       
		             itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleheaderName);
		             itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo1);
		             itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo2);
			       
		             itemWiseSalesDetailsPageheader = itemWiseSaleDetailsTableHeaderBuilder.build();
			          
		             itemSaleDetails = null;
			          
			          
			          
        			  itemSaleDetailsBuilder = Table.builder()
        					  	.addColumnsOfWidth(150,150,100,100)			                
					            .font(HELVETICA)
				                .borderWidth(0.5F)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			          
			          
        			  itemWisrSaledetailsTableHeader = Row.builder()
        					  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
  				        	.add(TextCell.builder().text("Employee Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
  			                .add(TextCell.builder().text("Amount to Be Paid/Salary").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
  			                .add(TextCell.builder().text("Amount Paid").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
  			                .backgroundColor(Color.LIGHT_GRAY)
  			                .textColor(Color.BLACK)
  			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
  			                .horizontalAlignment(CENTER)
  			                .build();
  		          itemSaleDetailsBuilder.addRow(itemWisrSaledetailsTableHeader);
        			  
			          TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(itemWiseSalesDetailsPageheader)
		                .startX(PADDING50)
		                .startY(currentY)
		                .build()
		                .draw();
		             
		          
	        		  }
	        		  
	        		  
	        		  laborBalanceDetailsDAO dao = this.getLaborBalanceDetailsList().get(s);
	        		  
	        	
	        		Row itemInfoRow = Row.builder()
	        					.add(TextCell.builder().text(dao.getDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(dao.getEmployeeName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getSalaryAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(10)				              
				                .horizontalAlignment(CENTER)
				                .height(25F)					                
				                .build();
	        		  
	        		itemSaleDetailsBuilder.addRow(itemInfoRow);
		        	 
	        			currentY = currentY -25;
	        		  
	        	  }
	        	  
	        	

	        		Row totalInfoRow = Row.builder()
		        			  	.add(TextCell.builder().text("Total").colSpan(2).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalSalaryAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(12)				              
				                .horizontalAlignment(CENTER)
				                .height(25F)					                
				                .build();
	        		itemSaleDetailsBuilder.addRow(totalInfoRow);
	        	  
	        		itemSaleDetails = itemSaleDetailsBuilder.build();
	        	  
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(itemSaleDetails)
	                .startX(PADDING50)
	                .startY(startY-70)
	                .build()
	                .draw();
		          
		     
		          contentStream.close();
		         
			       // System.out.println(path);
							
			        
			        document.save(path+"/employee-balance-report.pdf");
			        document.close();
			        
			        response.setHeader("Content-disposition", "inline; filename=employee-balance-report.pdf");
					response.setContentType("application/pdf");
					FileInputStream fileInputStream = new FileInputStream(path+"/employee-balance-report.pdf");
					PrintWriter out = response.getWriter();  
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						out.write(bytes);
					}
					fileInputStream.close();
					out.flush();
					out.close();
				
				
				
				
			}catch (SQLException e) {
				e.printStackTrace();
			
				addActionError("Records not found for specified dates!");
				
				
			} catch (Exception e) {
			
			
				e.printStackTrace();
				addActionError("Records not found for specified dates!");
			}finally
			{
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
        }
	}
	public HttpServletRequest getRequest() {
		return request;
	}
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	public HttpServletResponse getResponse() {
		return response;
	}
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	
	public String getFromDate() {
		return fromDate;
	}
	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}
	public String getToDate() {
		return toDate;
	}
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	


	public List<laborBalanceDetailsDAO> getLaborBalanceDetailsList() {
		return laborBalanceDetailsList;
	}
	public void setLaborBalanceDetailsList(List<laborBalanceDetailsDAO> laborBalanceDetailsList) {
		this.laborBalanceDetailsList = laborBalanceDetailsList;
	}
	public Float getTotalSalaryAmount() {
		return totalSalaryAmount;
	}
	public void setTotalSalaryAmount(Float totalSalaryAmount) {
		this.totalSalaryAmount = totalSalaryAmount;
	}
	public Float getTotalAmount() {
		return totalAmount;
	}
	public void setTotalAmount(Float totalAmount) {
		this.totalAmount = totalAmount;
	}
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	
	

}
