package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.EmployeeAbsentHalfOvertimeInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DownloadEmployeeAbsentReport extends ActionSupport implements SessionAware{

	
	

	/**
	 * 
	 */
	private static final long serialVersionUID = 21504356203314628L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

    private HttpSession session;
    private String fromDate;
	private String toDate;
	private ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> employeeAbsentHalfOvertimeList = new ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> ();
	private String addSideBarJs;
	private String LaborIdName;
	private String type;
	private String markingType;
	
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();
			
			String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	
        	Connection connection = null;
    		PreparedStatement preparedStatement= null;
    		ResultSet resultSet = null;
    	 
    		String sql = "";
    		String db = (String) session.getAttribute("db");
    		
    		try
			{
				connection = GetDBConnection.getDBConnection(db);
				
				if(this.getType().equals("Type 1"))
				{
					if(this.getMarkingType().equals("ALL") || this.getMarkingType().equals("ABSENT"))
					{
						
					
			 
				if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
				{
	    		

	    		sql = "SELECT "
						+ "entry_id,"
						+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
						+ "employee_id,"
						+ "employee_name,"
						+ "details,"
						+ "type_of_marking "
						+ "FROM "
						+ "crusher_employee_presenty_details "
						+ "WHERE "
						+ "type_of_marking = ? "
						+ "AND "
                        + "(marking_date BETWEEN "
						+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "ORDER BY marking_date ";

				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, "ABSENT");
				preparedStatement.setString(2, this.getFromDate());
				preparedStatement.setString(3, this.getToDate());
				preparedStatement.setString(4, crusherId);
				preparedStatement.setString(5, crusherCode);
				
	    		
	    	}else {
	    		
				sql = "SELECT "
						+ "entry_id,"
						+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
						+ "employee_id,"
						+ "employee_name,"
						+ "details,"
						+ "type_of_marking "
						+ "FROM "
						+ "crusher_employee_presenty_details "
						+ "WHERE "
						+ "type_of_marking = ? "
						+ "AND "
                        + "(marking_date BETWEEN "
						+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "AND "
						+ "employee_id = ? "
						+ "ORDER BY marking_date ";

				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, "ABSENT");
				preparedStatement.setString(2, this.getFromDate());
				preparedStatement.setString(3, this.getToDate());
				preparedStatement.setString(4, crusherId);
				preparedStatement.setString(5, crusherCode);
				preparedStatement.setString(6, this.getLaborIdName().split("-")[0]);

	    	}
	    		
				
				

				resultSet = preparedStatement.executeQuery();
				
				resultSet.last();
				int rowCount = resultSet.getRow();
				resultSet.beforeFirst();
				if(rowCount > 0)
				{
					while(resultSet.next())
					{
						EmployeeAbsentHalfOvertimeInfoDAO dao = new EmployeeAbsentHalfOvertimeInfoDAO();
						
						dao.setEntryId(EncryptionDecryption.encrypt(resultSet.getString(1)));
						dao.setMarkingDate(resultSet.getString(2));
						dao.setEmployeeId(resultSet.getString(3));
						dao.setEmployeeName(resultSet.getString(4));
						dao.setDetails(resultSet.getString(5));
						dao.setMarkingType(resultSet.getString(6));
						
						this.getEmployeeAbsentHalfOvertimeList().add(dao);
								
					}
				}
				
				
					}
					
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
				
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					
					
					if(this.getMarkingType().equals("ALL") || this.getMarkingType().equals("HALFDAY"))
					{
						
						

						if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
						{
			    		

			    		sql = "SELECT "
								+ "entry_id,"
								+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
								+ "employee_id,"
								+ "employee_name,"
								+ "details,"
								+ "type_of_marking "
								+ "FROM "
								+ "crusher_employee_presenty_details "
								+ "WHERE "
								+ "type_of_marking = ? "
								+ "AND "
	                            + "(marking_date BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY marking_date ";

						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, "HALFDAY");
						preparedStatement.setString(2, this.getFromDate());
						preparedStatement.setString(3, this.getToDate());
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						
			    		
			    	}else {
			    		
						sql = "SELECT "
								+ "entry_id,"
								+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
								+ "employee_id,"
								+ "employee_name,"
								+ "details,"
								+ "type_of_marking "
								+ "FROM "
								+ "crusher_employee_presenty_details "
								+ "WHERE "
								+ "type_of_marking = ? "
								+ "AND "
	                            + "(marking_date BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "AND "
								+ "employee_id = ? "
								+ "ORDER BY marking_date ";

						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, "HALFDAY");
						preparedStatement.setString(2, this.getFromDate());
						preparedStatement.setString(3, this.getToDate());
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						preparedStatement.setString(6, this.getLaborIdName().split("-")[0]);

			    	}
						resultSet = preparedStatement.executeQuery();
						
						resultSet.last();
						int rowCount = resultSet.getRow();
						resultSet.beforeFirst();
						if(rowCount > 0)
						{
							while(resultSet.next())
							{
								
								EmployeeAbsentHalfOvertimeInfoDAO dao = new EmployeeAbsentHalfOvertimeInfoDAO();
								
								dao.setEntryId(EncryptionDecryption.encrypt(resultSet.getString(1)));
								dao.setMarkingDate(resultSet.getString(2));
								dao.setEmployeeId(resultSet.getString(3));
								dao.setEmployeeName(resultSet.getString(4));
								dao.setDetails(resultSet.getString(5));
								dao.setMarkingType(resultSet.getString(6));
								
								this.getEmployeeAbsentHalfOvertimeList().add(dao);
											
							}
						}
						
					}
					
					
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					
					
					if(this.getMarkingType().equals("ALL") || this.getMarkingType().equals("OVERTIME"))
					{
						
						

						if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
						{
			    		

			    		sql = "SELECT "
								+ "entry_id,"
								+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
								+ "employee_id,"
								+ "employee_name,"
								+ "details,"
								+ "type_of_marking "
								+ "FROM "
								+ "crusher_employee_presenty_details "
								+ "WHERE "
								+ "type_of_marking = ? "
								+ "AND "
	                            + "(marking_date BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY marking_date ";

						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, "OVERTIME");
						preparedStatement.setString(2, this.getFromDate());
						preparedStatement.setString(3, this.getToDate());
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						
			    		
			    	}else {
			    		
						sql = "SELECT "
								+ "entry_id,"
								+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
								+ "employee_id,"
								+ "employee_name,"
								+ "details,"
								+ "type_of_marking "
								+ "FROM "
								+ "crusher_employee_presenty_details "
								+ "WHERE "
								+ "type_of_marking = ? "
								+ "AND "
	                            + "(marking_date BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "AND "
								+ "employee_id = ? "
								+ "ORDER BY marking_date ";

						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, "OVERTIME");
						preparedStatement.setString(2, this.getFromDate());
						preparedStatement.setString(3, this.getToDate());
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						preparedStatement.setString(6, this.getLaborIdName().split("-")[0]);

			    	}
						resultSet = preparedStatement.executeQuery();
						
						resultSet.last();
						int rowCount = resultSet.getRow();
						resultSet.beforeFirst();
						if(rowCount > 0)
						{
							while(resultSet.next())
							{
								
								EmployeeAbsentHalfOvertimeInfoDAO dao = new EmployeeAbsentHalfOvertimeInfoDAO();
								
								dao.setEntryId(EncryptionDecryption.encrypt(resultSet.getString(1)));
								dao.setMarkingDate(resultSet.getString(2));
								dao.setEmployeeId(resultSet.getString(3));
								dao.setEmployeeName(resultSet.getString(4));
								dao.setDetails(resultSet.getString(5));
								dao.setMarkingType(resultSet.getString(6));
								
								this.getEmployeeAbsentHalfOvertimeList().add(dao);
								
											
							}
						}
						
					}
					
				}
				
				

				if(this.getType().equals("Type 2"))
				{
					
					
					SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
					

					int noOfDays = 0;
					try {
					    Date date1 = myFormat.parse(this.getFromDate());
					    Date date2 = myFormat.parse(this.getToDate());
					    long diff = date2.getTime() - date1.getTime();
					    noOfDays = (int) TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS) +1;
					} catch (ParseException e) {}
				
					
					
					if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
					{
		    		

						sql = "SELECT "
								+ "employee_id,"
								+ "employee_name,"
								+ "type_of_marking "
								+ "FROM "
								+ "crusher_employee_presenty_details "
								+ "WHERE "
								+ "(marking_date BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y'))"
								+ "AND "
							    + "crusher_id = ? "
							    + "AND "
							    + "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, this.getFromDate());
						preparedStatement.setString(2, this.getToDate());
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						
					
		    		
		    	}else {
		    		
		    		sql = "SELECT "
		    				+ "employee_id,"
							+ "employee_name,"
							+ "type_of_marking "
							+ "FROM "
							+ "crusher_employee_presenty_details "
							+ "WHERE "
							+ "employee_id = ? "
							+ "AND "
							+ "(marking_date BETWEEN "
							+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y'))"
							+ "AND "
						    + "crusher_id = ? "
						    + "AND "
						    + "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, this.getLaborIdName().split("-")[0]);
					preparedStatement.setString(2, this.getFromDate());
					preparedStatement.setString(3, this.getToDate());
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					
					
						}
					
					
					
					 resultSet = preparedStatement.executeQuery();
						
						resultSet.last();
						int rowCount = resultSet.getRow();
						resultSet.beforeFirst();
						if(rowCount > 0)
						{
							Map<String, EmployeeAbsentHalfOvertimeInfoDAO> employeeMap = new LinkedHashMap<>();

							while (resultSet.next()) {
							    String empId = resultSet.getString(1);
							    String empName = resultSet.getString(2);
							    String typeOfMarking = resultSet.getString(3);

							    EmployeeAbsentHalfOvertimeInfoDAO dao = employeeMap.get(empId);

							    if (dao == null) {
							        dao = new EmployeeAbsentHalfOvertimeInfoDAO();
							        dao.setEmployeeId(empId);
							        dao.setEmployeeName(empName);
							        dao.setNoOfDaysInMonth(noOfDays);
							        dao.setNoOfDaysAbsentDays(0);
							        dao.setNoOfHalfDays(0);
							        dao.setNoOfOverTime(0);
							        employeeMap.put(empId, dao);
							    }

							    if ("ABSENT".equalsIgnoreCase(typeOfMarking)) {
							        dao.setNoOfDaysAbsentDays(dao.getNoOfDaysAbsentDays() + 1);
							    } else if ("HALFDAY".equalsIgnoreCase(typeOfMarking)) {
							        dao.setNoOfHalfDays(dao.getNoOfHalfDays() + 1);
							    } else if ("OVERTIME".equalsIgnoreCase(typeOfMarking)) {
							        dao.setNoOfOverTime(dao.getNoOfOverTime() + 1);
							    }
							}

							
							for (EmployeeAbsentHalfOvertimeInfoDAO dao : employeeMap.values()) {
							    dao.setNoOfFullDays(dao.getNoOfDaysInMonth() - (dao.getNoOfDaysAbsentDays() + dao.getNoOfHalfDays()));
							    this.getEmployeeAbsentHalfOvertimeList().add(dao);
							}

						}
							
							
					
				
				
					
					
				}
				
				
				
				if(this.getEmployeeAbsentHalfOvertimeList().size() > 0)
				{
					
				}else {
					addActionError(this.getText("message.error.noEmployeeAbsentDetailsForThisDate"));
					
				}
    			
    			
    			
				if(this.getType().equals("Type 1"))
				{
    			
				@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
				
				
    			
    			String path=	request.getSession().getServletContext().getRealPath("/images/");
    			PDDocument document = new PDDocument(); 
				PDPage page = null;
				
				
					 page = new PDPage(PDRectangle.A4);
				
				
			        document.addPage(page);
			         PDPageContentStream contentStream = new PDPageContentStream(document, page);
			         int pageCount = 1;
		    			 Table header;
		    			 Table absentDetails;
		    			 
		    			
		    			  TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row info1 = Row.builder()
					                .add(TextCell.builder().text("Employee  ABSENT/HALFDAY/OVERTIME Report  "
					                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info2 = Row.builder()
					                .add(TextCell.builder().text("From Date : "
					                		+ ""+this.getFromDate()
					                		+ " and To Date :"+this.getToDate()  ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info3 = Row.builder()
					                .add(TextCell.builder().text("Type : "
					                		+ ""+this.getType()
					                		+ " and Marking Type :"+this.getMarkingType()  ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				          
				          tableHeaderBuilder.addRow(headerName);
				          tableHeaderBuilder.addRow(info1);
				          tableHeaderBuilder.addRow(info2);
				          tableHeaderBuilder.addRow(info3);
				          header = tableHeaderBuilder.build();
				          
				          
				          TableBuilder tableabsentDetailsBuilder = Table.builder()
				        		  .addColumnsOfWidth(80,80, 80, 150, 130) 
	        					   .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				          
				          Row tableHeader = Row.builder()
				        		  	.add(TextCell.builder().text("Marking Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        		  	.add(TextCell.builder().text("Marking Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Employee Id").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Employee Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          tableabsentDetailsBuilder.addRow(tableHeader);
				       
				        
				     
				        	  int size = this.getEmployeeAbsentHalfOvertimeList().size();
				        	  
				        	  
					          float startY = page.getMediaBox().getHeight() - PADDING20;
					          float currentY = startY;
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
					          
					          
					          
					    	  for(int s=0;s<size;s++)
				        	  {
				        		  
				        		  if(currentY < 50)
				        		  {
				        			  pageCount++;
				        			  absentDetails = tableabsentDetailsBuilder.build();
				        			  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(absentDetails)
						                .startX(PADDING30)
						                .startY(startY-50)
						                .build()
						                .draw();
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			 
						    			 
						    			
						    			  tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(550)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								           headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								           info1 = Row.builder()
									                .add(TextCell.builder().text("Employee  ABSENT/HALFDAY/OVERTIME Report  "
								                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
								           info2 = Row.builder()
									                .add(TextCell.builder().text("From Date : "
									                		+ ""+this.getFromDate()
									                		+ " and To Date :"+this.getToDate() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								            info3 = Row.builder()
									                .add(TextCell.builder().text("Type : "
									                		+ ""+this.getType()
									                		+ " and Marking Type :"+this.getMarkingType()  ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								          tableHeaderBuilder.addRow(info3);
								          header = tableHeaderBuilder.build();
				        			  
				        			  absentDetails = null;
				        			   tableabsentDetailsBuilder = Table.builder()
				        					   .addColumnsOfWidth(80,80, 80, 150, 130) 
				        					   .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							           tableHeader = Row.builder()
							        		   .add(TextCell.builder().text("Marking Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        		   .add(TextCell.builder().text("Marking Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text("Employee Id").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Employee Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          tableabsentDetailsBuilder.addRow(tableHeader);
							          
				        			  
				        				PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
				        		  }
				        		  
				        		  EmployeeAbsentHalfOvertimeInfoDAO dao2 = this.getEmployeeAbsentHalfOvertimeList().get(s);
				        		  
				        			Row absentInfo = Row.builder()
				        					.add(TextCell.builder().text(dao2.getMarkingDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        					.add(TextCell.builder().text(dao2.getMarkingType()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getEmployeeId()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getEmployeeName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getDetails()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableabsentDetailsBuilder.addRow(absentInfo);
					        	 
					        	  currentY = currentY -25;
				        	  }
					          
							
				        	  absentDetails = tableabsentDetailsBuilder.build();
				         
				          
				          TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(absentDetails)
			                .startX(PADDING30)
			                .startY(startY-70)
			                .build()
			                .draw();
				          contentStream.close();
					          
					          
					          
					          document.save(path+"/employee-absent-halfday-overtime-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Type-"+this.getType()+"-MarkingType-"+this.getMarkingType()+"-report.pdf");
						        document.close();
						        
						        response.setHeader("Content-disposition", "inline; filename=employee-absent-halfday-overtime-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Type-"+this.getType()+"-MarkingType-"+this.getMarkingType()+"-report.pdf");
								response.setContentType("application/pdf");
								
								FileInputStream fileInputStream = new FileInputStream(path+"/employee-absent-halfday-overtime-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Type-"+this.getType()+"-MarkingType-"+this.getMarkingType()+"-report.pdf");
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.flush();
								out.close();
								
				}
				
				
				
				
				
				
				if(this.getType().equals("Type 2"))
				{
    			
				@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
				
				
    			
    			String path=	request.getSession().getServletContext().getRealPath("/images/");
    			PDDocument document = new PDDocument(); 
				PDPage page = null;
				
				
					 page = new PDPage(PDRectangle.A4);
				
				
			        document.addPage(page);
			         PDPageContentStream contentStream = new PDPageContentStream(document, page);
			         int pageCount = 1;
		    			 Table header;
		    			 Table absentDetails;
		    			 
		    			
		    			  TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row info1 = Row.builder()
					                .add(TextCell.builder().text("Employee  ABSENT/HALFDAY/OVERTIME Report  "
					                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info2 = Row.builder()
					                .add(TextCell.builder().text("From Date : "
					                		+ ""+this.getFromDate()
					                		+ " and To Date :"+this.getToDate()  ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info3 = Row.builder()
					                .add(TextCell.builder().text("Type : "
					                		+ ""+this.getType() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				          
				          tableHeaderBuilder.addRow(headerName);
				          tableHeaderBuilder.addRow(info1);
				          tableHeaderBuilder.addRow(info2);
				          tableHeaderBuilder.addRow(info3);
				          header = tableHeaderBuilder.build();
				          
				          
				          TableBuilder tableabsentDetailsBuilder = Table.builder()
				        		  .addColumnsOfWidth(80, 130, 80 , 80 ,80 ,80) 
	        					   .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				          
				          Row tableHeader = Row.builder()
				        		  	.add(TextCell.builder().text("Employee Id").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Employee Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("No Of Present Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("No Of Absent Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("No Of HalfDay Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("No Of OverTime Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          tableabsentDetailsBuilder.addRow(tableHeader);
				       
				        
				     
				        	  int size = this.getEmployeeAbsentHalfOvertimeList().size();
				        	  
				        	  
					          float startY = page.getMediaBox().getHeight() - PADDING20;
					          float currentY = startY;
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
					          
					          
					          
					    	  for(int s=0;s<size;s++)
				        	  {
				        		  
				        		  if(currentY < 50)
				        		  {
				        			  pageCount++;
				        			  absentDetails = tableabsentDetailsBuilder.build();
				        			  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(absentDetails)
						                .startX(PADDING30)
						                .startY(startY-50)
						                .build()
						                .draw();
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			 
						    			 
						    			
						    			  tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(550)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								           headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								           info1 = Row.builder()
									                .add(TextCell.builder().text("Employee  ABSENT/HALFDAY/OVERTIME Report  "
								                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
								           info2 = Row.builder()
									                .add(TextCell.builder().text("From Date : "
									                		+ ""+this.getFromDate()
									                		+ " and To Date :"+this.getToDate() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								            info3 = Row.builder()
									                .add(TextCell.builder().text("Type : "
									                		+ ""+this.getType() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								          tableHeaderBuilder.addRow(info3);
								          header = tableHeaderBuilder.build();
				        			  
				        			  absentDetails = null;
				        			   tableabsentDetailsBuilder = Table.builder()
				        					   .addColumnsOfWidth(80, 130, 80 , 80 ,80 ,80) 
					        					  .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							           tableHeader = Row.builder()
							        		   .add(TextCell.builder().text("Employee Id").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Employee Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("No Of Present Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("No Of Absent Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("No Of HalfDay Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("No Of OverTime Days").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                 .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          tableabsentDetailsBuilder.addRow(tableHeader);
							          
				        			  
				        				PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
				        		  }
				        		  
				        		  EmployeeAbsentHalfOvertimeInfoDAO dao2 = this.getEmployeeAbsentHalfOvertimeList().get(s);
				        		  
				        			Row absentInfo = Row.builder()
				        					.add(TextCell.builder().text(dao2.getEmployeeId()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getEmployeeName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getNoOfFullDays()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getNoOfDaysAbsentDays()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getNoOfHalfDays()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getNoOfOverTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableabsentDetailsBuilder.addRow(absentInfo);
					        	 
					        	  currentY = currentY -25;
				        	  }
					          
							
				        	  absentDetails = tableabsentDetailsBuilder.build();
				         
				          
				          TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(absentDetails)
			                .startX(PADDING30)
			                .startY(startY-70)
			                .build()
			                .draw();
				          contentStream.close();
					          
					          
					          
					          document.save(path+"/employee-absent-halfday-overtime-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Type-"+this.getType()+"-report.pdf");
						        document.close();
						        
						        response.setHeader("Content-disposition", "inline; filename=employee-absent-halfday-overtime-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Type-"+this.getType()+"-report.pdf");
								response.setContentType("application/pdf");
								
								FileInputStream fileInputStream = new FileInputStream(path+"/employee-absent-halfday-overtime-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Type-"+this.getType()+"-report.pdf");
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.flush();
								out.close();
								
				}
				
    			
    		}
    		catch (SQLException e) 
    		{
	    		 e.printStackTrace();
	    				    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    			
	    	} catch (Exception e) {
	    		
	    		e.printStackTrace();	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || Something Went Wrong!");
	    	}
    			finally {
    				if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
        }
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	 

	public ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> getEmployeeAbsentHalfOvertimeList() {
		return employeeAbsentHalfOvertimeList;
	}


	public void setEmployeeAbsentHalfOvertimeList(
			ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> employeeAbsentHalfOvertimeList) {
		this.employeeAbsentHalfOvertimeList = employeeAbsentHalfOvertimeList;
	}


	public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}


	public String getMarkingType() {
		return markingType;
	}


	public void setMarkingType(String markingType) {
		this.markingType = markingType;
	}


	public String getLaborIdName() {
		return LaborIdName;
	}


	public void setLaborIdName(String laborIdName) {
		LaborIdName = laborIdName;
	}


	


	




	

}
