package com.stonecrusher.download;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerCreditReportDAO;
import com.stonecrusher.DAO.CustomerInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;



public class DownloadCustCreditReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 693683379006686061L;
	
		public HttpServletRequest request;
		public HttpServletResponse response;
	
		private final static Color BLUE_DARK = new Color(76, 129, 190);
	    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
	    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

	    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
	    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
	    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
	    private static final float PADDING10 = 10f;
	    private static final float PADDING20 = 20f;
	    private static final float PADDING30 = 30f;
	    private static final float PADDING40 = 40f;
	    private static final float PADDING50 = 50f;

	private HttpSession session;
	private String minAmount;
	private String maxAmount;
	private String startDate;
	private String endDate;
	private List<CustomerCreditReportDAO> custCreditList = new ArrayList<CustomerCreditReportDAO>();	
	private float totolReportBillAmount = 0.0F;
	private float totalReportPaymentAmount = 0.0F;
	private float totalReportCreditAmount = 0.0F;
	
	private Float totalReportAfterDateBillAmt = 0.0f;
	private Float totalReportAfterDatePaymentAmt = 0.0F;
	private Float totalReportAfterDateBalAmt = 0.0F;

	private String downloadFileType;
	private String custIdStart;
	private String custIdEnd;
	private String addSideBarJs;
	private String fromDate;
	private String toDate;
	

		private String downloadFileLanguage;
	
	
	private SessionMap<String,Object> sessionMap;  

	
	public void download ()
	
    {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	
	        	response = ServletActionContext.getResponse();
				request = ServletActionContext.getRequest();
				
	    		DecimalFormat df = new DecimalFormat("##.##");
	        	String actualStartDate = "";
	        
	    		if(!this.getFromDate().equals("") && !this.getToDate().equals(""))
	        	{
	        		
		        	this.setStartDate(this.getFromDate());
		        	this.setEndDate(this.getToDate());
		       	
		        	Date today = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
		        	
		        	Calendar cal = Calendar.getInstance(); cal.setTime(today); // don't forget this if date is arbitrary e.g. 01-01-2014
		        	int year = cal.get(Calendar.YEAR);
		       
		        	
		        	actualStartDate = "01-04-"+(year-2);
		        	
		        	
	        	}else
	        	{
		        	Date today = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
		        	
		        	Calendar cal = Calendar.getInstance(); cal.setTime(today); // don't forget this if date is arbitrary e.g. 01-01-2014
		        	int year = cal.get(Calendar.YEAR);
		       
		        	SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-YYYY");
		        	
		        	actualStartDate = "01-04-"+(year-2);
		        	
		        	this.setStartDate("01-04-"+(year-2));
		        	this.setEndDate(sdf.format(today));
	        	}
	        	
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		

	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	    		SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-YYYY");
				   
	    		
	    		try
	    		{
	    			 Map<String,CustomerInfoDAO> customerInfoMap = new LinkedHashMap<String,CustomerInfoDAO>();
	    		
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			sql = "SELECT "
	    					+ "customer_id,"
	    					+ "customer_name,"
	    					+ "mobile_number,"
	    					+ "billing_address,"
	    					+ "credit_limit "
	    					+ "FROM "
	    					+ "crusher_customer_master "
	    					+ "WHERE "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? "
	    					+ "ORDER BY customer_name asc";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			/*preparedStatement.setString(1, this.getCustIdStart());
	    			preparedStatement.setString(2, this.getCustIdEnd());*/
	    			
	    			preparedStatement.setString(1, crusherId);
	    			preparedStatement.setString(2, crusherCode);
	    			
	    			resultSet = preparedStatement.executeQuery();
	    			int count = 1;
	    		
	    		
	    			while(resultSet.next())
	    			{
	    				CustomerInfoDAO customerInfoDAO = new CustomerInfoDAO();
	    				
	    				customerInfoDAO.setCustomerId(resultSet.getString(1));
	    				customerInfoDAO.setCustName(resultSet.getString(2));
	    				customerInfoDAO.setMobileNumber(resultSet.getString(3));
	    				customerInfoDAO.setBillingaddress(resultSet.getString(4));
	    				customerInfoDAO.setCreditlimit(resultSet.getString(5));
	    				
	    				customerInfoMap.put(resultSet.getString(1),customerInfoDAO);	    				
	    			}
	    			
	    			if(resultSet != null)
	    			{
	    				resultSet.close();
	    				resultSet = null;
	    			}
	    			
	    			if(preparedStatement != null)
	    			{
	    				preparedStatement.close();
	    				preparedStatement = null;
	    			}
	    			
	    			Map<String,CustomerCreditReportDAO> custCreditReportMap = new LinkedHashMap<String,CustomerCreditReportDAO>() ;
	    			
	    			for(String custId: customerInfoMap.keySet())
	    			{
	    				float opeingBalFloat = 0.0F;
       					PreparedStatement getOpeningBalPSMT = null;
           				ResultSet getOpeningBalRs = null;
           				String getOpeningBalSQL = "SELECT "
           						+ "opening_balance,"
           						+ "DATE_FORMAT(opening_balance_date,'%d/%m/%Y'),"
           						+ "updated_by "
           						+ "FROM "
           						+ "crusher_cust_close_open_bal_master "
           						+ "WHERE "
           						+ "customer_id = ? "
           						+ "AND "
           						+ "crusher_id = ? "
           						+ "AND "
           						+ "crusher_code = ?";
           				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
           				
           				getOpeningBalPSMT.setString(1, custId);
           				getOpeningBalPSMT.setString(2, crusherId);
           				getOpeningBalPSMT.setString(3, crusherCode);
           				
           				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
           				
           				if(getOpeningBalRs.next())
           				{
       					
           					opeingBalFloat = getOpeningBalRs.getFloat(1);
       					
           				}
           				
           			//	System.out.println(opeingBalFloat);
           				if(getOpeningBalRs != null)
           				{
           					getOpeningBalRs.close();
           					getOpeningBalRs = null;
           				}
           				if(getOpeningBalPSMT != null)
           				{
           					getOpeningBalPSMT.close();
           					getOpeningBalPSMT = null;
           				}
       					
       					
           				
	    				CustomerInfoDAO customerInfoDAO = customerInfoMap.get(custId);
	    				CustomerCreditReportDAO creditReportDAO = new CustomerCreditReportDAO();
	    				creditReportDAO.setCustometName(customerInfoDAO.getCustName());
	    				creditReportDAO.setCustomerMobile(customerInfoDAO.getMobileNumber());
	    				creditReportDAO.setCustomerAddress(customerInfoDAO.getBillingaddress());
	    				creditReportDAO.setOpeningBalance(opeingBalFloat);
	    				creditReportDAO.setSrNo(count);
	    				
	    				customerInfoDAO.setOpeningBalance(opeingBalFloat);
		    			
	    				
	    				count ++;
	    				
	    				float custTotalPaymentAmount = 0.0F;
	    				
	    				float custAfterDateTotalPayment = 0.0F;
	    				
	    				PreparedStatement getCustPaymentDetailsPSMT = null;
	    				ResultSet getCustPaymnetDetailsRS = null;
	    				
	    			
	    			
	    		 String getCustPaymentDetailsSQL = "SELECT "
    						+ "SUM(amount) "
	       					+ "FROM "
	       					+ "crusher_customer_payment_details_master "
	       					+ "WHERE "
	       					+ "customer_id = ? "
	       					+ "AND "
	       					+ "(payment_date "
	       					+ "BETWEEN "
	       					+ "STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
	       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
	       					+ "AND "
	       					+ "crusher_id = ? "
	       					+ "AND "
	       					+ "crusher_code = ? ";
		
			getCustPaymentDetailsPSMT = connection.prepareStatement(getCustPaymentDetailsSQL);
			
			getCustPaymentDetailsPSMT.setString(1, custId);
			getCustPaymentDetailsPSMT.setString(2, this.getStartDate());
			getCustPaymentDetailsPSMT.setString(3, this.getEndDate());
			getCustPaymentDetailsPSMT.setString(4, crusherId);
			getCustPaymentDetailsPSMT.setString(5, crusherCode);
			
			//System.out.println(getCustPaymentDetailsPSMT.toString());
			
			getCustPaymnetDetailsRS = getCustPaymentDetailsPSMT.executeQuery();
			
			if(getCustPaymnetDetailsRS.next())
			{
				if(getCustPaymnetDetailsRS.getString(1) != null)
				{
					custAfterDateTotalPayment = getCustPaymnetDetailsRS.getFloat(1);
				}
			}
	    			
			creditReportDAO.setTotalPaymentAfterDate(df.format(custAfterDateTotalPayment));
			custTotalPaymentAmount = custAfterDateTotalPayment;
			
			creditReportDAO.setTotalPaymentAmount(df.format(custTotalPaymentAmount));
			
			custCreditReportMap.put(custId, creditReportDAO);
	    			
	    			
			    			if(getCustPaymnetDetailsRS != null)
			    			{
			    				getCustPaymnetDetailsRS.close();
			    				getCustPaymnetDetailsRS = null;
			    			}
			    			
			    			if(getCustPaymentDetailsPSMT != null)
			    			{
			    				getCustPaymentDetailsPSMT.close();
			    				getCustPaymentDetailsPSMT = null;
			    			}
			    			
			    		//	System.out.println(creditReportDAO.getCustometName()+"::"+ creditReportDAO.getOpeningBalance());
	    			}
	    			
	    			for(String custId: custCreditReportMap.keySet())	    				
	    			{
	    				CustomerCreditReportDAO creditReportDAO = custCreditReportMap.get(custId);
	    				
	    				float custTotalPaymentAmount = Float.parseFloat(creditReportDAO.getTotalPaymentAmount());
			    				
			    				float billAmountAfterDate = 0.0F;
			    				
			    				float totalBillAmountAfterDate = 0.0F;
			    				
			    				float billAmountReceivedAfterDate = 0.0F;
			    				
			    				float totalAmountRecievedAfterDate = 0.0F;
			    				
			    				float billAmountBalanceAfterDate = 0.0F;
			    				
			    				float totalBalanceAmtAfterDate = 0.0F;
			    				
			       				float custTotalCreditAfterDate = 0.0F;
			       				
			       				float custTotalBillAfterDate = 0.0F;
			       				
			       				float custTotalBillAmtReceivedAfterDate = 0.0F;
			       				
			       				float custTotalCreditAmount = 0.0F;
			    				float custTotalBillAmount = 0.0F;
			    				float custTotalAmountReceived = 0.0F;
			       				
			       				PreparedStatement getBillAmountPSMT = null;
			       				ResultSet getBillAmountRS = null;
			       				 
			       				String	getBillAmountSQL=  "SELECT "	           					
			           					+ "bill_total_amount,"
			           					+ "bill_amount_received,"
			           					+ "bill_amount_return "
			           					+ "FROM "
			           					+ "crusher_bill_info_master "
			           					+ "WHERE "		           					
			           					+ "customer_id = ? "
			           					+ "AND "
			           					+ "(bill_date "
			           					+ "BETWEEN "
			           					+ "STR_TO_DATE(?, '%d-%m-%Y') "
				       					+ "AND "
				       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
				       					+ "AND "
				       					+ "crusher_id = ? "
				       					+ "AND "
				       					+ "crusher_code = ? ";
			       				
			       			
			       				
			       				getBillAmountPSMT = connection.prepareStatement(getBillAmountSQL);
			       				getBillAmountPSMT.setString(1, custId);
			       				getBillAmountPSMT.setString(2, this.getStartDate());
			       				getBillAmountPSMT.setString(3, this.getEndDate());
			       				getBillAmountPSMT.setString(4, crusherId);
			       				getBillAmountPSMT.setString(5, crusherCode);
			       				
			       				getBillAmountRS = getBillAmountPSMT.executeQuery();
			       				
			       				while(getBillAmountRS.next())
			       				{
			       					
			       					try
			       					{
			       						if(getBillAmountRS.getString(2) != null)
			       						{
			       						
			       							billAmountAfterDate = getBillAmountRS.getFloat(1);
			       							billAmountReceivedAfterDate = getBillAmountRS.getFloat(2);
			       							billAmountBalanceAfterDate = billAmountAfterDate - billAmountReceivedAfterDate;
			       							totalBillAmountAfterDate = totalBillAmountAfterDate + billAmountAfterDate;
				           					if(billAmountBalanceAfterDate > 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
					           					totalBalanceAmtAfterDate = totalBalanceAmtAfterDate+billAmountBalanceAfterDate;
					           					
					           				}
					           				else if(billAmountBalanceAfterDate == 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
						           								           				
					           				}
			       						}
			       						
				           			}catch(NumberFormatException nfe)
			       					{
			       						result = "error";
			       						addActionError(this.getText("message.error.errorWhileFormatting")
			       								+ this.getText("message.error.whileCalculatingEachBilldetailsForCustomer"));
			       						
			       					}
			       				}
			       			
			       				
			       				
			       				getBillAmountSQL=  "SELECT "	           					
			           					+ "bill_total_amount,"
			           					+ "bill_amount_received,"
			           					+ "amount_return "
			           					+ "FROM "
			           					+ "crusher_rmc_billinfo "
			           					+ "WHERE "		           					
			           					+ "customer_id = ? "
			           					+ "AND "
			           					+ "(bill_date "
			           					+ "BETWEEN "
			           					+ "STR_TO_DATE(?, '%d-%m-%Y') "
				       					+ "AND "
				       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
				       					+ "AND "
				       					+ "crusher_id = ? "
				       					+ "AND "
				       					+ "crusher_code = ? ";
			       				
			       				if(getBillAmountRS != null)
			       				{
			       					getBillAmountRS.close();
			       					getBillAmountRS = null;
			       				}
			       				if(getBillAmountPSMT != null)
			       				{
			       					getBillAmountPSMT.close();
			       					getBillAmountPSMT = null;
			       				}
			       				
			       				
			       				getBillAmountPSMT = connection.prepareStatement(getBillAmountSQL);
			       				getBillAmountPSMT.setString(1, custId);
			       				getBillAmountPSMT.setString(2, this.getStartDate());
			       				getBillAmountPSMT.setString(3, this.getEndDate());
			       				getBillAmountPSMT.setString(4, crusherId);
			       				getBillAmountPSMT.setString(5, crusherCode);
			       				
			       				getBillAmountRS = getBillAmountPSMT.executeQuery();
			       				
			       				while(getBillAmountRS.next())
			       				{
			       					
			       					try
			       					{
			       						if(getBillAmountRS.getString(2) != null)
			       						{
			       						
			       							billAmountAfterDate = getBillAmountRS.getFloat(1);
			       							billAmountReceivedAfterDate = getBillAmountRS.getFloat(2);
			       							billAmountBalanceAfterDate = billAmountAfterDate - billAmountReceivedAfterDate;
			       							totalBillAmountAfterDate = totalBillAmountAfterDate + billAmountAfterDate;
				           					if(billAmountBalanceAfterDate > 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
					           					totalBalanceAmtAfterDate = totalBalanceAmtAfterDate+billAmountBalanceAfterDate;
					           					
					           				}
					           				else if(billAmountBalanceAfterDate == 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
						           								           				
					           				}
			       						}
			       						
				           			}catch(NumberFormatException nfe)
			       					{
			       						result = "error";
			       						addActionError(this.getText("message.error.errorWhileFormatting")
			       								+ this.getText("message.error.whileCalculatingEachBilldetailsForCustomer"));
			       						
			       					}
			       				}
			       				
			       				
				       			creditReportDAO.setTotalBillAmountAfterDate(totalBillAmountAfterDate);
			       				creditReportDAO.setTotalPaymentAfterDate(""+(Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate()) + totalAmountRecievedAfterDate));
			       				
			       				creditReportDAO.setTotalBalAmountAfterDate(totalBillAmountAfterDate - (Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate())));
			       			
			       				
			       				
			       				
			       				creditReportDAO.setTotalBalAmount(totalBalanceAmtAfterDate);
			       				
			     				
			       				custTotalBillAmount =  totalBillAmountAfterDate;
			       				custTotalAmountReceived =  totalAmountRecievedAfterDate;
			       				
			       				custTotalPaymentAmount = Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate());
			       				custTotalCreditAmount = (custTotalBillAmount+creditReportDAO.getOpeningBalance()) - custTotalPaymentAmount;
			       				
			       				creditReportDAO.setTotalBillAmount(""+custTotalBillAmount);
			       				creditReportDAO.setTotalCreditAmount(custTotalCreditAmount);
			       				creditReportDAO.setTotalPaymentAmount(""+custTotalPaymentAmount);
			       				
			       				creditReportDAO.setSmsData(creditReportDAO.getCustomerMobile()
			       						+"-"+creditReportDAO.getTotalCreditAmount());
			       				

			       				if(getBillAmountRS != null)
			       				{
			       					getBillAmountRS.close();
			       					getBillAmountRS = null;
			       				}
			       				if(getBillAmountPSMT != null)
			       				{
			       					getBillAmountPSMT.close();
			       					getBillAmountPSMT = null;
			       				}
			       				
			       				if(!this.getMinAmount().equals("") && !this.getMaxAmount().equals(""))
			       				{
			       					float minAmt = Float.parseFloat(this.getMinAmount());
			       					float maxAmt = Float.parseFloat(this.getMaxAmount());
			       					
			       					if(custTotalCreditAmount >=minAmt && custTotalCreditAmount <=maxAmt)
			       					{
			       						custCreditList.add(creditReportDAO);
			       					}
			       					
			       				}
			       				else if(!this.getMinAmount().equals("") && this.getMaxAmount().equals(""))
			       				{
			       					float minAmt = Float.parseFloat(this.getMinAmount());
			       				
			       					if(custTotalCreditAmount >=minAmt)
			       					{
			       						custCreditList.add(creditReportDAO);
			       					}
			       				}
			       				else if(this.getMinAmount().equals("") && !this.getMaxAmount().equals(""))
			       				{
			       					float maxAmt = Float.parseFloat(this.getMaxAmount());
			       					
			       					if(custTotalCreditAmount <=maxAmt)
			       					{
			       						custCreditList.add(creditReportDAO);
			       					}
			       				}
			       				else if(custTotalCreditAmount>0)
			       				{
			       					custCreditList.add(creditReportDAO);
			       				}
			       				
			       				
			       				
			       				
			       				
			       			 Collections.sort(custCreditList);
			       			   
			       			
			       				
				    			
	    			}	
	    			
	    			boolean allOk = true;
	    			for(CustomerCreditReportDAO  dao : custCreditList)
       				{
       					
       				 
       				 try{
       					 
       				 
       				// System.out.println(totolReportBillAmount);
	       				totolReportBillAmount = totolReportBillAmount+Float.parseFloat(dao.getTotalBillAmount());
	       				totalReportPaymentAmount = totalReportPaymentAmount + Float.parseFloat(dao.getTotalPaymentAmount());
	       				totalReportCreditAmount = totalReportCreditAmount+dao.getTotalCreditAmount();
	       				
	       				totalReportAfterDateBillAmt = totalReportAfterDateBillAmt + dao.getTotalBillAmountAfterDate();
	       				totalReportAfterDatePaymentAmt = totalReportAfterDatePaymentAmt + Float.parseFloat(dao.getTotalPaymentAfterDate());
	       				totalReportAfterDateBalAmt = totalReportAfterDateBalAmt + dao.getTotalBalAmountAfterDate();
       				 }catch (Exception e) {
       					allOk = false;
       				 }
       				}
	    			
	    			this.setTotolReportBillAmount(totolReportBillAmount);
	    			this.setTotalReportPaymentAmount(totalReportPaymentAmount);
	    			this.setTotalReportCreditAmount(totalReportCreditAmount);
	    			
	    			this.setTotalReportAfterDateBillAmt(totalReportAfterDateBillAmt);
	    			this.setTotalReportAfterDatePaymentAmt(totalReportAfterDatePaymentAmt);
	    			this.setTotalReportAfterDateBalAmt(totalReportAfterDateBalAmt);
	    			
	    			if(allOk)
	    			{
	    				result = SUCCESS;
	    			}
	    			else
	    			{
	    				result = ERROR;
	    				addActionError(this.getText("message.error.somethingWentWrongComputongTotalAmount"));
	    			}
	    			
					@SuppressWarnings("unchecked")
					String crusherName = (String) this.getSessionMap().get("crushernameenglish");
				    
	    			if(this.getDownloadFileType().equals("PDF"))
	    			{
	    				
	    				if(this.getDownloadFileLanguage().equals("ENGLISH"))
	    					
	    				{
	    			
	    			String path=	request.getSession().getServletContext().getRealPath("/images/");
	    			PDDocument document = new PDDocument(); 
					PDPage page = null;
					
					 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
						
					 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
					 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
					 
					Date date = new Date();
					
					String dateToday = sdf.format(date); 
						 page = new PDPage(PDRectangle.A4);
					
					
				        document.addPage(page);
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
				         int pageCount = 1;
			    			 Table header;
			    			 Table creditDetails;
			    			 
			    			
			    			  TableBuilder tableHeaderBuilder = Table.builder()
						                .addColumnsOfWidth(550)				                
						                .font(HELVETICA)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					         
					          Row headerName = Row.builder()
						                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
						                .horizontalAlignment(CENTER)
						                .build();
					          
					          
					          Row info1 = Row.builder()
						                .add(TextCell.builder().text("Customer Credit Report From Date: "
						                			+startDate+" To Date : "+endDate +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
						                .horizontalAlignment(CENTER)
						                .build();
					          
					          Row info2 = Row.builder()
						                .add(TextCell.builder().text("Report generated for Minimum Credit Amount: "
						                		+ ""+this.getMinAmount()
						                		+ "and Maximum Credit Amount:"+this.getMaxAmount()+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
					         
					          
					          tableHeaderBuilder.addRow(headerName);
					          tableHeaderBuilder.addRow(info1);
					          tableHeaderBuilder.addRow(info2);
					          header = tableHeaderBuilder.build();
					          
					          
					          TableBuilder tableCreditDetailsBuilder = Table.builder()
					        		  .addColumnsOfWidth(25,130,60,50,50,60,60,60,80)				                
									        .font(HELVETICA)
						                .borderWidth(0.5F)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					          
					          Row tableHeader = Row.builder()
					        		  .add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						                .add(TextCell.builder().text("Customer Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Mobile").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Add").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						                .add(TextCell.builder().text("Open Bal.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							            .add(TextCell.builder().text("Tot. Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Tot. Paid Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Tot. Credit.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
						                .add(TextCell.builder().text("Remark").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
						                
						                .backgroundColor(Color.LIGHT_GRAY)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .build();
					          tableCreditDetailsBuilder.addRow(tableHeader);
					       
					        
					     
					        	  int size = custCreditList.size();
					        	  
					        	  
						          float startY = page.getMediaBox().getHeight() - PADDING20;
						          float currentY = startY;
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(header)
					                .startX(PADDING10)
					                .startY(startY)
					                .build()
					                .draw();
						          
						        
					        	  
					        	  for(int s=0;s<size;s++)
					        	  {
					        		  
					        		  if(currentY < 130)
					        		  {
					        			  pageCount++;
					        			  creditDetails = tableCreditDetailsBuilder.build();
					        			  TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(creditDetails)
							                .startX(PADDING10)
							                .startY(startY-50)
							                .build()
							                .draw();
					        			  
					        			  contentStream.close();
					        			  
					        			  header = null;
					        			  
					        			 
							    			 
							    			
							    			  tableHeaderBuilder = Table.builder()
										                .addColumnsOfWidth(550)				                
										                .font(HELVETICA)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									         
									           headerName = Row.builder()
										                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          
									          
									           info1 = Row.builder()
										                .add(TextCell.builder().text("Customer Credit Report From Date: "
										                			+startDate+" To Date : "+endDate +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									           info2 = Row.builder()
										                .add(TextCell.builder().text("Report generated for Minimum Credit Amount: "
										                		+ ""+this.getMinAmount()
										                		+ "and Maximum Credit Amount:"+this.getMaxAmount()+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
										                .horizontalAlignment(CENTER)
										                .build();
									         
									          
									          tableHeaderBuilder.addRow(headerName);
									          tableHeaderBuilder.addRow(info1);
									          tableHeaderBuilder.addRow(info2);
									          header = tableHeaderBuilder.build();
					        			  
					        			  creditDetails = null;
					        			   tableCreditDetailsBuilder = Table.builder()
					        					   .addColumnsOfWidth(25,130,60,50,50,60,60,60,80)				                
												             .font(HELVETICA)
									                .borderWidth(0.5F)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								          
								           tableHeader = Row.builder()
								        		  .add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
									                .add(TextCell.builder().text("Customer Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("Mobile").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("Add").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
									                .add(TextCell.builder().text("Open Bal.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
											        .add(TextCell.builder().text("Tot. Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("Tot. Paid Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("Tot. Credit.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
									                .add(TextCell.builder().text("Remark").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
									                .backgroundColor(Color.LIGHT_GRAY)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          tableCreditDetailsBuilder.addRow(tableHeader);
								          
					        			  
					        				PDPage newPage = new PDPage(PDRectangle.A4);
								        	 contentStream = new PDPageContentStream(document,newPage);
								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
								             document.addPage( newPage );
								             
								             TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(header)
								                .startX(PADDING10)
								                .startY(currentY)
								                .build()
								                .draw();
					        			  
					        		  }
					        		  
					        		  CustomerCreditReportDAO  dao2 =custCreditList.get(s) ;
					        		  	Row custInfo = Row.builder()
					        			  	.add(TextCell.builder().text(""+(s+1)).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getCustometName().replaceAll("\\s", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getCustomerMobile().replaceAll("\\s", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getCustomerAddress().replaceAll("\\s", " ")).fontSize(6).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			 	.add(TextCell.builder().text(df.format(dao2.getOpeningBalance())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			 	.add(TextCell.builder().text(dao2.getTotalBillAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getTotalPaymentAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(df.format(dao2.getTotalCreditAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			 	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(fontMarathi)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableCreditDetailsBuilder.addRow(custInfo);
					        	 
					        	  currentY = currentY -25;
					        	
					        	  }
					        	  
					        	  Row custInfo = Row.builder()
					        			  	.add(TextCell.builder().text("Total").colSpan(5).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(df.format(totolReportBillAmount)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(df.format(totalReportPaymentAmount)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(df.format(totalReportCreditAmount)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)					                
							                .build();
					        	  
					        	  tableCreditDetailsBuilder.addRow(custInfo);
					        	  creditDetails = tableCreditDetailsBuilder.build();
					         
					          
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(creditDetails)
				                .startX(PADDING10)
				                .startY(startY-50)
				                .build()
				                .draw();
	    			   contentStream.close();
				        
				       // System.out.println(path);
								
				        
				        document.save(path+"/cust-credit-report.pdf");
				        document.close();
				        
				        response.setHeader("Content-disposition", "inline; filename=customer-credit-report.pdf");
						response.setContentType("application/pdf");
						
						FileInputStream fileInputStream = new FileInputStream(path+"/cust-credit-report.pdf");
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.flush();
						out.close();
			        
						ttf1.close();
					//String fontPath =	request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf");
							
	    				}
	    				if(this.getDownloadFileLanguage().equals("MARATHI"))
		    			{

	    	    			
	    	    			String path=	request.getSession().getServletContext().getRealPath("/images/");
	    	    			PDDocument document = new PDDocument(); 
	    					PDPage page = null;
	    					
	    					 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
	    						
	    					 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
	    					 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
	    					 
	    					 
	    					 File fontKrutiDevFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Krutidev.ttf"));
	    						
	    					 TrueTypeFont ttf2 = new TTFParser().parse(fontKrutiDevFile);
	    					 PDFont fontKrutidev = PDType0Font.load(document, ttf2, true);
	    					 
	    					Date date = new Date();
	    					
	    					String dateToday = sdf.format(date); 
	    						 page = new PDPage(PDRectangle.A4);
	    					
	    					
	    				        document.addPage(page);
	    				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
	    				         int pageCount = 1;
	    			    			 Table header;
	    			    			 Table creditDetails;
	    			    			 
	    			    			
	    			    			  TableBuilder tableHeaderBuilder = Table.builder()
	    						                .addColumnsOfWidth(550)				                
	    						                .font(HELVETICA)
	    						                .borderColor(Color.BLACK)
	    						                .horizontalAlignment(CENTER);
	    					         
	    					          Row headerName = Row.builder()
	    						                .add(TextCell.builder().text("txnack LVksu dz'kj").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
	    						                .backgroundColor(WHITE)
	    						                .textColor(Color.BLACK)
	    						                .font(fontKrutidev).fontSize(30)				              
	    						                .horizontalAlignment(CENTER)
	    						                .build();
	    					          
	    					          
	    					          Row info1 = Row.builder()
	    						                .add(TextCell.builder().text("xzkgd dzsfMV jhiksVZ ;krkj[ksiklwu % "
	    						                			+startDate+" ;krkj[ksi;Zar % "+endDate +"       iku ua-% "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
	    						                .backgroundColor(WHITE)
	    						                .textColor(Color.BLACK)
	    						                .font(fontKrutidev).fontSize(10)
	    						                .horizontalAlignment(CENTER)
	    						                .build();
	    					          
	    					          Row info2 = Row.builder()
	    						                .add(TextCell.builder().text("Report generated for Minimum Credit Amount: "
	    						                		+ ""+this.getMinAmount()
	    						                		+ "and Maximum Credit Amount:"+this.getMaxAmount()+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
	    						                .backgroundColor(WHITE)
	    						                .textColor(Color.BLACK)
	    						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
	    						                .horizontalAlignment(CENTER)
	    						                .build();
	    					         
	    					          
	    					          tableHeaderBuilder.addRow(headerName);
	    					          tableHeaderBuilder.addRow(info1);
	    					       //   tableHeaderBuilder.addRow(info2);
	    					          header = tableHeaderBuilder.build();
	    					          
	    					          
	    					          TableBuilder tableCreditDetailsBuilder = Table.builder()
	    					        		  .addColumnsOfWidth(25,90,55,40,40,55,55,55,55,55,50)				                
	    								            .font(HELVETICA)
	    						                .borderWidth(0.5F)
	    						                .borderColor(Color.BLACK)
	    						                .horizontalAlignment(CENTER);
	    					          
	    					          Row tableHeader = Row.builder()
	    					        		  .add(TextCell.builder().text("fl-ua-").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    						                .add(TextCell.builder().text("xzkgdkps uko").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    						                .add(TextCell.builder().text("eksckbZy").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    						                .add(TextCell.builder().text("iRrk").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    						                .add(TextCell.builder().text("vksifuax cWyUl").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    							            .add(TextCell.builder().text(",dw.k fcy jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    						                .add(TextCell.builder().text(",dw.k tek jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    						                .add(TextCell.builder().text(",dw.k cWyUl").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	    						                .add(TextCell.builder().text("rkj[kslkBh fcy jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    						                .add(TextCell.builder().text("rkj[kslkBh tek jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    						                .add(TextCell.builder().text("rkj[kslkBh cWyUl").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	    						               
	    						                .backgroundColor(Color.LIGHT_GRAY)
	    						                .textColor(Color.BLACK)
	    						                .font(fontKrutidev).fontSize(8)				              
	    						                .horizontalAlignment(CENTER)
	    						                .build();
	    					          tableCreditDetailsBuilder.addRow(tableHeader);
	    					       
	    					        
	    					     
	    					        	  int size = custCreditList.size();
	    					        	  
	    					        	  
	    						          float startY = page.getMediaBox().getHeight() - PADDING20;
	    						          float currentY = startY;
	    						          TableDrawer.builder()
	    					                .contentStream(contentStream)
	    					                .table(header)
	    					                .startX(PADDING10)
	    					                .startY(startY)
	    					                .build()
	    					                .draw();
	    						          
	    						        
	    					        	  
	    					        	  for(int s=0;s<size;s++)
	    					        	  {
	    					        		  
	    					        		  if(currentY < 130)
	    					        		  {
	    					        			  pageCount++;
	    					        			  creditDetails = tableCreditDetailsBuilder.build();
	    					        			  TableDrawer.builder()
	    							                .contentStream(contentStream)
	    							                .table(creditDetails)
	    							                .startX(PADDING10)
	    							                .startY(startY-50)
	    							                .build()
	    							                .draw();
	    					        			  
	    					        			  contentStream.close();
	    					        			  
	    					        			  header = null;
	    					        			  
	    					        			 
	    							    			 
	    							    			
	    							    			  tableHeaderBuilder = Table.builder()
	    										                .addColumnsOfWidth(550)				                
	    										                .font(HELVETICA)
	    										                .borderColor(Color.BLACK)
	    										                .horizontalAlignment(CENTER);
	    									         
	    									           headerName = Row.builder()
	    										                .add(TextCell.builder().text("txnack LVksu dz'kj").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
	    										                .backgroundColor(WHITE)
	    										                .textColor(Color.BLACK)
	    										                .font(fontKrutidev).fontSize(30)				              
	    										                .horizontalAlignment(CENTER)
	    										                .build();
	    									          
	    									          
	    									           info1 = Row.builder()
	    			    						                .add(TextCell.builder().text("xzkgd dzsfMV jhiksVZ ;krkj[ksiklwu % "
	    			    						                			+startDate+" ;krkj[ksi;Zar % "+endDate +"       iku ua-% "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
	    			    						                .backgroundColor(WHITE)
	    			    						                .textColor(Color.BLACK)
	    			    						                .font(fontKrutidev).fontSize(10)
	    			    						                .horizontalAlignment(CENTER)
	    			    						                .build();
	    			    					          
	    									          
	    									           info2 = Row.builder()
	    										                .add(TextCell.builder().text("Report generated for Minimum Credit Amount: "
	    										                		+ ""+this.getMinAmount()
	    										                		+ "and Maximum Credit Amount:"+this.getMaxAmount()+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
	    										                .backgroundColor(WHITE)
	    										                .textColor(Color.BLACK)
	    										                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
	    										                .horizontalAlignment(CENTER)
	    										                .build();
	    									         
	    									          
	    									          tableHeaderBuilder.addRow(headerName);
	    									          tableHeaderBuilder.addRow(info1);
	    									         // tableHeaderBuilder.addRow(info2);
	    									          header = tableHeaderBuilder.build();
	    					        			  
	    					        			  creditDetails = null;
	    					        			   tableCreditDetailsBuilder = Table.builder()
	    					        					   .addColumnsOfWidth(25,90,55,40,40,55,55,55,55,55,50)				                
	    												       .font(HELVETICA)
	    									                .borderWidth(0.5F)
	    									                .borderColor(Color.BLACK)
	    									                .horizontalAlignment(CENTER);
	    								          
	    								           tableHeader = Row.builder()
	    								        		   .add(TextCell.builder().text("fl-ua-").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    		    						                .add(TextCell.builder().text("xzkgdkps uko").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    		    						                .add(TextCell.builder().text("eksckbZy").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    		    						                .add(TextCell.builder().text("iRrk").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    		    						                .add(TextCell.builder().text("vksifuax cWyUl").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    		    							            .add(TextCell.builder().text(",dw.k fcy jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    		    						                .add(TextCell.builder().text(",dw.k tek jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    		    						                .add(TextCell.builder().text(",dw.k cWyUl").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	    		    						                .add(TextCell.builder().text("rkj[kslkBh fcy jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    		    						                .add(TextCell.builder().text("rkj[kslkBh tek jDde").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	    		    						                .add(TextCell.builder().text("rkj[kslkBh cWyUl").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	    		    						                .backgroundColor(Color.LIGHT_GRAY)
	    		    						                .textColor(Color.BLACK)
	    		    						                .font(fontKrutidev).fontSize(8)				              
	    									                .horizontalAlignment(CENTER)
	    									                .build();
	    								          tableCreditDetailsBuilder.addRow(tableHeader);
	    								          
	    					        			  
	    					        				PDPage newPage = new PDPage(PDRectangle.A4);
	    								        	 contentStream = new PDPageContentStream(document,newPage);
	    								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
	    								             document.addPage( newPage );
	    								             
	    								             TableDrawer.builder()
	    								                .contentStream(contentStream)
	    								                .table(header)
	    								                .startX(PADDING10)
	    								                .startY(currentY)
	    								                .build()
	    								                .draw();
	    					        			  
	    					        		  }
	    					        		  
	    					        		  CustomerCreditReportDAO  dao2 =custCreditList.get(s) ;
	    					        		  	Row custInfo = Row.builder()
	    					        			  	.add(TextCell.builder().text(""+(s+1)).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(""+dao2.getCustNameMarathi().replaceAll("\\s", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(dao2.getCustomerMobile().replaceAll("\\s", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(dao2.getCustomerAddress().replaceAll("\\s", " ")).fontSize(6).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			 	.add(TextCell.builder().text(df.format(dao2.getOpeningBalance())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			 	.add(TextCell.builder().text(dao2.getTotalBillAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(dao2.getTotalPaymentAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(dao2.getTotalCreditAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			 	.add(TextCell.builder().text(df.format(dao2.getTotalBillAmountAfterDate())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(dao2.getTotalPaymentAfterDate()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(dao2.getTotalBalAmountAfterDate())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			   	.backgroundColor(Color.WHITE)
	    							                .textColor(Color.BLACK)
	    							                .font(fontMarathi)
	    							                .fontSize(8)				              
	    							                .horizontalAlignment(CENTER)
	    							                .height(25F)					                
	    							                .build();
	    					        	  
	    					        	  tableCreditDetailsBuilder.addRow(custInfo);
	    					        	 
	    					        	  currentY = currentY -25;
	    					        	
	    					        	  }
	    					        	  
	    					        	  Row custInfo = Row.builder()
	    					        			  	.add(TextCell.builder().text(",dw.k ").font(fontKrutidev).fontSize(12).colSpan(5).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(totolReportBillAmount)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(totalReportPaymentAmount)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(totalReportCreditAmount)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(totalReportAfterDateBillAmt)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(totalReportAfterDatePaymentAmt)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        			  	.add(TextCell.builder().text(df.format(totalReportAfterDateBalAmt)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
	    					        				.backgroundColor(Color.WHITE)
	    							                .textColor(Color.BLACK)
	    							                .font(PDType1Font.HELVETICA)
	    							                .fontSize(8)				              
	    							                .horizontalAlignment(CENTER)
	    							                .height(15F)					                
	    							                .build();
	    					        	  
	    					        	  tableCreditDetailsBuilder.addRow(custInfo);
	    					        	  creditDetails = tableCreditDetailsBuilder.build();
	    					         
	    					          
	    					          TableDrawer.builder()
	    				                .contentStream(contentStream)
	    				                .table(creditDetails)
	    				                .startX(PADDING10)
	    				                .startY(startY-50)
	    				                .build()
	    				                .draw();
	    	    			   contentStream.close();
	    				        
	    				       // System.out.println(path);
	    								
	    				        
	    				        document.save(path+"/cust-credit-report.pdf");
	    				        document.close();
	    				        
	    				        response.setHeader("Content-disposition", "inline; filename=customer-credit-report.pdf");
	    						response.setContentType("application/pdf");
	    						
	    						FileInputStream fileInputStream = new FileInputStream(path+"/cust-credit-report.pdf");
	    						PrintWriter out = response.getWriter();  
	    						int bytes;
	    						while ((bytes = fileInputStream.read()) != -1) {
	    							out.write(bytes);
	    						}
	    						fileInputStream.close();
	    						out.flush();
	    						out.close();
	    			        
	    						ttf1.close();
	    						ttf2.close();
	    					//String fontPath =	request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf");
	    							
	    	    				
		    			}
	    			}
	    			
	    			if(this.getDownloadFileType().equals("XLS"))
	    			{
	    				
	    				try
	    				{
	    					
	    					String fileName = "cust-credit-report-"+this.getStartDate()+"-to-"+this.getEndDate()+".xls";
	    					

	    					FileOutputStream fos=new FileOutputStream(new File(fileName));  

	    					HSSFWorkbook workbook = new HSSFWorkbook();
	    					HSSFSheet mySheet = workbook.createSheet("CREDIT REPORT");  
							
						  mySheet.setColumnWidth(0, 5 * 256);
							 mySheet.setColumnWidth(1, 18 * 256);
							 mySheet.setColumnWidth(2, 20 * 256);
							 mySheet.setColumnWidth(3, 20 * 256);
							 mySheet.setColumnWidth(4, 10 * 256);
							 mySheet.setColumnWidth(5, 25 * 256);
							 mySheet.setColumnWidth(6, 30 * 256);
							 mySheet.setColumnWidth(7, 15 * 256);
							 mySheet.setColumnWidth(8, 20 * 256);
							 mySheet.setColumnWidth(9, 10 * 256);
							 mySheet.setColumnWidth(10, 18 * 256);
						
							 
								Font font = workbook.createFont();
							       
						        font.setBold(true);
						       
							 final HSSFCellStyle cellStyle = workbook.createCellStyle();
							 
							 cellStyle.setBorderBottom(BorderStyle.THIN);
							 cellStyle.setBorderRight(BorderStyle.THIN);
							 cellStyle.setBorderLeft(BorderStyle.THIN);
							 cellStyle.setBorderTop(BorderStyle.THIN);
							 cellStyle.setFont(font);
							 cellStyle.setWrapText(true);
							 
							 final HSSFCellStyle cellStyleNonBold = workbook.createCellStyle();

							 cellStyleNonBold.setBorderBottom(BorderStyle.THIN);
							 cellStyleNonBold.setBorderRight(BorderStyle.THIN);
							 cellStyleNonBold.setBorderLeft(BorderStyle.THIN);
							 cellStyleNonBold.setBorderTop(BorderStyle.THIN);
							 
							 
							 HSSFRow rowHead = mySheet.createRow(0);			
							 
							 
							 Cell cellHead1 = rowHead.createCell(0);
							 cellHead1.setCellValue("Sr No");
							 cellHead1.setCellStyle(cellStyle);
							 
							 Cell cellHead2 = rowHead.createCell(1);
							 cellHead2.setCellValue("Customer Name");
							 cellHead2.setCellStyle(cellStyle);
							 
							 Cell cellHead3 = rowHead.createCell(2);
							 cellHead3.setCellValue("Mobile");
							 cellHead3.setCellStyle(cellStyle);
							 
							 
							 Cell cellHead4 = rowHead.createCell(3);
							 cellHead4.setCellValue("Address");
							 cellHead4.setCellStyle(cellStyle);
							 
							 
							 Cell cellHead5 = rowHead.createCell(4);
							 cellHead5.setCellValue("Opening Balance");
							 cellHead5.setCellStyle(cellStyle);
							 
							 
							 Cell cellHead6 = rowHead.createCell(5);
							 cellHead6.setCellValue("Total Bill Amount");
							 cellHead6.setCellStyle(cellStyle);
							 
							 
							 Cell cellHead7 = rowHead.createCell(6);
							 cellHead7.setCellValue("Total Amount Paid");
							 cellHead7.setCellStyle(cellStyle);
							 
							 
							 Cell cellHead8 = rowHead.createCell(7);
							 cellHead8.setCellValue("Total Balance");
							 cellHead8.setCellStyle(cellStyle);
							 
							 
							 Cell cellHead9 = rowHead.createCell(8);
							 cellHead9.setCellValue("Bill Amount For Dates");
							 cellHead9.setCellStyle(cellStyle);
							  
							 
							 Cell cellHead10 = rowHead.createCell(9);
							 cellHead10.setCellValue("Paid Amount For Dates");
							 cellHead10.setCellStyle(cellStyle);
							 
							 Cell cellHead11 = rowHead.createCell(10);
							 cellHead11.setCellValue("Balance Amount For Dates");
							 cellHead11.setCellStyle(cellStyle);
							 
							 int rowCount = 1;
							 
							 for(CustomerCreditReportDAO dao : this.getCustCreditList())
							 {
								
								 HSSFRow rowData = mySheet.createRow(rowCount);
								  
								 Cell cell1 = rowData.createCell(0);
								 cell1.setCellValue(rowCount);
								 cell1.setCellStyle(cellStyleNonBold);
								 
								 Cell cell2 = rowData.createCell(1);
								 cell2.setCellValue(dao.getCustometName());
								 cell2.setCellStyle(cellStyleNonBold);
								 
								 Cell cell3 = rowData.createCell(2);
								 cell3.setCellValue(dao.getCustomerMobile());
								 cell3.setCellStyle(cellStyleNonBold);
								 
								 Cell cell4 = rowData.createCell(3);
								 cell4.setCellValue(dao.getCustomerAddress());
								 cell4.setCellStyle(cellStyleNonBold);
								 
								 Cell cell5 = rowData.createCell(4);
								 cell5.setCellValue(dao.getOpeningBalance());
								 cell5.setCellStyle(cellStyleNonBold);
								 
								 
								 Cell cell6 = rowData.createCell(5);
								 cell6.setCellValue(dao.getTotalBillAmount());
								 cell6.setCellStyle(cellStyleNonBold);
								 
								 
								 Cell cell7 = rowData.createCell(6);
								 cell7.setCellValue(dao.getTotalPaymentAmount());
								 cell7.setCellStyle(cellStyleNonBold);
								 
								 
								 
								 Cell cell8 = rowData.createCell(7);
								 cell8.setCellValue(dao.getTotalCreditAmount());
								 cell8.setCellStyle(cellStyleNonBold);
								 
								 Cell cell9 = rowData.createCell(8);
								 cell9.setCellValue(dao.getTotalBillAmountAfterDate());
								 cell9.setCellStyle(cellStyleNonBold);
								 
								 
								 Cell cell10 = rowData.createCell(9);
								 cell10.setCellValue(dao.getTotalPaymentAfterDate());
								 cell10.setCellStyle(cellStyleNonBold);
								 
								 Cell cell11 = rowData.createCell(10);
								 cell11.setCellValue(dao.getTotalBalAmountAfterDate());
								 cell11.setCellStyle(cellStyleNonBold);
								 
								 rowCount++;
							 }
							 
							   
							   workbook.write(fos);
							   fos.close();
					            workbook.close();
					            
					            
					    		response.setHeader("Content-disposition", "inline; filename="+fileName);
								response.setContentType("application/xls");
								FileInputStream fileInputStream = new FileInputStream(fileName);
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.close();
								
								
							 
	    				}catch (Exception e) {
							e.printStackTrace();
							
						}
	    			}
	    			
	
	    		}
	    		 catch (SQLException e) {
		    			
		    			result = "error";
		    			e.printStackTrace();
		    			
		    		} catch (IOException e) {
		    			result = "error";
		    			//e.printStackTrace();
		    			
		    		}
	    			finally {
		    			if(resultSet != null)
						{
							try {
								resultSet.close();resultSet = null;
							} catch (SQLException e) {
								
							}
						}
		    			if(preparedStatement != null)
		    			{
		    				try {preparedStatement.close(); preparedStatement=null;}  catch (SQLException e) {}
		    			}
		    			if(connection != null)
		    			{
		    				
		    				try {connection.close(); connection=null;}catch (SQLException e) {}
		    			}
		    			
		    		}
	    		}
	    		
	}


	

	public String getStartDate() {
		return startDate;
	}


	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}


	public String getEndDate() {
		return endDate;
	}


	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}


	public String getMinAmount() {
		return minAmount;
	}


	public void setMinAmount(String minAmount) {
		this.minAmount = minAmount;
	}


	public String getMaxAmount() {
		return maxAmount;
	}


	public HttpServletRequest getRequest() {
		return request;
	}




	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}




	public HttpServletResponse getResponse() {
		return response;
	}




	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}




	public HttpSession getSession() {
		return session;
	}




	public void setSession(HttpSession session) {
		this.session = session;
	}




	public List<CustomerCreditReportDAO> getCustCreditList() {
		return custCreditList;
	}




	public void setCustCreditList(List<CustomerCreditReportDAO> custCreditList) {
		this.custCreditList = custCreditList;
	}




	public float getTotolReportBillAmount() {
		return totolReportBillAmount;
	}




	public void setTotolReportBillAmount(float totolReportBillAmount) {
		this.totolReportBillAmount = totolReportBillAmount;
	}




	public float getTotalReportPaymentAmount() {
		return totalReportPaymentAmount;
	}




	public void setTotalReportPaymentAmount(float totalReportPaymentAmount) {
		this.totalReportPaymentAmount = totalReportPaymentAmount;
	}




	public float getTotalReportCreditAmount() {
		return totalReportCreditAmount;
	}




	public void setTotalReportCreditAmount(float totalReportCreditAmount) {
		this.totalReportCreditAmount = totalReportCreditAmount;
	}




	public String getFromDate() {
		return fromDate;
	}




	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}




	public String getToDate() {
		return toDate;
	}




	public void setToDate(String toDate) {
		this.toDate = toDate;
	}




	public Float getTotalReportAfterDateBillAmt() {
		return totalReportAfterDateBillAmt;
	}




	public void setTotalReportAfterDateBillAmt(Float totalReportAfterDateBillAmt) {
		this.totalReportAfterDateBillAmt = totalReportAfterDateBillAmt;
	}




	public Float getTotalReportAfterDatePaymentAmt() {
		return totalReportAfterDatePaymentAmt;
	}




	public void setTotalReportAfterDatePaymentAmt(Float totalReportAfterDatePaymentAmt) {
		this.totalReportAfterDatePaymentAmt = totalReportAfterDatePaymentAmt;
	}




	public Float getTotalReportAfterDateBalAmt() {
		return totalReportAfterDateBalAmt;
	}




	public void setTotalReportAfterDateBalAmt(Float totalReportAfterDateBalAmt) {
		this.totalReportAfterDateBalAmt = totalReportAfterDateBalAmt;
	}




	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public String getCustIdStart() {
		return custIdStart;
	}




	public void setCustIdStart(String custIdStart) {
		this.custIdStart = custIdStart;
	}




	public String getCustIdEnd() {
		return custIdEnd;
	}




	public void setCustIdEnd(String custIdEnd) {
		this.custIdEnd = custIdEnd;
	}




	public void setMaxAmount(String maxAmount) {
		this.maxAmount = maxAmount;
	}


	public String getDownloadFileType() {
		return downloadFileType;
	}




	public void setDownloadFileType(String downloadFileType) {
		this.downloadFileType = downloadFileType;
	}




	public String getDownloadFileLanguage() {
		return downloadFileLanguage;
	}




	public void setDownloadFileLanguage(String downloadFileLanguage) {
		this.downloadFileLanguage = downloadFileLanguage;
	}




	

	

public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


public SessionMap<String, Object> getSessionMap() {
return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
this.sessionMap = sessionMap;
}

public void setSession(Map<String, Object> map) {  
sessionMap=(SessionMap<String, Object>)map;  
}


}
