package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.TodayBillingListDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class DownloadCreditReport extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -1942947821579293402L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;  
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;
	private String fromDate;
	private String toDate;
	

	private Float materialTotal;
	private Float matrialCostTotal;
	
	private Float allBillMatrialCostTotal;
	private Float transportTotal;
	private Float totalBillAmount;
	private Float totalBalanceAmount;
	private Float totalReceivedAmount;
	private Float totalRoyalty;
	
	private List<TodayBillingListDAO> creditReportList = new ArrayList<TodayBillingListDAO>();
	
	private Float totalCashAmt = 0.0f;
	private Float totalOnlineAmt = 0.0f;
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
	private List<String> typeList = new ArrayList<String>();
	private String type;
	
	private Float totalTaxableAmtAllTheTime;
	private Float totalCgstAllTheTime;
	private Float totalSgstAllTheTime;
	private Float totalPumpAmtAllTheTime;
	private Float totalLaborAmtAllTheTime;
	
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();
			
			String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		

        	Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			String sql = "";
			String db = (String) this.getSession().getAttribute("db");
        	
			
			
			 
			  float totalMaterial = 0.0F;
			  
			  
			  allBillMatrialCostTotal = 0.0F;
			  transportTotal = 0.0F;
			  totalBillAmount = 0.0F;
			  totalBalanceAmount = 0.0F;
			  totalReceivedAmount = 0.0F;
			  totalLaborAmtAllTheTime = 0.0f;
	   			totalPumpAmtAllTheTime = 0.0f;
			  
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				
				LinkedHashMap<String,TodayBillingListDAO> billMap = new LinkedHashMap<String,TodayBillingListDAO>();
				  
				if(this.getType().equals("ALL") || this.getType().equals("CRUSHER"))
				{
					
				
				sql = "SELECT "
				  		+ "bi.bill_number,"
				  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
				  		+ "bi.customer_id,"
				  		+ "bi.customer_name,"
				  		+ "cust.billing_address,"
				  		+ "bi.transportation_charges,"
				  		+ "bi.bill_total_amount,"
				  		+ "bi.bill_amount_received,"
				  		+ "bi.billed_by,"
				  		+ "bi.chalan_number,"
				  		+ "bi.bill_type,"
				  		+ "bi.comments,"      
				  		+ "bill_time,"
				  		+ "bi.account1_credit_debit_id,"
						+ "bi.account2_credit_debit_id " 
						+ ""
				  		+ "FROM "
				  		+ "crusher_bill_info_master as bi "
				  		+ "INNER JOIN "
				  		+ "crusher_customer_master as cust "
				  		+ "ON "
				  		+ "bi.customer_id = cust.customer_id "
				  		+ "WHERE "
				  		+ "(bill_date  "
				  		+ "BETWEEN "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
				  		+ "AND "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y'))  "
				  		+ "AND "
				  		+ "bi.crusher_id = ? "
				  		+ "AND "
				  		+ "bi.crusher_code = ? "
				  		+ "AND "
				  		+ "cust.crusher_id = ? "
				  		+ "AND "
				  		+ "cust.crusher_code = ? "
				  		+ "AND "
				  		+ "bi.bill_amount_received = 'null' "
                        + "ORDER BY bi.bill_date,bi.bill_number";
				  
				  preparedStatement = connection.prepareStatement(sql);
				  
				  preparedStatement.setString(1, this.getFromDate());
				  preparedStatement.setString(2, this.getToDate());
				  preparedStatement.setString(3, crusherId);
				  preparedStatement.setString(4, crusherCode);
				  preparedStatement.setString(5, crusherId);
				  preparedStatement.setString(6, crusherCode);
				  
				  
				  resultSet = preparedStatement.executeQuery();
				  
				  while(resultSet.next())
				  {
					  
					  transportTotal = transportTotal + resultSet.getFloat(6);
					  totalBillAmount = totalBillAmount + resultSet.getFloat(7);
					  totalReceivedAmount  = totalReceivedAmount + resultSet.getFloat(8);
					 
					  
					  float balAmt = totalBillAmount - totalReceivedAmount;
					  
					  if(balAmt>=0)
					  {
						  totalBalanceAmount = totalBalanceAmount + balAmt;
					  }
					  
					  TodayBillingListDAO dao = new TodayBillingListDAO();
					
					  dao.setBillNumber(resultSet.getString(1));
					  dao.setBillDate(resultSet.getString(2));
					  dao.setCustId(resultSet.getString(3));
					  dao.setCustName(resultSet.getString(4).split("-")[1]);
					  dao.setCustAddress(resultSet.getString(5));
					  dao.setTransportCharges(resultSet.getString(6));
					  dao.setBillTotalAmount(resultSet.getString(7));
					  dao.setBillAmountRecieved(resultSet.getString(8));
					  dao.setBilledBy(resultSet.getString(9));
					  dao.setChalanNumber(resultSet.getString(10));
					  dao.setBillType(resultSet.getString(11));
					  dao.setComments(resultSet.getString(12));
					  dao.setBillTime(resultSet.getString(13));
					  dao.setAccount1CreditDebitId(resultSet.getString(14));
					  dao.setAccount2CreditDebitId(resultSet.getString(15));
					  dao.setPumpAmount("0");
					  dao.setLaborAmount("0");

					  
					  String getVehicleIdSQL  =  "SELECT"
					  		+ " vehicle_id "
					  		+ "FROM "
					  		+ "crusher_vehicle_trip_master "
					  		+ "WHERE "
					  		+ "bill_number = ? "
					  		+ "AND "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  PreparedStatement getVehicleIdPSMT = connection.prepareStatement(getVehicleIdSQL);
					  getVehicleIdPSMT.setString(1, resultSet.getString(1));
					  getVehicleIdPSMT.setString(2, crusherId);
					  getVehicleIdPSMT.setString(3, crusherCode);
					  
					  ResultSet getVehicleIdRS = getVehicleIdPSMT.executeQuery();
					  if(getVehicleIdRS.next())
					  {
						  String vehicleId = getVehicleIdRS.getString(1);
						  
						  HashMap<String,String> vehicleDetails = GetVehicleDetailsById.getVehicleDetailsById(vehicleId, this.getSessionMap(), connection);
						  
						  dao.setVehicleMake(vehicleDetails.get("VEHICLEMAKE"));
						  dao.setVehicleNumber(vehicleDetails.get("REGISTRATIONNUMBER"));
					  }
					  
					  
					  if(getVehicleIdRS != null)
					  {
						  getVehicleIdRS.close();
						  getVehicleIdRS = null;
					  }
					  
					  if(getVehicleIdPSMT != null)
					  {
						  getVehicleIdPSMT.close();
						  getVehicleIdPSMT = null;
					  }
					  
					  
					  billMap.put(resultSet.getString(1)+"#"+resultSet.getString(11), dao);
				  }
				}
				  
				  if(resultSet != null)
				  {
					  resultSet.close();
					  resultSet = null;
				  }
				  
				  if(preparedStatement != null)
				  {
					  preparedStatement.close();
					  preparedStatement = null;
				  }
				  
				  
				  // rmc details 
				  
				 
				  if(this.getType().equals("ALL") || this.getType().equals("RMC"))
					{
						
					  
				  sql = "SELECT "
					  		+ "bi.bill_number,"
					  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
					  		+ "bi.customer_id,"
					  		+ "bi.customer_name,"
					  		+ "cust.billing_address,"
					  		+ "bi.transport_charges,"
					  		+ "bi.bill_total_amount,"
					  		+ "bi.bill_amount_received,"
					  		+ "bi.billed_by,"
					  		+ "bi.chalan_number,"
					  		+ "bi.bill_type,"
					  		+ "bi.comments,"
					  		+ "bill_time,"
					  		+ "bi.account1_credit_debit_id,"
							+ "bi.account2_credit_debit_id," 
							+ "bi.pumpAmount,"
           					+ "bi.labourAmount "
	           				+ "FROM "
					  		+ "crusher_rmc_billinfo as bi "
					  		+ "INNER JOIN "
					  		+ "crusher_customer_master as cust "
					  		+ "ON "
					  		+ "bi.customer_id = cust.customer_id "
					  		+ "WHERE "
					  		+ "(bill_date  "
					  		+ "BETWEEN "
					  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
					  		+ "AND "
					  		+ "STR_TO_DATE(?,'%d-%m-%Y'))  "
					  		+ "AND "
					  		+ "bi.crusher_id = ? "
					  		+ "AND "
					  		+ "bi.crusher_code = ? "
					  		+ "AND "
					  		+ "cust.crusher_id = ? "
					  		+ "AND "
					  		+ "cust.crusher_code = ? "
					  		+ "AND "
					  		+ "bi.bill_amount_received = 'null' "
	                        + "ORDER BY bi.bill_date,bi.bill_number";
					  
					  preparedStatement = connection.prepareStatement(sql);
					  
					  preparedStatement.setString(1, this.getFromDate());
					  preparedStatement.setString(2, this.getToDate());
					  preparedStatement.setString(3, crusherId);
					  preparedStatement.setString(4, crusherCode);
					  preparedStatement.setString(5, crusherId);
					  preparedStatement.setString(6, crusherCode);
					  
					  
					  resultSet = preparedStatement.executeQuery();
					  
					  while(resultSet.next())
					  {
						  
						  transportTotal = transportTotal + resultSet.getFloat(6);
						  totalBillAmount = totalBillAmount + resultSet.getFloat(7);
						  totalReceivedAmount  = totalReceivedAmount + resultSet.getFloat(8);
						 
						  
						  float balAmt = totalBillAmount - totalReceivedAmount;
						  
						  if(balAmt>=0)
						  {
							  totalBalanceAmount = totalBalanceAmount + balAmt;
						  }
						  
						  TodayBillingListDAO dao = new TodayBillingListDAO();
						
						  dao.setBillNumber(resultSet.getString(1));
						  dao.setBillDate(resultSet.getString(2));
						  dao.setCustId(resultSet.getString(3));
						  dao.setCustName(resultSet.getString(4).split("-")[1]);
						  dao.setCustAddress(resultSet.getString(5));
						  dao.setTransportCharges(resultSet.getString(6));
						  dao.setBillTotalAmount(resultSet.getString(7));
						  dao.setBillAmountRecieved(resultSet.getString(8));
						  dao.setBilledBy(resultSet.getString(9));
						  dao.setChalanNumber(resultSet.getString(10));
						  dao.setBillType(resultSet.getString(11));
						  dao.setComments(resultSet.getString(12));
						  dao.setBillTime(resultSet.getString(13));
						  dao.setAccount1CreditDebitId(resultSet.getString(14));
						  dao.setAccount2CreditDebitId(resultSet.getString(15));
						  dao.setPumpAmount(resultSet.getString(16));
						  dao.setLaborAmount(resultSet.getString(17));
    		       		
						  
						 totalPumpAmtAllTheTime = totalPumpAmtAllTheTime + resultSet.getFloat(16);
	        		        totalLaborAmtAllTheTime = totalLaborAmtAllTheTime + resultSet.getFloat(17);
	        		        
						  String getVehicleIdSQL  =  "SELECT"
						  		+ " trip_vehicle_id "
						  		+ "FROM "
						  		+ "crusher_rmc_vehicle_trip_master "
						  		+ "WHERE "
						  		+ "bill_number = ? "
						  		+ "AND "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						  PreparedStatement getVehicleIdPSMT = connection.prepareStatement(getVehicleIdSQL);
						  getVehicleIdPSMT.setString(1, resultSet.getString(1));
						  getVehicleIdPSMT.setString(2, crusherId);
						  getVehicleIdPSMT.setString(3, crusherCode);
						  
						  ResultSet getVehicleIdRS = getVehicleIdPSMT.executeQuery();
						  if(getVehicleIdRS.next())
						  {
							  String vehicleId = getVehicleIdRS.getString(1);
							  
							  HashMap<String,String> vehicleDetails = GetVehicleDetailsById.getVehicleDetailsById(vehicleId, this.getSessionMap(), connection);
							  
							  dao.setVehicleMake(vehicleDetails.get("VEHICLEMAKE"));
							  dao.setVehicleNumber(vehicleDetails.get("REGISTRATIONNUMBER"));
						  }
						  
						  
						  if(getVehicleIdRS != null)
						  {
							  getVehicleIdRS.close();
							  getVehicleIdRS = null;
						  }
						  
						  if(getVehicleIdPSMT != null)
						  {
							  getVehicleIdPSMT.close();
							  getVehicleIdPSMT = null;
						  }
						  
						  
						  billMap.put(resultSet.getString(1)+"#"+resultSet.getString(11), dao);
					  }
				  
					}
				  
				  
				  float royalty = 0.0F;
				  float totalcgst = 0.0F;
				  float totalsgst = 0.0F;
				  totalTaxableAmtAllTheTime = 0.0f;
				  totalCgstAllTheTime = 0.0f;
				  totalSgstAllTheTime = 0.0f;
				  
				  
				  
				  for(String billNumber:billMap.keySet())
				  {
					 
					  float totalMaterialCost = 0.0F;
						 
					  
					  String getProductInfoSQL = "";
					  PreparedStatement getProductInfoPSMT = null;
					  ResultSet getProductInfoRS = null;
					  
					  TodayBillingListDAO dao = billMap.get(billNumber);
					  if(this.getType().equals("ALL") || this.getType().equals("CRUSHER"))
						{
						  
						
					  getProductInfoSQL = "SELECT "
					  		+ "product_name,"
					  		+ "product_sale_amount_after_discount,"
					  		+ "sale_quantity,"
					  		+ "sales_rate,"
					  		+ "product_cgst_amount,"
					  		+ "product_sgst_amount,"
					  		+ "product_igst,"
					  		+ "product_gross_amount,"
					  		+ "royalty "
					  		+ "FROM "
					  		+ "crusher_bill_product_info "
					  		+ "WHERE "
					  		+ "bill_number = ? "
					  		+ "AND "
					  		+ "bill_type = ? "
					  		+ "AND "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  
					  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
					  
					  getProductInfoPSMT.setString(1, billNumber.split("#")[0]);
					  getProductInfoPSMT.setString(2, dao.getBillType());					  
					  getProductInfoPSMT.setString(3, crusherId);
					  getProductInfoPSMT.setString(4, crusherCode);
					  
					  getProductInfoRS = getProductInfoPSMT.executeQuery();
					
					  
					  StringBuilder productNames = new StringBuilder();
					  StringBuilder quantities = new StringBuilder();
					 
					  while(getProductInfoRS.next())
					  {
						  
						  String productName = getProductInfoRS.getString(1);
						    float quantity = getProductInfoRS.getFloat(3);

						     boolean found = false;
						    for (Map<String, Object> productInfo : productQuantityList) {
						        if (productInfo.get("productName").equals(productName)) {
						            float existingQuantity = (float) productInfo.get("quantity");
						            productInfo.put("quantity", existingQuantity + quantity);
						            found = true;
						            break;
						        }
						    }
						    

							   if (!found) {
							        Map<String, Object> newProduct = new LinkedHashMap<>();
							        newProduct.put("productName", productName);
							        newProduct.put("quantity", quantity);
							        productQuantityList.add(newProduct);
							    }
							

							  if (productNames.length() > 0) {
							        productNames.append(" / ");
							        quantities.append(" / ");
							    }
							  
							  productNames.append(getProductInfoRS.getString(1));  
							    quantities.append(getProductInfoRS.getString(3));    

							    dao.setItemNameAll(productNames.toString());  
							    dao.setItemQuantityAll(quantities.toString());
							    
							    
							    
						  totalMaterialCost = totalMaterialCost + getProductInfoRS.getFloat(2);
						  allBillMatrialCostTotal = allBillMatrialCostTotal + getProductInfoRS.getFloat(2);;
						
							  dao.setItemName(getProductInfoRS.getString(1));
							  dao.setItemQuantity(getProductInfoRS.getString(3));
							  dao.setItemRate(getProductInfoRS.getString(4));
							  dao.setCgst(getProductInfoRS.getFloat(5));
								 dao.setSgst(getProductInfoRS.getFloat(6));
								 dao.setIgst(getProductInfoRS.getString(7));
								   
								 dao.setTaxableAmt(getProductInfoRS.getString(8));

								  
								  totalCgstAllTheTime = totalCgstAllTheTime + getProductInfoRS.getFloat(5);
								  totalSgstAllTheTime = totalSgstAllTheTime + getProductInfoRS.getFloat(6);
								  totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime + getProductInfoRS.getFloat(8);
								  
								  
								 totalcgst = totalcgst + getProductInfoRS.getFloat(5);
								 totalsgst = totalsgst + getProductInfoRS.getFloat(6);
								 
							 totalMaterial = totalMaterial + getProductInfoRS.getFloat(3);
							 
							  royalty = royalty + getProductInfoRS.getFloat("royalty");
							  
							 	 
							  float royalty1 = getProductInfoRS.getFloat("royalty") ;
							  
							  
							  dao.setRoyalty(royalty1 + dao.getRoyalty());
								
							  
							  
				
					  }
					  
						}
					  if(resultSet != null)
					  {
						  resultSet.close();
						  resultSet = null;
					  }
					  
					  if(preparedStatement != null)
					  {
						  preparedStatement.close();
						  preparedStatement = null;
					  }
					  
					  
					  
					  //rmc details
					  
					  
					  if(this.getType().equals("ALL") || this.getType().equals("RMC"))
						{
						  
						
					  getProductInfoSQL = "SELECT "
						  		+ "product_name,"
						  		+ "product_amt_after_discount,"
						  		+ "quanity,"
						  		+ "sales_rate,"
						  		+ "cgst,"
						  		+ "sgst,"
						  		+ "igst,"
						  		+ "gross_amount "
						  		+ "FROM "
						  		+ "crusher_rmc_productbillinfo "
						  		+ "WHERE "
						  		+ "bill_number = ? "
						  		+ "AND "
						  		+ "bill_type = ? "
						  		+ "AND "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						  
						  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
						  
						  getProductInfoPSMT.setString(1, billNumber.split("#")[0]);
						  getProductInfoPSMT.setString(2, dao.getBillType());					  
						  getProductInfoPSMT.setString(3, crusherId);
						  getProductInfoPSMT.setString(4, crusherCode);
						  
						  getProductInfoRS = getProductInfoPSMT.executeQuery();
						
						  StringBuilder productNames = new StringBuilder();
						  StringBuilder quantities = new StringBuilder();
						 
						  while(getProductInfoRS.next())
						  {
							  
							  String productName = getProductInfoRS.getString(1);
							    float quantity = getProductInfoRS.getFloat(3);

							     boolean found = false;
							    for (Map<String, Object> productInfo : productQuantityList) {
							        if (productInfo.get("productName").equals(productName)) {
							            float existingQuantity = (float) productInfo.get("quantity");
							            productInfo.put("quantity", existingQuantity + quantity);
							            found = true;
							            break;
							        }
							    }
							    

								   if (!found) {
								        Map<String, Object> newProduct = new LinkedHashMap<>();
								        newProduct.put("productName", productName);
								        newProduct.put("quantity", quantity);
								        productQuantityList.add(newProduct);
								    }
								

								  if (productNames.length() > 0) {
								        productNames.append(" / ");
								        quantities.append(" / ");
								    }
								  
								  productNames.append(getProductInfoRS.getString(1));  
								    quantities.append(getProductInfoRS.getString(3));    

								    dao.setItemNameAll(productNames.toString());  
								    dao.setItemQuantityAll(quantities.toString());
								    
								    
								    
							  totalMaterialCost = totalMaterialCost + getProductInfoRS.getFloat(2);
							  allBillMatrialCostTotal = allBillMatrialCostTotal + getProductInfoRS.getFloat(2);;
							
								  dao.setItemName(getProductInfoRS.getString(1));
								  dao.setItemQuantity(getProductInfoRS.getString(3));
								  dao.setItemRate(getProductInfoRS.getString(4));
								  dao.setCgst(getProductInfoRS.getFloat(5));
								 dao.setSgst(getProductInfoRS.getFloat(6));
								 dao.setIgst(getProductInfoRS.getString(7));
								   
								 dao.setTaxableAmt(getProductInfoRS.getString(8));

								  
								  totalCgstAllTheTime = totalCgstAllTheTime + getProductInfoRS.getFloat(5);
								  totalSgstAllTheTime = totalSgstAllTheTime + getProductInfoRS.getFloat(6);
								  totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime + getProductInfoRS.getFloat(8);
								  
								  
								  
									 totalcgst = totalcgst + getProductInfoRS.getFloat(5);
									 totalsgst = totalsgst + getProductInfoRS.getFloat(6);
									 
								 totalMaterial = totalMaterial + getProductInfoRS.getFloat(3);
								 
								
								
								  
					
						  }
						  
						}
					  
					  this.setTotalRoyalty(royalty);
					  
					  this.setMaterialTotal(totalMaterial);
					  float amountReceived = Float.parseFloat(dao.getBillAmountRecieved());
					  
					
					  float totalAmount = Float.parseFloat(dao.getBillTotalAmount());
					  dao.setMaterialAmount(""+totalMaterialCost);
					  dao.setBalanceAmount(""+(totalAmount-amountReceived));
					  billMap.put(billNumber, dao);
					  
					  if(getProductInfoRS != null)
					  {
						  getProductInfoRS.close();
						  getProductInfoRS = null;
					  }
					  
					  if(getProductInfoPSMT != null)
					  {
						  getProductInfoPSMT.close();
						  getProductInfoPSMT = null;
					  }
					 
				  
				  
				  

					String getCashOnlineAmtCode = "SELECT payment_type,"
							+ "amount "
							+ " FROM "
							+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
							+ "crusher_code = ?";

					PreparedStatement getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

					getCashOnlineAmtPSMT.setString(1, dao.getAccount1CreditDebitId());
					getCashOnlineAmtPSMT.setString(2, crusherId);
					getCashOnlineAmtPSMT.setString(3, crusherCode);

					ResultSet getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
					if (getCashOnlineAmtRs.next()) {
						dao.setAcc1PaymentType(getCashOnlineAmtRs.getString(1));
						dao.setAcc1Amount(getCashOnlineAmtRs.getFloat(2));
					} else {
						dao.setAcc1PaymentType("NA");
						dao.setAcc1Amount(0.0f);
						
					}

					if (getCashOnlineAmtRs != null) {
						getCashOnlineAmtRs.close();
						getCashOnlineAmtRs = null;
					}

					if (getCashOnlineAmtPSMT != null) {
						getCashOnlineAmtPSMT.close();
						getCashOnlineAmtPSMT = null;
					}
					
					
					
					 getCashOnlineAmtCode = "SELECT payment_type,"
							+ "amount "
							+ " FROM "
							+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
							+ "crusher_code = ?";

					 getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

					getCashOnlineAmtPSMT.setString(1, dao.getAccount2CreditDebitId());
					getCashOnlineAmtPSMT.setString(2, crusherId);
					getCashOnlineAmtPSMT.setString(3, crusherCode);

					 getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
					if (getCashOnlineAmtRs.next()) {
						dao.setAcc2PaymentType(getCashOnlineAmtRs.getString(1));
						dao.setAcc2Amount(getCashOnlineAmtRs.getFloat(2));
					} else {
						dao.setAcc2PaymentType("NA");
						dao.setAcc2Amount(0.0f);
						
					}

					if (getCashOnlineAmtRs != null) {
						getCashOnlineAmtRs.close();
						getCashOnlineAmtRs = null;
					}

					if (getCashOnlineAmtPSMT != null) {
						getCashOnlineAmtPSMT.close();
						getCashOnlineAmtPSMT = null;
					}

					
			  
					
					
					if(dao.getAcc1PaymentType().equals("CASH"))
					{
						dao.setCashAmt(dao.getAcc1Amount()); 
						
					}else if(dao.getAcc2PaymentType().equals("CASH"))
					{
						dao.setCashAmt(dao.getAcc2Amount());
						
					}
					
					if(!dao.getAcc1PaymentType().equals("CASH"))
					{
						dao.setOnlineAmt(dao.getAcc1Amount());
						
					}else if(!dao.getAcc2PaymentType().equals("CASH"))
					{
						dao.setOnlineAmt(dao.getAcc2Amount());
						
					}
					
					this.setTotalCashAmt(this.getTotalCashAmt() + dao.getCashAmt());
					this.setTotalOnlineAmt(this.getTotalOnlineAmt() + dao.getOnlineAmt());
				  
			  }
			  
			 
				 
			  for(String billNumber:billMap.keySet())
			  {
				  this.getCreditReportList().add(billMap.get(billNumber));
			  }
			 
		
			  
				 
		        		
		        		
		        		
		        		if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
	       					
		        		@SuppressWarnings("unchecked")
						String crusherName = (String) this.getSessionMap().get("crushernameenglish");
					    
						
					 DecimalFormat df = new DecimalFormat("##.##");
					 String path=	request.getSession().getServletContext().getRealPath("/images/");
			    			PDDocument document = new PDDocument(); 
							PDPage page = null;
							
							SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-Y");
							Date date = new Date();
							
							String dateToday = sdf.format(date); 
							page = 	new PDPage(new PDRectangle(830,580));
							
							 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
							 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
							 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
							
						        document.addPage(page);
						         PDPageContentStream contentStream = new PDPageContentStream(document, page);
						         int pageCount = 1;
					    			 
						         Table header;
					    			
					    			
					    			  TableBuilder tableHeaderBuilder = Table.builder()
								                .addColumnsOfWidth(830)				                
								                .font(HELVETICA)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							         
							          Row headerName = Row.builder()
								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
								                .backgroundColor(WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          
							          
							          Row info1 = Row.builder()
								                .add(TextCell.builder().text("Credit Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
								                .backgroundColor(WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
								                .horizontalAlignment(CENTER)
								                .build();
							    
							          
							          Row info2 = Row.builder()
							                .add(TextCell.builder().text("From Date: "
							                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							                .horizontalAlignment(CENTER)
							                .build();
							          
							       
							          tableHeaderBuilder.addRow(headerName);
							          tableHeaderBuilder.addRow(info1);
							          tableHeaderBuilder.addRow(info2);
							       
							          header = tableHeaderBuilder.build();
							          
							          
							          
							          Table stateMentDetails ;
							          
							          TableBuilder statementDetailsBuilder = Table.builder()
							        		  .addColumnsOfWidth(17,35,35,25,30,35,70,50,40,50,20,25,25,25,25,25,25,25,25,25,25,25,25,25,25,30)				                
								              .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							          
							          Row tableDetailsHeader = Row.builder()
							        		  .add(TextCell.builder().text("Sr.No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							        		  	.add(TextCell.builder().text("Time").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							        		    .add(TextCell.builder().text("Bill No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							        		    .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
								                .add(TextCell.builder().text("Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text("Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text("Item").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
										        .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
								                .add(TextCell.builder().text("QTY").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
									            .add(TextCell.builder().text("Total Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("Taxable Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("cgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("sgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text("Transport Charge").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text("Total Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("Cash Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("Online Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("Amt Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("Balance Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									            .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          statementDetailsBuilder.addRow(tableDetailsHeader);
							          
							          
							          int size = this.getCreditReportList().size();
							          
							          float startY = page.getMediaBox().getHeight() - PADDING20;
							          float currentY = startY;
							          TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(header)
						                .startX(PADDING20)
						                .startY(startY)
						                .build()
						                .draw();

						        	  for(int s=0;s<size;s++)
						        	  {
						        		  if(currentY < 130)
						        		  {
						        			  pageCount++;
						        			  stateMentDetails = statementDetailsBuilder.build();
						        			  TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(stateMentDetails)
								                .startX(PADDING10)
								                .startY(startY-70)
								                .build()
								                .draw();
						        			  
						        			  contentStream.close();
						        			  
						        			  header = null;
						        			  
						        			  

	    					    			  tableHeaderBuilder = Table.builder()
	    								                .addColumnsOfWidth(830)				                
	    								                .font(HELVETICA)
	    								                .borderColor(Color.BLACK)
	    								                .horizontalAlignment(CENTER);
	    							         
	    							          headerName = Row.builder()
	    								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
	    								                .backgroundColor(WHITE)
	    								                .textColor(Color.BLACK)
	    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
	    								                .horizontalAlignment(CENTER)
	    								                .build();
	    							          
	    							           info1 = Row.builder()
	    								                .add(TextCell.builder().text("Credit Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
	    								                .backgroundColor(WHITE)
	    								                .textColor(Color.BLACK)
	    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
	    								                .horizontalAlignment(CENTER)
	    								                .build();
	    							       
	    							          
	    							           info2 = Row.builder()
	  								                .add(TextCell.builder().text("From Date: "
	  								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
	  								                .backgroundColor(WHITE)
	  								                .textColor(Color.BLACK)
	  								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
	  								                .horizontalAlignment(CENTER)
	  								                .build();
	    							          
	    							       
	    							          tableHeaderBuilder.addRow(headerName);
	    							          tableHeaderBuilder.addRow(info1);
	    							          tableHeaderBuilder.addRow(info2);
	    							       
	    							          header = tableHeaderBuilder.build();
	    							          
	    							          
	    							          
	    							          
	    							          
	    							          statementDetailsBuilder = Table.builder()
	    							        		  .addColumnsOfWidth(17,35,35,25,30,35,70,50,40,50,20,25,25,25,25,25,25,25,25,25,25,25,25,25,25,30)				                
	    								               .font(HELVETICA)
	    								                .borderWidth(0.5F)
	    								                .borderColor(Color.BLACK)
	    								                .horizontalAlignment(CENTER);
	    							          
	    							          
	    							          
	    							           tableDetailsHeader = Row.builder()
	    							        		   .add(TextCell.builder().text("Sr.No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	    							        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	    							        		  	.add(TextCell.builder().text("Time").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	    							        		    .add(TextCell.builder().text("Bill No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	    							        		    .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	    								                .add(TextCell.builder().text("Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .add(TextCell.builder().text("Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .add(TextCell.builder().text("Item").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	    										        .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	    								                .add(TextCell.builder().text("QTY").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	    								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	    									            .add(TextCell.builder().text("Total Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("Taxable Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("cgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("sgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .add(TextCell.builder().text("Transport Charge").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .add(TextCell.builder().text("Total Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("Cash Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("Online Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("Amt Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("Balance Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    									            .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	    								                .backgroundColor(Color.LIGHT_GRAY)
	    								                .textColor(Color.BLACK)
	    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
	    								                .horizontalAlignment(CENTER)
	    								                .build();	    							
	    							          statementDetailsBuilder.addRow(tableDetailsHeader);
						        			  
	    							          
	    							      	PDPage newPage = new PDPage(new PDRectangle(830,580));
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING20)
							                .startY(currentY)
							                .build()
							                .draw();
						        		  }
						        		  
						        		  
						        		  TodayBillingListDAO dao = this.getCreditReportList().get(s);
						        		  
						        		
						        		  
						        		 
						        		Row custInfo = Row.builder()
						        				.add(TextCell.builder().text(""+(s+1)).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	  	.add(TextCell.builder().text(dao.getBillDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	  	.add(TextCell.builder().text(dao.getBillTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  		.add(TextCell.builder().text(dao.getBillNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  		.add(TextCell.builder().text(dao.getChalanNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(dao.getBillType()).fontSize(5).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(dao.getCustName()).fontSize(7).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(dao.getCustAddress()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        			  	.add(TextCell.builder().text(""+dao.getItemName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
								        		.add(TextCell.builder().text(dao.getVehicleMake()+"-"+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getItemQuantity()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getItemRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			.add(TextCell.builder().text(dao.getMaterialAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			.add(TextCell.builder().text(dao.getTaxableAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			.add(TextCell.builder().text(""+dao.getCgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			.add(TextCell.builder().text(""+dao.getSgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			.add(TextCell.builder().text(""+dao.getRoyalty()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(dao.getTransportCharges()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(""+dao.getPumpAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(""+dao.getLaborAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(dao.getBillTotalAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(""+dao.getCashAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(""+dao.getOnlineAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(dao.getBillAmountRecieved()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(dao.getBalanceAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(dao.getCustAddress()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        			  	.backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA)
									                .fontSize(7)				              
									                .horizontalAlignment(CENTER)
									                .height(25F)					                
									                .build();
							        	  
						        			statementDetailsBuilder.addRow(custInfo);
							        	 
							        	  currentY = currentY -25;
						        		  
						        	  }
						        	  
						        		Row totalInfo = Row.builder()
						        				.add(TextCell.builder().text("Total : ").colSpan(10).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(df.format(totalMaterial)).colSpan(2).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getAllBillMatrialCostTotal()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        			  	.add(TextCell.builder().text(""+this.getTotalTaxableAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        			  	.add(TextCell.builder().text(""+this.getTotalCgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        			  	.add(TextCell.builder().text(""+this.getTotalSgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        			  	.add(TextCell.builder().text(""+this.getTotalRoyalty()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        				.add(TextCell.builder().text(""+this.getTransportTotal()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        				.add(TextCell.builder().text(""+this.getTotalPumpAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        				.add(TextCell.builder().text(""+this.getTotalLaborAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
						        			  	.add(TextCell.builder().text(""+this.getTotalBillAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getTotalCashAmt()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getTotalOnlineAmt()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getTotalReceivedAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getTotalBalanceAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text("").font(fontMarathi).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD)
								                .fontSize(7)				              
								                .horizontalAlignment(CENTER)
								                .height(25F)					                
								                .build();
						        	  
					        			statementDetailsBuilder.addRow(totalInfo);
						        	  
						        	  stateMentDetails = statementDetailsBuilder.build();
						        	  
						        	  
						        	
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(stateMentDetails)
					                .startX(PADDING10)
					                .startY(startY-70)
					                .build()
					                .draw();
						          
						          
						         
						          
						         
						          
							          
							          
								          contentStream.close();
								         
									       // System.out.println(path);
													
									        
									        document.save(path+"/credit-report.pdf");
									        document.close();
									        
									        response.setHeader("Content-disposition", "inline; filename=credit-report.pdf");
											response.setContentType("application/pdf");
											FileInputStream fileInputStream = new FileInputStream(path+"/credit-report.pdf");
											PrintWriter out = response.getWriter();  
											int bytes;
											while ((bytes = fileInputStream.read()) != -1) {
												out.write(bytes);
											}
											fileInputStream.close();
											out.flush();
											out.close();
											ttf1.close();
					  
											
											
		        		}else {
		        			
		        			@SuppressWarnings("unchecked")
							String crusherName = (String) this.getSessionMap().get("crushernameenglish");
						    
							
						 DecimalFormat df = new DecimalFormat("##.##");
						 String path=	request.getSession().getServletContext().getRealPath("/images/");
				    			PDDocument document = new PDDocument(); 
								PDPage page = null;
								
								SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-Y");
								Date date = new Date();
								
								String dateToday = sdf.format(date); 
								page = 	new PDPage(new PDRectangle(830,580));
								
								 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
								 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
								 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
								
							        document.addPage(page);
							         PDPageContentStream contentStream = new PDPageContentStream(document, page);
							         int pageCount = 1;
						    			 
							         Table header;
						    			
						    			
						    			  TableBuilder tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(830)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								          Row headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								          Row info1 = Row.builder()
									                .add(TextCell.builder().text("Credit Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								    
								          
								          Row info2 = Row.builder()
								                .add(TextCell.builder().text("From Date: "
								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
								                .backgroundColor(WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
								                .horizontalAlignment(CENTER)
								                .build();
								          
								       
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								       
								          header = tableHeaderBuilder.build();
								          
								          
								           
								          Table stateMentDetails ;
								          
								          TableBuilder statementDetailsBuilder = Table.builder()
								        		  .addColumnsOfWidth(17,35,35,25,30,35,70,50,40,50,20,27,27,27,27,27,27,27,27,27,27,27,27,27,30)				                
									               .font(HELVETICA)
									                .borderWidth(0.5F)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								          
								          
								          Row tableDetailsHeader = Row.builder()
								        		  .add(TextCell.builder().text("Sr.No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	 							        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	 							        		  	.add(TextCell.builder().text("Time").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	 							        		    .add(TextCell.builder().text("Bill No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	 							        		    .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	 								                .add(TextCell.builder().text("Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 								                .add(TextCell.builder().text("Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 								                .add(TextCell.builder().text("Item").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	 										        .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
	 								                .add(TextCell.builder().text("QTY").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	 								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
	 									            .add(TextCell.builder().text("Total Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("Taxable Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("cgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("sgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("Transport Charge").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 								                .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 								                .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 								                .add(TextCell.builder().text("Total Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("Cash Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("Online Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("Amt Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("Balance Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 									            .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
	 								                .backgroundColor(Color.LIGHT_GRAY)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          statementDetailsBuilder.addRow(tableDetailsHeader);
								          
								          
								          int size = this.getCreditReportList().size();
								          
								          float startY = page.getMediaBox().getHeight() - PADDING20;
								          float currentY = startY;
								          TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING20)
							                .startY(startY)
							                .build()
							                .draw();

							        	  for(int s=0;s<size;s++)
							        	  {
							        		  if(currentY < 130)
							        		  {
							        			  pageCount++;
							        			  stateMentDetails = statementDetailsBuilder.build();
							        			  TableDrawer.builder()
									                .contentStream(contentStream)
									                .table(stateMentDetails)
									                .startX(PADDING10)
									                .startY(startY-70)
									                .build()
									                .draw();
							        			  
							        			  contentStream.close();
							        			  
							        			  header = null;
							        			  
							        			  

		    					    			  tableHeaderBuilder = Table.builder()
		    								                .addColumnsOfWidth(830)				                
		    								                .font(HELVETICA)
		    								                .borderColor(Color.BLACK)
		    								                .horizontalAlignment(CENTER);
		    							         
		    							          headerName = Row.builder()
		    								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
		    								                .backgroundColor(WHITE)
		    								                .textColor(Color.BLACK)
		    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
		    								                .horizontalAlignment(CENTER)
		    								                .build();
		    							          
		    							           info1 = Row.builder()
		    								                .add(TextCell.builder().text("Credit Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
		    								                .backgroundColor(WHITE)
		    								                .textColor(Color.BLACK)
		    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
		    								                .horizontalAlignment(CENTER)
		    								                .build();
		    							       
		    							          
		    							           info2 = Row.builder()
		  								                .add(TextCell.builder().text("From Date: "
		  								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
		  								                .backgroundColor(WHITE)
		  								                .textColor(Color.BLACK)
		  								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
		  								                .horizontalAlignment(CENTER)
		  								                .build();
		    							          
		    							       
		    							          tableHeaderBuilder.addRow(headerName);
		    							          tableHeaderBuilder.addRow(info1);
		    							          tableHeaderBuilder.addRow(info2);
		    							       
		    							          header = tableHeaderBuilder.build();
		    							          
		    							          
		    							          
		    							          
		    							          
		    							          statementDetailsBuilder = Table.builder()
		    							        		  .addColumnsOfWidth(17,35,35,25,30,35,70,50,40,50,20,27,27,27,27,27,27,27,27,27,27,27,27,27,30)				                
											                .font(HELVETICA)
		    								                .borderWidth(0.5F)
		    								                .borderColor(Color.BLACK)
		    								                .horizontalAlignment(CENTER);
		    							          
		    							          
		    							          
		    							           tableDetailsHeader = Row.builder()
		    							        		   .add(TextCell.builder().text("Sr.No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
			 							        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
			 							        		  	.add(TextCell.builder().text("Time").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
			 							        		    .add(TextCell.builder().text("Bill No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
			 							        		    .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
			 								                .add(TextCell.builder().text("Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 								                .add(TextCell.builder().text("Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 								                .add(TextCell.builder().text("Item").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
			 										        .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
			 								                .add(TextCell.builder().text("QTY").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
			 								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
			 									            .add(TextCell.builder().text("Total Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("Taxable Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("cgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("sgst").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("Transport Charge").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 								                .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 								                .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 								                .add(TextCell.builder().text("Total Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("Cash Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("Online Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("Amt Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("Balance Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 									            .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
			 								                .backgroundColor(Color.LIGHT_GRAY)
		    								                .textColor(Color.BLACK)
		    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
		    								                .horizontalAlignment(CENTER)
		    								                .build();	    							
		    							          statementDetailsBuilder.addRow(tableDetailsHeader);
							        			  
		    							          
		    							      	PDPage newPage = new PDPage(new PDRectangle(830,580));
								        	 contentStream = new PDPageContentStream(document,newPage);
								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
								             document.addPage( newPage );
								             
								             TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(header)
								                .startX(PADDING20)
								                .startY(currentY)
								                .build()
								                .draw();
							        		  }
							        		  
							        		  
							        		  TodayBillingListDAO dao = this.getCreditReportList().get(s);
							        		  
							        		
							        		  
							        		 
							        		Row custInfo = Row.builder()
							        				.add(TextCell.builder().text(""+(s+1)).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	  	.add(TextCell.builder().text(dao.getBillDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	  	.add(TextCell.builder().text(dao.getBillTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  		.add(TextCell.builder().text(dao.getBillNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  		.add(TextCell.builder().text(dao.getChalanNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(dao.getBillType()).fontSize(5).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(dao.getCustName()).fontSize(7).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(dao.getCustAddress()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			  	.add(TextCell.builder().text(""+dao.getItemName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
									        		.add(TextCell.builder().text(dao.getVehicleMake()+"-"+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+dao.getItemQuantity()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+dao.getItemRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
								        			.add(TextCell.builder().text(dao.getMaterialAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
								        			.add(TextCell.builder().text(dao.getTaxableAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
								        			.add(TextCell.builder().text(""+dao.getCgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
								        			.add(TextCell.builder().text(""+dao.getSgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
								        			.add(TextCell.builder().text(dao.getTransportCharges()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        				.add(TextCell.builder().text(""+dao.getPumpAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        				.add(TextCell.builder().text(""+dao.getLaborAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(dao.getBillTotalAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        				.add(TextCell.builder().text(""+dao.getCashAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        				.add(TextCell.builder().text(""+dao.getOnlineAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        				.add(TextCell.builder().text(dao.getBillAmountRecieved()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        				.add(TextCell.builder().text(dao.getBalanceAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        				.add(TextCell.builder().text(dao.getCustAddress()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			  	.backgroundColor(Color.WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA)
										                .fontSize(7)				              
										                .horizontalAlignment(CENTER)
										                .height(25F)					                
										                .build();
								        	  
							        			statementDetailsBuilder.addRow(custInfo);
								        	 
								        	  currentY = currentY -25;
							        		  
							        	  }
							        	  
							        		Row totalInfo = Row.builder()
							        				.add(TextCell.builder().text("Total : ").colSpan(10).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(df.format(totalMaterial)).colSpan(2).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getAllBillMatrialCostTotal()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			  	.add(TextCell.builder().text(""+this.getTotalTaxableAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			  	.add(TextCell.builder().text(""+this.getTotalCgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			  	.add(TextCell.builder().text(""+this.getTotalSgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			  	.add(TextCell.builder().text(""+this.getTransportTotal()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        				.add(TextCell.builder().text(""+this.getTotalPumpAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        				.add(TextCell.builder().text(""+this.getTotalLaborAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())
							        			  	.add(TextCell.builder().text(""+this.getTotalBillAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getTotalCashAmt()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getTotalOnlineAmt()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getTotalReceivedAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getTotalBalanceAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text("").font(fontMarathi).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD)
									                .fontSize(7)				              
									                .horizontalAlignment(CENTER)
									                .height(25F)					                
									                .build();
							        	  
						        			statementDetailsBuilder.addRow(totalInfo);
							        	  
							        	  stateMentDetails = statementDetailsBuilder.build();
							        	  
							        	  
							        	
							          TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(stateMentDetails)
						                .startX(PADDING10)
						                .startY(startY-70)
						                .build()
						                .draw();
							          
							          contentStream.close();
								         
								       // System.out.println(path);
												
								        
								        document.save(path+"/credit-report.pdf");
								        document.close();
								        
								        response.setHeader("Content-disposition", "inline; filename=credit-report.pdf");
										response.setContentType("application/pdf");
										FileInputStream fileInputStream = new FileInputStream(path+"/credit-report.pdf");
										PrintWriter out = response.getWriter();  
										int bytes;
										while ((bytes = fileInputStream.read()) != -1) {
											out.write(bytes);
										}
										fileInputStream.close();
										out.flush();
										out.close();
										ttf1.close();
				  
										
										
	        		}
				  
				  
			}catch (SQLException e) {
				e.printStackTrace();
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Account details not found!");
			} catch (IOException e) {
				e.printStackTrace();
				addActionError(e.getMessage()+" || "+e.getCause()+" || Account details not found !");
			}finally {
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
        }
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public Float getMaterialTotal() {
		return materialTotal;
	}

	public void setMaterialTotal(Float materialTotal) {
		this.materialTotal = materialTotal;
	}

	public Float getMatrialCostTotal() {
		return matrialCostTotal;
	}

	public void setMatrialCostTotal(Float matrialCostTotal) {
		this.matrialCostTotal = matrialCostTotal;
	}

	public Float getAllBillMatrialCostTotal() {
		return allBillMatrialCostTotal;
	}

	public void setAllBillMatrialCostTotal(Float allBillMatrialCostTotal) {
		this.allBillMatrialCostTotal = allBillMatrialCostTotal;
	}

	public Float getTransportTotal() {
		return transportTotal;
	}

	public void setTransportTotal(Float transportTotal) {
		this.transportTotal = transportTotal;
	}

	public Float getTotalBillAmount() {
		return totalBillAmount;
	}

	public void setTotalBillAmount(Float totalBillAmount) {
		this.totalBillAmount = totalBillAmount;
	}

	public Float getTotalBalanceAmount() {
		return totalBalanceAmount;
	}

	public void setTotalBalanceAmount(Float totalBalanceAmount) {
		this.totalBalanceAmount = totalBalanceAmount;
	}

	public Float getTotalReceivedAmount() {
		return totalReceivedAmount;
	}

	public void setTotalReceivedAmount(Float totalReceivedAmount) {
		this.totalReceivedAmount = totalReceivedAmount;
	}

	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	

	public Float getTotalRoyalty() {
		return totalRoyalty;
	}

	public void setTotalRoyalty(Float totalRoyalty) {
		this.totalRoyalty = totalRoyalty;
	}

	public List<TodayBillingListDAO> getCreditReportList() {
		return creditReportList;
	}

	public void setCreditReportList(List<TodayBillingListDAO> creditReportList) {
		this.creditReportList = creditReportList;
	}

	

	public Float getTotalCashAmt() {
		return totalCashAmt;
	}

	public void setTotalCashAmt(Float totalCashAmt) {
		this.totalCashAmt = totalCashAmt;
	}

	public Float getTotalOnlineAmt() {
		return totalOnlineAmt;
	}

	public void setTotalOnlineAmt(Float totalOnlineAmt) {
		this.totalOnlineAmt = totalOnlineAmt;
	}

	public List<Map<String, Object>> getProductQuantityList() {
		return productQuantityList;
	}

	public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
		this.productQuantityList = productQuantityList;
	}

	public List<String> getTypeList() {
		return typeList;
	}

	public void setTypeList(List<String> typeList) {
		this.typeList = typeList;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Float getTotalTaxableAmtAllTheTime() {
		return totalTaxableAmtAllTheTime;
	}

	public void setTotalTaxableAmtAllTheTime(Float totalTaxableAmtAllTheTime) {
		this.totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime;
	}

	public Float getTotalCgstAllTheTime() {
		return totalCgstAllTheTime;
	}

	public void setTotalCgstAllTheTime(Float totalCgstAllTheTime) {
		this.totalCgstAllTheTime = totalCgstAllTheTime;
	}

	public Float getTotalSgstAllTheTime() {
		return totalSgstAllTheTime;
	}

	public void setTotalSgstAllTheTime(Float totalSgstAllTheTime) {
		this.totalSgstAllTheTime = totalSgstAllTheTime;
	}

	public Float getTotalPumpAmtAllTheTime() {
		return totalPumpAmtAllTheTime;
	}

	public void setTotalPumpAmtAllTheTime(Float totalPumpAmtAllTheTime) {
		this.totalPumpAmtAllTheTime = totalPumpAmtAllTheTime;
	}

	public Float getTotalLaborAmtAllTheTime() {
		return totalLaborAmtAllTheTime;
	}

	public void setTotalLaborAmtAllTheTime(Float totalLaborAmtAllTheTime) {
		this.totalLaborAmtAllTheTime = totalLaborAmtAllTheTime;
	}

	

	
}
