package com.stonecrusher.delete;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerPaymentReminderDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetNotificationList;

public class DeleteReminderEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	private String key;
	private ArrayList<CustomerPaymentReminderDetailsDAO> customerPaymentReminderList;
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "error";
	        }  
	        else{
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					String keyData [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					String entryId = keyData[0];
					String custId = keyData[1];
					String promiseDate = keyData[2];
					
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "DELETE "
							+ "FROM "
							+ "crusher_customer_payment_reminder_master "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "customer_id = ? "
							+ "AND "
							+ "payment_promise_date = STR_TO_DATE(?,'%d-%M-%Y')";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, custId);
					preparedStatement.setString(3, promiseDate);
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						result = SUCCESS;
						
						addActionMessage("Entry deleted Successfully!");
					}
					else
					{
						result = ERROR;
						addActionError("Entry not deleted! Please try again!");
					}
					
					

	        		this.setCustomerPaymentReminderList(GetNotificationList.getCustPaymentReminderList(this.getSessionMap()));
	        		
	        		this.getSessionMap().replace("customerpaymentnotificationlist",this.getCustomerPaymentReminderList());
	        
				}
				catch (SQLException e) {
					result = ERROR;
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Could not delete!");
				}
				catch (Exception e) {
					result = ERROR;
					
					addActionError(e.getMessage() +" || Could not delete !");
				}
				finally {
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public ArrayList<CustomerPaymentReminderDetailsDAO> getCustomerPaymentReminderList() {
		return customerPaymentReminderList;
	}

	public void setCustomerPaymentReminderList(ArrayList<CustomerPaymentReminderDetailsDAO> customerPaymentReminderList) {
		this.customerPaymentReminderList = customerPaymentReminderList;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}