package com.stonecrusher.delete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class DeleteMaintenanceEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap; 
	
	private String key;
	private String fromDate;
	private String toDate;
	private String vehicleId;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	downloadTypeList.add("pdf");
		    	downloadTypeList.add("xl");
			
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				java.util.Date date = new java.util.Date();
      	      long t = date.getTime();	        	     
      	      java.sql.Time time = new java.sql.Time(t);
				
				String user = (String) this.getSessionMap().get("userFullName");
				String userName = "";
				
				try
				{
					userName = user.split(" ")[0];
				}catch(Exception e)
				{
					userName = user;
				}
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					String entryId = keyDetails[0];
					String vehicleId = keyDetails[1];
					String entryDate = keyDetails[2];
					
					
					sql = "SELECT "
							+ "credit_debit_id "
							+ "FROM "
							+ "crusher_vehicle_expense_master "
							+ "WHERE "
    						+ "vehicle_expense_entry_id = ? "
    						+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, entryId);
    				preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
					resultSet = preparedStatement.executeQuery();
					
					
					if(resultSet.next()){
						String crditDebitId = resultSet.getString(1);
						
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						sql = "SELECT "
								+ "entry_id,"
								+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
								+ "entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
								
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crditDebitId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						int m = 0;
						String paymentType = null;
						String entryDate1 = null;
						String accountId = null;
						Float amount = null;
						
						if(resultSet.next())
						{
							accountId = resultSet.getString(2);
						    paymentType = resultSet.getString(6);
							 entryDate1 = resultSet.getString(4);
							 amount = resultSet.getFloat(7);
							 
							PreparedStatement  insertIntoDeletedPSMT = null;
							
							String inertDeletedSQL = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_deleted_entry_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details) "
									+ "VALUES "
									+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
							
							insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
							
							insertIntoDeletedPSMT.setString(1, crditDebitId);
							insertIntoDeletedPSMT.setString(2, crusherId);
							insertIntoDeletedPSMT.setString(3, crusherCode);
			        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
							insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
							insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
							insertIntoDeletedPSMT.setTime(7, time);
							insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
							insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
							insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
							insertIntoDeletedPSMT.setString(11, userName);
							insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
							
							  m = insertIntoDeletedPSMT.executeUpdate();
							
							if(insertIntoDeletedPSMT != null)
							{
								insertIntoDeletedPSMT.close();
								insertIntoDeletedPSMT = null;
							}
							
						}
						
						
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						if(m>0)
						{
							

						
						sql = "DELETE "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
								+ "entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crditDebitId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						int k = preparedStatement.executeUpdate();
						
						if(k>0  )
						{
							boolean isCloseingBalMaintained = false;
						    
							SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
							Date parsedDate = null;

							try {
							    parsedDate = inputDateFormat.parse(entryDate1); 
							} catch (ParseException e) {
							    e.printStackTrace();  
							}

							if (parsedDate != null) {
							     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
							    String formattedDate = outputDateFormat.format(parsedDate); 
							   
							    if (paymentType.equals("CREDIT")) {
							    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, userName, connection, this.getSessionMap());
							    } else {
							    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, userName, connection, this.getSessionMap());
							    }
							}
					
						
						
						sql = "DELETE "
								+ "FROM "
								+ "crusher_vehicle_expense_master "
								+ "WHERE "
								+ "vehicle_expense_entry_id = ? "
								+ "AND "
								+ "vehicle_id = ? "
								+ "AND "
								+ "exepense_date = STR_TO_DATE(?,'%d-%m-%Y') "
								+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
    							
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, entryId);
						preparedStatement.setString(2, vehicleId);
						preparedStatement.setString(3, entryDate);
						preparedStatement.setString(4, crusherId);
        				preparedStatement.setString(5, crusherCode);
        				
						
						int rowCount = preparedStatement.executeUpdate();
						
						if(rowCount > 0)
						{
							
							addActionMessage(this.getText("message.success.entryDeletedSuccessfully"));
								connection.commit();
								
								result = SUCCESS;
							
						}
    				else
    				{
    					connection.rollback();
    					addActionError(this.getText("message.error.vehicleMaintenanceEntryNotdeleted"));
    					result = "error";
    				}
    			
    			
					}
    			}
					
					}
				}
    		
					
					
				
				catch (SQLException e) {
					
					//e.printStackTrace();
					try {
						connection.rollback();
					} catch (SQLException e1) {}
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					//e.printStackTrace();
					
					try {
						connection.rollback();
					} catch (SQLException e1) {}
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	       
	        return result;
	}
	
	
	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public Map<String, String> getVehicleList() {
		return vehicleList;
	}


	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}
	

}




