package com.stonecrusher.delete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DeleteEmployeeAbsentEntry extends ActionSupport implements SessionAware{


	

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 5717500582440047991L;
	private String entryId;
	private String fromDate;
	private String toDate;
	private SessionMap<String,Object> sessionMap; 
	private String addSideBarJs;
	
	private List<String> typeList = new ArrayList<String>();
	private List<String> markingTypeList = new ArrayList<String>();

	
	
	public String execute() throws Exception {
		String result = "login";
		
		
        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
        	addActionMessage(this.getText("message.error.plzloginfirst"));
        	result = "login";
        	
        	
        }  
        else{
        	
        	
        	typeList.add("Type 1");
       		typeList.add("Type 2");
       		
       		
        	
       		markingTypeList.add("ALL");
       		markingTypeList.add("ABSENT");
       		markingTypeList.add("HALFDAY");
       		markingTypeList.add("OVERTIME");
        	
        	this.setAddSideBarJs("FALSE");
			
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
		
		
				
			String sql = "";
			String db = (String)  this.getSessionMap().get("db");
	    		
	    		try
	    		{
	    			
	    			String entryId  = EncryptionDecryption.decrypt(this.getEntryId());
	    			
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			
	    			if(!hasActionErrors())
	    			{
	    				sql ="DELETE "
	    						+ "FROM "
	    						+ "crusher_employee_presenty_details "
	    						+ "WHERE "
	    						+ "entry_id = ? "
	    						+ "AND "
	    						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				preparedStatement.setString(1, entryId);
	    				preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
	    				int k = preparedStatement.executeUpdate();
	    				
	    				if(k>0)
	    				{
	    					
	    					
	    					addActionMessage(this.getText("message.success.employeeAbsentEntryDeletedSuccessfully"));
	    					result = SUCCESS;
	    				}
	    				else
	    				{
	    					addActionError(this.getText("message.error.employeeAbsentEntryNotDeleted"));
	    					result = ERROR;
	    				}
	    			}
	    			
	    			
	    			
	    		}
	    		catch (SQLException e) {
	    			//e.printStackTrace();
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.employeeAbsentEntryNotDeleted"));
	    		}
	    		catch (Exception e) {
	    			//e.printStackTrace();
	    			
	    			addActionError(e.getMessage() +" || "+this.getText("message.error.employeeAbsentEntryNotDeleted"));
				}finally {
	    			if(resultSet != null)
   				{
   					try {
   						resultSet.close();
   						resultSet = null;
   					} catch (SQLException e) {
   						
   					}
   				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
       	
       	
       	
       	
       }
	    
	  
       return result;
}

	



	public String getEntryId() {
		return entryId;
	}





	public void setEntryId(String entryId) {
		this.entryId = entryId;
	}





	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	

	
	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}




	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}




	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}




	@Override
	public void setSession(Map<String, Object> map) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)map; 
	}





	public String getAddSideBarJs() {
		return addSideBarJs;
	}





	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}





	public List<String> getTypeList() {
		return typeList;
	}





	public void setTypeList(List<String> typeList) {
		this.typeList = typeList;
	}





	public List<String> getMarkingTypeList() {
		return markingTypeList;
	}





	public void setMarkingTypeList(List<String> markingTypeList) {
		this.markingTypeList = markingTypeList;
	}

	
	
	


	
	
}
