package com.stonecrusher.delete;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.PurchaseInvoiceInformationDAO;
import com.stonecrusher.DAO.PurchaseProductInfoDAO;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;

public class DeleteEditProductFromDieselAdbluePurchaseList extends ActionSupport implements SessionAware,Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1518042868893424844L;
	
	
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	
	private String purchaseDateTime;
	private String productName;
	private Float amount;
	private Float quantity;
	private String purchaseUnit;
	private Float purchaseRate;
	private String taxId;
	private Float frightCharges;
	private Float otherExpense;
	private String purchaseId;
	private String supplierName;
	private String invoiceNumber;
	private String comments;
	private File invoiceImage;
	private String invoiceImageContentType;
	private boolean addToStock;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO = null;
	
	private List<PurchaseProductInfoDAO> purchaseProductInfoList = null;
	
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private String paymentDefaultValue;
	private String purchaseBy;
	private String viewPurchaseInvoice;
	
	private Float totalPurchaseAmount;
	
	private Float totalNettAmount;
	private Float totalCGST;
	private Float totalSGST;
	private Float totalIGST;
	
	private DecimalFormat df;
	private String amountPaid;
	private String productNameForDelete;
	private String addSideBarJs;

	
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	
	private String accountId;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
    private String vehicleId;
    private List<String> productList = new ArrayList<String>();

    private List<String> paymentTypeList2 = new ArrayList<String>();
	
    private Float totalQuantity;
    
	@SuppressWarnings("unchecked")
	public String execute() {
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else
	        {
	        	this.setTotalQuantity(0.0F);
	        	
	        	this.setAddSideBarJs("FALSE");
	        	
	        	
	        	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	paymentTypeList2.add("CASH");
	        	paymentTypeList2.add("UPI");
	        	paymentTypeList2.add("RTGS");
	        	paymentTypeList2.add("NEFT");
	        	
	        	
	        	productList = GetListResource.getDieselAdblueProductList();
	    		
	     	
	        	 df = new DecimalFormat("0.00");
	        	purchaseInvoiceInformationDAO = (PurchaseInvoiceInformationDAO) sessionMap.get("purchaseInformation");
	        	purchaseProductInfoList = (List<PurchaseProductInfoDAO>) sessionMap.get("purchaseProductList");
	        	
	        	
	       	
	        	if(purchaseInvoiceInformationDAO != null && purchaseProductInfoList != null)
	        	{
	        		
	        		
	        		
	        	if(getProductNameForDelete() != null || getProductNameForDelete().equals(""))
	        	{
	        		int removeIndexCount = 0;
		        	int i = 0;
		        	boolean isPurchaseProductRemovedFromDB = false;
		        	
		        	for(PurchaseProductInfoDAO productInfoDAO : purchaseProductInfoList)
		        	{
		        		String listProductName = productInfoDAO.getProductName();
		        		
		        		
		        		if(this.getProductNameForDelete().equals(listProductName))
		        		{
		        			removeIndexCount = i;
		        		}
		        		
		        		i++;
		        	}
		        	
		        
		        		PurchaseProductInfoDAO dao = purchaseProductInfoList.get(removeIndexCount);
		        		
		        		this.setProductName(dao.getProductName());
		        		this.setPurchaseRate(dao.getPurchaseRate());
		        		this.setPurchaseUnit(dao.getPurchaseUnit());
		        		this.setQuantity(dao.getQuantity());
		        		this.setAmount(dao.getAmount());
		        		this.setTaxId(dao.getTaxId());
			        	this.setRateType(dao.getRateType());
			        	this.setRateTyprDefaultValue(dao.getRateType());
			        	
		        		purchaseProductInfoList.remove(removeIndexCount);
		        		
			        	 float floatTotalPurchaseAmount = 0.0F;
			        	 float floatTotalCGST = 0.0F;
			        	 float floatTotalSGST = 0.0F;
			        	 float floatTotalIGST = 0.0F;
			        	 float floatTotalNettAmount = 0.0F;

			        	 for (PurchaseProductInfoDAO pProductInfoDAO : this.getPurchaseProductInfoList())
			        	 {
			        		
			        			
			        		 this.setTotalQuantity(pProductInfoDAO.getQuantity()+this.getTotalQuantity());
			        		 floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getGrossAmount();
			        		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
			        		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
			        		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
			        		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
			        	 }
			        	 
			        	 this.setTotalPurchaseAmount(floatTotalPurchaseAmount);
			        	 this.setTotalNettAmount(floatTotalNettAmount);
			        	 this.setTotalCGST(floatTotalCGST);
			        	 this.setTotalSGST(floatTotalSGST);
			        	 this.setTotalIGST(floatTotalIGST);
		        		
			        	 
			        	 this.setPurchaseId(purchaseInvoiceInformationDAO.getPurchaseId());
			        	 this.setSupplierName(purchaseInvoiceInformationDAO.getSupplierId()+"-"+purchaseInvoiceInformationDAO.getSupplierName());
			        	 this.setInvoiceNumber(purchaseInvoiceInformationDAO.getInvoiceNumber());
			        	 this.setPaymentDefaultValue(purchaseInvoiceInformationDAO.getPaymentType());
			        	 this.setPurchaseBy(purchaseInvoiceInformationDAO.getPurchaseBy());
			        	 this.setAddToStock(purchaseInvoiceInformationDAO.isAddToStock());
			        	 this.setPurchaseDateTime(purchaseInvoiceInformationDAO.getPurchaseDate());
			             this.setVehicleId(purchaseInvoiceInformationDAO.getVehicleId());
			             
		        		 purchaseInvoiceInformationDAO.setPurchaseSaved(false);
		        		 result = "success";
			        	 addActionMessage(this.getText("message.success.productDeletedSuccessfullyfromList"));	
		        	
		        		this.getSessionMap().put("purchaseInformation", purchaseInvoiceInformationDAO);
		        		this.getSessionMap().put("purchaseProductList", purchaseProductInfoList);
	        		

			    		try {
			    			taxList = GetListResource.GetTaxList();
			    			
			    			
			    		} catch (IOException e) {
			    			
			    		}
			        	
			        	unitList = GetListResource.GetUnitList();
			       		
			        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
			       		
		        	
	        	}
	        	else
	        	{
	        		result = "input";
	        		addActionError(this.getText("message.error.urlTemperedPlzTryAgain"));
	        	}
	        	}
	        	else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.somethingWentWrongPlzTryAgain"));
	        	}
	        	
	        
	        	
	        }
	        
	        
	       
	        return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	

	public String getPurchaseUnit() {
		return purchaseUnit;
	}

	public void setPurchaseUnit(String purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}


	public String getTaxId() {
		return taxId;
	}

	public void setTaxId(String taxId) {
		this.taxId = taxId;
	}

	
	public String getPurchaseId() {
		return purchaseId;
	}

	public void setPurchaseId(String purchaseId) {
		this.purchaseId = purchaseId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getInvoiceNumber() {
		return invoiceNumber;
	}

	public void setInvoiceNumber(String invoiceNumber) {
		this.invoiceNumber = invoiceNumber;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public File getInvoiceImage() {
		return invoiceImage;
	}

	public void setInvoiceImage(File invoiceImage) {
		this.invoiceImage = invoiceImage;
	}

	public String getInvoiceImageContentType() {
		return invoiceImageContentType;
	}

	public void setInvoiceImageContentType(String invoiceImageContentType) {
		this.invoiceImageContentType = invoiceImageContentType;
	}

	public boolean isAddToStock() {
		return addToStock;
	}

	public void setAddToStock(boolean addToStock) {
		this.addToStock = addToStock;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public PurchaseInvoiceInformationDAO getPurchaseInvoiceInformationDAO() {
		return purchaseInvoiceInformationDAO;
	}

	public void setPurchaseInvoiceInformationDAO(PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO) {
		this.purchaseInvoiceInformationDAO = purchaseInvoiceInformationDAO;
	}

	public List<PurchaseProductInfoDAO> getPurchaseProductInfoList() {
		return purchaseProductInfoList;
	}

	public void setPurchaseProductInfoList(List<PurchaseProductInfoDAO> purchaseProductInfoList) {
		this.purchaseProductInfoList = purchaseProductInfoList;
	}

	public String getViewPurchaseInvoice() {
		return viewPurchaseInvoice;
	}

	public void setViewPurchaseInvoice(String viewPurchaseInvoice) {
		this.viewPurchaseInvoice = viewPurchaseInvoice;
	}

	
	public Float getTotalPurchaseAmount() {
		return totalPurchaseAmount;
	}

	public void setTotalPurchaseAmount(Float totalPurchaseAmount) {
		this.totalPurchaseAmount = totalPurchaseAmount;
	}

	public Float getTotalNettAmount() {
		return totalNettAmount;
	}

	public void setTotalNettAmount(Float totalNettAmount) {
		this.totalNettAmount = totalNettAmount;
	}

	public Float getTotalCGST() {
		return totalCGST;
	}

	public void setTotalCGST(Float totalCGST) {
		this.totalCGST = totalCGST;
	}

	public Float getTotalSGST() {
		return totalSGST;
	}

	public void setTotalSGST(Float totalSGST) {
		this.totalSGST = totalSGST;
	}

	public Float getTotalIGST() {
		return totalIGST;
	}

	public void setTotalIGST(Float totalIGST) {
		this.totalIGST = totalIGST;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public DecimalFormat getDf() {
		return df;
	}

	public void setDf(DecimalFormat df) {
		this.df = df;
	}
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public String getProductNameForDelete() {
		return productNameForDelete;
	}

	public void setProductNameForDelete(String productNameForDelete) {
		this.productNameForDelete = productNameForDelete;
	}

	public String getAmountPaid() {
		return amountPaid;
	}

	public void setAmountPaid(String amountPaid) {
		this.amountPaid = amountPaid;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public Float getQuantity() {
		return quantity;
	}

	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}

	public Float getPurchaseRate() {
		return purchaseRate;
	}

	public void setPurchaseRate(Float purchaseRate) {
		this.purchaseRate = purchaseRate;
	}

	public Float getFrightCharges() {
		return frightCharges;
	}

	public void setFrightCharges(Float frightCharges) {
		this.frightCharges = frightCharges;
	}

	public Float getOtherExpense() {
		return otherExpense;
	}

	public void setOtherExpense(Float otherExpense) {
		this.otherExpense = otherExpense;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public String getPaymentDefaultValue() {
		return paymentDefaultValue;
	}

	public void setPaymentDefaultValue(String paymentDefaultValue) {
		this.paymentDefaultValue = paymentDefaultValue;
	}

	public String getPurchaseBy() {
		return purchaseBy;
	}

	public void setPurchaseBy(String purchaseBy) {
		this.purchaseBy = purchaseBy;
	}

	public String getPurchaseDateTime() {
		return purchaseDateTime;
	}

	public void setPurchaseDateTime(String purchaseDateTime) {
		this.purchaseDateTime = purchaseDateTime;
	}

	

	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}

	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}

	public String getRateType() {
		return rateType;
	}

	public void setRateType(String rateType) {
		this.rateType = rateType;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	public List<String> getProductList() {
		return productList;
	}

	public void setProductList(List<String> productList) {
		this.productList = productList;
	}

	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}

	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}

	public Float getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}

	     

	

}
