package com.stonecrusher.delete;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.DAO.ChallanInfoDAO;
import com.stonecrusher.DAO.ChallanProductInfoDAO;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.resource.GetListResource;

public class DeleteEditProductFromChallanAndroidList  extends ActionSupport implements SessionAware{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4763633241204670926L;
	private String challanNumber;
	private String challanDateTime;
	private String paymentType;
	private String customerName;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private Float quantity;
	private String comments;
	private String alternateMobileNumber;
	private SessionMap<String,Object> sessionMap;
	private String productNameForDelete;
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private List<ChallanProductInfoDAO> challanProductInfoList ;
	private String defaultValue;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private BillVehicleInfoDAO billVehicleInfoDAO = null;
	
	private String removeVaules="false";
	
	private ChallanInfoDAO challanInfoDAO = null;
	
	private String viewChallan;
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private boolean challanSaved;
	private boolean sendSMS;
	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private String addSideBarJs;

	private Float transportCharges;

	@SuppressWarnings("unchecked")
	public String execute() throws IOException{
		 
		String result = "login";

        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
        	addActionMessage("Please Logout and Login again !");
        	result = "error";
        }  
        else{
	        	
	       	
	        	this.setAddSideBarJs("FALSE");
			
	        	challanProductInfoList = (List<ChallanProductInfoDAO>) this.getSessionMap().get("challanProductList");
	        	challanInfoDAO = (ChallanInfoDAO) this.getSessionMap().get("challanInformation");
	        	
	        	int removeIndexCount = 0;
	        	int i = 0;
	        	boolean isProductRemovedFromDB = true;
	        
					
			
	        	for(ChallanProductInfoDAO infoDAO : this.getChallanProductInfoList())
	        	{
	        		
	        		String pName = infoDAO.getProductName();
	        		
	        		if(this.getProductNameForDelete().equals(pName))
	        		{
	        			removeIndexCount = i;
	        		}
	        		i++;
	        		
	        	}
	        	
	        	if(challanInfoDAO != null)
	        	{	
	            	this.setCustomerName(this.getChallanInfoDAO().getCustomerAllDetails());
	            	this.setVehicleId(this.getChallanInfoDAO().getVehicleAllDetails());
	            	this.setKmStart(this.getChallanInfoDAO().getKmStart());
	            	this.setKmEnd(this.getChallanInfoDAO().getKmEnd());
	            	this.setTotalKm(this.getChallanInfoDAO().getTotalKm());
	            	this.setTotalTrips(this.getChallanInfoDAO().getTotalTripCount());
	            	this.setTripFrom(this.getChallanInfoDAO().getTripFrom());
	            	this.setTripTo(this.getChallanInfoDAO().getTripTo());
	            	this.setComments(this.getChallanInfoDAO().getComments());
	            	this.setTransportCharges(this.getChallanInfoDAO().getTransportCharges());
	            	this.setCustomerName(this.getChallanInfoDAO().getCustomerAllDetails());
	            	this.setVehicleId(this.getChallanInfoDAO().getVehicleAllDetails());
	            	this.setChallanNumber(this.getChallanInfoDAO().getChallanNumber());
	              	this.setPaymentType(this.getChallanInfoDAO().getPaymentType());
	        		

	            	this.setChallanDateTime(this.getChallanInfoDAO().getChallanDate());
	        	}
	        	
	        	
	        	ChallanProductInfoDAO dao = challanProductInfoList.get(removeIndexCount);
	        	
	        	this.setAlias(dao.getAlias());
	        	this.setProductName(dao.getProductName());
	        	this.setProductMarathiName(dao.getProductNameMarathi());
	        	this.setSalesUnit(dao.getSalesUnit());
	        	this.setQuantity(dao.getQuantity());
	        	this.setPaymentType(this.getChallanInfoDAO().getPaymentType());
	       
		        	if(isProductRemovedFromDB && !challanInfoDAO.getChallanSaved())
	    			{
		        		challanInfoDAO.setChallanSaved(false);
		        		challanProductInfoList.remove(removeIndexCount);
		        		addActionMessage("Product removed from list !");
	    			}	        	
		        	else if(isProductRemovedFromDB && challanInfoDAO.getChallanSaved())
		        	{
		        	
	        		challanInfoDAO.setChallanSaved(false);
	        		challanProductInfoList.remove(removeIndexCount);
	        	
        			
        			
		        	}
	        	else
	        	{
	        		addActionError("Product not removed from list !");
	        	}
	        
	        	
	        	
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	       	
	        	
	      
	        	unitList = GetListResource.GetUnitList();
	      	
	        	
	   		
	    		this.getSessionMap().put("challanInformation", this.getChallanInfoDAO());
	    		this.getSessionMap().put("challanProductList", this.getChallanProductInfoList());
	        	
	        	if(!hasActionErrors())
	        	{
	        		result = SUCCESS;
	        	}
	        	else
	        	{
	        		result = ERROR;
	        	}
	        }
	        
	        return result;
	}
	
	
	
	
	public String getChallanNumber() {
		return challanNumber;
	}




	public void setChallanNumber(String challanNumber) {
		this.challanNumber = challanNumber;
	}




	public String getChallanDateTime() {
		return challanDateTime;
	}




	public void setChallanDateTime(String challanDateTime) {
		this.challanDateTime = challanDateTime;
	}




	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}




	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}




	public List<ChallanProductInfoDAO> getChallanProductInfoList() {
		return challanProductInfoList;
	}




	public void setChallanProductInfoList(List<ChallanProductInfoDAO> challanProductInfoList) {
		this.challanProductInfoList = challanProductInfoList;
	}




	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}




	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}




	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}




	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}




	public String getRemoveVaules() {
		return removeVaules;
	}




	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}




	public ChallanInfoDAO getChallanInfoDAO() {
		return challanInfoDAO;
	}




	public void setChallanInfoDAO(ChallanInfoDAO challanInfoDAO) {
		this.challanInfoDAO = challanInfoDAO;
	}




	public String getViewChallan() {
		return viewChallan;
	}




	public void setViewChallan(String viewChallan) {
		this.viewChallan = viewChallan;
	}




	public boolean isChallanSaved() {
		return challanSaved;
	}




	public void setChallanSaved(boolean challanSaved) {
		this.challanSaved = challanSaved;
	}




	public boolean isSendSMS() {
		return sendSMS;
	}




	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}




	public Float getTransportCharges() {
		return transportCharges;
	}




	public void setTransportCharges(Float transportCharges) {
		this.transportCharges = transportCharges;
	}




	public String getPaymentType() {
		return paymentType;
	}
	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}
	public String getCustomerName() {
		return customerName;
	}
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
	public String getProductName() {
		return productName;
	}
	public void setProductName(String productName) {
		this.productName = productName;
	}
	public String getProductMarathiName() {
		return productMarathiName;
	}
	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}
	public String getAlias() {
		return alias;
	}
	public void setAlias(String alias) {
		this.alias = alias;
	}
	public String getSalesUnit() {
		return salesUnit;
	}
	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}
	


	public Float getQuantity() {
		return quantity;
	}




	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}








	public Map<String, String> getUnitList() {
		return unitList;
	}
	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}
	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}
	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}
	
	public String getDefaultValue() {
		return defaultValue;
	}
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}




	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}




	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}



	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}






	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public String getComments() {
		return comments;
	}




	public void setComments(String comments) {
		this.comments = comments;
	}






	public Map<String, String> getVehicleList() {
		return vehicleList;
	}




	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}




	public String getTripDate() {
		return tripDate;
	}




	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}




	public String getVehicleId() {
		return vehicleId;
	}




	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}




	public String getMaterialName() {
		return materialName;
	}




	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}




	public Float getMaterialVolume() {
		return materialVolume;
	}




	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}




	public Float getKmStart() {
		return kmStart;
	}




	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}




	public Float getKmEnd() {
		return kmEnd;
	}




	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}




	public Float getTotalKm() {
		return totalKm;
	}




	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}




	public String getTripFrom() {
		return tripFrom;
	}




	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}




	public String getTripTo() {
		return tripTo;
	}




	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}




	public Integer getTotalTrips() {
		return totalTrips;
	}




	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}




	public String getAddSideBarJs() {
		return addSideBarJs;
	}




	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}




	public String getProductNameForDelete() {
		return productNameForDelete;
	}




	public void setProductNameForDelete(String productNameForDelete) {
		this.productNameForDelete = productNameForDelete;
	}



	
	
	
	
	
	

}
