package com.stonecrusher.delete;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class DeleteDC extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	
	private String fromDate;
	private String toDate;
	private String challanNumber;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				String crusherId = (String) this.getSessionMap().get("crusherId");
				String crusherCode = (String) this.getSessionMap().get("crusherCode");

			
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "DELETE FROM "
							+ "challan_product_details "
							+ "WHERE "
							+ "challan_number = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getChallanNumber());
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					
					int rowCountProductDeleted = preparedStatement.executeUpdate();
					
					if(rowCountProductDeleted > 0)
					{
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						
						sql = "DELETE FROM "
								+ "crusher_delivery_challan_master "
								+ "WHERE "
								+ "challan_number = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, this.getChallanNumber());
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						
						int rowCountDCDeleted = preparedStatement.executeUpdate();
						
						if(rowCountDCDeleted > 0)
						{
							
							
							 sql = "UPDATE crusher_vehicle_entry_details "
    		        			     + "SET delivery_chalan_no = NULL "
    		        			     + "WHERE delivery_chalan_no = ? "
    		        			     + "AND crusher_id = ? "
    		        			     + "AND crusher_code = ?";

    		        			 preparedStatement = connection.prepareStatement(sql);
    		        			 preparedStatement.setString(1, this.getChallanNumber());
    		        			 preparedStatement.setString(2, crusherId);
    		        			 preparedStatement.setString(3, crusherCode);
    		        			 int updateCount = preparedStatement.executeUpdate();

    		        			 sql = "UPDATE crusher_vehicle_entry_details "
    		        			     + "SET status = 'OPEN' "
    		        			     + "WHERE bill_no IS NULL "
    		        			     + "AND delivery_chalan_no IS NULL "
    		        			     + "AND crusher_id = ? "
    		        			     + "AND crusher_code = ?";

    		        			 preparedStatement = connection.prepareStatement(sql);
    		        			 preparedStatement.setString(1, crusherId);
    		        			 preparedStatement.setString(2, crusherCode);
    		        			 int statusUpdateCount = preparedStatement.executeUpdate();

    		        			
	    	        		
	    		        	
					
					
							result = SUCCESS;
							addActionMessage(this.getText("message.success.deliveryChalanDeletedSuccessfully"));
						}
						else
						{
							result = ERROR;
							addActionError(this.getText("message.error.deliveryChalanNotDeletedPlzTryAgain"));
						}
					
					}
				}
				catch (SQLException e) {
					//e.printStackTrace();
					result = ERROR;					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					//e.printStackTrace();
					result = ERROR;					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public String getChallanNumber() {
		return challanNumber;
	}


	public void setChallanNumber(String challanNumber) {
		this.challanNumber = challanNumber;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



