package com.stonecrusher.delete;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.update.UpdateProductStockDetails;
import com.stonecrusher.utils.MaintainCloseingBalUtil;
import com.opensymphony.xwork2.ActionSupport;

public class DeleteConsumptionEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap; 
	
	private String key;
	private String fromDate;
	private String toDate;
	private String vehicleId;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	      	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
               String fullUserName = (String) this.getSessionMap().get("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	String deletedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		deletedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		deletedBy =fullUserName;
	        	}
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					String entryId = keyDetails[0];
					String vehicleId = keyDetails[1];
					String entryDate = keyDetails[2];
					
					String productId = "";
					Float productQty = 0.0F;
					String productName = "";
					String dieselCreditDebitId = "";
					String adblueCreditDebitId = "";
					
					sql = "SELECT "
							+ "consumption_product_id,"
							+ "quantity,"
							+ "diesel_credit_debit_id,"
							+ "consumption_product_name,"
							+ "adblue_credit_debit_id "
							+ "FROM "
							+ "crusher_vehicle_consumption_master "
							+ "WHERE "
							+ "vehicle_expense_entry_id = ? "
							+ "AND "
							+ "vehicle_id = ? "
							+ "AND "
							+ "consumption_date = STR_TO_DATE(?,'%d-%m-%Y') "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, vehicleId);
					preparedStatement.setString(3, entryDate);
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						productId = resultSet.getString(1);
						productQty = resultSet.getFloat(2);
						dieselCreditDebitId = resultSet.getString(3);
						productName = resultSet.getString(4);
						adblueCreditDebitId = resultSet.getString(5);
					}
					
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
					if(!productId.equals(""))
					{
						sql = "DELETE "
								+ "FROM "
								+ "crusher_vehicle_consumption_master "
								+ "WHERE "
								+ "vehicle_expense_entry_id = ? "
								+ "AND "
								+ "vehicle_id = ? "
								+ "AND "
								+ "consumption_date = STR_TO_DATE(?,'%d-%m-%Y') "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, entryId);
						preparedStatement.setString(2, vehicleId);
						preparedStatement.setString(3, entryDate);
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						
						
						int rowCount = preparedStatement.executeUpdate();
						
						if(rowCount > 0)
						{
							boolean stockPlus = UpdateProductStockDetails.addStockToCurrentStock(this.getSessionMap(), productId, productQty);
							if(stockPlus)
							{
								
								boolean isCloseingBalMaintained = false;
								
								if(productName.equals("DIESEL"))
								{
									if(resultSet != null)
									{
										try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
									}
									if(preparedStatement != null)
									{
										try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
									}
									
								sql = "SELECT "
										+ "entry_id,"
										+ "product_id,"
										+ "product_name,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "quantity,"
										+ "entry_by,"
										+ "entry_details "
										+ "FROM "
										+ "diesel_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, dieselCreditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);

								
								resultSet = preparedStatement.executeQuery();
								
								int m = 0;
								if(resultSet.next())
								{
									
									PreparedStatement  insertIntoDeletedPSMT = null;
									
									String inertDeletedSQL = "INSERT "
											+ "INTO "
											+ "diesel_credit_debit_deleted_entry_master "
											+ "("
											+ "entry_id,"
											+ "crusher_id,"
											+ "crusher_code,"
											+ "product_id,"
											+ "product_name,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "quantity,"
											+ "entry_by,"
											+ "entry_details) "
											+ "VALUES "
											+ "(?,?,?,?,?,?,?,?,?,?,?)";
									
									insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
									
									insertIntoDeletedPSMT.setString(1, dieselCreditDebitId);
									insertIntoDeletedPSMT.setString(2, crusherId);
									insertIntoDeletedPSMT.setString(3, crusherCode);
									insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
									insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
									insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
									insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
									insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
									insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
									insertIntoDeletedPSMT.setString(10, deletedBy);
									insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
									
									
									  m = insertIntoDeletedPSMT.executeUpdate();
									  
									  String paymentType = resultSet.getString(6);
									  
									  
									  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
										Date parsedDate = null;

										try {
										    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
										} catch (ParseException e) {
										    e.printStackTrace();  
										}

										if (parsedDate != null) {
										     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
										    String formattedDate = outputDateFormat.format(parsedDate); 
							
										    
									 
									    
									    
									  
									  
									  if (paymentType.equals("CREDIT")) {
									   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
									  }else {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
										  
									  }
										}
									  
									if(insertIntoDeletedPSMT != null)
									{
										insertIntoDeletedPSMT.close();
										insertIntoDeletedPSMT = null;
									}
									
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									
									
									if(m>0)
									{
										
										
									
									sql = "DELETE "
											+ "FROM "
											+ "diesel_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, dieselCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);
									
									int k = preparedStatement.executeUpdate();
									}
									
								}
								
							
								
							}
								
								
								
								if(productName.equals("ADBLUE") || productName.equals("DEF"))
								{
									if(resultSet != null)
									{
										try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
									}
									if(preparedStatement != null)
									{
										try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
									}
									
								sql = "SELECT "
										+ "entry_id,"
										+ "product_id,"
										+ "product_name,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "quantity,"
										+ "entry_by,"
										+ "entry_details "
										+ "FROM "
										+ "adblue_credit_debit_master "
										+ "WHERE "
										+ "entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, adblueCreditDebitId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);

								
								resultSet = preparedStatement.executeQuery();
								
								int m = 0;
								if(resultSet.next())
								{
									
									PreparedStatement  insertIntoDeletedPSMT = null;
									
									String inertDeletedSQL = "INSERT "
											+ "INTO "
											+ "adblue_credit_debit_deleted_entry_master "
											+ "("
											+ "entry_id,"
											+ "crusher_id,"
											+ "crusher_code,"
											+ "product_id,"
											+ "product_name,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "quantity,"
											+ "entry_by,"
											+ "entry_details) "
											+ "VALUES "
											+ "(?,?,?,?,?,?,?,?,?,?,?)";
									
									insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
									
									insertIntoDeletedPSMT.setString(1, adblueCreditDebitId);
									insertIntoDeletedPSMT.setString(2, crusherId);
									insertIntoDeletedPSMT.setString(3, crusherCode);
									insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
									insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
									insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
									insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
									insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
									insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
									insertIntoDeletedPSMT.setString(10, deletedBy);
									insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
									
									
									  m = insertIntoDeletedPSMT.executeUpdate();
									  
									  String paymentType = resultSet.getString(6);
									  
									  
									  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
										Date parsedDate = null;

										try {
										    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
										} catch (ParseException e) {
										    e.printStackTrace();  
										}

										if (parsedDate != null) {
										     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
										    String formattedDate = outputDateFormat.format(parsedDate); 
							
										    
									 
									    
									    
									  
									  
									  if (paymentType.equals("CREDIT")) {
									   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
									  }else {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
										  
									  }
										}
									  
									if(insertIntoDeletedPSMT != null)
									{
										insertIntoDeletedPSMT.close();
										insertIntoDeletedPSMT = null;
									}
									
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									
									
									if(m>0)
									{
										
										
									
									sql = "DELETE "
											+ "FROM "
											+ "adblue_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, adblueCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);
									
									int k = preparedStatement.executeUpdate();
									}
									
								}
								
							
								
							}
								
								
								connection.commit();
								
								result = SUCCESS;
								addActionMessage(this.getText("message.success.entryDeletedSuccessfully"));
							}
							else
							{
								connection.rollback();
								result = ERROR;
								addActionError(this.getText("message.error.entryNotDeletedPlzTryAgainErrorWhileStockUpdate"));
							}
						}
						else
						{
							connection.rollback();
							result = ERROR;
							addActionError(this.getText("message.error.entryNotDeletedPlzTryAgainErrorWhileDeletingEntryDetails"));
						}
					}else
					{
						connection.rollback();
						result = ERROR;
						addActionError(this.getText("message.error.entryNotDeletedPlzTryAgainErrorWhileFindingEntryDetails"));
					}
				}
				catch (SQLException e) {
					
					//e.printStackTrace();
					try {
						connection.rollback();
					} catch (SQLException e1) {}
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					e.printStackTrace();
					
					try {
						connection.rollback();
					} catch (SQLException e1) {}
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	       
	        return result;
	}
	
	
	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



