package com.stonecrusher.delete;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class DeleteBankAccEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2077541946875522965L;
	private SessionMap<String,Object> sessionMap;  
	private HttpSession session;
	private String key;
	
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String fromDate;
	private String fromTo;
	private String accountId;
	
	public String execute() {
		 
		String result = "login";
		
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){
	        	
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
	    		setCustomerSearchOption("BYNAME");
	    		setDefaultValue("BYNAME");
	    		
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
			
				
				try
				{
					java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
					
					String user = (String) session.getAttribute("userFullName");
					String userName = "";
					
					try
					{
						userName = user.split(" ")[0];
					}catch(Exception e)
					{
						userName = user;
					}
					
					
					String [] keyDetails = EncryptionDecryption.decrypt(this.getKey()).split("#") ;
					
					String entryId = keyDetails[0] ;
					String accountId = keyDetails[1];
					
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					
					
					sql = "SELECT "
							+ "entry_id,"
							+ "account_id,"
							+ "account_number,"
							+ "entry_date,"
							+ "entry_time,"
							+ "entry_type,"
							+ "amount,"
							+ "payment_type,"
							+ "entry_by,"
							+ "entry_details "
							+ "FROM "
							+ "bank_account_credit_debit_master "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "account_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
							
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, accountId);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int m = 0;
					String paymentType = null;
					String entryDate = null;
					Float amount = null;
					
					if(resultSet.next())
					{
						 paymentType = resultSet.getString(6);
						 entryDate = resultSet.getString(4);
						 amount = resultSet.getFloat(7);
						 
						PreparedStatement  insertIntoDeletedPSMT = null;
						
						String inertDeletedSQL = "INSERT "
								+ "INTO "
								+ "bank_account_credit_debit_deleted_entry_master "
								+ "("
								+ "entry_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details) "
								+ "VALUES "
								+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
						
						insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
						
						insertIntoDeletedPSMT.setString(1, entryId);
						insertIntoDeletedPSMT.setString(2, crusherId);
						insertIntoDeletedPSMT.setString(3, crusherCode);
		        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
						insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
						insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
						insertIntoDeletedPSMT.setTime(7, time);
						insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
						insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
						insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
						insertIntoDeletedPSMT.setString(11, userName);
						insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
						
						  m = insertIntoDeletedPSMT.executeUpdate();
						
						if(insertIntoDeletedPSMT != null)
						{
							insertIntoDeletedPSMT.close();
							insertIntoDeletedPSMT = null;
						}
						
					}
					
					
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
					
					if(m>0)
					{
						

					
					sql = "DELETE "
							+ "FROM "
							+ "bank_account_credit_debit_master "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "account_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, accountId);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0  )
					{
						boolean isCloseingBalMaintained = false;
					    
						SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
						Date parsedDate = null;

						try {
						    parsedDate = inputDateFormat.parse(entryDate); 
						} catch (ParseException e) {
						    e.printStackTrace();  
						}

						if (parsedDate != null) {
						     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
						    String formattedDate = outputDateFormat.format(parsedDate); 
						   
						    if (paymentType.equals("CREDIT")) {
						    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, userName, connection, this.getSessionMap());
						    } else {
						    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, userName, connection, this.getSessionMap());
						    }
						}
						
						if(isCloseingBalMaintained)
						{
							connection.commit();
							result = SUCCESS;
							addActionMessage(this.getText("message.success.bankAccountEntryDeletedSuccessfully"));
	       			}
						
						
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.bankAccountEntryNotDeletedPlzTryAgain"));
					}
					}else
					{
						result = ERROR;
						addActionError(this.getText("message.error.bankAccountEntryNotDeletedPlzTryAgain"));
					}
				}catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.entryNotDeleted"));
				} catch (IOException e) {
					result = "error";
					e.printStackTrace();
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.entryNotDeleted"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
		        
				
				
	        }
	        
	        return result;
	}
	
	

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}



	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}



	public String getCustomerSearchOption() {
		return customerSearchOption;
	}



	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}



	public String getDefaultValue() {
		return defaultValue;
	}



	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getFromTo() {
		return fromTo;
	}



	public void setFromTo(String fromTo) {
		this.fromTo = fromTo;
	}



	public String getAccountId() {
		return accountId;
	}



	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}
	
}
