package com.stonecrusher.bulksmsgateway;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.bulksmsgateway.BulkSMSGatewayMessageReplyPojo;
import com.fasterxml.jackson.databind.ObjectMapper;

public class AddBulkSMSGatewayResponseToDB {
private HttpSession session;
	
	public Map<String,String> addBulkSMSGatewayResponseToDB(String resp, String mobileNumber, String service_provider, String senderId, String message, String messageReason)
	{
		
		Map<String, String > sendResponseDetails = new HashMap<String,String>();
		this.setSession(ServletActionContext.getRequest().getSession(false)); 
		
        if(this.getSession()==null || this.getSession().getAttribute("login")==null){ 
        
        	
        }  
        else{
        	
        
       
		ObjectMapper mapper = new ObjectMapper();
	     
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet  resultSet = null;
		
		String sql = "";
		String db = (String) this.getSession().getAttribute("db");
		
	     try {
	    	 
	    	 BulkSMSGatewayMessageReplyPojo messageReplyPojo = mapper.readValue(resp,BulkSMSGatewayMessageReplyPojo.class);
	    	 
	    	 Response response = messageReplyPojo.getResponse()[0];
	    		connection = new GetDBConnection().getDBConnection(db);
				connection.setAutoCommit(false);
				
	    	 String messageBalance = messageReplyPojo.getRemainingcredits();
	    	 
	    	 sql = "UPDATE"
	    	 		+ " settings SET VALUE = ? "
	    	 				+ "WHERE name = 'messagebalance' ";
	    	
	    	 preparedStatement = connection.prepareStatement(sql);
	    	 
	    	 preparedStatement.setString(1, messageBalance);
	    	
	    	 
	    	 preparedStatement.executeUpdate();   	 
	    	
	         /*System.out.println("Balance is :"+messageReplyPojo.getBalance());
	         System.out.println("Cost is : "+messageReplyPojo.getCost());
	         System.out.println("Status : "+messageReplyPojo.getStatus());
	         System.out.println("Batch ID : "+messageReplyPojo.getBatch_id());
	         System.out.println("Sender ID : "+messageReplyPojo.getMessageObject().getSender());*/
	    	 
	    	 preparedStatement.close();
	         
	         Date messageDateTime = new Date();
	     	SimpleDateFormat messageDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
	     	
	     	//System.out.println(messageDateFormat.format(messageDateTime));
	         
	         sql = "INSERT "
	         		+ "INTO "
	         		+ "messagedetails "
	         		+ "("
	         		+ "datetime,"
	         		+ "mobilenumber,"
	         		+ "senderid,"
	         		+ "status,"
	         		+ "batchid,"
	         		+ "messagecost,"
	         		+ "content,"
	         		+ "messagetype,"
	         		+ "service_provider) "
	         		+ "values "
	         		+ "(?,?,?,?,?,?,?,?,?)";
	         
	         
	         
	         preparedStatement = connection.prepareStatement(sql);
	       
	         preparedStatement.setString(1, messageDateFormat.format(messageDateTime));
	         preparedStatement.setString(2, mobileNumber);
	         preparedStatement.setString(3, senderId);
	         preparedStatement.setString(4, messageReplyPojo.getStatus());
	         preparedStatement.setString(5, response.getUnique_id());
	         preparedStatement.setString(6, messageReplyPojo.getMsgcount());
	         preparedStatement.setString(7, message);
	         preparedStatement.setString(8, messageReason);
	         preparedStatement.setString(9, service_provider);
	         
	        int i =  preparedStatement.executeUpdate();
	         
	         if(i > 0)
	         {
	        	 connection.commit();
	        	 sendResponseDetails.put("DBADDED", "TRUE");
	        	 
	        	 if(messageReason.contains("BIILING"))
	        	 {
	        	 sendResponseDetails.put("MESSAGE", "Biiling message sent to "+mobileNumber+". "
	        			 			+ " Message Cost : "+messageReplyPojo.getMsgcount()
	        			 			+ ". Message Balance : "+messageReplyPojo.getRemainingcredits());
	        	 }else if(messageReason.contains("NEW-CUSTOMER"))
	        	 {
	        		 sendResponseDetails.put("MESSAGE", "Welcome message sent to "+mobileNumber+". "
     			 			+ " Message Cost : "+messageReplyPojo.getMsgcount()
     			 			+ ". Message Balance : "+messageReplyPojo.getRemainingcredits());
	        		 
	        	 }
	        	 else if(messageReason.contains("OUTSTANDING"))
	        	 {
	        		 sendResponseDetails.put("MESSAGE", "Outsanding message sent to "+mobileNumber+". "
     			 			+ " Message Cost : "+messageReplyPojo.getMsgcount()
     			 			+ ". Message Balance : "+messageReplyPojo.getRemainingcredits());
	        		 
	        	 }
	        	 else 
	        	 {
	        		 sendResponseDetails.put("MESSAGE", "Message sent to "+mobileNumber+". "
	     			 			+ " Message Cost : "+messageReplyPojo.getMsgcount()
	     			 			+ ". Message Balance : "+messageReplyPojo.getRemainingcredits());
	        		 
	        	 }
	         }

	     }catch(SQLException sqe)
	     {
	    	 sendResponseDetails.put("DBADDED", "FALSE");
	    	 sendResponseDetails.put("MESSAGE",sqe.getMessage());
	     }
	     catch (IOException e) {
	        
	    	 sendResponseDetails.put("DBADDED", "FALSE");
	    	 sendResponseDetails.put("MESSAGE",e.getMessage());
	     }finally {
	    	 if(resultSet !=null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();
					 connection = null;
					}catch (SQLException e) {}
				}
				
			}
		
        }
		return sendResponseDetails;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}
	

}
