package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.LaborInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class SearchLaborInfo extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6280306575341472031L;
	private String key;
	private String searchOption;
	
	private HttpSession session;	
	
	private List<LaborInfoDAO> laborInfoList = new ArrayList<LaborInfoDAO>();
	
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
            result = "login";  
        }  
        else
        {
        	
        	String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
        //	System.out.println("hello");
        	
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       	
       		String actualKey = this.getKey().trim();
       		
       		String sql = "";
       		
       		
       		
       		if(this.getSearchOption().equals("BYNAME"))
       		{	
       			 sql = "SELECT "
       				+ "employee_id,"
       				+ "employee_name,"
       				+ "employee_mobile_number "       			
       				+ "FROM "
       				+ "crusher_employee_master "
       				+ "WHERE "
       				+ "employee_name LIKE '%"+actualKey+"%' "
       				+ "AND "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
       			
       		}
       		else if(this.getSearchOption().equals("BYMOBILE"))
       		{
       			 sql = "SELECT "
        				+ "employee_id,"
        				+ "employee_name,"
        				+ "employee_mobile_number "       			
        				+ "FROM "
        				+ "crusher_employee_master "
        				+ "WHERE "
        				+ "employee_mobile_number LIKE '%"+actualKey+"%' "
        				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
           				
       		}
       		else if(this.getSearchOption().equals("BYADDRESS"))
       		{
       			sql = "SELECT "
        				+ "employee_id,"
        				+ "employee_name,"
        				+ "employee_mobile_number "       			
        				+ "FROM "
        				+ "crusher_employee_master "
        				+ "WHERE "
        				+ "employee_address LIKE '%"+actualKey+"%' "
        				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
       		}
       		else
       		{
       			sql = "SELECT "
        				+ "employee_id,"
        				+ "employee_name,"
        				+ "employee_mobile_number "       			
        				+ "FROM "
        				+ "crusher_employee_master "
        				+ "WHERE "
           				+ "employee_name LIKE '%"+actualKey+"%' "
           				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
       				
       			
       		}
       		
       		
       		String db = (String) session.getAttribute("db");
       		try {
       			
       			
				connection = GetDBConnection.getDBConnection(db);
       			
       			preparedStatement = connection.prepareStatement(sql);
       			preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();      			
       			resultSet.last();
				int rowCount = resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rowCount>0)
				{
       			 	
	       			while(resultSet.next())
	       			{
	       				LaborInfoDAO laborInfoDAO = new LaborInfoDAO();
	       				
	       				laborInfoDAO.setLaborId(resultSet.getString(1));
	       				laborInfoDAO.setLaborName(resultSet.getString(2));
	       				laborInfoDAO.setLaborMobile(resultSet.getString(3));
	       				
	       				laborInfoDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
	       				
	       				
	       				PreparedStatement preparedStmt= null;
						ResultSet  rs = null;
						
						
						sql = "SELECT "
		       					+ "employee_id "
		       					+ "FROM "
								+ "crusher_employee_salary_details "
								+ "WHERE "
								+ "employee_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
						        + "ORDER BY employee_id";
						
						preparedStmt = connection.prepareStatement(sql);
						preparedStmt.setString(1, resultSet.getString(1));
						preparedStmt.setString(2, crusherId);
						preparedStmt.setString(3, crusherCode);
	    				
						
						rs = preparedStmt.executeQuery();
						
						
						while(rs.next())
						{
							laborInfoDAO.setSalaryAdded(true);
							
						}
	       				
	       				
	       				this.getLaborInfoList().add(laborInfoDAO);
	       				
	       				
	       				
	       				
	       			}
				}
	       				
				
   				
       		}	 catch (SQLException e) {
   				//e.printStackTrace();
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
			} catch (IOException e) {
				//e.printStackTrace();
				addActionMessage(e.getMessage()+"|| SOME ERROR");
			}	
   			finally
   			{
   				if(resultSet != null)
   				{
   					try{resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		}
    	
		result = "success";
    	return result;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public List<LaborInfoDAO> getLaborInfoList() {
		return laborInfoList;
	}

	public void setLaborInfoList(List<LaborInfoDAO> laborInfoList) {
		this.laborInfoList = laborInfoList;
	}

	public String getSearchOption() {
		return searchOption;
	}

	public void setSearchOption(String searchOption) {
		this.searchOption = searchOption;
	}

		

	
	
}
