package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class SearchCustomerInfo extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3828289564696834998L;
	
	private String key;
	private String searchOption;
	
	private HttpSession session;	
	
	private List<CustomerInfoDAO> custInfoList = new ArrayList<CustomerInfoDAO>();
	
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
            result = "login";  
        }  
        else
        {
        	String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
        	
        //	System.out.println("hello");
        	
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       	
       		String actualKey = this.getKey().trim();
       		
       		String sql = "";
       		if(this.getSearchOption().equals("BYNAME"))
       		{	
       			
       			
       		 sql = "SELECT  "
       				+ "customer_id,"
       				+ "add_date,"
       				+ "customer_name,"
       				+ "mobile_number,"
       				+ "gst_number,"
       				+ "pan_number,"
       				+ "tin_number,"
       				+ "billing_address,"
       				+ "birth_date,"
       				+ "is_mobile_verified,"
       				+ "credit_limit "
       				+ "FROM "
       				+ "crusher_customer_master "
       				+ "WHERE "
       				+ "customer_name LIKE '%"+actualKey+"%' "
       				+ "AND "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
       			
       		}
       		else if(this.getSearchOption().equals("BYMOBILE"))
       		{
       			sql = "SELECT  "
           				+ "customer_id,"
           				+ "add_date,"
           				+ "customer_name,"
           				+ "mobile_number,"
           				+ "gst_number,"
           				+ "pan_number,"
           				+ "tin_number,"
           				+ "billing_address,"
           				+ "birth_date,"
           				+ "is_mobile_verified,"
           				+ "credit_limit "
           				+ "FROM "
           				+ "crusher_customer_master "
           				+ "WHERE "
           				+ "mobile_number LIKE '%"+actualKey+"%' "
           				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
           				
       		}
       		else if(this.getSearchOption().equals("BYADDRESS"))
       		{
       			sql = "SELECT  "
           				+ "customer_id,"
           				+ "add_date,"
           				+ "customer_name,"
           				+ "mobile_number,"
           				+ "gst_number,"
           				+ "pan_number,"
           				+ "tin_number,"
           				+ "billing_address,"
           				+ "birth_date,"
           				+ "is_mobile_verified,"
           				+ "credit_limit "
           				+ "FROM "
           				+ "crusher_customer_master "
           				+ "WHERE "
           				+ "billing_address LIKE '%"+actualKey+"%' "
           				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
       		}
       		else
       		{
       		 sql = "SELECT  "
        				+ "customer_id,"
        				+ "add_date,"
        				+ "customer_name,"
        				+ "mobile_number,"
        				+ "gst_number,"
        				+ "pan_number,"
        				+ "tin_number,"
        				+ "billing_address,"
        				+ "birth_date,"
        				+ "is_mobile_verified,"
        				+ "credit_limit "
        				+ "FROM "
        				+ "crusher_customer_master "
        				+ "WHERE "
        				+ "customer_name LIKE '%"+actualKey+"%' "
        				+ "AND "
    					+ "crusher_id = ? "
    					+ "AND "
    					+ "crusher_code = ?";
       				
       			
       		}
       	//	System.out.println(sql);
       		
       		String db = (String) session.getAttribute("db");
       		try {
       			
       			
				connection = GetDBConnection.getDBConnection(db);
       			
       			preparedStatement = connection.prepareStatement(sql);
       			preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
       			resultSet = preparedStatement.executeQuery();      			
       			resultSet.last();
				int rowCount = resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rowCount>0)
				{
       			 	
	       			while(resultSet.next())
	       			{
	       				CustomerInfoDAO customerInfoDAO = new CustomerInfoDAO();
	       				
	       			//	System.out.println("Name:"+resultSet.getString(3)+",ID:"+resultSet.getString(1));
	       				customerInfoDAO.setCustomerId(resultSet.getString(1));
	       				customerInfoDAO.setCustName(resultSet.getString(3));
	       				customerInfoDAO.setMobileNumber(resultSet.getString(4));
	       				customerInfoDAO.setBillingaddress(resultSet.getString(8));
	       				customerInfoDAO.setCreditlimit(resultSet.getString(11));
	       				customerInfoDAO.setMobileVerified(resultSet.getString(10));       				
	       				
	       				customerInfoDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
	       				
	       				 
	       				
	       				PreparedStatement getOpeningBalPSMT = null;
	       				ResultSet getOpeningBalRs = null;
	       				String getOpeningBalSQL = "SELECT "
	       						+ "opening_balance "
	       						+ "FROM "
	       						+ "crusher_cust_close_open_bal_master "
	       						+ "WHERE "
	       						+ "customer_id = ?"
	       						+ "AND "
	        					+ "crusher_id = ? "
	        					+ "AND "
	        					+ "crusher_code = ?";
	       				
	       				
	       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
	       				
	       				getOpeningBalPSMT.setString(1, resultSet.getString(1));
	       				getOpeningBalPSMT.setString(2, crusherId);
	       				getOpeningBalPSMT.setString(3, crusherCode);
	    				
	       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
	       				
	       				if(getOpeningBalRs.next())
	       				{
	       					customerInfoDAO.setCustomerOpeningBalance(getOpeningBalRs.getFloat(1));
	       				}
	       				else
	       				{
	       					customerInfoDAO.setCustomerOpeningBalance(0.0F);
	       				}
	       				
	       				if(getOpeningBalRs != null)
	       				{
	       					getOpeningBalRs.close();
	       					getOpeningBalRs = null;
	       				}
	       				if(getOpeningBalPSMT != null)
	       				{
	       					getOpeningBalPSMT.close();
	       					getOpeningBalPSMT = null;
	       				}

	       				float floatTotalAmt = 0.0F;
	       				float floatAmtReceived = 0.0F;
	       				float floatBalanceAmt = 0.0F;
	       				float totalBalanceAmt = 0.0F;
	       				float totalPaymentDone = 0.0F;
	       				
	       				sql = "SELECT "	           					
	           					+ "bill_total_amount,"
	           					+ "bill_amount_received,"
	           					+ "bill_amount_return "
	           					+ "FROM "
	           					+ "crusher_bill_info_master "
	           					+ "WHERE "		           					
	           					+ "customer_id = '"+resultSet.getString(1)+"' "
	           					+ "AND "
	           	    			+ "crusher_id = ? "
	           	    			+ "AND "
	           	    			+ "crusher_code = ?";
	           	       				
	           				
	       				
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				preparedStatement.setString(1, crusherId);
	    				preparedStatement.setString(2, crusherCode);
	    				
	    				
	       				ResultSet resultSetBillInfo = preparedStatement.executeQuery();
	       				
	       				while(resultSetBillInfo.next())
	       				{
	       					try
	       					{
		       					floatTotalAmt = Float.parseFloat(resultSetBillInfo.getString(1));
		           				floatAmtReceived = Float.parseFloat(resultSetBillInfo.getString(2));
		           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
		           				
		           				if(floatBalanceAmt > 0)
		           				{
		           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 	           					
		           				}
		           				
	       					}catch(NumberFormatException nfe)
	       					{
	       						result = "error";
	       						addActionError("Error While Formatting while calculating balance amount!"+nfe.getMessage());
	       					}
	       				}
	       				
	       				if(resultSetBillInfo != null)
	       				{
	       					resultSetBillInfo.close();
	       					resultSetBillInfo = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       			

	       				sql = "SELECT "	           					
	           					+ "bill_total_amount,"
	           					+ "bill_amount_received,"
	           					+ "amount_return "
	           					+ "FROM "
	           					+ "crusher_rmc_billinfo "
	           					+ "WHERE "		           					
	           					+ "customer_id = '"+resultSet.getString(1)+"' "
	           					+ "AND "
	           	    			+ "crusher_id = ? "
	           	    			+ "AND "
	           	    			+ "crusher_code = ?";
	           				
	       				
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				preparedStatement.setString(1, crusherId);
	    				preparedStatement.setString(2, crusherCode);
	    				
	    				
	       				ResultSet resultSetRMCBillInfo = preparedStatement.executeQuery();
	       				while(resultSetRMCBillInfo.next())
	       				{
	       					
	       					try
	       					{
		       					floatTotalAmt = Float.parseFloat(resultSetRMCBillInfo.getString(1));
		           				floatAmtReceived = Float.parseFloat(resultSetRMCBillInfo.getString(2));
		           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
		           				
		           				if(floatBalanceAmt > 0)
		           				{
		           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 
		           					
		           				}
		           				
	       					}catch(NumberFormatException nfe)
	       					{
	       						result = "error";
	       						addActionError("Error While Formatting while calculating balance amount!"+nfe.getMessage());
	       					}
	       				}
	       				
	       			
	       				
	       				
	       				
	       				sql = "SELECT "
	       						+ "sum(amount) "
	       						+ "FROM "
	       						+ "crusher_customer_payment_details_master "
	       						+ "WHERE "
	       						+ "customer_id = '"+resultSet.getString(1)+"'"
	       						+ "AND "
	    	           	    	+ "crusher_id = ? "
	    	           	    	+ "AND "
	    	           	    	+ "crusher_code = ?";
	       			
	       				preparedStatement = connection.prepareStatement(sql);
	       				preparedStatement.setString(1, crusherId);
	    				preparedStatement.setString(2, crusherCode);
	    				
	       				ResultSet resultSetTotalPayment = preparedStatement.executeQuery();
	       				
	       				resultSetTotalPayment.last();
	       				int rowCount2 = resultSetTotalPayment.getRow();
	       				resultSetTotalPayment.beforeFirst();
	       				
	       				if(rowCount2>0)
	       				{
	       				
		       				while(resultSetTotalPayment.next())
		       				{
		       					try
		       					{
		       						if(resultSetTotalPayment.getString(1) != null)
		       						{		       						
		       							totalPaymentDone = Float.parseFloat(resultSetTotalPayment.getString(1));
		       						}
		       					}
		       					catch(NumberFormatException nfe)
		       					{
		       						result = "error";
		       						addActionError("Error While Formatting while calculating total payment amount!"+nfe.getMessage());
		       					}
		       				}
		       						
		       				
		       				totalBalanceAmt = (customerInfoDAO.getCustomerOpeningBalance() + totalBalanceAmt) - totalPaymentDone;
	       				}
	       				
	       				if(resultSetTotalPayment != null)
	       				{
	       					resultSetTotalPayment.close();
	       				}
	       				customerInfoDAO.setTotalOutStandingAmount(""+totalBalanceAmt);
	       				
	       				custInfoList.add(customerInfoDAO);
	       				
	       			}
	       			
	       			Collections.sort(custInfoList, new Comparator<CustomerInfoDAO>() {
				        @Override
				        public int compare(CustomerInfoDAO c1, CustomerInfoDAO c2) {
				            return c1.getCustomerId().compareTo(c2.getCustomerId());
				        }
				    });
	       			
				}
				
				
				
			
       		
       		
   				
       		}	 catch (SQLException e) {
   				//e.printStackTrace();
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
			} catch (IOException e) {
				//e.printStackTrace();
				addActionMessage(e.getMessage()+"|| SOME ERROR");
			}	
   			finally
   			{
   				if(resultSet != null)
   				{
   					try{resultSet.close();resultSet = null;}catch(SQLException sqe){}   					
   				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		}
    	
		result = "success";
    	return result;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public List<CustomerInfoDAO> getCustInfoList() {
		return custInfoList;
	}

	public void setCustInfoList(List<CustomerInfoDAO> custInfoList) {
		this.custInfoList = custInfoList;
	}

	public String getSearchOption() {
		return searchOption;
	}

	public void setSearchOption(String searchOption) {
		this.searchOption = searchOption;
	}

		

	
	
}
