package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.catalina.Session;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BoulderSupplierInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class SearchBoulderSupplierInfoJSON extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6756358979030980171L;
	private String key;
	private String searchOption;
	
	private HttpSession session;	
	private SessionMap<String,Object> sessionMap;
	
	private List<BoulderSupplierInfoDAO> boulderSupplierInfoList = new ArrayList<BoulderSupplierInfoDAO>();
	
	
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
           result =  "login";  
        }  
        else
        {
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       	
       		String actualKey = this.getKey().trim();
       		
       		String sql = "";
	       		if(this.getSearchOption().equals("BYNAME"))
	       		{	
	       			sql = "SELECT "
	       					+ "boulder_supplier_id,"
	       					+ "boulder_supplier_name,"
	       					+ "boulder_supplier_mobile_number,"
	       					+ "boulder_supplier_address "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_master "
	       					+ "WHERE "
	       					+ "(boulder_supplier_name LIKE '%"+actualKey+"%' OR boulder_supplier_name LIKE '%"+actualKey+"%') "
	       					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? ";
	       		}
	       		else if(this.getSearchOption().equals("BYMOBILE"))
	       		{
	       			sql = "SELECT "
	       					+ "boulder_supplier_id,"
	       					+ "boulder_supplier_name,"
	       					+ "boulder_supplier_mobile_number,"
	       					+ "boulder_supplier_address "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_master "
	       					+ "WHERE "
	       					+ "boulder_supplier_mobile_number LIKE '%"+actualKey+"%'"
	       					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ?";
	       		}
	       		else if(this.getSearchOption().equals("BYADDRESS"))
	       		{
	       			sql = "SELECT "
	       					+ "boulder_supplier_id,"
	       					+ "boulder_supplier_name,"
	       					+ "boulder_supplier_mobile_number,"
	       					+ "boulder_supplier_address "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_master "
	       					+ "WHERE "
	       					+ "boulder_supplier_address LIKE '%"+actualKey+"%'"
	       					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ?";
	       		}
	       		
	       		
	       		
	       		String db = (String) session.getAttribute("db");
			       	try{
			       			
			       		
							connection = GetDBConnection.getDBConnection(db);
			       			
			       			preparedStatement = connection.prepareStatement(sql);
			       			preparedStatement.setString(1, crusherId);
							preparedStatement.setString(2, crusherCode);
							
			       			resultSet = preparedStatement.executeQuery();      			
			       			resultSet.last();
							int rowCount = resultSet.getRow();
							resultSet.beforeFirst();
							
							if(rowCount>0)
							{
								while(resultSet.next())
								{
									
									BoulderSupplierInfoDAO infoDAO = new BoulderSupplierInfoDAO();
									
									PreparedStatement getOpeningBalPSMT = null;
				       				ResultSet getOpeningBalRs = null;
				       				String getOpeningBalSQL = "SELECT "
				       						+ "opening_balance "
				       						+ "FROM "
				       						+ "crusher_boulder_supplier_close_open_bal_master "
				       						+ "WHERE "
				       						+ "boulder_supplier_id = ? "
				       						+ "AND "
					    					+ "crusher_id = ? "
					    					+ "AND "
					    					+ "crusher_code = ?";
				       				
				       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
				       				
				       				getOpeningBalPSMT.setString(1, resultSet.getString(1));
				       				getOpeningBalPSMT.setString(2, crusherId);
				       				getOpeningBalPSMT.setString(3, crusherCode);
									
				       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
				       				
				       				if(getOpeningBalRs.next())
				       				{
				       					infoDAO.setSupplierOpeningBal(getOpeningBalRs.getFloat(1));
				       				}
				       				else
				       				{
				       					infoDAO.setSupplierOpeningBal(0.0F);
				       				}
				       				
				       				
				       				if(getOpeningBalRs != null)
				       				{
				       					getOpeningBalRs.close();
				       					getOpeningBalRs = null;
				       				}
				       				if(getOpeningBalPSMT != null)
				       				{
				       					getOpeningBalPSMT.close();
				       					getOpeningBalPSMT = null;
				       				}

									
									infoDAO.setSupplierId(resultSet.getString(1));
									infoDAO.setSupplierName(resultSet.getString(2));
									infoDAO.setSupplierMobile(resultSet.getString(3));
									infoDAO.setSupplierAddress(resultSet.getString(4));
									infoDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
									
									float floatTotalBillAmt = 0.0F;
				       				float floatTotalAmountPaid = 0.0f;
				       				float floatTotalBalanceAmt = 0.0f;
				       				
				       				PreparedStatement getTotalBillPSMT = null;
				       				ResultSet getTotalBillRS = null;
				       				
				       				String getTotalPurchaseSQL = "SELECT "
				       						+ "SUM(total_bill_amount) "
				       						+ "FROM "
				       						+ "boulder_inward_bill_info "
				       						+ "WHERE "
				       						+ "boulder_supp_id = ? "
				       						+ "AND "
					    					+ "crusher_id = ? "
					    					+ "AND "
					    					+ "crusher_code = ? ";
				       				
				       				getTotalBillPSMT = connection.prepareStatement(getTotalPurchaseSQL);
				       				
				       				getTotalBillPSMT.setString(1, resultSet.getString(1));
				       				getTotalBillPSMT.setString(2, crusherId);
				       				getTotalBillPSMT.setString(3, crusherCode);
									
				       				getTotalBillRS = getTotalBillPSMT.executeQuery();
				       				
				       				if(getTotalBillRS.next())
				       				{
				       					floatTotalBillAmt = getTotalBillRS.getFloat(1);
				       					
				       					
				       				}
				       				
				       				
				       				PreparedStatement getSuppAmtPaidPSMT = null;
				       				ResultSet getSuppAmtPaidRS = null;
				       				String getSuppAmtPaidSQL = "SELECT "
				       						+ "SUM(amount) "
				       						+ "FROM "
				       						+ "crusher_boulder_supplier_payment_master "
				       						+ "WHERE "
				       						+ "boulder_supplier_id = ? "
				       						+ "AND "
					    					+ "crusher_id = ? "
					    					+ "AND "
					    					+ "crusher_code = ? ";
				       				
				       				getSuppAmtPaidPSMT = connection.prepareStatement(getSuppAmtPaidSQL);
				       				
				       				
				       				
				       				getSuppAmtPaidPSMT.setString(1, resultSet.getString(1));
				       				getSuppAmtPaidPSMT.setString(2, crusherId);
				       				getSuppAmtPaidPSMT.setString(3, crusherCode);
									
				       				getSuppAmtPaidRS = getSuppAmtPaidPSMT.executeQuery();
				       				
				       				
				       				
				       				if(getSuppAmtPaidRS.next())
				       				{
				       					floatTotalAmountPaid = floatTotalAmountPaid + getSuppAmtPaidRS.getFloat(1);
				       				}
				       				
				       				floatTotalBalanceAmt = floatTotalBillAmt - floatTotalAmountPaid;
				       				
				       				infoDAO.setTotalBillAmount(floatTotalBillAmt);
				       				infoDAO.setDebtAmount(floatTotalBalanceAmt+infoDAO.getSupplierOpeningBal());
				       				
				       	
				       				if(getSuppAmtPaidRS != null)
				       				{
				       					getSuppAmtPaidRS.close();
				       					getSuppAmtPaidRS = null;
				       				}
				       				
				       				if(getSuppAmtPaidPSMT != null)
				       				{
				       					getSuppAmtPaidPSMT.close();
				       					getSuppAmtPaidPSMT = null;
				       				}
				       				
				       				
				       				
				       				if(getTotalBillRS != null)
				       				{
				       					getTotalBillRS.close();
				       					getTotalBillRS = null;
				       				}
				       				
				       				if(getTotalBillPSMT != null)
				       				{
				       					getTotalBillPSMT.close();
				       					getTotalBillPSMT = null;
				       				}
				       				
									
									this.getBoulderSupplierInfoList().add(infoDAO);
								}
								
							}
							
							Collections.sort(getBoulderSupplierInfoList(), new Comparator<BoulderSupplierInfoDAO>() {
						        @Override
						        public int compare(BoulderSupplierInfoDAO c1, BoulderSupplierInfoDAO c2) {
						            return c1.getSupplierId().compareTo(c2.getSupplierId());
						        }
						    });
							
			       		}
	       				catch (SQLException e) {
	       					e.printStackTrace();
	       				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
						} catch (Exception e) {
							e.printStackTrace();
							addActionMessage(e.getMessage()+"|| SOME ERROR");
						}	
						finally
						{
							if(resultSet != null)
							{
								try{resultSet.close();resultSet=null;}catch(SQLException sqe){}   					
							}
							if(preparedStatement != null)
							{
								try {preparedStatement.close();preparedStatement=null;} catch (SQLException e) {}
							}
							if(connection != null)
							{
								try {connection.close();connection=null;} catch (SQLException e) {}
							}
							
						}
        	}
			
       result = "success";
		
		return result;
	}
		
		



	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getSearchOption() {
		return searchOption;
	}


	public void setSearchOption(String searchOption) {
		this.searchOption = searchOption;
	}


	


	public HttpSession getSession() {
		return session;
	}





	public void setSession(HttpSession session) {
		this.session = session;
	}






	public List<BoulderSupplierInfoDAO> getBoulderSupplierInfoList() {
		return boulderSupplierInfoList;
	}





	public void setBoulderSupplierInfoList(List<BoulderSupplierInfoDAO> boulderSupplierInfoList) {
		this.boulderSupplierInfoList = boulderSupplierInfoList;
	}





	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}
}
