package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInfoForSearchDAO;
import com.stonecrusher.db.GetDBConnection;


public class SearchBillInfo extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 992825583872321632L;
	private String key;	
	private String billDate;
	private  HttpSession session;
	private String billAll;
	
	private ArrayList<BillInfoForSearchDAO> billInfoForSearchList = new ArrayList<BillInfoForSearchDAO>();
	
	
	@Override
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
            return "login";  
        }  
        else
        {
        	
        	
        	//System.out.println("hello");
        	
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       		
       		String sql = "";
       		String db = (String) session.getAttribute("db");
       		String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
       		try {
       			
				connection = GetDBConnection.getDBConnection(db);
       			String keyWithOutSpace = getKey().trim();
       			if(billAll.equals("true") & !(getKey().toUpperCase().contains("CASH") 
       					|| getKey().toUpperCase().contains("CAS")))
       			
       			{
       				sql = "select "
           					+ "bill_number,"
           					+ "DATE_FORMAT(bill_date, '%d-%M-%Y'),"
           					+ "payment_type,"
           					+ "bill_type,"
           					+ "customer_name,"       					
           					+ "comments,"
           					+ "bill_total_amount,"
           					+ "bill_amount_received,"
           					+ "bill_amount_return,"
           					+ "bill_type "
           					+ "FROM "
           					+ "crusher_bill_info_master "
           					+ "WHERE "
           					+ "bill_time <> 'NULL' "
           					+ "AND "              					
           					+ "(customer_name like '%"+keyWithOutSpace.toUpperCase()+"%' or bill_number like '%"+keyWithOutSpace+"%') "
           					+ "AND crusher_id = ? "
           			        + "AND crusher_code = ?";
           			
       			
       			}
       			else if(getKey().trim().toUpperCase().contains("ALL"))
       			{
       				sql = "select "
           					+ "bill_number,"
           					+ "DATE_FORMAT(bill_date, '%d-%M-%Y'),"
           					+ "payment_type,"
           					+ "bill_type,"
           					+ "customer_name,"       					
           					+ "comments,"
           					+ "bill_total_amount,"
           					+ "bill_amount_received,"
           					+ "bill_amount_return,"
           					+ "bill_type "
           					+ "FROM "
           					+ "crusher_bill_info_master "
           					+ "WHERE "
           					+ "billbill_datedate = STR_TO_DATE('"+getBillDate()+"', '%d-%m-%Y') "
           					+ "and "
           					+ "bill_time <> 'NULL' "
           					+ "AND crusher_id = ? "
           			        + "AND crusher_code = ?";
       				
           					
       			}
       			else if(getKey().trim().toUpperCase().contains("-"))
       			{
       				sql = "select "
           					+ "bill_number,"
           					+ "DATE_FORMAT(bill_date, '%d-%M-%Y'),"
           					+ "payment_type,"
           					+ "bill_type,"
           					+ "customer_name,"       					
           					+ "comments,"
           					+ "bill_total_amount,"
           					+ "bill_amount_received,"
           					+ "bill_amount_return,"
           					+ "bill_type "
           					+ "FROM "
           					+ "crusher_bill_info_master "
           					+ "WHERE "
           					+ "bill_date = STR_TO_DATE('"+getBillDate()+"', '%d-%m-%Y') "
           					+ "AND "
           					+ "bill_time <> 'NULL' "
           					+ "AND "
           					+ "customer_name NOT LIKE '%CASH%'"
           					+ "AND crusher_id = ? "
           			        + "AND crusher_code = ?";
       				
           					
       			}
       			else
       			{

       				sql = "select "
           					+ "bill_number,"
           					+ "DATE_FORMAT(bill_date, '%d-%M-%Y'),"
           					+ "payment_type,"
           					+ "bill_type,"
           					+ "customer_name,"       					
           					+ "comments,"
           					+ "bill_total_amount,"
           					+ "bill_amount_received,"
           					+ "bill_amount_return,"
           					+ "bill_type "
           					+ "FROM "
           					+ "crusher_bill_info_master "
           					+ "WHERE "
           					+ "bill_date = STR_TO_DATE('"+getBillDate()+"', '%d-%m-%Y') "
           					+ "AND "
           					+ "bill_time <> 'NULL' "
           					+ "AND "
           					+ "(customer_name like '%"+keyWithOutSpace.toUpperCase()+"%' OR bill_number like '%"+keyWithOutSpace+"%') "
           					+ "AND crusher_id = ? "
           			        + "AND crusher_code = ?";
           			
       			}
      
       			preparedStatement = connection.prepareStatement(sql);
       			preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
       			resultSet = preparedStatement.executeQuery();
       			
       			while(resultSet.next())
       			{
       				int totalItemCount = 0;
       			String billNumber = resultSet.getString(1);
       				BillInfoForSearchDAO dao = new BillInfoForSearchDAO();
       				dao.setBillNumber(resultSet.getString(1));
       				dao.setBillDate(resultSet.getString(2));
       				dao.setPaymentType(resultSet.getString(3));
       				dao.setBillType(resultSet.getString(4));
       				dao.setCustomerName(resultSet.getString(5));
       				dao.setComments(resultSet.getString(6));
       				dao.setTotalAmount(resultSet.getString(7));
       				dao.setBillType(resultSet.getString(10));
       				
       				float floatTotalAmt = 0.0F;
       				float floatAmtReceived = 0.0F;
       				float floatBalanceAmt = 0.0F;
       				
       				try
       				{
	       				if(resultSet.getString(8) == null)
	       				{
	       				 dao.setAmountReceived("0.0");
	       				}
	       				else
	       				{
	       				 dao.setAmountReceived(resultSet.getString(8));
	       				}
	       				if(resultSet.getString(9) == null || resultSet.getString(9).equals(""))
	       				{
	       				 dao.setAmtReturn("0.0");
	       				}
	       				else
	       				{
	       				 dao.setAmtReturn(resultSet.getString(9));
	       				}
	       				
	       				
	       				if(resultSet != null)
	       				{
	       					try {resultSet.close();}catch(SQLException sqe){}   					
	       				}
	       				
	       				
	       				
	       				String s = "SELECT COUNT(*) FROM crusher_bill_product_info WHERE bill_number = ? "
	       			         + "AND crusher_id = ? "
	       			         + "AND crusher_code = ?";

	       			preparedStatement = connection.prepareStatement(s);
	       			preparedStatement.setString(1, billNumber);
	       			preparedStatement.setString(2, crusherId);
	       			preparedStatement.setString(3, crusherCode);
       			
       			resultSet = preparedStatement.executeQuery();
       			if (resultSet.next()) {
       			    totalItemCount = resultSet.getInt(1); 
       			}
    				
       				
       				
       				
       				
       				floatTotalAmt = Float.parseFloat(dao.getTotalAmount());
       				floatAmtReceived = Float.parseFloat(dao.getAmountReceived());
       				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
       				}catch(NumberFormatException nfe)
       				{
       					nfe.printStackTrace();
       				}
       				
       				if(floatBalanceAmt > 0)
       				{
       					
       				}
       				else
       				{
       					floatBalanceAmt = 0.0F;
       				}
       				
       				dao.setItemsCount(""+totalItemCount);
       				dao.setBalanceAmount(""+floatBalanceAmt);
       				billInfoForSearchList.add(dao);
       				
       				
       			}
       			
       			result = "success";
       					
       		} catch (SQLException e) {
   			e.printStackTrace();
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
			} catch (Exception e) {
				e.printStackTrace();
				addActionMessage(e.getMessage()+"|| SOME ERROR");
			}	
   			finally
   			{
   				if(resultSet != null)
   				{
   					try {resultSet.close();}catch(SQLException sqe){}   					
   				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close();} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close();} catch (SQLException e) {}
   				}
   				
   			}
   		}
    	
    	
    	return result;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}



	public ArrayList<BillInfoForSearchDAO> getBillInfoForSearchList() {
		return billInfoForSearchList;
	}

	public void setBillInfoForSearchList(ArrayList<BillInfoForSearchDAO> billInfoForSearchList) {
		this.billInfoForSearchList = billInfoForSearchList;
	}

	public String getBillDate() {
		return billDate;
	}

	public void setBillDate(String billDate) {
		this.billDate = billDate;
	}

	public String getBillAll() {
		return billAll;
	}

	public void setBillAll(String billAll) {
		this.billAll = billAll;
	}


	
	
	
	
	

}
