package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class GetVehicleBrassCapacity extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4829113075212226580L;

	private HttpSession session;
	private String vehicleId;
	private String quantity;
	private SessionMap<String,Object> sessionMap;  
	
	public String execute(){
		
		
		 
		String result = "login";;
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
			
					try
					{
						String [] vehicleData = this.getVehicleId().split("-");
						
						String vId = vehicleData[0];
						String vNum = vehicleData[2];
						
						
						connection = GetDBConnection.getDBConnection(db);
						
						sql = "SELECT "
								+ "brass_quantity "
								+ "FROM "
								+ "crusher_vehicle_details_master "
								+ "WHERE "
								+ "vehicle_id = ? "
								+ "AND "
								+ "vehicle_registration_number = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, vId);
						preparedStatement.setString(2, vNum);
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						
						if(resultSet.next()){
							this.setQuantity(resultSet.getString(1));
						}
						else
						{
							this.setQuantity("0.0");
						}
					}catch (SQLException e) {
						
					//e.printStackTrace();
					} catch (Exception e) {
						
					//e.printStackTrace();
					}finally {
						if(resultSet != null)
		   				{
		   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
		   				}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        }
	
	return SUCCESS;
}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	public String getQuantity() {
		return quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	
}
