package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class GetTotalCalculetdSalaryOfLabor extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8851188258173210694L;
	
	private String LaborIdName;
	private SessionMap<String,Object> sessionMap;
	private Integer noOfDaysAbsentDays;
	private Integer noOfOverTime;
	private Integer noOfHalfDays;
	private Integer noOfDaysInMonth;
	private Integer noOfFullDays;
	private Float additionalDeduction;
	private Float additionalPayment;
	private String totalSalary;
	public String execute() {
		 
		String result = "login";
	      if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "error";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet  resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				try
				{
					DecimalFormat df = new DecimalFormat("##");
					String typeOfSalary = "";
					float salaryAmount = 0.0f;
					
					connection = GetDBConnection.getDBConnection(db);
					String [] laborDetails = this.getLaborIdName().split("-");
					
					String laborId = laborDetails[0];
					
				
					sql = "SELECT "
							+ "employee_salary_type,"
							+ "employee_salary_amount "
							+ "FROM "
							+ "crusher_employee_salary_details "
							+ "WHERE "
							+ "employee_id = ?"
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, laborId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						typeOfSalary = resultSet.getString(1);
						salaryAmount = resultSet.getFloat(2);
					}
					
					float salaryPerDay = 0;
					
					if ("MONTHLY".equalsIgnoreCase(typeOfSalary)) {
					  salaryPerDay = salaryAmount / this.getNoOfDaysInMonth();
					} else if ("DAILY".equalsIgnoreCase(typeOfSalary)) {
					  salaryPerDay = salaryAmount; 
					}else if ("WEEKLY".equalsIgnoreCase(typeOfSalary)) {
					    salaryPerDay = salaryAmount / 6; 
					}
					
					
						float salaryForPresentDays = salaryPerDay * this.getNoOfFullDays();
						float salaryForHalfDay = ( salaryPerDay / 2 ) * this.getNoOfHalfDays();
						float salaryForOverTime = salaryPerDay * this.getNoOfOverTime();
						
						this.setTotalSalary(df.format((salaryForPresentDays+salaryForHalfDay+salaryForOverTime+this.getAdditionalPayment())-this.getAdditionalDeduction()));
						
					
					result = SUCCESS;
					
				}catch (SQLException e) {
					//e.printStackTrace();
				} catch (IOException e) {
					//e.printStackTrace();
				}finally {
					if(resultSet !=null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();
						 connection = null;
						}catch (SQLException e) {}
					}
				}
				
	        }
	      
	      return result;
	}
	
	

	public String getLaborIdName() {
		return LaborIdName;
	}



	public void setLaborIdName(String laborIdName) {
		LaborIdName = laborIdName;
	}



	public Integer getNoOfDaysAbsentDays() {
		return noOfDaysAbsentDays;
	}



	public void setNoOfDaysAbsentDays(Integer noOfDaysAbsentDays) {
		this.noOfDaysAbsentDays = noOfDaysAbsentDays;
	}



	public Integer getNoOfOverTime() {
		return noOfOverTime;
	}



	public void setNoOfOverTime(Integer noOfOverTime) {
		this.noOfOverTime = noOfOverTime;
	}



	public Integer getNoOfHalfDays() {
		return noOfHalfDays;
	}



	public void setNoOfHalfDays(Integer noOfHalfDays) {
		this.noOfHalfDays = noOfHalfDays;
	}



	public Integer getNoOfDaysInMonth() {
		return noOfDaysInMonth;
	}



	public void setNoOfDaysInMonth(Integer noOfDaysInMonth) {
		this.noOfDaysInMonth = noOfDaysInMonth;
	}



	public Integer getNoOfFullDays() {
		return noOfFullDays;
	}



	public void setNoOfFullDays(Integer noOfFullDays) {
		this.noOfFullDays = noOfFullDays;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public Float getAdditionalDeduction() {
		return additionalDeduction;
	}



	public void setAdditionalDeduction(Float additionalDeduction) {
		this.additionalDeduction = additionalDeduction;
	}



	public Float getAdditionalPayment() {
		return additionalPayment;
	}



	public void setAdditionalPayment(Float additionalPayment) {
		this.additionalPayment = additionalPayment;
	}




	public String getTotalSalary() {
		return totalSalary;
	}



	public void setTotalSalary(String totalSalary) {
		this.totalSalary = totalSalary;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	
	
}
