package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class GetMarathiName extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2169290453504299091L;


	private String productName;
	private String fullNameMarathi;
	private String alias;
	private String salesUnit;
	private String tax;
	private String salesRate;
	
	private HttpSession session;
	@Override
	public String execute() throws Exception {
		
	
			 
			String result = "login";;
			session=ServletActionContext.getRequest().getSession(false); 
			
		        if(session==null || session.getAttribute("login")==null){ 
		        	addActionMessage("Please Login First !!!");
		        	result = "login";
		        }  
		        else{
		        	String crusherId = (String) session.getAttribute("crusherId");
		    		String crusherCode = (String) session.getAttribute("crusherCode");
		    		
		        	Connection connection = null;
					PreparedStatement preparedStatement= null;
					ResultSet resultSet = null;
					
					String sql = "";
					String db = (String) session.getAttribute("db");
					
					
						try
						{
							
							connection = GetDBConnection.getDBConnection(db);
							
							sql = "SELECT product_name_mar,product_alias,sales_unit,tax_id,customer_sales_price "
									+ "FROM crusher_product_master "
									+ "where "
									+ "product_name_eng = ?'"
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ?";
						
							
							
							preparedStatement = connection.prepareStatement(sql);
						
							preparedStatement.setString(1, this.getProductName());
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							resultSet.last();
							int rowCount = resultSet.getRow();
							resultSet.beforeFirst();
							if(rowCount>0)
							{
							while(resultSet.next())
							{
								
								setFullNameMarathi(resultSet.getString(1));
								setAlias(resultSet.getString(2));
								setSalesUnit(resultSet.getString(3));
								setTax(resultSet.getString(4));
								setSalesRate(resultSet.getString(5));
							}
								result = "success";
							}
							else
							{
								result = "error";
							}
							
						}catch (SQLException e) {
							
						//e.printStackTrace();
						} catch (IOException e) {
							
						//e.printStackTrace();
						}finally {
							if(resultSet != null)
			   				{
			   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
			   				}
							if(preparedStatement != null)
							{
								try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
							}
							if(connection != null)
							{
								
								try {connection.close(); connection = null;}catch (SQLException e) {}
							}
							
						}
		        }
		
		return result;
}
	public String getProductName() {
		return productName;
	}
	public void setProductName(String productName) {
		this.productName = productName;
	}
	public String getFullNameMarathi() {
		return fullNameMarathi;
	}
	public void setFullNameMarathi(String fullNameMarathi) {
		this.fullNameMarathi = fullNameMarathi;
	}
	public String getAlias() {
		return alias;
	}
	public void setAlias(String alias) {
		this.alias = alias;
	}
	public String getSalesUnit() {
		return salesUnit;
	}
	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}
	public String getTax() {
		return tax;
	}
	public void setTax(String tax) {
		this.tax = tax;
	}
	public String getSalesRate() {
		return salesRate;
	}
	public void setSalesRate(String salesRate) {
		this.salesRate = salesRate;
	}
	
	
	
	
	
}

