package com.stonecrusher.ajax;

import java.text.DecimalFormat;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.utils.GetCustomerTotalCreditAmountById;

public class GetCustomerCreditAmount extends ActionSupport implements SessionAware{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2271972602360418773L;
	private String customerName;
	private String outstandingAmount;
	private HttpSession session;

	private SessionMap<String,Object> sessionMap;
	
	public String execute() {
		 
		String result = "login";
	
		
		session=ServletActionContext.getRequest().getSession(false); 
		
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	result = "login";
        }  
        else{
	        	
	        	
			
				
				try
				{
					String customerData [] = this.getCustomerName().split("-");
					String custId = customerData[0];
					DecimalFormat df = new DecimalFormat("##.#");
					float custOutStandingAmt = GetCustomerTotalCreditAmountById.getCustomerTotalCreditAmountById(custId, this.getSessionMap());
					
					this.setOutstandingAmount(df.format(custOutStandingAmt));
					
					result = SUCCESS;
					
				}
				
				catch (Exception e) {
						result = "error";
					e.printStackTrace();
					addActionError(e.getMessage() +" || Area details not added !");
				}
				
	        	
	        }
	        return result;
	}
	public String getCustomerName() {
		return customerName;
	}
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getOutstandingAmount() {
		return outstandingAmount;
	}
	public void setOutstandingAmount(String outstandingAmount) {
		this.outstandingAmount = outstandingAmount;
	}
	


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	
	

}