package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BankNameDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetChequeBankList extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2215511971668055519L;
	
	
	private HttpSession session;	
	private SessionMap<String,Object> sessionMap;  
	
	private List<BankNameDAO> bankNameList = new ArrayList<BankNameDAO>();
	
	public String execute() throws Exception {

	 	String result = "login";
		session=ServletActionContext.getRequest().getSession(false);  
        
		if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
            result = "login";  
        }  
        else
        {
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	
        	//System.out.println("hello");
        	
        	Connection connection = null;
       		PreparedStatement preparedStatement= null;
       		ResultSet resultSet = null;
       		
       		
       		String sql ="";
       		String db = (String) session.getAttribute("db");
       		try {
       			
       			
				connection = GetDBConnection.getDBConnection(db);
       			
       			sql = "SELECT "
       					+ "cheque_book_bank_name "
       					+ "FROM "
       					+ "cheque_book_details_master "
       					+ "WHERE "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "GROUP BY "
       					+ "cheque_book_bank_name";
       			
       			
       			preparedStatement = connection.prepareStatement(sql);
       			preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				
				resultSet = preparedStatement.executeQuery();
       			BankNameDAO dao1 = new BankNameDAO();
       			dao1.setBankName("-----  SELECT BANK ------");
       			dao1.setValue("");
       			bankNameList.add(dao1);
       			
       			while(resultSet.next())
       			{
       				BankNameDAO dao = new BankNameDAO();
       				dao.setBankName(resultSet.getString(1));
       				dao.setValue(resultSet.getString(1));
       				
       				bankNameList.add(dao);
       			}
       			
       			result = "success";
       			
       		}	 catch (SQLException e) {
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| SOME ERROR");
			
			} catch (IOException e) {
				
				addActionMessage(e.getMessage()+"|| SOME ERROR");
			}	
   			finally
   			{
   				if(resultSet != null)
   				{
   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
   			}
       		
        }
		
		return result;
	}

	public List<BankNameDAO> getBankNameList() {
		return bankNameList;
	}

	public void setBankNameList(List<BankNameDAO> bankNameList) {
		this.bankNameList = bankNameList;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	

}
