package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class GetAliasFullName extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6993409795460783076L;
	private String fullName;
	private String aliasValue;
	private String fullNameMarathi;
	private String salesUnit;
	private String tax;
	private String salesRate;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;  
	
	
	@Override
	public String execute(){
		
	
			 
			String result = "login";;
			session=ServletActionContext.getRequest().getSession(false); 
			
		        if(session==null || session.getAttribute("login")==null){ 
		        	addActionMessage("Please Login First !!!");
		        	result = "login";
		        }  
		        else{
		        	String crusherId = (String) this.getSessionMap().get("crusherId");
		    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
		    		
		        	Connection connection = null;
					PreparedStatement preparedStatement= null;
					ResultSet resultSet = null;
					
					String sql = "";
					String db = (String) session.getAttribute("db");
					
				
						try
						{
							
							connection = GetDBConnection.getDBConnection(db);
							try
							{
								if(this.getAliasValue().contains("-"))
								{
									this.setAliasValue(this.getAliasValue().split("-")[1]);
								}
							}catch (Exception e) {}
							
							sql = "SELECT "
									+ "product_id,product_name_eng,product_name_mar,sales_unit,tax_id,customer_sales_price "
									+ "FROM "
									+ "crusher_product_master "
									+ "WHERE "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "AND "
									+ "(product_alias = '"+this.getAliasValue()+"' OR product_name_eng='"+this.getAliasValue()+"') ";
						
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crusherId);
							preparedStatement.setString(2, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							resultSet.last();
							int rowCount = resultSet.getRow();
							resultSet.beforeFirst();
							if(rowCount>0)
							{
							while(resultSet.next())
							{
								this.setFullName(resultSet.getString(1)+"-"+resultSet.getString(2));
								this.setFullNameMarathi(resultSet.getString(3));
								this.setSalesUnit(resultSet.getString(4));								
								this.setTax(resultSet.getString(5));
								this.setSalesRate(resultSet.getString(6));
							}
								result = "success";
							}
							else
							{
								result = "error";
							}
							
						}catch (SQLException e) {
							
						//e.printStackTrace();
						} catch (IOException e) {
							
						//e.printStackTrace();
						}finally {
							if(resultSet != null)
			   				{
			   					try {resultSet.close();}catch(SQLException sqe){}   					
			   				}
							if(preparedStatement != null)
							{
								try {preparedStatement.close();} catch (SQLException e) {}
							}
							if(connection != null)
							{
								
								try {connection.close();}catch (SQLException e) {}
							}
							
						}
		        }
		
		return result;
	}
	public String getAliasValue() {
		return aliasValue;
	}
	public void setAliasValue(String aliasValue) {
		this.aliasValue = aliasValue;
	}
	public String getFullName() {
		return fullName;
	}
	public void setFullName(String fullName) {
		this.fullName = fullName;
	}
	public String getFullNameMarathi() {
		return fullNameMarathi;
	}
	public void setFullNameMarathi(String fullNameMarathi) {
		this.fullNameMarathi = fullNameMarathi;
	}
	public String getSalesUnit() {
		return salesUnit;
	}
	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}
	public String getTax() {
		return tax;
	}
	public void setTax(String tax) {
		this.tax = tax;
	}
	public String getSalesRate() {
		return salesRate;
	}
	public void setSalesRate(String salesRate) {
		this.salesRate = salesRate;
	}
	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	
	
	
	
}
