package com.stonecrusher.ajax;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;


public class CustromerListInfo extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5866515510478343589L;
	private  HttpSession session;

	private String term;
	private Map<String, String> customerList = new HashMap<String, String>();
	private SessionMap<String,Object> sessionMap;  
	
	public String execute() {
		
		String result = "login";
		  session=ServletActionContext.getRequest().getSession(false);  
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result= "login";  
	        }  
	        else
	        {
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        session=ServletActionContext.getRequest().getSession(false);  
			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			
			String db = (String) session.getAttribute("db");
			
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				sql = "SELECT "
						+ "customer_id,"
						+ "customer_name,"
						+ "mobile_number,"
						+ "billing_address "
						+ "FROM "
						+ "crusher_customer_master "
						+ "WHERE "
						+ "("
					    + "UPPER(customer_name) LIKE '%" + this.getTerm().toUpperCase() + "%' "
					    + "OR "
					    + "CAST(customer_id AS CHAR) LIKE '%" + this.getTerm() + "%' "
					    + ") "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
				
				
				/*
				 * sql = "select " + "customer_id," + "customer_name," + "mobile_number," +
				 * "billing_address " + " FROM " +
				 * "crusher_customer_master where match(customer_name) against ('%"+term+"%') "
				 * + "AND " + "crusher_id = ? " + "AND " + "crusher_code = ? ";
				 */
				
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
			//	System.out.println(preparedStatement.toString());
						
				
				resultSet = preparedStatement.executeQuery();
				resultSet.last();
				int rows=resultSet.getRow();
				resultSet.beforeFirst();
				
				if(rows>0)
				{
					while(resultSet.next())
					{
					customerList.put(resultSet.getString(1)+"-"+resultSet.getString(2)+"-"+resultSet.getString(3), 
							resultSet.getString(1)+"-"+resultSet.getString(2)+"-"+resultSet.getString(4));
					
					}
				}
				else
				{
					customerList.put("Customer_Not_Found", "Customer Not Found");
				}
				
				
				result = SUCCESS;
			} catch (SQLException e) {
				//e.printStackTrace();
				
			} catch (IOException e) {
			
				//e.printStackTrace();
			}finally
			{
				if(resultSet != null)
   				{
   					try {resultSet.close();resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {
						preparedStatement.close();preparedStatement = null;
					} catch (SQLException e) {
						
					}
				}
				
				if(connection != null)
				{
					try {
						connection.close();connection=null;
					} catch (SQLException e) {
						
					}
				}
				
				
			}
			
			
	   }
	        
	        return result;
}

public String getTerm() {
	return term;
}

public void setTerm(String term) {
	this.term = term;
}

public Map<String, String> getCustomerList() {
	return customerList;
}

public void setCustomerList(Map<String, String> customerList) {
	this.customerList = customerList;
}

@Override
public void setSession(Map<String, Object> arg0) {
	// TODO Auto-generated method stub
	sessionMap=(SessionMap<String, Object>)arg0;
}


public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}



}

