package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.DAO.ChallanInfoDAO;
import com.stonecrusher.DAO.ChallanProductInfoDAO;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class SaveDCAndPrint extends ActionSupport implements SessionAware{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4205886934505595095L;
	private String challanNumber;
	private String challanDateTime;
	private String paymentType;
	private String customerName;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private Float quantity;
	private String comments;
	private String alternateMobileNumber;
	private SessionMap<String,Object> sessionMap;
	
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private List<ChallanProductInfoDAO> challanProductInfoList ;
	private String defaultValue;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private BillVehicleInfoDAO billVehicleInfoDAO = null;
	
	private String removeVaules="false";
	
	private ChallanInfoDAO challanInfoDAO = null;
	
	private String viewChallan;
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private boolean challanSaved;
	private boolean sendSMS;
	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private String addSideBarJs;

	private Float transportCharges;
	
	private File image1;
	private File image2;
	private File image3;
	
	private String keyVehicle;
	
	private Boolean isFromVehicleEntryDetails ;
	
	
		
	@SuppressWarnings("unchecked")
	public String execute() {
		
		
		String result = "login";

        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
        	addActionMessage(this.getText("message.error.plzloginfirst"));
        	result = "error";
        }  
        else{
	        	
        	
        	
         	
        		String crusherId = (String) this.getSessionMap().get("crusherId");
        		String crusherCode = (String) this.getSessionMap().get("crusherCode");		
	        
        		String fullUserName = (String) this.getSessionMap().get("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String dcBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		dcBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		dcBy =fullUserName;
	        	}
	        	
				Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	 
	        
	        		
	        		String challanDateTime = "";
	        		
	        		challanDateTime = this.getChallanInfoDAO().getChallanDate();
	        		
	        		if(challanDateTime == null || challanDateTime == "" )
	        		{
	               	challanDateTime = dateFormat.format(d);
	        			
	        		}
	        		
	        	
		        	
		        Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				
				this.setChallanProductInfoList((List<ChallanProductInfoDAO>) this.getSessionMap().get("challanProductList"));
	        	
	        	this.setChallanInfoDAO((ChallanInfoDAO) this.getSessionMap().get("challanInformation"));
	        	
	        	//System.out.print("Is Bill Saved : "+this.getBillInfoDAO().isBillSaved());
	        	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("challanVehicleinfo"));
	        	if(!this.getChallanInfoDAO().getChallanSaved())	        	
	        	{
	        		if(this.getChallanInfoDAO().getTransportCharges() == null)
	        		{
	        			this.getChallanInfoDAO().setTransportCharges(0.0f);
	        		}
	        		/*System.out.println("In Save Bill");
	        		
		        	Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");*/
		        	//String billDateTime = dateFormat.format(d);	        	
		        	
	         	
		        	
	        	try
	        	{
	        		FileInputStream fisImage1 = null;
		        	FileInputStream fisImage2 = null;
		        	FileInputStream fisImage3 = null;
		        	
		     		if(this.getImage1() != null)
		      		{
		     			fisImage1 =  new FileInputStream(this.getImage1());
		      		}

		     		if(this.getImage2() != null)
		      		{
		     			fisImage2 =  new FileInputStream(this.getImage2());
		      		}
		     		
		     		if(this.getImage3() != null)
		      		{
		     			fisImage3 =  new FileInputStream(this.getImage3());
		      		}
		        	
	        		  java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
	        	      
	        
				connection = GetDBConnection.getDBConnection(db);
	        	connection.setAutoCommit(false);
	        	
	     	
        		
        		if(this.getChallanInfoDAO().getChallanNumber().equalsIgnoreCase("NA") || this.getChallanInfoDAO().getChallanNumber().equals(""))
				{
        		
        			
					sql = "SELECT "
							+ "challan_number "
							+ "FROM "
							+ "crusher_delivery_challan_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "			
							+ "ORDER BY "
							+ "challan_number  "
							+ "DESC LIMIT 1;";
					
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
			
				int newChallanNumber = 0;
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						newChallanNumber = Integer.parseInt(resultSet.getString(1));
						
						
						this.getChallanInfoDAO().setChallanNumber(""+(newChallanNumber+1));
					}
					else
					{
						newChallanNumber =1;
						this.getChallanInfoDAO().setChallanNumber(""+(newChallanNumber));
					
						
					}
				}
				else
				{	newChallanNumber =1;
					this.getChallanInfoDAO().setChallanNumber(""+(newChallanNumber));
				}
				}
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
        	
	        	int countChallanInfoInserted = 0;
	        	int countChallanInfoUpdated = 0;
	        	
	        		
	      
				
				 int year = Calendar.getInstance().get(Calendar.YEAR);
	        	
	        	if(!this.getChallanInfoDAO().getChallanSaved())
	        	{
	        		
	        		this.getChallanInfoDAO().setChallanNumber(this.getChallanInfoDAO().getChallanNumber());
	        		
	        		
	        		
	        	sql = "INSERT INTO "
	        			+ "crusher_delivery_challan_master"
	        			+ "( "
	        			+ "crusher_id,"
	        			+ "crusher_code,"
	        			+ "challan_number,"
	        			+ "challan_number_str,"
	        			+ "challan_entry_date,"	  
	        			+ "challan_entry_time,"
	        			+ "challan_date,"
	        			+ "payment_type,"
	        			+ "customer_all_details,"
	        			+ "customer_id,"
	        			+ "customer_name,"
	        			+ "vehicle_all_details,"
	        			+ "vehicle_id,"
	        			+ "veihcle_reg_number,"
	        			+ "vehicle_start_km,"
	        			+ "vehicle_end_km,"
	        			+ "vehicle_total_km,"
	        			+ "trip_start_location,"
	        			+ "trip_end_location,"
	        			+ "total_trip_count,"
	        			+ "comments,"
	        			+ "entry_by,"
	        			+ "vehicle_image1,"
	        			+ "vehicle_image2,"
	        			+ "vehicle_image3) "
	        			+ "VALUES "
    					+ "(?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        			
	        	
	        	preparedStatement = connection.prepareStatement(sql);
	        	
	        	preparedStatement.setString(1, crusherId);
	        	preparedStatement.setString(2, crusherCode);
	        	preparedStatement.setString(3,this.getChallanInfoDAO().getChallanNumber());
	        	preparedStatement.setString(4,"DC/"+year+"/"+this.getChallanInfoDAO().getChallanNumber());		        
	           	preparedStatement.setString(5, dateFormat.format(date));
	           	preparedStatement.setTime(6, time);
	           	preparedStatement.setString(7, this.getChallanInfoDAO().getChallanDate());	           	
	        	preparedStatement.setString(8,this.getChallanInfoDAO().getPaymentType());
	        	preparedStatement.setString(9,this.getChallanInfoDAO().getCustomerAllDetails());
	        	preparedStatement.setString(10, this.getChallanInfoDAO().getCustomerId());
	        	preparedStatement.setString(11,this.getChallanInfoDAO().getCustomerName());
	        	preparedStatement.setString(12,this.getChallanInfoDAO().getVehicleAllDetails());	
	        	preparedStatement.setString(13,this.getChallanInfoDAO().getVehicleId());
	        	preparedStatement.setString(14, this.getChallanInfoDAO().getVehicleRegNumber());
	        	preparedStatement.setFloat(15, this.getChallanInfoDAO().getKmStart());
	        	preparedStatement.setFloat(16, this.getChallanInfoDAO().getKmEnd());
	        	preparedStatement.setFloat(17, this.getChallanInfoDAO().getTotalKm());
	        	preparedStatement.setString(18, this.getChallanInfoDAO().getTripFrom());
	        	preparedStatement.setString(19, this.getChallanInfoDAO().getTripTo());
	        	preparedStatement.setInt(20, this.getChallanInfoDAO().getTotalTripCount());
	        	preparedStatement.setString(21, this.getChallanInfoDAO().getComments());
	        	preparedStatement.setString(22, dcBy);
	        	
	        	if(this.getImage1() != null)
	        	{
	        		preparedStatement.setBinaryStream(23, fisImage1,(int)getImage1().length());
					
	        	}
	        	else
	        	{
	        		preparedStatement.setBinaryStream(23, null,0);
	        	}
	        	
	        	

	        	if(this.getImage2() != null)
	        	{
	        		preparedStatement.setBinaryStream(24, fisImage2,(int)getImage2().length());
					
	        	}
	        	else
	        	{
	        		preparedStatement.setBinaryStream(24, null,0);
	        	}
	        	
	        	if(this.getImage3() != null)
	        	{
	        		preparedStatement.setBinaryStream(25, fisImage3,(int)getImage3().length());
					
	        	}
	        	else
	        	{
	        		preparedStatement.setBinaryStream(25, null,0);
	        	}
	        	
	        	
	        	countChallanInfoInserted = preparedStatement.executeUpdate();
	        	
				
	        	}
	        	else
	        	{

	        		
	        		sql = "UPDATE "
	        				+ "crusher_delivery_challan_master "
	        				+ "SET "
	        				+ "challan_entry_date = STR_TO_DATE(?,'%d-%m-%Y'),"
	        				+ "challan_entry_time=?,"
		        			+ "challan_date= STR_TO_DATE(?,'%d-%m-%Y'),"
		        			+ "payment_type=?,"
		        			+ "customer_all_details=?,"
		        			+ "customer_id=?,"
		        			+ "customer_name=?,"
		        			+ "vehicle_all_details=?,"
		        			+ "vehicle_id=?,"
		        			+ "veihcle_reg_number=?,"
		        			+ "vehicle_start_km=?,"
		        			+ "vehicle_end_km=?,"
		        			+ "vehicle_total_km=?,"
		        			+ "trip_start_location=?,"
		        			+ "trip_end_location=?,"
		        			+ "total_trip_count=?,"
		        			+ "comments=?,"
		        			+ "entry_by = ? "	        			        			
		        			+ "WHERE "
		        			+ "challan_number = ? "
		        			+ "AND "
		        			+ "customer_id = ? "
		        			+ "AND "
		        			+ "crusher_id = ? "
		        			+ "AND "
		        			+ "crusher_code = ? ";
	        		
	        		preparedStatement = connection.prepareStatement(sql);  	
		        	
		        	
		           	preparedStatement.setString(1, dateFormat.format(date));
		           	preparedStatement.setTime(2, time);
		        	preparedStatement.setString(3, this.getChallanInfoDAO().getChallanDate());
		        	preparedStatement.setString(4,this.getChallanInfoDAO().getPaymentType());
		        	preparedStatement.setString(5,this.getChallanInfoDAO().getCustomerAllDetails());
		        	preparedStatement.setString(6, this.getChallanInfoDAO().getCustomerId());
		        	preparedStatement.setString(7, this.getChallanInfoDAO().getCustomerName());
		        	preparedStatement.setString(8, this.getChallanInfoDAO().getVehicleAllDetails());
		        	preparedStatement.setString(9, this.getChallanInfoDAO().getVehicleId());
		        	preparedStatement.setString(10, this.getChallanInfoDAO().getVehicleRegNumber());
		        	preparedStatement.setFloat(11, this.getChallanInfoDAO().getKmStart());
		        	preparedStatement.setFloat(12, this.getChallanInfoDAO().getKmEnd());
		        	preparedStatement.setFloat(13, this.getChallanInfoDAO().getTotalKm());
		        	preparedStatement.setString(14, this.getChallanInfoDAO().getTripFrom());
		        	preparedStatement.setString(15, this.getChallanInfoDAO().getTripTo());
		        	preparedStatement.setInt(16, this.getChallanInfoDAO().getTotalTripCount());
		        	preparedStatement.setString(17, this.getChallanInfoDAO().getComments());
		        	preparedStatement.setString(18, dcBy);
		        	preparedStatement.setString(19, this.getChallanInfoDAO().getChallanNumber());
		        	preparedStatement.setString(20, this.getChallanInfoDAO().getCustomerId());
		        	preparedStatement.setString(21, crusherId);
		        	preparedStatement.setString(22, crusherCode);
		        	
		        	
		        	
		        	countChallanInfoUpdated = preparedStatement.executeUpdate();
		        	
		        	
	        		
	        	}
	        	
	        	
	        	
	        	if(countChallanInfoInserted>0 || countChallanInfoUpdated > 0)
	        	{
	        		
	        		
	        		if(preparedStatement != null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		
	        		
	        		sql = "SELECT "
	        				+ "product_name_eng "
	        				+ "FROM "
	        				+ "challan_product_details "
	        				+ "WHERE "
	        				+ "challan_number = ? "
	        				+ "AND "
	        				+ "crusher_id = ? "
	        				+ "AND "
	        				+ "crusher_code = ? ";
	        		
	        		
	        		preparedStatement = connection.prepareStatement(sql);
	        		preparedStatement.setString(1, this.getChallanInfoDAO().getChallanNumber());
	        		preparedStatement.setString(2, crusherId);
	        		preparedStatement.setString(3, crusherCode);
	        		
	        		
	        		resultSet = preparedStatement.executeQuery();
	        		
	        		resultSet.last();
	        		int rowCount = resultSet.getRow();
	        		resultSet.beforeFirst();
	        		
	        		
	        		if(rowCount > 0)
	        		{
	        			if(preparedStatement != null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
	        			
	        			sql = "DELETE FROM challan_product_details "
	        					+ "WHERE "
	        					+ "challan_number = ? "
	        					+ "AND "
	        					+ "crusher_id = ? "
	        					+ "AND "
	        					+ "crusher_code = ? ";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			preparedStatement.setString(1, this.getChallanInfoDAO().getChallanNumber());
	        			preparedStatement.setString(2, crusherId);
	        			preparedStatement.setString(3, crusherCode);
	        			
		        		
	        			preparedStatement.executeUpdate(); 	        			
	        			
	        		}
	        			int productInserted = 0;
	        			
	        			for(ChallanProductInfoDAO productInfoDAO : this.getChallanProductInfoList())
	        			{
	        				if(preparedStatement != null)
	    	        		{
	    	        			preparedStatement.close();
	    	        			preparedStatement = null;
	    	        		}
	        				
	        		
	        			
	        			sql = "INSERT INTO challan_product_details "
	        					+ "("
	        					+ "crusher_id,"
	        					+ "crusher_code,"
	        					+ "challan_number,"
	        					+ "product_id,"
	        					+ "product_name_eng,"
	        					+ "sale_unit,"
	        					+ "quantity,"
	        					+ "empty_weight,"
	        					+ "gross_weight) "
	        					+ "values "
	        					+ "(?,?,?,?,?,?,?,?,?)";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			
	        			preparedStatement.setString(1, crusherId);
	        			preparedStatement.setString(2, crusherCode);
	        			preparedStatement.setString(3, this.getChallanInfoDAO().getChallanNumber());
	        			preparedStatement.setString(4, productInfoDAO.getProductId());
	        			preparedStatement.setString(5, productInfoDAO.getProductName());
	        			preparedStatement.setString(6, productInfoDAO.getSalesUnit());
	        			preparedStatement.setFloat(7, productInfoDAO.getQuantity());
	        			if(productInfoDAO.getVehicleEmptyWeight() != null)
	        			{
	        				preparedStatement.setFloat(8, productInfoDAO.getVehicleEmptyWeight());
		        			
	        			}else {
	        				preparedStatement.setFloat(8, 0.0f);
		        			
	        			}
	        			if(productInfoDAO.getGrossWeight() != null)
	        			{
	        				preparedStatement.setFloat(9, productInfoDAO.getGrossWeight());
	    	        		
	        			}else {
	        				preparedStatement.setFloat(9, 0.0f);
	    	        		
	        			}
	        			
	        			productInserted = productInserted +  preparedStatement.executeUpdate();
	        			
	        		
	        			}
	        			
	        			
	        			
	        			if(productInserted == this.getChallanProductInfoList().size())
	        			{
	        				if(countChallanInfoInserted > 0)
	        				{
	        					this.getChallanInfoDAO().setChallanSaved(true);
	        					this.setChallanSaved(true);
	        				}
	        				
	        				
	        				
	        				
	        				String entryId = EncryptionDecryption.decrypt(this.getKeyVehicle());
	        				
	        				for(ChallanProductInfoDAO productInfoDAO : this.getChallanProductInfoList())
    	        			{
	        				if(entryId != null && productInfoDAO.getQuantity() != null &&  productInfoDAO.getGrossWeight() != null)
	        				{
	        					
	        						
	        				
	        				
	    	        		sql = "UPDATE "
	    	        				+ "crusher_vehicle_entry_details "
	    	        				+ "SET "
	    	        				+ "delivery_chalan_no=?,"
	    		        			+ "gross_weight=?,"
	    		        			+ "material_weight=?,"
	    		        			+ "status=? "
	    		        			+ "WHERE "
	    		        			+ "entry_id = ? "
	    		        			+ "AND "
	    		        			+ "crusher_id = ? "
	    		        			+ "AND "
	    		        			+ "crusher_code = ? ";
	    	        		
	    	        		preparedStatement = connection.prepareStatement(sql);  	
	    		        	
	    		        	
	    		           	preparedStatement.setString(1, this.getChallanInfoDAO().getChallanNumber());
	    		        	preparedStatement.setFloat(2,productInfoDAO.getGrossWeight() );
	    		        	preparedStatement.setFloat(3,productInfoDAO.getQuantity());
	    		        	preparedStatement.setString(4,"DC ADDED");
	    		        	preparedStatement.setString(5, entryId);
	    		        	preparedStatement.setString(6, crusherId);
	    		        	preparedStatement.setString(7, crusherCode);
	    		        	
	    		        	
	    		        	
	    		        	int updated = preparedStatement.executeUpdate();
	    		        	
	    	        			}
	    		        	
	        				}
	    		        	
	    		        	
	        				
	        				
	        				
	    	        		this.setChallanDateTime(this.getChallanInfoDAO().getChallanDate());
	    	        		this.setCustomerName(this.getChallanInfoDAO().getCustomerAllDetails());
	    	        		this.setVehicleId(this.getChallanInfoDAO().getVehicleAllDetails());
	    	        		
	    	        		this.setChallanNumber(this.getChallanInfoDAO().getChallanNumber());
	    	        		this.setAlternateMobileNumber(this.getChallanInfoDAO().getCustomerMobile());
	    	        		this.setSendSMS(this.getChallanInfoDAO().getSendSMS());
	    	            	
	    	        		paymentTypeList.put("CASH","CASH");
	    		        	paymentTypeList.put("CREDIT","CREDIT");
	    		        	
	    		        	this.setDefaultValue(this.getChallanInfoDAO().getPaymentType());
	    		        	addActionMessage(this.getText("message.success.chalanDetailsSavedSuccessfully"));
	    	        		this.getSessionMap().put("challanInformation", this.getChallanInfoDAO());
	    	        		this.getSessionMap().put("challanProductList", this.getChallanProductInfoList());
							connection.commit();
    						result = SUCCESS;
							
	    						
	    						
	    	        			
	    	        		
	        			}
	        			else
	        			{
	        				result = "error";
	        				addActionError(this.getText("message.error.billNotSavedProperly"));
	        			}
	        			
	        	}
	        	else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.sryBillDetailsNotSaved"));
	        	}
	        	
	        	
	        	
	        	
	        	
    			
	        		
	        	}
	        	catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					try {connection.rollback();} catch (SQLException e1) {}
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||1 " +this.getText("message.error.chalanDetailsNotSavedSuccessfully"));
				} catch (IOException e) {
					//e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" ||2 "+this.getText("message.error.chalanDetailsNotSavedSuccessfully"));
				}catch (Exception e) {
					e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" ||3 "+this.getText("message.error.chalanDetailsNotSavedSuccessfully"));
				}finally {
					if(resultSet != null)
	   				{
	   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
	   				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
					}
	        	}
	        	else
	        	{
	        		
		        
		        	
		        	
		        	
	        		this.getSessionMap().put("challanProductList", this.getChallanProductInfoList());
	        		
	        		setCustomerName(this.getChallanInfoDAO().getCustomerName());
	        		setTransportCharges(this.getChallanInfoDAO().getTransportCharges());
	        		//System.out.println(getAlternateMobileNumber());
	        		
	        		setAlternateMobileNumber(this.getChallanInfoDAO().getCustomerMobile());
	        		setSendSMS(this.getChallanInfoDAO().getSendSMS());
	        		
		        	
		        
		        	
	        		paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        	
		        	setDefaultValue(this.getChallanInfoDAO().getPaymentType());
		        	

		        	
		        	unitList = GetListResource.GetUnitList();
		        	this.getSessionMap().put("challanInformation", this.getChallanInfoDAO());
	        		this.getSessionMap().put("challanProductList", this.getChallanProductInfoList());
	        		result = "success";
	        		addActionError(this.getText("message.error.chalanAlreadySaved"));
	        	}
	        		
	        }
	       // System.out.print(result);
	        return result;
		
	}
	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		
		this.setChallanProductInfoList((List<ChallanProductInfoDAO>) this.getSessionMap().get("challanProductList"));		        	
    	this.setChallanInfoDAO((ChallanInfoDAO) this.getSessionMap().get("challanInformation"));
    	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("challanVehicleinfo"));
 
    	
		
    	this.setTransportCharges(this.getChallanInfoDAO().getTransportCharges());
    	this.setCustomerName(this.getChallanInfoDAO().getCustomerAllDetails());
    	this.setVehicleId(this.getChallanInfoDAO().getVehicleAllDetails());
    	this.setChallanNumber(this.getChallanInfoDAO().getChallanNumber());
    	this.setChallanDateTime(this.getChallanInfoDAO().getChallanDate());
	
		paymentTypeList.put("CASH","CASH");
    	paymentTypeList.put("CREDIT","CREDIT");
    	
    	setDefaultValue(this.getChallanInfoDAO().getPaymentType());
    	

    	unitList = GetListResource.GetUnitList();
    	this.setAddSideBarJs("FALSE");
    	
    	this.setCustomerName(this.getChallanInfoDAO().getCustomerAllDetails());
    	this.setVehicleId(this.getChallanInfoDAO().getVehicleAllDetails());
    	this.setKmStart(this.getChallanInfoDAO().getKmStart());
    	this.setKmEnd(this.getChallanInfoDAO().getKmEnd());
    	this.setTotalKm(this.getChallanInfoDAO().getTotalKm());
    	this.setTotalTrips(this.getChallanInfoDAO().getTotalTripCount());
    	this.setTripFrom(this.getChallanInfoDAO().getTripFrom());
    	this.setTripTo(this.getChallanInfoDAO().getTripTo());
    	this.setComments(this.getChallanInfoDAO().getComments());
    	
    	this.setPaymentType(this.getChallanInfoDAO().getPaymentType());
		
		this.getSessionMap().put("challanInformation", this.getChallanInfoDAO());
		this.getSessionMap().put("challanProductList", this.getChallanProductInfoList());
	}
	
	
	public String getChallanNumber() {
		return challanNumber;
	}
	public void setChallanNumber(String challanNumber) {
		this.challanNumber = challanNumber;
	}
	public String getChallanDateTime() {
		return challanDateTime;
	}
	public void setChallanDateTime(String challanDateTime) {
		this.challanDateTime = challanDateTime;
	}
	public String getPaymentType() {
		return paymentType;
	}
	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}
	public String getProductName() {
		return productName;
	}
	public void setProductName(String productName) {
		this.productName = productName;
	}
	public String getProductMarathiName() {
		return productMarathiName;
	}
	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}
	public String getAlias() {
		return alias;
	}
	public void setAlias(String alias) {
		this.alias = alias;
	}
	public String getSalesUnit() {
		return salesUnit;
	}
	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}
	public Float getQuantity() {
		return quantity;
	}
	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public List<ChallanProductInfoDAO> getChallanProductInfoList() {
		return challanProductInfoList;
	}
	public void setChallanProductInfoList(List<ChallanProductInfoDAO> challanProductInfoList) {
		this.challanProductInfoList = challanProductInfoList;
	}
	public Map<String, String> getVehicleList() {
		return vehicleList;
	}
	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}
	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}
	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}
	public String getRemoveVaules() {
		return removeVaules;
	}
	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}
	public ChallanInfoDAO getChallanInfoDAO() {
		return challanInfoDAO;
	}
	public void setChallanInfoDAO(ChallanInfoDAO challanInfoDAO) {
		this.challanInfoDAO = challanInfoDAO;
	}
	public String getViewChallan() {
		return viewChallan;
	}
	public void setViewChallan(String viewChallan) {
		this.viewChallan = viewChallan;
	}
	public boolean isChallanSaved() {
		return challanSaved;
	}
	public void setChallanSaved(boolean challanSaved) {
		this.challanSaved = challanSaved;
	}
	public String getTripDate() {
		return tripDate;
	}
	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}
	public String getVehicleId() {
		return vehicleId;
	}
	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}
	public String getMaterialName() {
		return materialName;
	}
	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}
	public Float getMaterialVolume() {
		return materialVolume;
	}
	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}
	public Float getKmStart() {
		return kmStart;
	}
	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}
	public Float getKmEnd() {
		return kmEnd;
	}
	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}
	public Float getTotalKm() {
		return totalKm;
	}
	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}
	public String getTripFrom() {
		return tripFrom;
	}
	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}
	public String getTripTo() {
		return tripTo;
	}
	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}
	public Integer getTotalTrips() {
		return totalTrips;
	}
	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}
	public Float getTransportCharges() {
		return transportCharges;
	}
	public void setTransportCharges(Float transportCharges) {
		this.transportCharges = transportCharges;
	}
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}


	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	
	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}



	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}



	public boolean isSendSMS() {
		return sendSMS;
	}



	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}
	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}
	
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public File getImage1() {
		return image1;
	}
	public void setImage1(File image1) {
		this.image1 = image1;
	}
	public File getImage2() {
		return image2;
	}
	public void setImage2(File image2) {
		this.image2 = image2;
	}
	public File getImage3() {
		return image3;
	}
	public void setImage3(File image3) {
		this.image3 = image3;
	}
	public String getKeyVehicle() {
		return keyVehicle;
	}
	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}
	public Boolean getIsFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}
	public void setIsFromVehicleEntryDetails(Boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}
	

	
}

