package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetNewIdForNewEntry;
import com.opensymphony.xwork2.ActionSupport;

public class AddVehicleToBoulderSupplier extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1031154216319323739L;
	private SessionMap<String,Object> sessionMap; 
	
	private String boulderSupplierId;
	private String vehicleId;
	
	private String addSideBarJs;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
							
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					String [] suppDetails = this.getBoulderSupplierId().split("-");
					String [] vehicleDetails = this.getVehicleId().split("-");
					
					int newId = GetNewIdForNewEntry.getNewIdForNewEntry("boulder_supplier_vehicle_mapping_master", "entry_id", this.getSessionMap(), connection);
					
					sql = "INSERT INTO "
							+ "boulder_supplier_vehicle_mapping_master "
							+ "("
							+ "entry_id,"
							+ "crusher_id,"
							+ "crusher_code,"
							+ "boulder_supplier_id,"
							+ "vehicle_id,"
							+ "vehicle_number) "
							+ "VALUES "
							+ "(?,?,?,?,?,?)";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setInt(1, newId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					preparedStatement.setString(4, suppDetails[0]);
					preparedStatement.setString(5, vehicleDetails[0]);
					preparedStatement.setString(6, vehicleDetails[2]);
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						addActionMessage("Vehicle mapped to provided supplier successfully!");
						result = SUCCESS;
					}
					else
					{
						addActionError("Vehicle not mapped! Please try again!");
						result = ERROR;
					}
				}
				catch (SQLException e) {
					result = "error";
					
					if(e.getMessage().contains("Duplicate"))
					{
						addActionError("Already added!");
						
					}
					else
					{
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
					}
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        
	        if(result.equals("error"))
	        {
	        	this.setAddSideBarJs("FALSE");
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		
		if(this.getBoulderSupplierId() == null || this.getBoulderSupplierId().equals(""))
		{
			addActionError("Please provide boulder supplier details!");
		}
		else {
			
			
			try
			{
				String [] details = this.getBoulderSupplierId().split("-");
				
				if(details.length <2)
				{
					addActionError("Please provide boulder supplier details correctly!");
				}
			}
			catch(Exception e)
			{
				addActionError("Please provide boulder supplier details correctly!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getVehicleId() == null || this.getVehicleId().equals(""))
			{
				addActionError("Please provide vehicle details!");
			}else {
				
				
				try
				{
					String [] details = this.getVehicleId().split("-");
					
					if(details.length <2)
					{
						addActionError("Please provide vehicle details correctly!");
					}
				}
				catch(Exception e)
				{
					addActionError("Please provide vehicle details correctly!");
				}
			}
		}
		
		
		if(hasActionErrors())
		{
			this.setAddSideBarJs("FALSE");
		}
	
	}
	
	
	public String getBoulderSupplierId() {
		return boulderSupplierId;
	}



	public void setBoulderSupplierId(String boulderSupplierId) {
		this.boulderSupplierId = boulderSupplierId;
	}



	public String getVehicleId() {
		return vehicleId;
	}



	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



