package com.stonecrusher.add;


import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;


public class AddVehicleEntryDetails extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1852634394058786218L;
	
	private HttpSession session;
	
	private String entryDate;
	private String vehicleId;
	private float vehicleEmptyWeight;
	
	
	private File photo1PDF;
	

	private String addSideBarJs;

	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	    		
				java.util.Date date = new java.util.Date();
      	      long t = date.getTime();	        	     
      	      java.sql.Time time = new java.sql.Time(t);
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	         	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						connection.setAutoCommit(false);
						

						FileInputStream fis = null;
						
						
						if(this.getPhoto1PDF() != null)
						{
							
							 fis = new FileInputStream(this.getPhoto1PDF());
							
							
							
							sql = "INSERT INTO crusher_vehicle_entry_details "
								+ "("
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "entry_date,"
								+ "entry_time,"
								+ "vehicle_id,"
								+ "vehicle_name,"
								+ "vehicle_reg_no,"
								+ "photo_1,"
								+ "empty_weight,"
								+ "status) "
								+ "values "
								+ "(?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?)";
						
								
								preparedStatement = connection.prepareStatement(sql);
							    preparedStatement.setString(1, crusherId);
				        		preparedStatement.setString(2, crusherCode);
				        		preparedStatement.setString(3, this.getEntryDate());
								preparedStatement.setTime(4, time);
								preparedStatement.setString(5, this.getVehicleId().split("-")[0]);
								preparedStatement.setString(6, this.getVehicleId().split("-")[1]);
								preparedStatement.setString(7, this.getVehicleId().split("-")[2]);
								preparedStatement.setBinaryStream(8, fis,(int)this.getPhoto1PDF().length());
								preparedStatement.setFloat(9, this.getVehicleEmptyWeight());
								preparedStatement.setString(10, "OPEN");
								
								
						}
						if(this.getPhoto1PDF() == null)
						{
							//System.out.print("Hello in insert");
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							sql = "INSERT INTO crusher_vehicle_entry_details "
									+ "("
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "entry_date,"
									+ "entry_time,"
									+ "vehicle_id,"
									+ "vehicle_name,"
									+ "vehicle_reg_no,"
									+ "empty_weight,"
									+ "status) "
									+ "values "
									+ "(?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?)";
							
									
									preparedStatement = connection.prepareStatement(sql);
								    preparedStatement.setString(1, crusherId);
					        		preparedStatement.setString(2, crusherCode);
					        		preparedStatement.setString(3, this.getEntryDate());
									preparedStatement.setTime(4, time);
									preparedStatement.setString(5, this.getVehicleId().split("-")[0]);
									preparedStatement.setString(6, this.getVehicleId().split("-")[1]);
									preparedStatement.setString(7, this.getVehicleId().split("-")[2]);
									preparedStatement.setFloat(8, this.getVehicleEmptyWeight());
									preparedStatement.setString(9, "OPEN");
								
						}
						
						
						
						
						int i = preparedStatement.executeUpdate();
								
						
								if(i>0)
								{
									connection.commit();
									result = "success";
									addActionMessage(this.getText("message.success.vehicleEmptyEntryDetailsAddedSuccessfully"));
								}
								else
								{
									addActionError(this.getText("message.error.vehicleEmptyEntryDetailsNotAddedPlzTryAgain"));
									result="error";
								}
								
								if(fis != null)
					        	{
					        		fis.close();
					        		fis = null;
					        	}
					
					
	    	} catch (SQLException e) {
				result = ERROR;
				e.printStackTrace();
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.vehicleEmptyEntryDetailsNotAdded"));
			} catch (IOException e) {
				result = ERROR;
				e.printStackTrace();
				addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.vehicleEmptyEntryDetailsNotAdded"));
			}finally {
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection=null;}catch (SQLException e) {}
				}
				
			}
	        
	    
	      
	        
	        	result = "success";
	        }
	       
	        return result;
	}


	@Override
	public void validate() 
	{
		
    	
		if(this.getEntryDate().equals("") || getEntryDate().equals("" ) )
		{
			addActionError(this.getText("message.error.plzprovideEntryDate"));
		}
		
		if(this.getVehicleId().equals("") || getVehicleId().equals("" ) )
		{
			addActionError(this.getText("message.error.plzSelectVehicle"));
		}
		
		
		
		
		this.setAddSideBarJs("FALSE");
		
		
	}
	
	
	public HttpSession getSession() {
		return session;
	}



	public void setSession(HttpSession session) {
		this.session = session;
	}




	public String getEntryDate() {
		return entryDate;
	}


	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}


	public String getVehicleId() {
		return vehicleId;
	}


	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}


	


	public File getPhoto1PDF() {
		return photo1PDF;
	}


	public void setPhoto1PDF(File photo1pdf) {
		photo1PDF = photo1pdf;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public float getVehicleEmptyWeight() {
		return vehicleEmptyWeight;
	}


	public void setVehicleEmptyWeight(float vehicleEmptyWeight) {
		this.vehicleEmptyWeight = vehicleEmptyWeight;
	}


	
	
	
	
	
	
	
	

}
