package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.update.UpdateProductStockDetails;
import com.stonecrusher.utils.GetProductStockByName;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class AddVehicleConsumptionEntry extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	private String productName;
	private Float quantity;
	private Float productRate;
	private Float amount;
	private String comments;
	private String entryDate;
	private String vehicleId;
	private String addSideBarJs;
	
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				String vehicleDetails [] = this.getVehicleId().split("-");
				String productDetails [] = this.getProductName().split("-");
				
        		String fullUserName = (String) this.getSessionMap().get("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String entryBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		entryBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		entryBy =fullUserName;
	        	}
	        	
	        	 java.util.Date date = new java.util.Date();
       	      long t = date.getTime();	        	     
       	      java.sql.Time time = new java.sql.Time(t);
	        	
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);

					sql = "SELECT "
							+ "vehicle_expense_entry_id "
							+ "FROM "
							+ "crusher_vehicle_consumption_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ "vehicle_expense_entry_id "
							+ "DESC LIMIT 1;";
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				int entryId = 1;
			
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						entryId = Integer.parseInt(resultSet.getString(1));
						entryId = entryId + 1;
						
					}
					
				}
				else
				{	entryId =1;
					
				}
				
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
					
					sql = "INSERT INTO "
							+ "crusher_vehicle_consumption_master "
							+ "("
							+ "vehicle_expense_entry_id,"
							+ "crusher_id,"
							+ "crusher_code,"
							+ "vehicle_id,"
							+ "consumption_date,"
							+ "consupmtion_time,"
							+ "consumption_product_id,"
							+ "consumption_product_name,"
							+ "quantity,"
							+ "product_rate,"
							+ "amount,"
							+ "entry_by,"
							+ "consupmtion_details) "
							+ "VALUES "
							+ "(?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?)";
					
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setInt(1, entryId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					preparedStatement.setString(4, vehicleDetails[0]);
					preparedStatement.setString(5, this.getEntryDate());
					preparedStatement.setTime(6, time);
					preparedStatement.setString(7, productDetails[0]);
					preparedStatement.setString(8, productDetails[1]);
					preparedStatement.setFloat(9, this.getQuantity());
					preparedStatement.setFloat(10, this.getProductRate());
					preparedStatement.setFloat(11, this.getAmount());
					preparedStatement.setString(12, entryBy);
					preparedStatement.setString(13, this.getComments().trim().toUpperCase() );
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						boolean stockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), productDetails[0], productDetails[1], this.getQuantity());
        	        	
						
						if(stockMinus)
						{
							
							if(productDetails[1].equals("DIESEL"))
							{
								
								float stockConversionRatio = 0.0F;
								PreparedStatement updateStockPSMT= null;
								
								sql = "SELECT "
										+ "in_stock_quantity,"
										+ "stock_conversion_ratio "
										+ "FROM "
										+ "crusher_product_master "
										+ "WHERE "
										+ "product_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								updateStockPSMT = connection.prepareStatement(sql);
								
								updateStockPSMT.setString(1, productDetails[0]);
								updateStockPSMT.setString(2, crusherId);
								updateStockPSMT.setString(3, crusherCode);
								
						
								resultSet = updateStockPSMT.executeQuery();
								
								if(resultSet.next())
								{
									stockConversionRatio = resultSet.getFloat(2);
								}
								
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								
								
							sql = "SELECT "
									+ "entry_id "
									+ "FROM "
									+ "diesel_credit_debit_master "
									+ "WHERE "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY "
									+ "entry_id "
									+ "DESC LIMIT 1;";
							
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						
						
						int dieselCreditDebitEntryId = 1;
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								dieselCreditDebitEntryId = Integer.parseInt(resultSet.getString(1));
								dieselCreditDebitEntryId = dieselCreditDebitEntryId + 1;
								
							}
							
						}
						else
						{	dieselCreditDebitEntryId =1;
							
						}
						
		        		
		        		
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		
							sql = "INSERT "
									+ "INTO "
									+ "diesel_credit_debit_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "product_id,"
									+ "product_name,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "quantity,"
									+ "entry_by,"
									+ "entry_details,"
									+ "entry_source) "
									+ "VALUES "
									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
							
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, dieselCreditDebitEntryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, productDetails[0]);
							preparedStatement.setString(5, productDetails[1]);
							preparedStatement.setString(6, this.getEntryDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, "DEBIT");
							preparedStatement.setFloat(9, (this.getQuantity() * stockConversionRatio));
							preparedStatement.setString(10, entryBy);
							preparedStatement.setString(11, "CONSUMPTION ENTRY ADDED FOR VEHICLE NO : "+vehicleDetails[2]+" AGAINST QUANTITY: "+(this.getQuantity() * stockConversionRatio));
							preparedStatement.setString(12, "ADD CONSUMPTION ENTRY ");
							
							
							int rowInsetred = preparedStatement.executeUpdate();
							boolean isCloseingBalMaintained = false;
							
							if(rowInsetred > 0)
							{
								 isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(productDetails[0], productDetails[1],"DEBIT", this.getEntryDate(), (this.getQuantity() * stockConversionRatio), entryBy, connection, this.getSessionMap());
								
							}
							
							
							if(isCloseingBalMaintained && rowInsetred > 0)
							{
								
								sql = "UPDATE "
        	        					+ "crusher_vehicle_consumption_master "
        	        					+ "SET "
        	        					+ "diesel_credit_debit_id = ? "
        	        					+ "WHERE "
    									+ "vehicle_expense_entry_id = ? "
    									+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
        	        			
        	        			
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, dieselCreditDebitEntryId);
	    						preparedStatement.setInt(2, entryId);
	    						preparedStatement.setString(3, crusherId);
	    		        		preparedStatement.setString(4, crusherCode);
	    		        		
	    					    preparedStatement.executeUpdate();
	        				
	    						
	    						
	    						
	    						
	    						
							}
							
							
							}
							
							
							
							if(productDetails[1].equals("ADBLUE") || productDetails[1].equals("DEF"))
							{
								
								float stockConversionRatio = 0.0F;
								PreparedStatement updateStockPSMT= null;
								
								sql = "SELECT "
										+ "in_stock_quantity,"
										+ "stock_conversion_ratio "
										+ "FROM "
										+ "crusher_product_master "
										+ "WHERE "
										+ "product_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								updateStockPSMT = connection.prepareStatement(sql);
								
								updateStockPSMT.setString(1, productDetails[0]);
								updateStockPSMT.setString(2, crusherId);
								updateStockPSMT.setString(3, crusherCode);
								
						
								resultSet = updateStockPSMT.executeQuery();
								
								if(resultSet.next())
								{
									stockConversionRatio = resultSet.getFloat(2);
								}
								
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								
								
							sql = "SELECT "
									+ "entry_id "
									+ "FROM "
									+ "adblue_credit_debit_master "
									+ "WHERE "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY "
									+ "entry_id "
									+ "DESC LIMIT 1;";
							
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						
						
						int adblueCreditDebitEntryId = 1;
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								adblueCreditDebitEntryId = Integer.parseInt(resultSet.getString(1));
								adblueCreditDebitEntryId = adblueCreditDebitEntryId + 1;
								
							}
							
						}
						else
						{	adblueCreditDebitEntryId =1;
							
						}
						
		        		
		        		
		        		if(resultSet != null)
		        		{
		        			resultSet.close();
		        			resultSet = null;
		        		}
		        		if(preparedStatement!= null)
		        		{
		        			preparedStatement.close();
		        			preparedStatement = null;
		        		}
		        		
		        		
							sql = "INSERT "
									+ "INTO "
									+ "adblue_credit_debit_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "product_id,"
									+ "product_name,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "quantity,"
									+ "entry_by,"
									+ "entry_details,"
									+ "entry_source) "
									+ "VALUES "
									+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
							
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setInt(1, adblueCreditDebitEntryId);
							preparedStatement.setString(2, crusherId);
			        		preparedStatement.setString(3, crusherCode);
			        		preparedStatement.setString(4, productDetails[0]);
							preparedStatement.setString(5, productDetails[1]);
							preparedStatement.setString(6, this.getEntryDate());
							preparedStatement.setTime(7, time);
							preparedStatement.setString(8, "DEBIT");
							preparedStatement.setFloat(9, (this.getQuantity() * stockConversionRatio));
							preparedStatement.setString(10, entryBy);
							preparedStatement.setString(11, "CONSUMPTION ENTRY ADDED FOR VEHICLE NO : "+vehicleDetails[2]+" AGAINST QUANTITY: "+(this.getQuantity() * stockConversionRatio));
							preparedStatement.setString(12, "ADD CONSUMPTION ENTRY ");
							
							
							int rowInsetred = preparedStatement.executeUpdate();
							boolean isCloseingBalMaintained = false;
							
							if(rowInsetred > 0)
							{
								 isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(productDetails[0], productDetails[1],"DEBIT", this.getEntryDate(), (this.getQuantity() * stockConversionRatio), entryBy, connection, this.getSessionMap());
								
							}
							
							
							if(isCloseingBalMaintained && rowInsetred > 0)
							{
								
								sql = "UPDATE "
        	        					+ "crusher_vehicle_consumption_master "
        	        					+ "SET "
        	        					+ "adblue_credit_debit_id = ? "
        	        					+ "WHERE "
    									+ "vehicle_expense_entry_id = ? "
    									+ "AND "
    									+ "crusher_id = ? "
    									+ "AND "
    									+ "crusher_code = ? ";
        	        			
        	        			
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, adblueCreditDebitEntryId);
	    						preparedStatement.setInt(2, entryId);
	    						preparedStatement.setString(3, crusherId);
	    		        		preparedStatement.setString(4, crusherCode);
	    		        		
	    					    preparedStatement.executeUpdate();
	        				
	    						
	    						
	    						
	    						
	    						
							}
							
							
							}
							
							
							connection.commit();
							
							result = SUCCESS;
							
							
							
							this.setVehicleId("");
							this.setProductName("");
							this.setQuantity(0.0f);
							this.setProductRate(0.0f);
							this.setAmount(0.0f);
							this.setComments("");
							
							
							addActionMessage(this.getText("message.success.vehicleConsumtionDetailsAddedSuccessfully"));
						}
						else
						{
							connection.rollback();
							result = ERROR;
							
							addActionError(this.getText("message.error.vehicleConsumtionDetailsNotAddedStockMaintainErrorPlzTryAgain"));
						}
					}
					
					//System.out.println(result);
					
				}
				catch (SQLException e) {
					//e.printStackTrace();
					result = "error";
					
					try {
						connection.rollback();
					} catch (SQLException e1) {}
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					//e.printStackTrace();
						result = "error";
						try {
							connection.rollback();
						} catch (SQLException e1) {}
						
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	
	@Override
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		if(this.getEntryDate() == null || this.getEntryDate().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectEntryDate"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getVehicleId() == null || this.getVehicleId().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
			}
			else
			{
				try
				{
					String [] vehicleDetails = this.getVehicleId().split("-");
					
					if(vehicleDetails.length <3)
					{
						addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
					}
				}
				catch (Exception e) {
					addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
				}
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getProductName() == null || this.getProductName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectProductName"));
			}
			else 
			{
				try
				{
					String [] productDetails = this.getProductName().split("-");
					
					if(productDetails.length != 2)
					{
						addActionError(this.getText("message.error.plzProvideCorrectProductName"));
					}
				}
				catch (Exception e) {
					
					addActionError(this.getText("message.error.plzProvideCorrectProductName"));
				}
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getQuantity() == null || this.getQuantity().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectQuantity"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getProductRate() == null || this.getProductName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectRate"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getAmount() == null || this.getAmount().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAmount"));
			}
		}
		
		if(!hasActionErrors())
    	{
    		
    			
			
    		try
    		{
    		String dbStockQuantity = GetProductStockByName.getProductStockByName(this.getProductName().split("-")[0],this.getSessionMap());
    		
    		
    		if(!dbStockQuantity.equals("NA"))
    		{
    			float dbStockQuantityFloat = Float.parseFloat(dbStockQuantity);
    			
    			if(dbStockQuantityFloat == 0 || dbStockQuantityFloat < 0)
    			{
    				addActionError(this.getText("message.error.quantityIsLess")+dbStockQuantity+this.getText("message.error.inStockOf")+this.getProductName()+this.getText("message.error.cannotEntry"));
    			}else
    			{
    				float saleProductQuantity =this.getQuantity();
    				
    				float diffToUpdateQuantity = dbStockQuantityFloat - saleProductQuantity;
    				
    				if(diffToUpdateQuantity < 0)
    				{
    					addActionError(this.getText("message.error.quantityIsLess")+dbStockQuantity+this.getText("message.error.inStockOf")+this.getProductName().split("-")[1]+this.getText("message.error.cannotSale"));
    				}
    			}
    			
    		}
    		else
    		{
    			addActionError(this.getText("message.error.errorWhileGettingDbStockQuanityOfProduct"));
    		}
    		
    		}catch(Exception e)
    		{
    			addActionError(this.getText("message.error.errorWhileGettingDbStockQuanityOfProduct"));
    		}
			
    		
    	}
    	
		
	}
	public String getProductName() {
		return productName;
	}




	public void setProductName(String productName) {
		this.productName = productName;
	}





	public Float getQuantity() {
		return quantity;
	}



	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}



	public Float getProductRate() {
		return productRate;
	}



	public void setProductRate(Float productRate) {
		this.productRate = productRate;
	}



	public Float getAmount() {
		return amount;
	}



	public void setAmount(Float amount) {
		this.amount = amount;
	}



	public String getComments() {
		return comments;
	}




	public void setComments(String comments) {
		this.comments = comments;
	}




	public String getEntryDate() {
		return entryDate;
	}




	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}




	public String getVehicleId() {
		return vehicleId;
	}




	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}




	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	

}



