package com.stonecrusher.add;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;

public class AddRMCProductToBill extends ActionSupport implements SessionAware,Serializable {

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4825693062711532803L;
	private HttpSession session;
	private String chalanNumber;
	private String billDateTime;
	private String operator;
	private String paymentType;
	private String customerName;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private String taxPercentage;
	private Float salesRate;
	private Float quantity;
	private Float discountPercentage;
	private Float discountRupees;
	private Float productAmount;
	private String billType;
	private Float amountAfterDiscount;
	private Float transportCharge;
	private String comments;
	private boolean sendSMS;
	private String alternateMobileNumber;
	private Float totalPaybleAmount;
	private SessionMap<String,Object> sessionMap;  
	private String amountPaid;
	
	private String billNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private List<BillProductInfoDAO> productInfoList ;
	private String defaultValue;
	
	private String totalAmount;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	private String amountPaid1;
	private String modeOfPayment1;
	
	private String removeVaules="false";
	
	private BillInformationDAO billInfoDAO = null;
	private BillVehicleInfoDAO billVehicleInfoDAO = null;
	
	private String viewBill;
	
	private boolean billSaved;
	
	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList2 = new ArrayList<String>();
	private String addSideBarJs;

	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	 private String discountType;
	 
		private Map<String,String> discountTypeList = new HashMap<String,String>();
		
		   private Float tenmm;
		   private Float twentymm;
		   private Float crushsand;
		   private Float washsand;
		   private Float water;
		   private Float addmixture;
		   private Float cementOPC;
		   private Float cementPPC;
		   
		   private Float pumpAmount;
		   private Float labourAmount;
	
   
					   
						  
						   
						  
					   
							
						   
						   
   
							
							  
   
   
   
 
	@SuppressWarnings("unchecked")
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
		    	
	    		session=ServletActionContext.getRequest().getSession(false); 
	    		
	    		
	    			
			
	        	productInfoList = (List<BillProductInfoDAO>) this.getSessionMap().get("RMCProductList");
	        	
	        	billInfoDAO = (BillInformationDAO) this.getSessionMap().get("RMCBillInformation");
	        	
	        	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("RMCBillvehicleinfo"));
				
	        	if(productInfoList == null)
	        	{
	        		productInfoList = new ArrayList<BillProductInfoDAO>();
	        	}
	        	
	        	
	        	
	        	if(this.getBillInfoDAO()==null)
	        	{
	        		this.setBillInfoDAO(new BillInformationDAO());
	        	}
	        
	        	if(this.getBillVehicleInfoDAO() == null)
	        	{
	        		this.setBillVehicleInfoDAO(new BillVehicleInfoDAO());
	        		
	        		
	        		String vDetails[] = this.getVehicleId().split("-");
	        		String vId = vDetails[0];
	        		String vMake = vDetails[1];
	        		String vNum = vDetails[2];
	        		
	        		this.getBillVehicleInfoDAO().setVehicleId(vId);
	        		this.getBillVehicleInfoDAO().setVehicleMake(vMake);
	        		this.getBillVehicleInfoDAO().setVehicleRCNumber(vNum);
	        		this.getBillVehicleInfoDAO().setKmStart(this.getKmStart());
	        		this.getBillVehicleInfoDAO().setKmEnd(this.getKmEnd());
	        		this.getBillVehicleInfoDAO().setTripFrom(this.getTripFrom());
	        		this.getBillVehicleInfoDAO().setTripTo(this.getTripTo());
	        		this.getBillVehicleInfoDAO().setTotalKM(this.getTotalKm());
	        		this.getBillVehicleInfoDAO().setTotalTrips(this.getTotalTrips());
	        	
	        		
	        		
	        		
	        	}
	        	this.getSessionMap().put("RMCBillvehicleinfo", this.getBillVehicleInfoDAO());
	        	
	        	
	        	
	        			
				
	        	BillProductInfoDAO billProductInfoDAO = new BillProductInfoDAO();
	        	
	        
	        	billProductInfoDAO.setProductId(this.getProductName().split("-")[0]);
	        	billProductInfoDAO.setProductName(this.getProductName().split("-")[1]);
        		billProductInfoDAO.setProductNameMarathi(getProductMarathiName());
	        	billProductInfoDAO.setSalesUnit(getSalesUnit());
	        	billProductInfoDAO.setTaxId(getTaxPercentage());
	        	billProductInfoDAO.setSalesRate(getSalesRate());
	        	billProductInfoDAO.setQuantity(getQuantity());
	        	billProductInfoDAO.setDiscountPecentage(getDiscountPercentage());
	        	billProductInfoDAO.setDiscountRupees(getDiscountRupees());
	        	billProductInfoDAO.setAmount(this.getProductAmount());
	        	
	        	billProductInfoDAO.setAlias(getAlias());
	        	billProductInfoDAO.setAddedToDB(false);
	        	billProductInfoDAO.setRateType(this.getRateType());
		  
	        	billProductInfoDAO.setTenmm(this.getTenmm());
	        	billProductInfoDAO.setTwentymm(this.getTwentymm());
	        	billProductInfoDAO.setWashsand(this.getWashsand());
	        	billProductInfoDAO.setCrushsand(this.getCrushsand());
	        	billProductInfoDAO.setAddmixture(this.getAddmixture());
	        	billProductInfoDAO.setWater(this.getWater());
	        	billProductInfoDAO.setCementOPC(this.getCementOPC());
	        	billProductInfoDAO.setCementPPC(this.getCementPPC());
	        	
	        	
	        	
	        	float totalOtherCharges = +this.getTransportCharge()+this.getLabourAmount()+this.getPumpAmount();
	        	
	        	float floatAmountAftDiscount = this.getAmountAfterDiscount() - totalOtherCharges;
	        	float totalProductDiscount = (this.getProductAmount()) - this.getAmountAfterDiscount();
	        	
	        	
	        	float sgst = 0.0F;
	        	float cgst = 0.0F;
	        	float igst = 0.0F;
	        	
				
				
				Map<String,String> taxInfo = GetListResource.GetTaxNamePercentage(this.getTaxPercentage());
	        	
				String taxName = taxInfo.get("TAX-NAME");
				String taxPercentage = taxInfo.get("TAX-PERCENTAGE");
				
				billProductInfoDAO.setTaxName(taxName);
				billProductInfoDAO.setTaxPercentage(taxPercentage);
				
				Float grossAmount = 0.0F;
				float totalTax = 0.0F;
				

				if(this.getBillType().equals("TAX-INVOICE"))
				{
					
					
					if(this.getRateType().equals("INCLUDINGGST"))
					{
						float floatTaxRate = Float.parseFloat(taxPercentage);
				
						float basicTax = floatTaxRate+100.0F;
			        	
						grossAmount = (floatAmountAftDiscount / basicTax) * 100.0F;
			        	
			        	 totalTax = floatAmountAftDiscount - grossAmount;
						
						if(taxName.toUpperCase().contains("IGST"))
						{
							igst = totalTax;
						}
						else
						{
							sgst = totalTax/2.0F;
				        	cgst = totalTax/2.0F;
						}
						 DecimalFormat df = new DecimalFormat("0.00");
				        	
					  	
			        	 billProductInfoDAO.setProductTotalDiscount(totalProductDiscount);
			        	 billProductInfoDAO.setGrossAmount(grossAmount);
			        	 billProductInfoDAO.setSgst(Float.parseFloat(df.format(sgst)));
			        	 billProductInfoDAO.setCgst(Float.parseFloat(df.format(cgst)));
			        	 billProductInfoDAO.setIgst(Float.parseFloat(df.format(igst)));
			        	 
			        	 billProductInfoDAO.setAmountAfterDiscount(this.getAmountAfterDiscount()-totalOtherCharges);
			        	
					}  	
		        	if(this.getRateType().equals("EXCLUDINGGST"))
	    			{
												  
																  
	  
	    	
		        	//	System.out.println("floatTaxRate : "+floatTaxRate);
						
						float floatTaxRate = Float.parseFloat(taxPercentage);	
						
						grossAmount = (this.getQuantity() * this.getSalesRate()) ;
			        	
						totalTax = floatAmountAftDiscount * (floatTaxRate/100.0F);
						
						if(taxName.toUpperCase().contains("IGST"))
						{
							igst = totalTax;
						}
						else
						{
							sgst = totalTax/2.0F;
				        	cgst = totalTax/2.0F;
						}
						
						 DecimalFormat df = new DecimalFormat("0.00");
				        	
			        	 billProductInfoDAO.setProductTotalDiscount(totalProductDiscount);
			        	 billProductInfoDAO.setGrossAmount(floatAmountAftDiscount);
			        	 billProductInfoDAO.setSgst(Float.parseFloat(df.format(sgst)));
			        	 billProductInfoDAO.setCgst(Float.parseFloat(df.format(cgst)));
			        	 billProductInfoDAO.setIgst(Float.parseFloat(df.format(igst)));
			        	
			        	 billProductInfoDAO.setAmountAfterDiscount((this.getAmountAfterDiscount()+totalTax)-totalOtherCharges);
	    			}
		        	
		        	 
				}
				else
				{

			    	
		        	//	System.out.println("floatTaxRate : "+floatTaxRate);
						
						float floatTaxRate = Float.parseFloat(taxPercentage);	
						
						
						totalTax = floatAmountAftDiscount * (floatTaxRate/100.0F);
						
						if(taxName.toUpperCase().contains("IGST"))
						{
							igst = totalTax;
						}
						else
						{
							sgst = totalTax/2.0F;
				        	cgst = totalTax/2.0F;
						}
						
						 DecimalFormat df = new DecimalFormat("0.00");
				        	
			        	 billProductInfoDAO.setProductTotalDiscount(totalProductDiscount);
			        	 billProductInfoDAO.setGrossAmount(floatAmountAftDiscount);
			        	 billProductInfoDAO.setSgst(Float.parseFloat(df.format(sgst)));
			        	 billProductInfoDAO.setCgst(Float.parseFloat(df.format(cgst)));
			        	 billProductInfoDAO.setIgst(Float.parseFloat(df.format(igst)));
			        	  
			        	
			        	 billProductInfoDAO.setAmountAfterDiscount(this.getAmountAfterDiscount()-totalOtherCharges);
			        	      
			        	
					
				}
	        	
				
				
				
	        	
	        	 this.getProductInfoList().add(billProductInfoDAO);
	        	
	        	float floatTotalAmount = 0.0F;
	        	float floatTotalDiscount = 0.0F;
	        	float floatTotalAmtAfterDiscount = 0.0F;
	        	
	        	
	        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
	        	{
	        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
	        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
	        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();	        		
	        	}
	        	
	        	
	        	this.getBillInfoDAO().setChalanNumber(this.getChalanNumber());
	        	this.getBillInfoDAO().setBillDate(this.getBillDateTime());
	        	this.getBillInfoDAO().setBillNumber(this.getBillNumber());	        	
        		this.getBillInfoDAO().setPaymentType(this.getPaymentType());
        		this.getBillInfoDAO().setBillType(this.getBillType());
        		this.getBillInfoDAO().setCustomerName(this.getCustomerName());        		
	        	this.getBillInfoDAO().setBillSaved(false);
	        	this.getBillInfoDAO().setSendSMS(sendSMS);
	        	this.getBillInfoDAO().setDiscountType(this.getDiscountType());
	        	
	        	
        		
	        	this.getBillInfoDAO().setVehicleId(this.getVehicleId());
        		this.getBillInfoDAO().setKmStart(this.getKmStart());
        		this.getBillInfoDAO().setKmEnd(this.getKmEnd());
        		this.getBillInfoDAO().setTripFrom(this.getTripFrom());
        		this.getBillInfoDAO().setTripTo(this.getTripTo());
        		this.getBillInfoDAO().setTotalKm(this.getTotalKm());
        		this.getBillInfoDAO().setTotalTrips(this.getTotalTrips());
        	
        		
	        	
	        	if(this.getBillInfoDAO().getTransportCharge() == null)
	        	{
	        		this.getBillInfoDAO().setTransportCharge(0.0F);
	        	}
	        	
		  
	        	this.getBillInfoDAO().setPumpAmount(this.getPumpAmount());
	        	this.getBillInfoDAO().setLabourAmount(this.getLabourAmount());
		  
	        	this.getBillInfoDAO().setTransportCharge(this.getTransportCharge());
	        	this.getBillInfoDAO().setComments(this.getComments());
	        	this.setBillSaved(false);
	        	
	        	String custMobNum  = "0";
	        	
	        	if(this.getBillInfoDAO().getCustomerMobile() == null || this.getBillInfoDAO().getCustomerMobile().equals(""))
	        	{
	        	
		        	String [] custData = new String[5];
		        	
		        	try
		        	{
		        		custData = this.getCustomerName().split("-");
		        		custMobNum = custData[2];
		        		if(!(custMobNum.length() == 10))
		        		{
		        			this.getBillInfoDAO().setSendSMS(false);
		        		}
		        		
		        	}
		        	catch(Exception e)
		        	{
		        		if(getAlternateMobileNumber().length()==10)
		        		{
		        			custMobNum = getAlternateMobileNumber();
		        			this.getBillInfoDAO().setSendSMS(true);
		        		}
		        		else
		        		{
		        			this.getBillInfoDAO().setSendSMS(false);
		        		}
		        	}
	        	this.getBillInfoDAO().setCustomerMobile(custMobNum.trim());
	        	}
	        	//System.out.println("view : "+viewBill);
	        	
	        	
	        	
       			
	        	float transportCharge = 0.0F;
	        	if(this.getTransportCharge() == null )
	        	{
	        		this.setTransportCharge(0.0F);
	        		
	        	}
	        	if(this.getTransportCharge() != null || !this.getTransportCharge().equals(""))
	        	{
	        		
	        		try
	        		{
	        			transportCharge = this.getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{
	        			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
	        		}
	        	}
	        	
	        	if(!hasActionErrors())
	        	{
	        		float totalBillAmt = floatTotalAmount + this.getBillInfoDAO().getTransportCharge() + this.getPumpAmount() + this.getLabourAmount();
		        	this.setTotalAmount(""+(totalBillAmt));	        	
		        	this.setTotalDiscount(""+floatTotalDiscount);
		        	this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge()+ this.getPumpAmount() + this.getLabourAmount()));
		        	this.
		        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
	        	}
	        	else
	        	{
	        		float totalBillAmt = floatTotalAmount + this.getBillInfoDAO().getTransportCharge() + this.getPumpAmount() + this.getLabourAmount();
	 		       
	        		this.setTotalAmount(""+(totalBillAmt));	        	
	        		this.setTotalDiscount(""+floatTotalDiscount);
	        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getBillInfoDAO().getTransportCharge()+ this.getPumpAmount() + this.getLabourAmount()));
		        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
	        	}
	        	removeVaules= "true";
	        	
	        	
	        	
	        	
	        	this.getSessionMap().put("RMCBillInformation", this.getBillInfoDAO());
	        	this.getSessionMap().put("RMCProductList",  this.getProductInfoList());
	        	
	        	
	        	result = SUCCESS;
	        	
	        	this.setProductName("");
	        	this.setProductMarathiName("");
	        	this.setQuantity(0.0F);
	        	this.setSalesRate(0.0F);
	        	this.setProductAmount(0.0F);
	        	this.setDiscountRupees(0.0F);
	        	this.setAmountAfterDiscount(0.0F);
	        	this.setTransportCharge(this.getBillInfoDAO().getTransportCharge());
	        	this.setSalesUnit("");
	        	//this.setTaxPercentage("");
	        
	        	this.setAmountPaid("0.0");
	        	this.setAmountPaid1("0.0");
	        }
	     
	        return result;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		
  
		this.setAddSideBarJs("FALSE");
		
		
		session=ServletActionContext.getRequest().getSession(false); 
		List<BillProductInfoDAO> productInfoListTest = (List<BillProductInfoDAO>) this.getSessionMap().get("RMCProductList");
		
		//String checkCustName = (String) sessionMap.get("checkCustName");
    	
    	
		paymentTypeList.put("CASH","CASH");
    	paymentTypeList.put("CREDIT","CREDIT");
    	
    	if(productInfoListTest == null)
    	{    	
    		this.setDefaultValue("CASH");
    	}
    	else
    	{
    		this.setDefaultValue(getPaymentType());
    	}
    	
    	
    	
    	

    	try {
			taxList = GetListResource.GetTaxList();
			
		} catch (IOException e) {
			
		}
    	
    	unitList = GetListResource.GetUnitList();
    	billTypeList = GetListResource.GetBillTypeList();
    	//setBillType(billTypeList.get("CASH-MEMO"));
    	
    	if(this.getCustomerName() == null || this.getProductName().equals("") 
				|| this.getSalesUnit().equals("") || this.getTaxPercentage().equals("") 
				|| this.getBillType().equals(""))
		{
			addActionError(this.getText("message.error.filedsMarkedWithAstrickAreMandetory1"));
		}
		if(!hasActionErrors())
		{
			
			if(this.getSalesRate() == null 
					|| this.getQuantity() == null 
					|| this.getDiscountPercentage() == null 
					|| this.getDiscountRupees() == null
					|| this.getProductAmount() ==null)
			{
				addActionError(this.getText("message.error.filedsMarkedWithAstrickAreMandetory2"));
			}
		}
		if(!hasActionErrors())
		{
			if(getCustomerName().equals("Customer_Not_Found"))
			{
				addActionError(this.getText("message.error.givenCustomerNameIsNotCorrect"));
			}
		}
		if(getCustomerName().equals("Customer_Not_Found"))
		{
			addActionError(this.getText("message.error.givenCustomerNameIsNotCorrect"));
		}
		
		if(this.getChalanNumber() == null || this.getChalanNumber().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideChalanNo"));
		}
		
		if(!hasActionErrors())
    	{
    		if(this.getVehicleId()!= null)
    		{
    			if(this.getVehicleId().equals(""))
    			{
    				addActionError(this.getText("message.error.plzSelectVehicle"));
    			}
    		}
    	}
    	
    	if(!hasActionErrors())
		{
			if(this.getKmEnd() == null || this.getKmEnd().equals(""))
			{
				addActionError(this.getText("message.error.plzprovideCorrectEndKm"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTotalKm() == null || this.getTotalKm().equals(""))
			{
				addActionError(this.getText("message.error.plzprovideCorrectTotalLm"));
			}
			else if(this.getTotalKm() <0 )
			{
				addActionError(this.getText("message.error.plzprovideCorrectTotalLm"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTripFrom().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideTripFromDetails"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTripTo().equals(""))
			{
				addActionError(this.getText("message.error.plzprovideTripToDetails"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getTotalTrips() == null || this.getTotalTrips().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectTotalTripFigure"));
			}
			else if(this.getTotalTrips() <= 0)
			{
				addActionError(this.getText("message.error.plzProvideCorrectTotalTripFigure"));
			}
				
		}
		
		if(!hasActionErrors())
		{

			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_eng", "NA", getProductName().split("-")[1]);
			
			isCustomerAdded = result[0];
			
			if(!isCustomerAdded.equals("true"))
			{
									 
	
									 
	
																																			 
	
								
	
									   
	 
				addActionError(this.getText("message.error.productNameGivenNotFoundPlzProvideCorrectProductName"));
	 
			}	
	
												 
	
			
		}
		/*
		 * billInfoDAO = (BillInformationDAO)
		 * this.getSessionMap().get("RMCBillInformation"); if(!hasActionErrors()) {
		 * if(this.getBillInfoDAO() == null) { String isChalanNumberAdded = "false";
		 * 
		 * String conddition = " AND bill_date >= '2023-04-01'";
		 * 
		 * 
		 * String [] result = new String[2];
		 * 
		 * result = new CheckAlreadyAvailable().checkAvaibility("crusher_rmc_billinfo",
		 * "chalan_number", conddition , this.getChalanNumber());
		 * 
		 * isChalanNumberAdded = result[0];
		 * 
		 * if(isChalanNumberAdded.equals("true")) {
		 * addActionError("This chalan number is already added! Please change chalan number!"
		 * ); } } if(this.getBillInfoDAO() != null &&
		 * this.getBillInfoDAO().getBillNumber().equals("NA")) { String
		 * isChalanNumberAdded = "false";
		 * 
		 * String conddition = " AND bill_date >= '2023-04-01'";
		 * 
		 * String [] result = new String[2];
		 * 
		 * result = new CheckAlreadyAvailable().checkAvaibility("crusher_rmc_billinfo",
		 * "chalan_number", conddition, this.getChalanNumber());
		 * 
		 * isChalanNumberAdded = result[0];
		 * 
		 * if(isChalanNumberAdded.equals("true")) {
		 * addActionError("This chalan number is already added! Please change chalan number!"
		 * ); } }
		 * 
		 * 
		 * }
		 */
						
   
																	
	
	
																			  
	
	
   
  
		
		if(!hasActionErrors())
		{
			if(this.getPumpAmount() == null)
			{
				addActionError("Please provide correct pump amount!");
			}
			else if(this.getPumpAmount() < 0)
			{
				addActionError("Please provide correct pump amount!");
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getLabourAmount() == null)
			{
				addActionError("Please provide correct Labour amount!");
			}
			else if(this.getLabourAmount() < 0)
			{
				addActionError("Please provide correct labour amount!");
			}
		}
		if(!hasActionErrors())
		{
			if(this.getSalesRate() == null || this.getSalesRate().equals(""))
			{
				
					addActionError(this.getText("message.error.plzProvideCorrectSalesRate"));
				
			}
		}
		
		
		 if ("TAX-INVOICE".equals(this.getBillType())) {
	  	        
		    	if(!hasActionErrors())
				{
				
		    		if(!this.getDiscountType().equals("By Quantity"))
	    			{
						
							addActionError(this.getText("message.error.modeOfBilltypeIsTaxInvoiceDiscountTypeShouldBeByQuantity"));
						
					}
				}
		    	}else {
		    		
		    		{
		    			
		    			if(this.getDiscountType() == null || this.getDiscountType().equals(""))
		    			{
		    				
		    					addActionError(this.getText("message.error.plzProvideDiscountType"));
		    				
		    			}
		    		}
		    		
		    	}
		 
		 
		
		if(!hasActionErrors())
		{
			//System.out.println(this.getQuantity());
			if(this.getQuantity() == null || this.getQuantity().equals(""))
			{
				
					addActionError(this.getText("message.error.plzprovideCorrectQuantity"));
				
			}
		}
		if(!hasActionErrors())
		{
			if(this.getDiscountPercentage() == null ||  this.getDiscountPercentage().equals(""))
			{
				
					addActionError(this.getText("message.error.plzProvideCorrectDiscountPercentage"));
				
			}
		}
		if(!hasActionErrors())
		{
			if(this.getDiscountRupees() == null || this.getDiscountRupees().equals(""))
			{
				
					addActionError(this.getText("message.error.plzprovideCorrectDiscountRupees"));
				
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getTenmm() == null )
			{
				addActionError("Please provide correct 10 MM quantity!");
			}
			else if(this.getTenmm() < 0)
			{
				addActionError("Please provide correct 10 MM quantity!");
			}
		}
		

	

		if(!hasActionErrors())
		{
			if(this.getTwentymm() == null )
			{
				addActionError("Please provide correct 20 MM quantity!");
			}
			else if(this.getTwentymm() < 0)
			{
				addActionError("Please provide correct 20 MM quantity!");
			}
		}
		

		if(!hasActionErrors())
		{
			if(this.getCrushsand() == null )
			{
				addActionError("Please provide correct CRUSH SAND quantity!");
			}
			else if(this.getCrushsand() < 0)
			{
				addActionError("Please provide correct CRUSH SAND quantity!");
			}
		}
		

		if(!hasActionErrors())
		{
			if(this.getWashsand() == null )
			{
				addActionError("Please provide correct WASH SAND quantity!");
			}
			else if(this.getWashsand() < 0)
			{
				addActionError("Please provide correct WASH SAND quantity!");
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getWater() == null )
			{
				addActionError("Please provide correct WATER quantity!");
			}
			else if(this.getWater() < 0)
			{
				addActionError("Please provide correct WATER quantity!");
			}
		}
		if(!hasActionErrors())
		{
			if(this.getAddmixture() == null )
			{
				addActionError("Please provide correct ADD MIXTURE quantity!");
			}
			else if(this.getAddmixture() < 0)
			{
				addActionError("Please provide correct ADD MIXTURE quantity!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getCementOPC() == null )
			{
				addActionError("Please provide correct CEMENT OPC quantity!");
			}
			else if(this.getCementOPC() < 0)
			{
				addActionError("Please provide correct CEMENT OPC quantity!");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getCementPPC() == null )
			{
				addActionError("Please provide correct CEMENT PPC quantity!");
			}
			else if(this.getCementPPC() < 0)
			{
				addActionError("Please provide correct CEMENT PPC quantity!");
			}
		}
		
		
		if(productInfoListTest !=null)
		{
			if(!productInfoListTest.isEmpty())
			{
				for(BillProductInfoDAO infoDAO:productInfoListTest)
				{
					
					
					if(infoDAO.getProductName().equals(this.productName))
					{
						addActionError(this.getText("message.error.productIsAlreadyAddedToList"));
						productInfoList = productInfoListTest;
					}
					
				}
			}
			else
			{
				productInfoList = productInfoListTest;
			}
		}
		
		
		
		float floatTotalAmount = 0.0F;
    	float floatTotalDiscount = 0.0F;
    	float floatTotalAmtAfterDiscount = 0.0F;
    	
    	if(productInfoList == null)
    	{
    		productInfoList = (List<BillProductInfoDAO>) session.getAttribute("RMCProductList");
    	}
    	
    	if(productInfoList !=null)
    	{
	    	for(BillProductInfoDAO infoDAO : productInfoList)
	    	{
	    		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
	    		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
	    		
	    		
	    	}
	    	floatTotalDiscount = floatTotalAmount - floatTotalAmtAfterDiscount;
	    	
	    	this.setTotalAmount(""+floatTotalAmount);
	    	this.setTotalDiscount(""+floatTotalDiscount);
	    	this.setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
    	}
    	if(getCustomerName().equals("Customer_Not_Found"))
    	{
    		addActionError(this.getText("message.error.plzProvideCorrectCustomerName"));
    	}
    	
    	if(!hasActionErrors())
    	{
    		if(getPaymentType().equals("CREDIT") && !getCustomerName().equals("Customer_Not_Found"))
    		{
    			setDefaultValue(getPaymentType());
    			String isCustomerAdded = "false";
    			String [] custData = new String [5];
    			try
    			{
	    			custData = getCustomerName().split("-");
	    			
	    			String [] result = new String[2];
	    			String condition  = " or mobile_number = '"+custData[2]+"' ";
	    			
	    			
	    			result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "customer_name", condition, custData[1]);
	    			
	    			isCustomerAdded = result[0];
	    			
	    			if(isCustomerAdded.equals("false"))
	    			{
	    				addActionError(this.getText("message.error.isPaymentIsCreditThenCustomerInformationAddedFirstPlzCheckCustomerDetailsFirst"));
	    			}
    			}
    			catch(Exception e)
    			{
    				addActionError(this.getText("message.error.ifPaymentIsCreditThenCustomerInformationAddedFirst"));
    			}
    					
    		}
    	}   
    	
		/*
		 * if ("TAX-INVOICE".equals(this.getBillType())) {
		 * 
		 * if(!hasActionErrors()) {
		 * 
	
		 * if(this.getPaymentType().equals("CREDIT")) {
		 * 
	  
		 * addActionError(this.getText(
		 * "message.error.modeOfBillTypeIsTaxInvoidePaymentTypeShouldBeCash"));
		 * 
		 * } } }
		 */
 	
    	 
    	
    	this.setAccountList(GetAccountListForDrCr.getAccountList((this.getSessionMap()))); 
		
    	this.setPaymentTypeList2(GetTypeOfPaymentList.getPaymentTypeList());
    	this.setModeOfPayment1("CASH");
    	
    	 discountTypeList.put("", "Select Discount Type");
	      discountTypeList.put("By Quantity", "By Quantity");
	      discountTypeList.put("By Percentage", "By Percentage");
	      discountTypeList.put("By Direct Amount", "By Direct Amount");
			
    	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
    	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
    	this.setRateTyprDefaultValue("INCLUDINGGST");
    	
    	
	}

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getBillDateTime() {
		return billDateTime;
	}


	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}


	public String getOperator() {
		return operator;
	}


	public void setOperator(String operator) {
		this.operator = operator;
	}


	public String getPaymentType() {
		return paymentType;
	}


	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}


	public String getCustomerName() {
		return customerName;
	}


	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}


	public String getAlias() {
		return alias;
	}


	public void setAlias(String alias) {
		this.alias = alias;
	}





	public String getSalesUnit() {
		return salesUnit;
	}

	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}

	

	public String getTaxPercentage() {
		return taxPercentage;
	}

	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}

	public Float getSalesRate() {
		return salesRate;
	}

	public void setSalesRate(Float salesRate) {
		this.salesRate = salesRate;
	}

	public Float getQuantity() {
		return quantity;
	}

	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}

	public Float getDiscountPercentage() {
		return discountPercentage;
	}

	public void setDiscountPercentage(Float discountPercentage) {
		this.discountPercentage = discountPercentage;
	}

	public Float getDiscountRupees() {
		return discountRupees;
	}

	public void setDiscountRupees(Float discountRupees) {
		this.discountRupees = discountRupees;
	}

 
 


								 
					 
  

												 
								 
  

									
						
	public Float getProductAmount() {
		return productAmount;
	}

	public void setProductAmount(Float productAmount) {
		this.productAmount = productAmount;
	}



										   
									   
  

	public void setAmountAfterDiscount(Float amountAfterDiscount) {
		this.amountAfterDiscount = amountAfterDiscount;
	}

	public void setTotalPaybleAmount(Float totalPaybleAmount) {
		this.totalPaybleAmount = totalPaybleAmount;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}

	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getProductMarathiName() {
		return productMarathiName;
	}

	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}

	
	public Float getAmountAfterDiscount() {
		return amountAfterDiscount;
	}

	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}

	public String getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getTotalDiscount() {
		return totalDiscount;
	}

	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}

	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}

	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}

	public String getRemoveVaules() {
		return removeVaules;
	}

	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}

	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}

	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	
	public Float getTransportCharge() {
		return transportCharge;
	}

	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getViewBill() {
		return viewBill;
	}

	public void setViewBill(String viewBill) {
		this.viewBill = viewBill;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}

	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}

	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}

	public boolean isBillSaved() {
		return billSaved;
	}

	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}

	public String getChalanNumber() {
		return chalanNumber;
	}

	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	

	public Float getTotalPaybleAmount() {
		return totalPaybleAmount;
	}

	public String getAmountPaid() {
		return amountPaid;
	}

	public void setAmountPaid(String amountPaid) {
		this.amountPaid = amountPaid;
	}

	public String getTripDate() {
		return tripDate;
	}

	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public Float getMaterialVolume() {
		return materialVolume;
	}

	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}

	public Float getKmStart() {
		return kmStart;
	}

	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}

	public Float getKmEnd() {
		return kmEnd;
	}

	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}

	public Float getTotalKm() {
		return totalKm;
	}

	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}

	public String getTripFrom() {
		return tripFrom;
	}

	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}

	public String getTripTo() {
		return tripTo;
	}

	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}


	public Integer getTotalTrips() {
		return totalTrips;
	}

	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}

	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}

	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}

	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}

	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}

	public String getRateType() {
		return rateType;
	}

	public void setRateType(String rateType) {
		this.rateType = rateType;
	}

	public String getDiscountType() {
		return discountType;
	}

	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}

	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}

	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}

	public Float getTenmm() {
		return tenmm;
	}

	public void setTenmm(Float tenmm) {
		this.tenmm = tenmm;
	}

	public Float getTwentymm() {
		return twentymm;
	}

	public void setTwentymm(Float twentymm) {
		this.twentymm = twentymm;
	}

	public Float getCrushsand() {
		return crushsand;
	}

	public void setCrushsand(Float crushsand) {
		this.crushsand = crushsand;
	}

 
	public Float getWashsand() {
		return washsand;
	}

	public void setWashsand(Float washsand) {
		this.washsand = washsand;
	}

	public Float getWater() {
		return water;
	}

	public void setWater(Float water) {
		this.water = water;
	}

	public Float getAddmixture() {
		return addmixture;
	}

	public void setAddmixture(Float addmixture) {
		this.addmixture = addmixture;
	}

	public Float getCementOPC() {
		return cementOPC;
	}

	public void setCementOPC(Float cementOPC) {
		this.cementOPC = cementOPC;
	}

	public Float getCementPPC() {
		return cementPPC;
	}

	public void setCementPPC(Float cementPPC) {
		this.cementPPC = cementPPC;
	}

	public Float getPumpAmount() {
		return pumpAmount;
	}

	public void setPumpAmount(Float pumpAmount) {
		this.pumpAmount = pumpAmount;
	}

	public Float getLabourAmount() {
		return labourAmount;
	}

	public void setLabourAmount(Float labourAmount) {
		this.labourAmount = labourAmount;
	}

	public String getAmountPaid1() {
		return amountPaid1;
	}

	public void setAmountPaid1(String amountPaid1) {
		this.amountPaid1 = amountPaid1;
	}

	public String getModeOfPayment1() {
		return modeOfPayment1;
	}

	public void setModeOfPayment1(String modeOfPayment1) {
		this.modeOfPayment1 = modeOfPayment1;
	}

	

	
	
	
	
	

}
