package com.stonecrusher.add;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.PurchaseInvoiceInformationDAO;
import com.stonecrusher.DAO.PurchaseProductInfoDAO;
import com.stonecrusher.resource.CheckInputCorrection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;



public class AddProductToPurchaseInvoice extends ActionSupport implements SessionAware,Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -5375687134990140583L;
	private SessionMap<String,Object> sessionMap;  
	private HttpSession session;
	private String paymentType;
	private String purchaseDateTime;
	private String productName;
	private Float amount;
	private Float quantity;
	private String purchaseUnit;
	private Float purchaseRate;
	private String taxId;
	private Float frightCharges;
	private Float otherExpense;
	private String purchaseId;
	private String supplierName;
	private String invoiceNumber;
	private String comments;
	private File invoiceImage;
	private Float amountPaid;
	private String invoiceImageContentType;
	private boolean addToStock;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO = null;
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private String paymentDefaultValue;
	private List<PurchaseProductInfoDAO> purchaseProductInfoList = null;
	private String purchaseBy;	
	
	private String viewPurchaseInvoice;
	
	private Float totalPurchaseAmount;
	
	private Float totalNettAmount;
	private Float totalCGST;
	private Float totalSGST;
	private Float totalIGST;
	

	
	private String addSideBarJs;
	private String accountId;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	
	private DecimalFormat df;
	private Float totalQuantity;
	
	private List<String> paymentTypeList2 = new ArrayList<String>();
	
	@SuppressWarnings("unchecked")
	public String execute() {
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	this.setTotalQuantity(0.0F);
	        	
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	       
	        	
	        	
	        	
	        	
	        	purchaseInvoiceInformationDAO = (PurchaseInvoiceInformationDAO) sessionMap.get("purchaseInformation");
	        	purchaseProductInfoList = (List<PurchaseProductInfoDAO>) sessionMap.get("purchaseProductList");
	        	
	        	if(purchaseInvoiceInformationDAO == null)
	        	{
	        		purchaseInvoiceInformationDAO = new PurchaseInvoiceInformationDAO();
	        	}
	        	
	        	if(purchaseProductInfoList == null)
	        	{
	        		purchaseProductInfoList = new ArrayList<PurchaseProductInfoDAO>();
	        	}
	        	
	        	PurchaseProductInfoDAO purchaseProductInfoDAO = new PurchaseProductInfoDAO();
	        	
	        	purchaseProductInfoDAO.setPurchaseId(this.getPurchaseId());
	        	purchaseProductInfoDAO.setProductId(this.getProductName().split("-")[0]);
	        	purchaseProductInfoDAO.setProductName(this.getProductName().split("-")[1]);
	        	purchaseProductInfoDAO.setPurchaseRate(this.getPurchaseRate());
	        	purchaseProductInfoDAO.setPurchaseUnit(this.getPurchaseUnit());
	        	purchaseProductInfoDAO.setQuantity(this.getQuantity());
	        	purchaseProductInfoDAO.setAmount(this.getAmount());
	        	purchaseProductInfoDAO.setTaxId(this.getTaxId());	        	
	        	purchaseProductInfoDAO.setAddedToDB(false);
	        	purchaseProductInfoDAO.setRateType(this.getRateType());
	        	
	        	
	        	

	        	float sgst = 0.0F;
	        	float cgst = 0.0F;
	        	float igst = 0.0F;
	        	
				
				
				Map<String,String> taxInfo = GetListResource.GetTaxNamePercentage(this.getTaxId());
	        	
				String taxName = taxInfo.get("TAX-NAME");
				String taxPercentage = taxInfo.get("TAX-PERCENTAGE");
	        	
				purchaseProductInfoDAO.setTaxName(taxName);
				purchaseProductInfoDAO.setTaxPercentage(Float.parseFloat(taxPercentage));
				
				if(this.getRateType().equals("INCLUDINGGST"))
				{
						
					float totalAmt = 0f;
							try
							{
								totalAmt = this.getPurchaseRate() * this.getQuantity();
								
							}catch(NumberFormatException nfe){}
			
							float floatTaxRate = Float.parseFloat(taxPercentage);	
							
							float basicTax = floatTaxRate+100.0F;
				        	
				        	float nettAmount = (totalAmt / basicTax) * 100.0F;
				        	
				        	float totalTax = totalAmt - nettAmount;
							
							if(taxName.toUpperCase().contains("IGST"))
							{
								igst = totalTax;
							}
							else
							{
								sgst = totalTax/2.0F;
					        	cgst = totalTax/2.0F;
							}    
				        	
				        	
				        	
							 purchaseProductInfoDAO.setNettAmount((float) (Math.round(nettAmount * 10) / 10.0));				        
				        	 purchaseProductInfoDAO.setSgst((float) (Math.round(sgst * 10) / 10.0));
				        	 purchaseProductInfoDAO.setCgst((float) (Math.round(cgst * 10) / 10.0));
				        	 purchaseProductInfoDAO.setIgst((float) (Math.round(igst * 10) / 10.0));
				        	 
				        	
				        	 
				        	 purchaseProductInfoDAO.setGrossAmount(totalAmt);
				       
				         	 this.getPurchaseProductInfoList().add(purchaseProductInfoDAO);
				        	
				}
				
				if(this.getRateType().equals("EXCLUDINGGST"))
				{
					
				
					float totalAmt = this.getPurchaseRate() * this.getQuantity();
				
					float floatTaxRate = Float.parseFloat(taxPercentage);	
					
		        	
		        	float totalTax = totalAmt * (floatTaxRate / 100.0F);
					
					if(taxName.toUpperCase().contains("IGST"))
					{
						igst = totalTax;
					}
					else
					{
						sgst = totalTax/2.0F;
			        	cgst = totalTax/2.0F;
					}    
		        	 
		        	
		        	 purchaseProductInfoDAO.setNettAmount((float) (Math.round(this.getAmount() * 10) / 10.0));
		        	 purchaseProductInfoDAO.setSgst((float) (Math.round(sgst * 10) / 10.0));
		        	 purchaseProductInfoDAO.setCgst((float) (Math.round(cgst * 10) / 10.0));
		        	 purchaseProductInfoDAO.setIgst((float) (Math.round(igst * 10) / 10.0));
		        	
		        	 
		        	
		        	 
		        	 purchaseProductInfoDAO.setGrossAmount(purchaseProductInfoDAO.getNettAmount()
		        			 +purchaseProductInfoDAO.getSgst()
		        			 +purchaseProductInfoDAO.getCgst()
		        			 +purchaseProductInfoDAO.getIgst());
		        	 
		        	 this.getPurchaseProductInfoList().add(purchaseProductInfoDAO);
		        	 
		        	 
		       
		        	
				}
				
	        	 
	        	 
	        	 float floatTotalPurchaseAmount = 0.0F;
	        	 float floatTotalCGST = 0.0F;
	        	 float floatTotalSGST = 0.0F;
	        	 float floatTotalIGST = 0.0F;
	        	 float floatTotalNettAmount = 0.0F;
	        	 
	        	 
	        	 for (PurchaseProductInfoDAO pProductInfoDAO : this.getPurchaseProductInfoList())
	        	 {
	        		
	        			
	        		 this.setTotalQuantity(pProductInfoDAO.getQuantity()+this.getTotalQuantity());
	        		 floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getGrossAmount();
	        		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
	        		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
	        		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
	        		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
	        	 }
	        	 
	        	 this.setTotalPurchaseAmount(floatTotalPurchaseAmount);
	        	 this.setTotalNettAmount(floatTotalNettAmount);
	        	 this.setTotalCGST(floatTotalCGST);
	        	 this.setTotalSGST(floatTotalSGST);
	        	 this.setTotalIGST(floatTotalIGST);
	        	 
	        	 if(getFrightCharges() != null)
	        	 {
		        	 if(getFrightCharges().equals(""))
		        	 {
		        		 setFrightCharges(0.0F);
		        	 }
	        	 }
	        	 if(getOtherExpense() != null)
	        	 {
		        	 if(getOtherExpense().equals(""))
		        	 {
		        		 setOtherExpense(0.0F);
		        	 }
	        	 }
	        	 
	        	 String [] supplierInfo = new String [5] ;
	        
	        	 try
	        	 {
	        		 supplierInfo = this.getSupplierName().split("-") ;
	        	 }catch(Exception e){}
	        	 
	        	
	        	 purchaseInvoiceInformationDAO.setPurchaseId(this.getPurchaseId());
	        	 purchaseInvoiceInformationDAO.setSupplierId(supplierInfo[0]);
	        	 purchaseInvoiceInformationDAO.setSupplierName(supplierInfo[1]);
	        	 purchaseInvoiceInformationDAO.setSupplierDetails(this.getSupplierName());
	        	 purchaseInvoiceInformationDAO.setInvoiceNumber(this.getInvoiceNumber());
	        	 purchaseInvoiceInformationDAO.setOtherExpense(this.getOtherExpense());
	        	 purchaseInvoiceInformationDAO.setFrightCharges(this.getFrightCharges());
	        	 purchaseInvoiceInformationDAO.setPurchaseTotalAmount(this.getTotalPurchaseAmount());
	        	 purchaseInvoiceInformationDAO.setInvoiceImage(this.getInvoiceImage());
	        	 purchaseInvoiceInformationDAO.setPurchaseDate(this.getPurchaseDateTime());
	        	 purchaseInvoiceInformationDAO.setTotalCGST(floatTotalCGST);
	        	 purchaseInvoiceInformationDAO.setTotalSGST(floatTotalSGST);
	        	 purchaseInvoiceInformationDAO.setTotalIGST(floatTotalIGST);
	        	 purchaseInvoiceInformationDAO.setTotalNettAmount(floatTotalNettAmount);
	        	 purchaseInvoiceInformationDAO.setPaymentType(this.getPaymentType());
	        	 purchaseInvoiceInformationDAO.setPurchaseSaved(false);	        	
	        	 purchaseInvoiceInformationDAO.setAddToStock(this.isAddToStock());
	        	 purchaseInvoiceInformationDAO.setPurchaseBy(this.getPurchaseBy());
	        	 
	        	 unitList = GetListResource.GetUnitList();
	        		this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
		       		
	        		
	        		this.setProductName("");
	        		this.setQuantity(0.0F);
	        		this.setPurchaseRate(0.0f);
	        		this.setAmount(0.0f);
		        	result = "success";
	        	
	        }
	        sessionMap.put("purchaseInformation", purchaseInvoiceInformationDAO);
        	sessionMap.put("purchaseProductList", purchaseProductInfoList);
        	
	        return result;
	}
	
	@SuppressWarnings("unlikely-arg-type")
	@Override
	public void validate() {
		
		this.setRateTyprDefaultValue(this.getRateType());
		
		this.setAddSideBarJs("FALSE");
		this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
   		
		paymentTypeList.put("CASH","CASH");
    	paymentTypeList.put("CREDIT","CREDIT");
    	this.setPaymentDefaultValue("CREDIT");
    	
    	paymentTypeList2.add("CASH");
    	paymentTypeList2.add("UPI");
    	paymentTypeList2.add("RTGS");
    	paymentTypeList2.add("NEFT");
    	
    	
		 df = new DecimalFormat("0.00");
		session=ServletActionContext.getRequest().getSession(false); 
		@SuppressWarnings("unchecked")
		List<PurchaseProductInfoDAO> purchaseProductInfoListTest = (List<PurchaseProductInfoDAO>) sessionMap.get("purchaseProductList");
		purchaseInvoiceInformationDAO = (PurchaseInvoiceInformationDAO) sessionMap.get("purchaseInformation");
		
		try {
			taxList = GetListResource.GetTaxList();
			
		} catch (IOException e) {
			
		}
    	
    	unitList = GetListResource.GetUnitList();
		
		if(getSupplierName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectSupplierName"));
		}
		if(!hasActionErrors())
		{
			if(getSupplierName().equals("Supplier_Not_Found"))
			{
				addActionError(this.getText("message.error.plzProvideCorrectSupplierName"));
			}
		}
		
		if(!getSupplierName().equals(""))
		{
			try
			{
				getSupplierName().split("-");
			}catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzProvideCorrectSupplierName"));
			}
		}
		if(getProductName().equals(""))
		{
			
		}
		else if(getInvoiceNumber().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectInvoiceNumber"));
		}
		
		else if(getPurchaseId().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectPurchaseUnit"));
		}
		
		else if(getPurchaseRate().equals(""))
		{
			addActionError(this.getText("message.error.plzProvidePurchaseRate"));
		}
		else if(getTaxId().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideTax"));
		}
		else if(getQuantity().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideQuantity"));
		}
		else if(this.getAmount().equals(""))
		{
			addActionError(this.getText("message.error.amountCannotBeBlank"));
		}
		if(!hasActionErrors())
		{
			boolean isSpecialCharsAddedtoInvoiceNumber = false;
			isSpecialCharsAddedtoInvoiceNumber = CheckInputCorrection.checkSpecialCharactersAdded(getInvoiceNumber());
			if(isSpecialCharsAddedtoInvoiceNumber)
			{
				addActionError(this.getText("invoiceNumberCannotHaveSpecialCharacters"));
			}
		}
		if(!hasActionErrors())
		{
			if(this.getQuantity()!=null || !this.getQuantity().equals(""))
			{
			
				
				try
				{
					
					
					if(this.getQuantity()<0)
					{
						addActionError(this.getText("quantityCannotBeLessThan0"));
					}
				}
				catch(NumberFormatException nfe)
				{
					addActionError(this.getText("message.error.plzProvideCorrectQuantity"));
				}
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(!this.getPurchaseRate().equals(""))
			{
				float purchaserate  = 0.0F;
				
				try
				{
					purchaserate = this.getPurchaseRate();
					
					if(purchaserate<0)
					{
						addActionError(this.getText("purchaseRateCannotBeLessThan0"));
					}
				}
				catch(NumberFormatException nfe)
				{
					addActionError(this.getText("plzProvideCorrectPurchaseRate"));
				}
			}
		}
		
		
		if(!hasActionErrors())
			
		{
			if(this.getInvoiceImage() != null)
			{
			
				if(!getInvoiceImageContentType().equals("image/jpeg"))
				{
					addActionError(this.getText("plzProvideOnlyJpegFileToUploadImage"));
				}
			}
		}
		
		
		
		
		
		if(purchaseProductInfoListTest !=null)
		{
			if(!purchaseProductInfoListTest.isEmpty())
			{
				for(PurchaseProductInfoDAO infoDAO:purchaseProductInfoListTest)
				{
					
					
					if(infoDAO.getProductName().equals(this.getProductName().split("-")[1]))
					{
						addActionError(this.getText("message.error.productIsAlreadyAddedToList"));
						purchaseProductInfoList = purchaseProductInfoListTest;
					}
					
				}
				
				
			}
			else
			{
				this.purchaseProductInfoList = purchaseProductInfoListTest;
			}
		}
		this.purchaseProductInfoList = purchaseProductInfoListTest;
		
		if(purchaseProductInfoList != null && purchaseProductInfoList.size()>0)
		{
		
		 float floatTotalPurchaseAmount = 0.0F;
    	 float floatTotalCGST = 0.0F;
    	 float floatTotalSGST = 0.0F;
    	 float floatTotalIGST = 0.0F;
    	 float floatTotalNettAmount = 0.0F;
    	 this.setTotalQuantity(0.0f);

    	 for (PurchaseProductInfoDAO pProductInfoDAO : this.getPurchaseProductInfoList())
    	 {
    		
    			
    		 this.setTotalQuantity(pProductInfoDAO.getQuantity()+this.getTotalQuantity());
    		 floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getGrossAmount();
    		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
    		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
    		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
    		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
    	 }
    	 
    	 if(this.getPaymentType().equals("CREDIT")){
    		 this.setAmountPaid(0.0F);
    	 }
    	this.setTotalPurchaseAmount(floatTotalPurchaseAmount);
    	this.setTotalNettAmount(floatTotalNettAmount);
    	this.setTotalCGST(floatTotalCGST);
    	this.setTotalSGST(floatTotalSGST);
    	this.setTotalIGST(floatTotalIGST);
		
    	 
    	this.setPurchaseId(purchaseInvoiceInformationDAO.getPurchaseId());
    	this.setInvoiceNumber(purchaseInvoiceInformationDAO.getInvoiceNumber());
    	purchaseInvoiceInformationDAO.setPurchaseSaved(false);
    	this.setAddToStock(purchaseInvoiceInformationDAO.isAddToStock());
    	 
		sessionMap.put("purchaseInformation", purchaseInvoiceInformationDAO);
    	sessionMap.put("purchaseProductList", purchaseProductInfoList);
	

		try {
			taxList = GetListResource.GetTaxList();
			
		} catch (IOException e) {
			
		}
    	
    	unitList = GetListResource.GetUnitList();
		}
		
		
    	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
    	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
    	this.setRateTyprDefaultValue("INCLUDINGGST");
	       
    	
    	
	}
	
	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}


	public String getPurchaseUnit() {
		return purchaseUnit;
	}

	public void setPurchaseUnit(String purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}

	

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public Float getQuantity() {
		return quantity;
	}

	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}

	public Float getPurchaseRate() {
		return purchaseRate;
	}

	public void setPurchaseRate(Float purchaseRate) {
		this.purchaseRate = purchaseRate;
	}

	public Float getFrightCharges() {
		return frightCharges;
	}

	public void setFrightCharges(Float frightCharges) {
		this.frightCharges = frightCharges;
	}

	public Float getOtherExpense() {
		return otherExpense;
	}

	public void setOtherExpense(Float otherExpense) {
		this.otherExpense = otherExpense;
	}

	public String getTaxId() {
		return taxId;
	}


	public void setTaxId(String taxId) {
		this.taxId = taxId;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public PurchaseInvoiceInformationDAO getPurchaseInvoiceInformationDAO() {
		return purchaseInvoiceInformationDAO;
	}


	public void setPurchaseInvoiceInformationDAO(PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO) {
		this.purchaseInvoiceInformationDAO = purchaseInvoiceInformationDAO;
	}


	public List<PurchaseProductInfoDAO> getPurchaseProductInfoList() {
		return purchaseProductInfoList;
	}


	public void setPurchaseProductInfoList(List<PurchaseProductInfoDAO> purchaseProductInfoList) {
		this.purchaseProductInfoList = purchaseProductInfoList;
	}


	public String getViewPurchaseInvoice() {
		return viewPurchaseInvoice;
	}


	public void setViewPurchaseInvoice(String viewPurchaseInvoice) {
		this.viewPurchaseInvoice = viewPurchaseInvoice;
	}



	
	public String getPurchaseId() {
		return purchaseId;
	}


	public void setPurchaseId(String purchaseId) {
		this.purchaseId = purchaseId;
	}


	public String getSupplierName() {
		return supplierName;
	}


	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}


	public String getInvoiceNumber() {
		return invoiceNumber;
	}


	public void setInvoiceNumber(String invoiceNumber) {
		this.invoiceNumber = invoiceNumber;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public File getInvoiceImage() {
		return invoiceImage;
	}


	public void setInvoiceImage(File invoiceImage) {
		this.invoiceImage = invoiceImage;
	}

	public String getInvoiceImageContentType() {
		return invoiceImageContentType;
	}

	public void setInvoiceImageContentType(String invoiceImageContentType) {
		this.invoiceImageContentType = invoiceImageContentType;
	}


	public Float getTotalPurchaseAmount() {
		return totalPurchaseAmount;
	}

	public void setTotalPurchaseAmount(Float totalPurchaseAmount) {
		this.totalPurchaseAmount = totalPurchaseAmount;
	}

	public Float getTotalNettAmount() {
		return totalNettAmount;
	}

	public void setTotalNettAmount(Float totalNettAmount) {
		this.totalNettAmount = totalNettAmount;
	}

	public Float getTotalCGST() {
		return totalCGST;
	}

	public void setTotalCGST(Float totalCGST) {
		this.totalCGST = totalCGST;
	}

	public Float getTotalSGST() {
		return totalSGST;
	}

	public void setTotalSGST(Float totalSGST) {
		this.totalSGST = totalSGST;
	}

	public Float getTotalIGST() {
		return totalIGST;
	}

	public void setTotalIGST(Float totalIGST) {
		this.totalIGST = totalIGST;
	}

	public boolean isAddToStock() {
		return addToStock;
	}

	public void setAddToStock(boolean addToStock) {
		this.addToStock = addToStock;
	}

	public String getPurchaseDateTime() {
		return purchaseDateTime;
	}

	public void setPurchaseDateTime(String purchaseDateTime) {
		this.purchaseDateTime = purchaseDateTime;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	
	public String getPaymentDefaultValue() {
		return paymentDefaultValue;
	}

	public void setPaymentDefaultValue(String paymentDefaultValue) {
		this.paymentDefaultValue = paymentDefaultValue;
	}

	public DecimalFormat getDf() {
		return df;
	}

	public void setDf(DecimalFormat df) {
		this.df = df;
	}

	public String getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}

	public Float getAmountPaid() {
		return amountPaid;
	}

	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}

	public String getPurchaseBy() {
		return purchaseBy;
	}

	public void setPurchaseBy(String purchaseBy) {
		this.purchaseBy = purchaseBy;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	

	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}

	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public String getRateType() {
		return rateType;
	}

	public void setRateType(String rateType) {
		this.rateType = rateType;
	}

	public Float getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}

	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}

	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}
	
	

}
