package com.stonecrusher.add;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.DAO.ChallanInfoDAO;
import com.stonecrusher.DAO.ChallanProductInfoDAO;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.resource.GetListResource;

public class AddProductToDeliveryChallanList extends ActionSupport implements SessionAware,Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5416864158386161538L;
	private String challanNumber;
	private String challanDateTime;
	private String paymentType;
	private String customerName;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private Float quantity;
	private String comments;
	private String alternateMobileNumber;
	private SessionMap<String,Object> sessionMap;
	
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private List<ChallanProductInfoDAO> challanProductInfoList ;
	private String defaultValue;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private BillVehicleInfoDAO billVehicleInfoDAO = null;
	
	private String removeVaules="false";
	
	private ChallanInfoDAO challanInfoDAO = null;
	
	private boolean viewChallan;
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private boolean challanSaved;
	private boolean sendSMS;
	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private String addSideBarJs;
	private String keyVehicle;
	private Float vehicleEmptyWeight;
	private Float grossWeight;
	private Boolean isFromVehicleEntryDetails ;
	

	private Float transportCharges;

	@SuppressWarnings("unchecked")
	public String execute() throws IOException{
		 
		String result = "login";
	
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    		String sql = "";
	    		String db = (String) this.getSessionMap().get("db");
	    		
	    		
	    			
			
	        	challanProductInfoList = (List<ChallanProductInfoDAO>) this.getSessionMap().get("challanProductList");
	        	
	        	challanInfoDAO = (ChallanInfoDAO) this.getSessionMap().get("challanInformation");
				

	        	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("challanVehicleinfo"));
				
	        	if(this.getBillVehicleInfoDAO() == null)
	        	{
	        		this.setBillVehicleInfoDAO(new BillVehicleInfoDAO());
	        		
	        		
	        		String vDetails[] = this.getVehicleId().split("-");
	        		String vId = vDetails[0];
	        		String vMake = vDetails[1];
	        		String vNum = vDetails[2];
	        		
	        		this.getBillVehicleInfoDAO().setProductId(this.getProductName().split("-")[0]);
	        		this.getBillVehicleInfoDAO().setProductName(this.getProductName().split("-")[1]);
	        		this.getBillVehicleInfoDAO().setProductQuantity(this.getQuantity());
	        		this.getBillVehicleInfoDAO().setVehicleId(vId);
	        		this.getBillVehicleInfoDAO().setVehicleMake(vMake);
	        		this.getBillVehicleInfoDAO().setVehicleRCNumber(vNum);
	        		this.getBillVehicleInfoDAO().setKmStart(this.getKmStart());
	        		this.getBillVehicleInfoDAO().setKmEnd(this.getKmEnd());
	        		this.getBillVehicleInfoDAO().setTripFrom(this.getTripFrom());
	        		this.getBillVehicleInfoDAO().setTripTo(this.getTripTo());
	        		this.getBillVehicleInfoDAO().setTotalKM(this.getTotalKm());
	        		this.getBillVehicleInfoDAO().setTotalTrips(this.getTotalTrips());
	        		this.getBillVehicleInfoDAO().setVehicleEmptyWeight(this.getVehicleEmptyWeight());
	        		this.getBillVehicleInfoDAO().setGrossWeight(this.getGrossWeight());
	       		
	        	}
	        	
	        	
	        	if(challanProductInfoList == null)
	        	{
	        		challanProductInfoList = new ArrayList<ChallanProductInfoDAO>();
	        	}
	        	
	        	if(this.getChallanInfoDAO()==null)
	        	{
	        		this.setChallanInfoDAO(new ChallanInfoDAO());
	        	}
	        
	        	
	        	
        		String vDetails[] = this.getVehicleId().split("-");
        		String vId = vDetails[0];
        		String vMake = vDetails[1];
        		String vNum = vDetails[2];
				
	        	ChallanProductInfoDAO productInfoDAO = new ChallanProductInfoDAO();
	        	
	        
	        	productInfoDAO.setProductId(this.getProductName().split("-")[0]);
	        	productInfoDAO.setProductName(this.getProductName().split("-")[1]);
	        	productInfoDAO.setProductNameMarathi(this.getProductMarathiName());
	        	productInfoDAO.setSalesUnit(this.getSalesUnit());
	        	productInfoDAO.setQuantity(this.getQuantity());
	        	productInfoDAO.setAlias(this.getAlias());
	        	productInfoDAO.setAddedToDB(false);
	        	productInfoDAO.setVehicleEmptyWeight(this.getVehicleEmptyWeight());
	        	productInfoDAO.setGrossWeight(this.getGrossWeight());
	        
	        	 this.getChallanProductInfoList().add(productInfoDAO);
	        	
	      	
	        
	        	this.getChallanInfoDAO().setChallanNumber(this.getChallanNumber());
	        	this.getChallanInfoDAO().setChallanDate(this.getChallanDateTime());	
        		this.getChallanInfoDAO().setPaymentType(this.getPaymentType());
        		this.getChallanInfoDAO().setCustomerName(this.getCustomerName());        		
	        	this.getChallanInfoDAO().setChallanSaved(false);
	        	this.getChallanInfoDAO().setSendSMS(this.isSendSMS());
	        	this.getChallanInfoDAO().setCustomerAllDetails(this.getCustomerName());
	        	this.getChallanInfoDAO().setCustomerId(this.getCustomerName().split("-")[0]);
	        	this.getChallanInfoDAO().setCustomerName(this.getCustomerName().split("-")[1]);
	        	this.getChallanInfoDAO().setVehicleAllDetails(this.getVehicleId());
	        	this.getChallanInfoDAO().setVehicleId(vId);
        		this.getChallanInfoDAO().setVehicleRegNumber(vNum);
        		this.getChallanInfoDAO().setKmStart(this.getKmStart());
        		this.getChallanInfoDAO().setKmEnd(this.getKmEnd());
        		this.getChallanInfoDAO().setTripFrom(this.getTripFrom());
        		this.getChallanInfoDAO().setTripTo(this.getTripTo());
        		this.getChallanInfoDAO().setTotalKm(this.getTotalKm());
        		this.getChallanInfoDAO().setTotalTripCount(this.getTotalTrips());
	        	this.getChallanInfoDAO().setTransportCharges(0.0F);
	        	this.getChallanInfoDAO().setComments(this.getComments().trim().toUpperCase());
	        	this.getChallanInfoDAO().setChallanSaved(false);
	        	this.getChallanInfoDAO().setPaymentType(this.getPaymentType());
	        	this.setChallanSaved(false);
	        	
	       	
	        
	        	//System.out.println("view : "+viewBill);
	        	
	        	
	        	try
    			{

					connection = GetDBConnection.getDBConnection(db);
	    			
	    			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "vehicle_details_master "
	    					+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();


	    			while(resultSet.next())
	    			{
	    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
	    			}
	    			
	    		
	       		
    			}
    			catch (SQLException e) {
					// TODO: handle exception
				}
    			finally
    			{
    				if(resultSet != null)
    				{
    					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
    				}
        			if(preparedStatement != null)
        			{
        				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
        			}
        			if(connection != null)
        			{
        				
        				try {connection.close(); connection = null;}catch (SQLException e) {}
        			}
    			}
        	
       			
       			
	        	
	        	
	        	
	        	removeVaules= "true";
	        	
	        	
	        	
	        	
	        	this.getSessionMap().put("challanInformation", this.getChallanInfoDAO());
	        	this.getSessionMap().put("challanProductList",  this.getChallanProductInfoList());
	        	this.getSessionMap().put("challanVehicleinfo", this.getBillVehicleInfoDAO());
	        	
	        	
	        	result = SUCCESS;
	        	
	        	this.setProductName("");
	        	this.setProductMarathiName("");
	        	this.setQuantity(0.0F);
	        	this.setTransportCharges(this.getChallanInfoDAO().getTransportCharges());
	        	this.setSalesUnit("");
	       	//this.setTaxPercentage("");
	        }
	      return result;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		this.setAddSideBarJs("FALSE");

    	unitList = GetListResource.GetUnitList();
    	List<ChallanProductInfoDAO> productInfoListTest = (List<ChallanProductInfoDAO>) this.getSessionMap().get("challanProductList");
		
		//String checkCustName = (String) sessionMap.get("checkCustName");
    	
    	
		paymentTypeList.put("CASH","CASH");
    	paymentTypeList.put("CREDIT","CREDIT");
    	
    	if(productInfoListTest == null)
    	{    	
    		this.setDefaultValue("CASH");
    	}
    	else
    	{
    		this.setDefaultValue(getPaymentType());
    	}
    	
    	
    	
    
    	
   	//setBillType(billTypeList.get("CASH-MEMO"));
    	
    	if(this.getCustomerName() == null || this.getProductName().equals("") || this.getSalesUnit().equals(""))
		{
			addActionError(this.getText("message.error.filedsMarkedWithAstrickAreMandetory1"));
		}
		if(!hasActionErrors())
		{
			
			if(this.getQuantity() == null )
			{
				addActionError(this.getText("message.error.plzProvideQuantity"));
			}
		}
		if(!hasActionErrors())
		{
			if(getCustomerName().equals("Customer_Not_Found"))
			{
				addActionError(this.getText("message.error.givenCustomerNameIsNotCorrect"));
			}
		}
		if(getCustomerName().equals("Customer_Not_Found"))
		{
			addActionError(this.getText("message.error.givenCustomerNameIsNotCorrect"));
		}
		
		if(this.getChallanNumber() == null || this.getChallanNumber().equals(""))
		{
			this.setChallanNumber("NA");
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getCustomerName().split("-").length <3)
			{
				addActionError(this.getText("message.error.plzProvideCorrectCustomerName"));
			}
		}
		if(!hasActionErrors())
		{
			if(this.getVehicleId().split("-").length < 3)
			{
				addActionError(this.getText("message.error.plzProvideCorrectVehicleDetails"));
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getProductName().split("-").length <2)
			{
				addActionError(this.getText("message.error.givenCustomerNameIsNotCorrect"));
			}
		}
		
		if(!hasActionErrors())
		{

			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_eng", "NA", getProductName().split("-")[1]);
			
			isCustomerAdded = result[0];
			
			if(!isCustomerAdded.equals("true"))
			{
				addActionError(this.getText("message.error.productNameGivenNotFoundPlzProvideCorrectProductName"));
			}	
			
		}
		if(!hasActionErrors())
		{

			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_delivery_challan_master", "challan_number_str", "NA", getChallanNumber());
			
			isCustomerAdded = result[0];
			
			if(isCustomerAdded.equals("true"))
			{
				addActionError(this.getText("message.error.chalanNoIsAddedAlreadyPlzUseDifferentChalanNo"));
			}	
			
		}
		
		
		if(!hasActionErrors())
		{
			//System.out.println(this.getQuantity());
			if(this.getQuantity() == null || this.getQuantity().equals(""))
			{
				
					addActionError(this.getText("message.error.plzProvideCorrectQuantity"));
				
			}else if(this.getQuantity() <= 0.0)
			{
				addActionError(this.getText("message.error.plzProvideCorrectQuantity"));
			}
		}
	
		
		
		if(productInfoListTest !=null)
		{
			if(!productInfoListTest.isEmpty())
			{
				for(ChallanProductInfoDAO infoDAO:productInfoListTest)
				{
					
					if(infoDAO.getProductName().equals(this.getProductName().split("-")[1]))
					{
						addActionError(this.getText("message.error.productIsAlreadyAddedToList"));
						challanProductInfoList = productInfoListTest;
					}
					
				}
			}
			else
			{
				challanProductInfoList = productInfoListTest;
			}
		}
		
		
	
    	if(challanProductInfoList == null)
    	{
    		challanProductInfoList = (List<ChallanProductInfoDAO>) this.getSessionMap().get("challanProductList");
    	}
    	
    	
    	if(getCustomerName().equals("Customer_Not_Found"))
    	{
    		addActionError(this.getText("message.error.plzProvideCorrectCustomerName"));
    	}
    	
    	if(!hasActionErrors())
    	{
    		if(this.getPaymentType().equals("CREDIT") && !getCustomerName().equals("Customer_Not_Found"))
    		{
    			setDefaultValue(getPaymentType());
    			String isCustomerAdded = "false";
    			String [] custData = new String [5];
    			try
    			{
	    			custData = getCustomerName().split("-");
	    			
	    			String [] result = new String[2];
	    			String condition  = " or mobile_number = '"+custData[2]+"' ";
	    			
	    			
	    			result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "customer_name", condition, custData[1]);
	    			
	    			isCustomerAdded = result[0];
	    			
	    			if(isCustomerAdded.equals("false"))
	    			{
	    				addActionError(this.getText("message.error.isPaymentIsCreditThenCustomerInformationAddedFirstPlzCheckCustomerDetailsFirst"));
	    			}
    			}
    			catch(Exception e)
    			{
    				addActionError(this.getText("message.error.ifPaymentIsCreditThenCustomerInformationAddedFirst"));
    			}
    					
    		}
    	}
    	
    	
    	
    	
	}



	public String getPaymentType() {
		return paymentType;
	}


	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}


	public String getCustomerName() {
		return customerName;
	}


	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}


	public String getAlias() {
		return alias;
	}


	public void setAlias(String alias) {
		this.alias = alias;
	}





	public String getSalesUnit() {
		return salesUnit;
	}

	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}

	
	public Float getQuantity() {
		return quantity;
	}

	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}


	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	
	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getProductMarathiName() {
		return productMarathiName;
	}

	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}

	

	public String getRemoveVaules() {
		return removeVaules;
	}

	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}

	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}


	public boolean isChallanSaved() {
		return challanSaved;
	}

	public void setChallanSaved(boolean challanSaved) {
		this.challanSaved = challanSaved;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	

	public Map<String, String> getVehicleList() {
		return vehicleList;
	}

	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}

	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}

	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}

	public String getTripDate() {
		return tripDate;
	}

	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public Float getMaterialVolume() {
		return materialVolume;
	}

	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}

	public Float getKmStart() {
		return kmStart;
	}

	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}

	public Float getKmEnd() {
		return kmEnd;
	}

	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}

	public Float getTotalKm() {
		return totalKm;
	}

	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}

	public String getTripFrom() {
		return tripFrom;
	}

	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}

	public String getTripTo() {
		return tripTo;
	}

	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}

	public Integer getTotalTrips() {
		return totalTrips;
	}

	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}

	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}

	public String getChallanNumber() {
		return challanNumber;
	}

	public void setChallanNumber(String challanNumber) {
		this.challanNumber = challanNumber;
	}

	public String getChallanDateTime() {
		return challanDateTime;
	}

	public void setChallanDateTime(String challanDateTime) {
		this.challanDateTime = challanDateTime;
	}

	public List<ChallanProductInfoDAO> getChallanProductInfoList() {
		return challanProductInfoList;
	}

	public void setChallanProductInfoList(List<ChallanProductInfoDAO> challanProductInfoList) {
		this.challanProductInfoList = challanProductInfoList;
	}

	public ChallanInfoDAO getChallanInfoDAO() {
		return challanInfoDAO;
	}

	public void setChallanInfoDAO(ChallanInfoDAO challanInfoDAO) {
		this.challanInfoDAO = challanInfoDAO;
	}

	

	public boolean isViewChallan() {
		return viewChallan;
	}

	public void setViewChallan(boolean viewChallan) {
		this.viewChallan = viewChallan;
	}

	public Float getTransportCharges() {
		return transportCharges;
	}

	public void setTransportCharges(Float transportCharges) {
		this.transportCharges = transportCharges;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public String getKeyVehicle() {
		return keyVehicle;
	}

	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}

	public Float getVehicleEmptyWeight() {
		return vehicleEmptyWeight;
	}

	public void setVehicleEmptyWeight(Float vehicleEmptyWeight) {
		this.vehicleEmptyWeight = vehicleEmptyWeight;
	}

	public Float getGrossWeight() {
		return grossWeight;
	}

	public void setGrossWeight(Float grossWeight) {
		this.grossWeight = grossWeight;
	}

	public Boolean getIsFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}

	public void setIsFromVehicleEntryDetails(Boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}

	

}

