package com.stonecrusher.add;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class AddNewVehicle extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3861179817044789970L;
	private HttpSession session;
	private String vehicleMake;
	private String vehicleRegistrationNumber;
	private String vehicleOwnerName;
	private String ownerMobileNumber;
	private String vehicleDriverName;
	private String driverMobileNumber;
	private String insuranceCompanyName;
	private String insuranceContactNumber;
	private String insuranceStartDate;
	private String insuranceEndDate;
	private String taxReceiptStartDate;
	private String taxReceiptEndDate;
	private String rtoPassingStartDate;
	private String rtoPassingEndDate;
	
	private String pucPassingStartDate;
	private String pucPassingEndDate;
	private File pucPassingPDF;
	private File gpsCertificatePDF;
	
	private File insurancePDF;
	private File taxReceiptPDF;
	private File rtoPassingPDF;
	private String addSideBarJs;
	private Float carryingCapacityCUM;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private SessionMap<String,Object> sessionMap;  
	
	private Float carryingCapacityBrass;
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				
				String sql = "";
				
				String db = (String) session.getAttribute("db");
				
			
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						int rowAdded = 0;
						
						
						FileInputStream insuranceFileFis  = null;
						FileInputStream taxReceiptFileFis  = null;
						FileInputStream rtoPassingFileFis = null;
						FileInputStream pucPassingFileFis = null;
						FileInputStream gpsCertificateFileFis = null;
						if(this.getInsurancePDF() != null)
						{
							insuranceFileFis =  new FileInputStream(this.getInsurancePDF());
						}
						if(this.getTaxReceiptPDF() != null)
						{
							taxReceiptFileFis =  new FileInputStream(this.getTaxReceiptPDF());
						}
						
						if(this.getRtoPassingPDF() != null)
						{
							rtoPassingFileFis =  new FileInputStream(this.getRtoPassingPDF());
						}
						if(this.getPucPassingPDF() != null)
						{
							pucPassingFileFis = new FileInputStream(this.getPucPassingPDF());
						}
						if(this.getGpsCertificatePDF() != null)
						{
							gpsCertificateFileFis = new FileInputStream(this.getGpsCertificatePDF());
						}
						
						
						
						sql = "SELECT "
								+ "vehicle_id "
								+ "FROM "
								+ "crusher_vehicle_details_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "vehicle_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int vehicleId = 0;
					
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							vehicleId = Integer.parseInt(resultSet.getString(1));
							vehicleId = vehicleId + 1;
							
						}
						
					}
					else
					{	vehicleId =1;
						
					}
					
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
						
						
						sql = "INSERT "
								+ "INTO "
								+ "crusher_vehicle_details_master "
								+ "("
								+ "vehicle_id,"
								+ "crusher_id,"
								+ "crusher_code,"
								+ "vehicle_make,"
								+ "vehicle_registration_number,"
								+ "owner_name,"
								+ "owner_mobile_number,"
								+ "driver_name,"
								+ "driver_mobile_number,"
								+ "vehicle_insurance_name,"
								+ "vehicle_insurance_company_contact,"
								+ "insurance_start_date,"
								+ "insurance_end_date,"
								+ "tax_receipt_start_date,"
								+ "tax_receipt_end_date,"
								+ "rto_passing_start_date,"
								+ "rto_passing_end_date,"
								+ "puc_passing_start_date,"
								+ "puc_passing_end_date,"
								+ "brass_quantity,"
								+ "cum_quantity)"
								+ "VALUES "
								+ "(?,?,?,?,?,?,?,?,?,?,?,"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "STR_TO_DATE(?, '%d-%m-%Y'),"
								+ "?,?)";

						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setInt(1, vehicleId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						preparedStatement.setString(4, this.getVehicleMake().trim().toUpperCase());
						preparedStatement.setString(5, this.getVehicleRegistrationNumber().trim().toUpperCase());
						preparedStatement.setString(6, this.getVehicleOwnerName());
						preparedStatement.setString(7, this.getOwnerMobileNumber());
						preparedStatement.setString(8, this.getVehicleDriverName());
						preparedStatement.setString(9, this.getDriverMobileNumber());
						if (this.getInsuranceCompanyName() == null || this.getInsuranceCompanyName().trim().isEmpty()) {
						    preparedStatement.setNull(10, java.sql.Types.VARCHAR);
						} else {
						    preparedStatement.setString(10, this.getInsuranceCompanyName().trim().toUpperCase());
						}

					
						if (this.getInsuranceContactNumber() == null || this.getInsuranceContactNumber().trim().isEmpty()) {
						    preparedStatement.setNull(11, java.sql.Types.VARCHAR);
						} else {
						    preparedStatement.setString(11, this.getInsuranceContactNumber());
						}
						
						
						if (this.getInsuranceStartDate() == null || this.getInsuranceStartDate().isEmpty()) {
						    preparedStatement.setNull(12, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(12, this.getInsuranceStartDate());
						}

						if (this.getInsuranceEndDate() == null || this.getInsuranceEndDate().isEmpty()) {
						    preparedStatement.setNull(13, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(13, this.getInsuranceEndDate());
						}

						
						if (this.getTaxReceiptStartDate() == null || this.getTaxReceiptStartDate().isEmpty()) {
						    preparedStatement.setNull(14, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(14, this.getTaxReceiptStartDate());
						}

						if (this.getTaxReceiptEndDate() == null || this.getTaxReceiptEndDate().isEmpty()) {
						    preparedStatement.setNull(15, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(15, this.getTaxReceiptEndDate());
						}

						// Handling null for RTO passing start and end dates
						if (this.getRtoPassingStartDate() == null || this.getRtoPassingStartDate().isEmpty()) {
						    preparedStatement.setNull(16, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(16, this.getRtoPassingStartDate());
						}

						if (this.getRtoPassingEndDate() == null || this.getRtoPassingEndDate().isEmpty()) {
						    preparedStatement.setNull(17, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(17, this.getRtoPassingEndDate());
						}
						
						
						if (this.getPucPassingStartDate() == null || this.getPucPassingStartDate().isEmpty()) {
						    preparedStatement.setNull(18, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(18, this.getPucPassingStartDate());
						}

						if (this.getPucPassingEndDate() == null || this.getPucPassingEndDate().isEmpty()) {
						    preparedStatement.setNull(19, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(19, this.getPucPassingEndDate());
						}
						
						
                      preparedStatement.setFloat(20, this.getCarryingCapacityBrass());
						preparedStatement.setFloat(21, this.getCarryingCapacityCUM());
						
						//preparedStatement.setBinaryStream(9, insuranceFileFis,(int)this.getInsurancePDF().length() );
					
						
						rowAdded = preparedStatement.executeUpdate();
						
						
						if(rowAdded > 0 )
						{
							if(this.getInsurancePDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								
								
									
								
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "insurance_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, insuranceFileFis,(int)this.getInsurancePDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							if(this.getTaxReceiptPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "tax_receipt_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, taxReceiptFileFis,(int)this.getTaxReceiptPDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							if(this.getRtoPassingPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "rto_passing_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, rtoPassingFileFis,(int)this.getRtoPassingPDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							
							
							if(this.getPucPassingPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "puc_passing_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, pucPassingFileFis,(int)this.getPucPassingPDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							
						
							
							
							if(this.getGpsCertificatePDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "gps_certificate_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, gpsCertificateFileFis,(int)this.getGpsCertificatePDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							
								result = "success";
								addActionMessage(this.getText("message.success.vehicleDetailsAddedSuccessfully"));
							
							
							
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.unableToAddVehicleDetailsPlzTryAgain"));
						}
						
						if(insuranceFileFis != null)
			        	{
							insuranceFileFis.close();
							insuranceFileFis = null;
			        	}
						
						if(taxReceiptFileFis != null)
			        	{
							taxReceiptFileFis.close();
							taxReceiptFileFis = null;
			        	}
						

						if(rtoPassingFileFis != null)
			        	{
							rtoPassingFileFis.close();
							rtoPassingFileFis = null;
			        	}
						
					}catch (SQLException e) {
						result = "error";
						e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.vehicleDetailsNotAdded"));
					} catch (Exception e) {
						//e.printStackTrace();
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.vehicleDetailsNotAdded"));
					}finally {
						
						if(preparedStatement != null)
						{
							try {preparedStatement.close();} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();}catch (SQLException e) {}
						}
						
					}
	        	
					
	        	
	        }
	        
	        customerSearchOptionList.put("BYNAME", "BY NAME");
        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
			setCustomerSearchOption("BYNAME");
			setDefaultValue("BYNAME");
	        
	        return result;
	}
	
	@Override
	public void validate() {
		
		
		if(this.getVehicleMake().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideVehicleMake"));
		}
		if(!hasActionErrors())
		{
			if(this.getVehicleRegistrationNumber().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideVehicleRegistrationNumber"));
			}
		}
		
		/*
		 * if(!hasActionErrors()) { if(this.getInsuranceCompanyName().equals("")) {
		 * addActionError("Please provide insurance company name!"); } }
		 */
		
		/*
		 * if(!hasActionErrors()) { if(this.getInsuranceContactNumber().equals("")) {
		 * addActionError("Please provide insurance comapny contact number!"); } }
		 */
		
		/*
		 * if(!hasActionErrors()){ if(this.getInsuranceStartDate().equals("") ||
		 * this.getInsuranceEndDate().equals("")) {
		 * addActionError("Please provide insurance start and end date!"); } }
		 */
		
		/*
		 * if(!hasActionErrors()) { if(this.getTaxReceiptStartDate().equals("") ||
		 * this.getTaxReceiptEndDate().equals("")) {
		 * addActionError("Please provide tax receipt start and end date!"); } }
		 */
		if(!hasActionErrors())
		{
			String isVehicleAdded = "false";
			
			String [] result = new String[2];
			String condition  = "NA";
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_vehicle_details_master", "vehicle_registration_number", condition, this.getVehicleRegistrationNumber().trim().toUpperCase());
			
			isVehicleAdded = result[0];
			
			if(isVehicleAdded.equals("true"))
			{
				addActionError(this.getText("message.error.vehiclewithThisRegistrationNumberIsAlreadyAdded"));
			}		
		}
		
		/*
		 * if(!hasActionErrors()) { if(this.getInsurancePDF() != null) { int sizeOfImage
		 * =(int)this.getInsurancePDF().length();
		 * 
		 * if(sizeOfImage > 1000000) {
		 * addActionError("Size of insurance file is large than 1000Kb!"); } } }
		 */
		
		/*
		 * if(!hasActionErrors()) { if(this.getTaxReceiptPDF() != null) { int
		 * sizeOfImage =(int)this.getTaxReceiptPDF().length();
		 * 
		 * if(sizeOfImage > 1000000) {
		 * addActionError("Size of tax receipt file is large than 1000Kb!"); } } }
		 */
	
		/*
		 * if(!hasActionErrors()) { if(this.getRtoPassingPDF() != null) { int
		 * sizeOfImage =(int)this.getRtoPassingPDF().length();
		 * 
		 * if(sizeOfImage > 1000000) {
		 * addActionError("Size of RTO passing file is large than 1000Kb!"); } } }
		 */
		
		if(!hasActionErrors())
		{
			if(this.getCarryingCapacityBrass() == null)
			{
				addActionError(this.getText("message.error.plzProvideCorrectCarryingBrassCapacity"));
			}
		}
		
		
		if(!hasActionErrors())

		{
			if(this.getCarryingCapacityCUM() == null)
			{
				addActionError(this.getText("message.error.plzProvideCorrectCumCarryingCapacity"));
			}
			
		}
			this.setAddSideBarJs("FALSE");
	} 
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getVehicleMake() {
		return vehicleMake;
	}
	public void setVehicleMake(String vehicleMake) {
		this.vehicleMake = vehicleMake;
	}
	public String getVehicleRegistrationNumber() {
		return vehicleRegistrationNumber;
	}
	public void setVehicleRegistrationNumber(String vehicleRegistrationNumber) {
		this.vehicleRegistrationNumber = vehicleRegistrationNumber;
	}
	public String getInsuranceCompanyName() {
		return insuranceCompanyName;
	}
	public void setInsuranceCompanyName(String insuranceCompanyName) {
		this.insuranceCompanyName = insuranceCompanyName;
	}
	public String getInsuranceContactNumber() {
		return insuranceContactNumber;
	}
	public void setInsuranceContactNumber(String insuranceContactNumber) {
		this.insuranceContactNumber = insuranceContactNumber;
	}
	public String getInsuranceStartDate() {
		return insuranceStartDate;
	}
	public void setInsuranceStartDate(String insuranceStartDate) {
		this.insuranceStartDate = insuranceStartDate;
	}
	public String getInsuranceEndDate() {
		return insuranceEndDate;
	}
	public void setInsuranceEndDate(String insuranceEndDate) {
		this.insuranceEndDate = insuranceEndDate;
	}
	public String getTaxReceiptStartDate() {
		return taxReceiptStartDate;
	}
	public void setTaxReceiptStartDate(String taxReceiptStartDate) {
		this.taxReceiptStartDate = taxReceiptStartDate;
	}
	public String getTaxReceiptEndDate() {
		return taxReceiptEndDate;
	}
	public void setTaxReceiptEndDate(String taxReceiptEndDate) {
		this.taxReceiptEndDate = taxReceiptEndDate;
	}
	public File getInsurancePDF() {
		return insurancePDF;
	}
	public void setInsurancePDF(File insurancePDF) {
		this.insurancePDF = insurancePDF;
	}
	public File getTaxReceiptPDF() {
		return taxReceiptPDF;
	}
	public void setTaxReceiptPDF(File taxReceiptPDF) {
		this.taxReceiptPDF = taxReceiptPDF;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getRtoPassingStartDate() {
		return rtoPassingStartDate;
	}

	public void setRtoPassingStartDate(String rtoPassingStartDate) {
		this.rtoPassingStartDate = rtoPassingStartDate;
	}

	public String getRtoPassingEndDate() {
		return rtoPassingEndDate;
	}

	public void setRtoPassingEndDate(String rtoPassingEndDate) {
		this.rtoPassingEndDate = rtoPassingEndDate;
	}

	public File getRtoPassingPDF() {
		return rtoPassingPDF;
	}

	public void setRtoPassingPDF(File rtoPassingPDF) {
		this.rtoPassingPDF = rtoPassingPDF;
	}

	public String getVehicleOwnerName() {
		return vehicleOwnerName;
	}

	public void setVehicleOwnerName(String vehicleOwnerName) {
		this.vehicleOwnerName = vehicleOwnerName;
	}

	public String getOwnerMobileNumber() {
		return ownerMobileNumber;
	}

	public void setOwnerMobileNumber(String ownerMobileNumber) {
		this.ownerMobileNumber = ownerMobileNumber;
	}

	public String getVehicleDriverName() {
		return vehicleDriverName;
	}

	public void setVehicleDriverName(String vehicleDriverName) {
		this.vehicleDriverName = vehicleDriverName;
	}

	public String getDriverMobileNumber() {
		return driverMobileNumber;
	}

	public void setDriverMobileNumber(String driverMobileNumber) {
		this.driverMobileNumber = driverMobileNumber;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public Float getCarryingCapacityBrass() {
		return carryingCapacityBrass;
	}

	public void setCarryingCapacityBrass(Float carryingCapacityBrass) {
		this.carryingCapacityBrass = carryingCapacityBrass;
	}

	public Float getCarryingCapacityCUM() {
		return carryingCapacityCUM;
	}

	public void setCarryingCapacityCUM(Float carryingCapacityCUM) {
		this.carryingCapacityCUM = carryingCapacityCUM;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)arg0; 
	}

	public String getPucPassingStartDate() {
		return pucPassingStartDate;
	}

	public void setPucPassingStartDate(String pucPassingStartDate) {
		this.pucPassingStartDate = pucPassingStartDate;
	}

	public String getPucPassingEndDate() {
		return pucPassingEndDate;
	}

	public void setPucPassingEndDate(String pucPassingEndDate) {
		this.pucPassingEndDate = pucPassingEndDate;
	}

	public File getPucPassingPDF() {
		return pucPassingPDF;
	}

	public void setPucPassingPDF(File pucPassingPDF) {
		this.pucPassingPDF = pucPassingPDF;
	}

	public File getGpsCertificatePDF() {
		return gpsCertificatePDF;
	}

	public void setGpsCertificatePDF(File gpsCertificatePDF) {
		this.gpsCertificatePDF = gpsCertificatePDF;
	}

	
	
	
	
}