package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.TaxDAO;
import com.stonecrusher.db.GetDBConnection;

public class AddNewTax extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4108681230226340561L;
	private HttpSession session;
	private String taxName;
	private String taxPercentage;
	private List<TaxDAO> taxList = new ArrayList<TaxDAO>();
	
	
	public AddNewTax() {

    	Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		session=ServletActionContext.getRequest().getSession(false); 
		String sql = "";
		String db = (String) session.getAttribute("db");
		
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");
		
		
		try
		{
			connection = new GetDBConnection().getDBConnection(db);
			
			
			sql = "SELECT "
					+ "tax_name,"
					+ "tax_percentage "
					+ "FROM "
					+ "crusher_tax_table "
					+ "WHERE "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ? "
					+ "order by tax_percentage";
			
			
			
			preparedStatement = connection.prepareStatement(sql);
			preparedStatement.setString(1, crusherId);
			preparedStatement.setString(2, crusherCode);
			
			
			
			resultSet = preparedStatement.executeQuery();
			
			int serial = 1;
			
			while(resultSet.next())
			{
				TaxDAO taxDAO = new TaxDAO();
				taxDAO.setSerial(""+serial);
				taxDAO.setTaxName(resultSet.getString(1));
				taxDAO.setTaxPercentage((String)resultSet.getString(2));
				taxList.add(taxDAO);
				serial++;
			}
			
		} catch (SQLException e) {
			
			addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||"+this.getText("message.error.taxNotAdded"));
		} catch (IOException e) {
			
			
			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.taxNotAdded"));
		}finally {
			if(resultSet != null)
				{
					try {resultSet.close();}catch(SQLException sqe){}   					
				}
			if(preparedStatement != null)
			{
				try {preparedStatement.close();} catch (SQLException e) {}
			}
			if(connection != null)
			{
				
				try {connection.close();}catch (SQLException e) {}
			}
			
		}
	   

	}
	
	@Override
	public String execute() throws Exception {
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else
	        {
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
			
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
					connection = new GetDBConnection().getDBConnection(db);
					connection.setAutoCommit(false);
					
					sql = "insert into "
							+ "crusher_tax_table "
							+ "("
							+ "crusher_id,"
	        				+ "crusher_code,"
	        				+ "tax_name,"
							+ "tax_percentage) values (?,?,?,?)";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
	        		preparedStatement.setString(2, crusherCode);
	        		preparedStatement.setString(3, taxName);
					preparedStatement.setFloat(4, Float.parseFloat(taxPercentage));
					
					int i = preparedStatement.executeUpdate();
				
					
					
					if(i>0)
					{
						int serial = taxList.size()+1;
						TaxDAO taxDAO = new TaxDAO();
						taxDAO.setSerial(""+serial);
						taxDAO.setTaxName(getTaxName());
						taxDAO.setTaxPercentage(getTaxPercentage());
						taxList.add(taxDAO);
						setTaxName("");
						setTaxPercentage("");
						connection.commit();
						result= "success";
						addActionMessage(this.getText("message.success.newTaxAddedSuccessfully"));
					}
					else
					{
						result= "error";
						addActionError(this.getText("message.error.taxNotAdded"));
					}
					
				} catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || " +this.getText("message.error.taxNotAdded"));
				} catch (IOException e) {
					result = "error";
					
					addActionError(e.getMessage()+" || "+e.getCause()+" || " +this.getText("message.error.taxNotAdded"));
				}finally {
					
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
	        	
	        }
		
		return result;
	}
	
	
	@Override
	public void validate() {
		session=ServletActionContext.getRequest().getSession(false); 
		
		
		if(getTaxName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvidetaxName"));
		}
		else if(getTaxPercentage().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideTaxPercentage"));
		}
		
		
		if(!hasActionErrors())
		{
			
			try
			{
				Float.parseFloat(taxPercentage);
			}
			catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzProvideAppropriatePercentageValue"));
			}
		}
		
		if(!hasActionErrors())
		{
			String crusherId = (String) session.getAttribute("crusherId");
    		String crusherCode = (String) session.getAttribute("crusherCode");
    		
    		
			Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			session=ServletActionContext.getRequest().getSession(false); 
			String sql = "";
			String db = (String) session.getAttribute("db");
			
			try
			{
				connection = new GetDBConnection().getDBConnection(db);
				sql = "select * "
						+ "from crusher_tax_table where tax_name=? and tax_percentage=? and crusher_id=? and crusher_code=?";
				
				
				preparedStatement = connection.prepareStatement(sql);
				
				preparedStatement.setString(1, getTaxName());
				preparedStatement.setFloat(2, Float.parseFloat(getTaxPercentage()));
				preparedStatement.setString(3, crusherId);
        		preparedStatement.setString(4, crusherCode);
        		
				resultSet = preparedStatement.executeQuery();
				
				
				if(resultSet.next())
				{
					
					addActionError(getTaxName()+this.getText("message.error.isAlreadyAdded"));
					setTaxName("");
					setTaxPercentage("");
				}
				
			} catch (SQLException e) {
				e.printStackTrace();
				addActionError(e.getErrorCode()+" || "+e.getMessage());
			} catch (Exception e) {
				e.printStackTrace();
				addActionError(e.getMessage()+" || "+e.getCause());
			}finally {
				if(resultSet != null)
   				{
   					try {resultSet.close();}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close();} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();}catch (SQLException e) {}
				}
				
			}
		}
		
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getTaxName() {
		return taxName;
	}
	public void setTaxName(String taxName) {
		this.taxName = taxName;
	}
	public String getTaxPercentage() {
		return taxPercentage;
	}
	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}
	public List<TaxDAO> getTaxList() {
		return taxList;
	}
	public void setTaxList(List<TaxDAO> taxList) {
		this.taxList = taxList;
	}

	
	
	
}
