package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class AddNewSite extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6755442233479762552L;
	private SessionMap<String,Object> sessionMap;  
	
	private String siteName;
	private String siteAddress;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	 
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	         	
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					

					sql = "SELECT "
							+ "site_code "
							+ "FROM "
							+ "side_details_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ "site_code "
							+ "DESC LIMIT 1;";
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				int entryId = 1;
				
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						entryId =resultSet.getInt(1);
						
						
						entryId = entryId+1;
					}
					else
					{
						entryId =1;
					}
				}
					
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(preparedStatement != null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				
			  	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	       
					
					sql = "INSERT INTO "
							+ "side_details_master "
							+ "("
							+ "crusher_id,"
							+ "crusher_code,"
							+ "site_code,"
							+ "site_name,"
							+ "site_address,"
							+ "site_created_on_date"
							+ ") "
							+ "VALUES "
							+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'))";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setInt(3, entryId);
					preparedStatement.setString(4, this.getSiteName().trim().toUpperCase());
					preparedStatement.setString(5, this.getSiteAddress().trim().toUpperCase());
					
					preparedStatement.setString(6, dateFormat.format(d));
					
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						result = SUCCESS;
						addActionMessage(this.getText("message.success.siteDetailsAddedSuccessfully"));
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
					}
					
					
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		
		if(this.getSiteName() == null || this.getSiteName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideSiteName"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getSiteAddress() == null || this.getSiteAddress().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideSiteAddress"));
			}
		}
	}
	public String getSiteName() {
		return siteName;
	}


	public void setSiteName(String siteName) {
		this.siteName = siteName;
	}


	public String getSiteAddress() {
		return siteAddress;
	}


	public void setSiteAddress(String siteAddress) {
		this.siteAddress = siteAddress;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



