package com.stonecrusher.add;


import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;
import com.stonecrusher.resource.GetListResource;


public class AddNewProduct extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1852634394058786218L;
	
	private HttpSession session;
	
	private String productAddDate;
	private String productName;
	private String puchaseRate;
	private String productNameMarathi ;
	
	private String salesRate;
	private String taxPercentage;
	private String Alias;
	private String saleUnit;
	private String purchaseUnit;
	private String lowStockCount;
	private String hsnCode;
	private String convertQuantity;
	
	private File productImage;
	private String key;
	
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> supplierList = new LinkedHashMap<String,String>();
	
	private String addSideBarJs;

	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	        	
	        	
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	         	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				HashMap<String,String> taxDetails = GetListResource.GetTaxNamePercentage(this.getTaxPercentage());
			
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						connection.setAutoCommit(false);
						


						sql = "SELECT "
								+ "product_id "
								+ "FROM "
								+ "crusher_product_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "product_id "
								+ "DESC LIMIT 1;";
						
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					int entryId = 1;
					
					if(resultSet.next())
					{
						if(!(resultSet.getString(1) == null))
						{
							entryId =resultSet.getInt(1);
							
							
							entryId = entryId+1;
						}
						else
						{
							entryId =1;
						}
					}
						
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(preparedStatement != null)
					{
						preparedStatement.close();
						preparedStatement = null;
					}
						taxList = GetListResource.GetTaxList();
						unitList = GetListResource.GetUnitList();
						supplierList = GetListResource.GetSupplierList();
						
						if(this.getProductImage() != null)
						{
							FileInputStream fis =  new FileInputStream(getProductImage());
							
							sql = "INSERT INTO crusher_product_master "
								+ "("
								+ "product_id,"
								+ "crusher_id,"
		        				+ "crusher_code,"
		        				+ "add_date,"
								+ "product_name_eng,"
								+ "product_name_mar,"
								+ "product_short_code,"
								+ "product_alias,"
								+ "low_stock_count,"
								+ "purchase_rate,"
								+ "customer_sales_price,"
								+ "dealer_sales_price,"
								+ "retailer_sales_price,"
								+ "tax_id,"
								+ "tax_percentage,"
								+ "purchase_unit,"
								+ "sales_unit,"
								+ "hsn_sac_code,"
								+ "stock_conversion_ratio,"
								+ "product_image,"
								+ "in_stock_quantity) "
								+ "values "
								+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setInt(1, entryId);
								preparedStatement.setString(2, crusherId);
				        		preparedStatement.setString(3, crusherCode);
				        		preparedStatement.setString(4, this.getProductAddDate());
								preparedStatement.setString(5, this.getProductName().toUpperCase().trim());
								preparedStatement.setString(6, this.getProductNameMarathi().trim());
								preparedStatement.setString(7, "NA");
								preparedStatement.setString(8, this.getAlias().toUpperCase());
								preparedStatement.setString(9, this.getLowStockCount());
								preparedStatement.setString(10, this.getPuchaseRate());
								preparedStatement.setString(11, this.getSalesRate());
								preparedStatement.setString(12, this.getSalesRate());
								preparedStatement.setString(13, this.getSalesRate());
								preparedStatement.setString(14, this.getTaxPercentage());
								preparedStatement.setString(15, taxDetails.get("TAX-PERCENTAGE"));
								preparedStatement.setString(16, this.getPurchaseUnit());
								preparedStatement.setString(17, this.getSaleUnit());
								preparedStatement.setString(18, this.getHsnCode());
								preparedStatement.setString(19, this.getConvertQuantity());
								preparedStatement.setBinaryStream(20, fis,(int)this.getProductImage().length());
								preparedStatement.setFloat(21, 0.0F);
								if(fis != null)
					        	{
					        		fis.close();
					        		fis = null;
					        	}
						}
						if(this.getProductImage() == null)
						{
							//System.out.print("Hello in insert");
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							sql = "INSERT INTO crusher_product_master "
									+ "("
									+ "product_id,"
									+ "crusher_id,"
			        				+ "crusher_code,"
			        				+ "add_date,"
									+ "product_name_eng,"
									+ "product_name_mar,"
									+ "product_short_code,"
									+ "product_alias,"
									+ "low_stock_count,"
									+ "purchase_rate,"
									+ "customer_sales_price,"
									+ "dealer_sales_price,"
									+ "retailer_sales_price,"
									+ "tax_id,"
									+ "tax_percentage,"
									+ "purchase_unit,"
									+ "sales_unit,"
									+ "hsn_sac_code,"
									+ "stock_conversion_ratio,"
									+ "in_stock_quantity) "
									+ "values "
									+ "(?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setInt(1, entryId);
									preparedStatement.setString(2, crusherId);
					        		preparedStatement.setString(3, crusherCode);
					        		preparedStatement.setString(4, this.getProductAddDate());
									preparedStatement.setString(5, this.getProductName().toUpperCase().trim());
									preparedStatement.setString(6, this.getProductNameMarathi().trim());
									preparedStatement.setString(7, "NA");
									preparedStatement.setString(8, this.getAlias().toUpperCase());
									preparedStatement.setString(9, this.getLowStockCount());
									preparedStatement.setString(10, this.getPuchaseRate());
									preparedStatement.setString(11, this.getSalesRate());
									preparedStatement.setString(12, this.getSalesRate());
									preparedStatement.setString(13, this.getSalesRate());
									preparedStatement.setString(14, this.getTaxPercentage());
									preparedStatement.setString(15, taxDetails.get("TAX-PERCENTAGE"));
									preparedStatement.setString(16, this.getPurchaseUnit());
									preparedStatement.setString(17, this.getSaleUnit());
									preparedStatement.setString(18, this.getHsnCode());
									preparedStatement.setString(19, this.getConvertQuantity());
									preparedStatement.setFloat(20, 0.0F);
								
						}
						
						
						
						
						int i = preparedStatement.executeUpdate();
								
						
								if(i>0)
								{
									connection.commit();
									result = "success";
									addActionMessage(this.getText("message.success.productDetailsAddedSuccessFully"));
								}
								else
								{
									addActionError(this.getText("message.error.productDetailsNotAddedPlzTryAgain"));
									result="error";
								}
						
					
					
	    	} catch (SQLException e) {
				result = ERROR;
				//e.printStackTrace();
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.productDetailsNotAdded"));
			} catch (IOException e) {
				result = ERROR;
				//e.printStackTrace();
				addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.productDetailsNotAdded"));
			}finally {
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection=null;}catch (SQLException e) {}
				}
				
			}
	        
	    
	      
	        
	        	result = "success";
	        }
	       
	        return result;
	}


	@Override
	public void validate() 
	{
		try {
			taxList = GetListResource.GetTaxList();
			unitList = GetListResource.GetUnitList();
			supplierList = GetListResource.GetSupplierList();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	
		if(getProductName().equals("") || getProductNameMarathi().equals("" ) || getAlias().equals("") || getLowStockCount().equals("") 
				|| getPuchaseRate().equals("") || getSalesRate().equals("") || getTaxPercentage().equals("") 
				|| getSaleUnit().equals("") || getPurchaseUnit().equals("") || getHsnCode().equals("") 
				|| getConvertQuantity().equals(""))
		{
			addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
		}
		
		if(!hasActionErrors())
		{
			String isAliasAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_eng", "NA", getProductName());
			
			isAliasAdded = result[0];
			
			if(isAliasAdded.equals("true"))
			{
				addActionError(this.getText("message.error.productIsAlreadyAddedWithSameName"));
			}				
			
		}
		
		if(!hasActionErrors())
		{
			String isAliasAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_name_mar", "NA", getProductNameMarathi());
			
			isAliasAdded = result[0];
			
			if(isAliasAdded.equals("true"))
			{
				addActionError(this.getText("message.error.productIsAlreadyAddedWithSameMarathiName"));
			}				
			
		}
		
		if(!hasActionErrors())
		{
			String isAliasAdded = "false";
			
			String [] result = new String[2];
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_product_master", "product_alias", "NA", getAlias());
			
			isAliasAdded = result[0];
			
			if(isAliasAdded.equals("true"))
			{
				addActionError(this.getText("message.error.aliasIsAlreadyAdded"));
			}				
			
		}
		if(!hasActionErrors())
		{
			try
			{
				Float.parseFloat(getPuchaseRate());
			}
			catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzProvideCorrectPurchaseRate"));
			}
		}
		
		if(!hasActionErrors())
		{
			try
			{
				Float.parseFloat(getSalesRate());
			}
			catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzprovideCorrectSalesRate"));
			}
		}
		if(!hasActionErrors())
		{
			try
			{
				Integer.parseInt(getLowStockCount());
			}
			catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.plzProvideCorrectLowStockCount"));
			}
		}
		
		
		this.setAddSideBarJs("FALSE");
		
		
	}
	
	
	public HttpSession getSession() {
		return session;
	}



	public void setSession(HttpSession session) {
		this.session = session;
	}



	public String getProductAddDate() {
		return productAddDate;
	}



	public void setProductAddDate(String productAddDate) {
		this.productAddDate = productAddDate;
	}



	public String getProductName() {
		return productName;
	}



	public void setProductName(String productName) {
		this.productName = productName;
	}



	public String getPuchaseRate() {
		return puchaseRate;
	}



	public void setPuchaseRate(String puchaseRate) {
		this.puchaseRate = puchaseRate;
	}



	public String getProductNameMarathi() {
		return productNameMarathi;
	}



	public void setProductNameMarathi(String productNameMarathi) {
		this.productNameMarathi = productNameMarathi;
	}



	public String getSalesRate() {
		return salesRate;
	}



	public void setSalesRate(String salesRate) {
		this.salesRate = salesRate;
	}




	public String getTaxPercentage() {
		return taxPercentage;
	}



	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}



	public String getAlias() {
		return Alias;
	}



	public void setAlias(String alias) {
		Alias = alias;
	}






	public String getSaleUnit() {
		return saleUnit;
	}


	public void setSaleUnit(String saleUnit) {
		this.saleUnit = saleUnit;
	}


	public String getPurchaseUnit() {
		return purchaseUnit;
	}


	public void setPurchaseUnit(String purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}


	public String getHsnCode() {
		return hsnCode;
	}


	public void setHsnCode(String hsnCode) {
		this.hsnCode = hsnCode;
	}


	public String getConvertQuantity() {
		return convertQuantity;
	}


	public void setConvertQuantity(String convertQuantity) {
		this.convertQuantity = convertQuantity;
	}


	public String getLowStockCount() {
		return lowStockCount;
	}



	public void setLowStockCount(String lowStockCount) {
		this.lowStockCount = lowStockCount;
	}



	public Map<String, String> getTaxList() {
		return taxList;
	}



	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}



	public Map<String, String> getUnitList() {
		return unitList;
	}



	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}


	public File getProductImage() {
		return productImage;
	}


	public void setProductImage(File productImage) {
		this.productImage = productImage;
	}


	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public Map<String, String> getSupplierList() {
		return supplierList;
	}


	public void setSupplierList(Map<String, String> supplierList) {
		this.supplierList = supplierList;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	
	
	
	
	

}
