package com.stonecrusher.add;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class AddNewAccountHead extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;
	private String accountHeadCode;
	private String accountHeadName;
	private String accountHeadDesc;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "INSERT INTO "
							+ "crusher_daily_expenses_head_master "
							+ "("
							+ "crusher_id,"
	        				+ "crusher_code,"
	        				+ "head_name) "
							+ "VALUES "
							+ "(?,?,?)";
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, crusherId);
	        		preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, this.getAccountHeadName().trim().toUpperCase());
				
					int rowCount = preparedStatement.executeUpdate();
					
					if(rowCount >0)
					{
						this.setAccountHeadCode("");
						this.setAccountHeadName("");
						
						result = SUCCESS;
						addActionMessage(this.getText("message.success.accountHeadAddedSuccessfully"));
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.accountHeadNotAddedPlzTryAgain"));
					}
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.accountHeadDetailsNotAdded"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.accountHeadDetailsNotAdded"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	@Override
	public void validate() {
		
		Map<String,String> specialChars = new HashMap<String,String>(); 
		specialChars.put("!", "!");
		specialChars.put("@", "@");
		specialChars.put("$", "$");
		specialChars.put("%", "%");
		specialChars.put("^", "^");
		specialChars.put("&", "&");
		specialChars.put("*", "*");
		specialChars.put("(", "(");
		specialChars.put(")", ")");
		
	
		if(!hasActionErrors())
		{
			if(this.getAccountHeadName() == null || this.getAccountHeadName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideAccountHeadName"));
			}
			else if(this.getAccountHeadName().length() > 25)
			{
				addActionError(this.getText("message.error.characterLegthOfAccountHeadNameIsMoreThan25Characters"));
			}
			
		}
		
	
	}
	
	
	
	
	public String getAccountHeadCode() {
		return accountHeadCode;
	}


	public void setAccountHeadCode(String accountHeadCode) {
		this.accountHeadCode = accountHeadCode;
	}


	public String getAccountHeadName() {
		return accountHeadName;
	}


	public void setAccountHeadName(String accountHeadName) {
		this.accountHeadName = accountHeadName;
	}


	public String getAccountHeadDesc() {
		return accountHeadDesc;
	}


	public void setAccountHeadDesc(String accountHeadDesc) {
		this.accountHeadDesc = accountHeadDesc;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}