package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class AddLaborSalaryDetails extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5543099235530390172L;

	private SessionMap<String,Object> sessionMap;
	private String customerSearchOption;
	private String defaultValue;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private HashMap<String,String> typeOfBalanceAmountList = new LinkedHashMap<String,String>();
	
	private HttpSession session;
	private String typeOfSalaryPayment;
	private Float salaryAmount;
	private String laborId;
	private String laborName;
	private String typeOfOpeningBal;
	private Float balanceAmount;

	private HashMap<String,String> typeOfSalaryPaymentList = new LinkedHashMap<String,String>();
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				
				customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				
				try
				{
					
					int rowAdded = 0;
					connection = GetDBConnection.getDBConnection(db);
					sql = "INSERT INTO "
							+ "crusher_employee_salary_details "
							+ "(employee_id,"
							+ "crusher_id,"
	        				+ "crusher_code,"
	        				+ "employee_name,"
							+ "employee_salary_type,"
							+ "employee_salary_amount,"
							+ "opening_bal_type,"
							+ "opening_balance_amount) "
							+ "VALUES "
							+ "(?,?,?,?,?,?,?,?)";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getLaborId());
					preparedStatement.setString(2, crusherId);
	        		preparedStatement.setString(3, crusherCode);
	        		preparedStatement.setString(4, this.getLaborName().trim().toUpperCase());
					preparedStatement.setString(5, this.getTypeOfSalaryPayment());
					preparedStatement.setFloat(6, this.getSalaryAmount());
					preparedStatement.setString(7, this.getTypeOfOpeningBal());
					preparedStatement.setFloat(8, this.getBalanceAmount());
					
					rowAdded = preparedStatement.executeUpdate();
							
					if(rowAdded >  0)
					{
						addActionMessage(this.getText("message.success.employeeSalaryDetailsAddedSuccessfully"));
						result = SUCCESS;				
					}
					else
					{
						addActionError(this.getText("message.error.employeeSalaryDetailsNotAddedPlzTryAgain"));
						result = ERROR;	
					}
					
				}
				catch (SQLException e) {
					e.printStackTrace();
					result = ERROR;				
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.employeeSalarydetailsNotAdded"));
				
				} catch (Exception e) {
					e.printStackTrace();
					result = ERROR;			
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.employeeSalarydetailsNotAdded"));
				
				}finally {
					
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
        		
					
	        }
	        
	        
	      return  result;
	}
	
	@Override
	public void validate() {
		if(this.getSalaryAmount() == null || this.getSalaryAmount().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCorrectSalaryAmount"));
		}
		
		if(this.getTypeOfSalaryPayment() == null || this.getTypeOfSalaryPayment().equals("")){
			addActionError(this.getText("message.error.plzSelectTypeOfSalaryPayment"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getTypeOfOpeningBal() == null || this.getTypeOfOpeningBal().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectTypeOfOpeningBalanceType"));
			}
		}
		if(!hasActionErrors())
		{
			if(this.getBalanceAmount() == null || this.getBalanceAmount().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectBalanceAmount"));
			}
		}
		
		this.getTypeOfSalaryPaymentList().put("MONTHLY", "MONTHLY");
    	this.getTypeOfSalaryPaymentList().put("PERHOURBASIS", "PER HOUR BASIS");
    	this.getTypeOfSalaryPaymentList().put("DAILY", "DAILY");
    	this.getTypeOfSalaryPaymentList().put("WORKBASIS", "WORK BASIS");
    	this.getTypeOfSalaryPaymentList().put("WEEKLY", "WEEKLY");
    	
    	
    	this.getTypeOfBalanceAmountList().put("ADVANCE", "ADVANCE");
    	this.getTypeOfBalanceAmountList().put("PENDING", "PENDING");
	}
	
	public String getCustomerSearchOption() {
		return customerSearchOption;
	}


	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}


	public String getDefaultValue() {
		return defaultValue;
	}


	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}


	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getTypeOfSalaryPayment() {
		return typeOfSalaryPayment;
	}


	public void setTypeOfSalaryPayment(String typeOfSalaryPayment) {
		this.typeOfSalaryPayment = typeOfSalaryPayment;
	}


	public Float getSalaryAmount() {
		return salaryAmount;
	}


	public void setSalaryAmount(Float salaryAmount) {
		this.salaryAmount = salaryAmount;
	}


	public String getLaborId() {
		return laborId;
	}


	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}


	public String getLaborName() {
		return laborName;
	}


	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}


	public HashMap<String, String> getTypeOfSalaryPaymentList() {
		return typeOfSalaryPaymentList;
	}

	public void setTypeOfSalaryPaymentList(HashMap<String, String> typeOfSalaryPaymentList) {
		this.typeOfSalaryPaymentList = typeOfSalaryPaymentList;
	}

	public HashMap<String, String> getTypeOfBalanceAmountList() {
		return typeOfBalanceAmountList;
	}

	public void setTypeOfBalanceAmountList(HashMap<String, String> typeOfBalanceAmountList) {
		this.typeOfBalanceAmountList = typeOfBalanceAmountList;
	}

	public String getTypeOfOpeningBal() {
		return typeOfOpeningBal;
	}

	public void setTypeOfOpeningBal(String typeOfOpeningBal) {
		this.typeOfOpeningBal = typeOfOpeningBal;
	}


	public Float getBalanceAmount() {
		return balanceAmount;
	}

	public void setBalanceAmount(Float balanceAmount) {
		this.balanceAmount = balanceAmount;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
}
