package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class AddLaborPresentyDetails extends ActionSupport implements SessionAware{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -1002181125915309484L;
	private SessionMap<String,Object> sessionMap; 
	
	private String markingDate;
	private String LaborIdName;
	private String typeOfMarking;
	private String details;
	private String addSideBarJs;
	private Map<String,String> typeOfMarkingMap = new HashMap<String,String>();
	public String execute() {
		 
		String result = "login";
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

				String user = (String) this.getSessionMap().get("userFullName");
				String shortName = "";
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet  resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				try
				{
					String [] laborDetails = this.getLaborIdName().split("-");
					
					String laborId = laborDetails[0];
					String laborName = laborDetails[1];
					String laborMobile = laborDetails[2];
					
					
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					

					sql = "SELECT "
							+ "entry_id "
							+ "FROM "
							+ "crusher_employee_presenty_details "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ "entry_id "
							+ "DESC LIMIT 1;";
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				int entryId = 0;
				
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						entryId =resultSet.getInt(1);
						
						
						entryId = entryId+1;
					}
					else
					{
						entryId =1;
					}
				}
					
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(preparedStatement != null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				
				java.util.Date date = new java.util.Date();
	      	      long t = date.getTime();	        	     
	      	      java.sql.Time time = new java.sql.Time(t);
					sql = "INSERT INTO "
							+ "crusher_employee_presenty_details "
							+ "(entry_id,"
							+ "crusher_id,"
	        				+ "crusher_code,"
	        				+ "marking_date,"
							+ "marking_time,"
							+ "employee_id,"
							+ "employee_name,"
							+ "type_of_marking,"
							+ "details,"
							+ "entry_by) "
							+ "VALUES "
							+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?)";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setInt(1, entryId);
					preparedStatement.setString(2, crusherId);
	        		preparedStatement.setString(3, crusherCode);
	        		preparedStatement.setString(4, this.getMarkingDate());
					preparedStatement.setTime(5, time);
					preparedStatement.setString(6, laborId);
					preparedStatement.setString(7, laborName);
					preparedStatement.setString(8, this.getTypeOfMarking());
					preparedStatement.setString(9, this.getDetails());
					preparedStatement.setString(10, shortName);
					
					int k = preparedStatement.executeUpdate();
					
					if(k>0)
					{
						connection.commit();
						result = SUCCESS;
						addActionMessage(this.getText("message.success.employeeAbsent/HalfDay/OverTimeDetailsAddedSuccessfully"));
						
						this.setLaborIdName("");
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
					}
					
				}catch (SQLException e) {
					e.printStackTrace();
					try {
						connection.rollback();
					} catch (SQLException e1) {}
					result = ERROR;
					addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
				} catch (IOException e) {
					
					result = ERROR;
					addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
				}finally {
				if(resultSet !=null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();
					 connection = null;
					}catch (SQLException e) {}
				}
				
				  
			}
	        }
	        
	     return result ;
	}
	@Override
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		
		
		
		if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideEmployeeDetails"));
		}
		else
		{
			try
			{
				int count = this.getLaborIdName().split("-").length;
				
				if(count!=3)
				{
					addActionError(this.getText("message.error.plzProvideCorrectEmployeeDetails"));
				}
			}
			catch (Exception e) {
				addActionError(this.getText("message.error.plzProvideCorrectEmployeeDetails"));
			}
		}
		
		if(!hasActionErrors())
		{
			String isCustomerAdded = "false";
			
			String [] result = new String[2];
			String condition = "AND marking_date = STR_TO_DATE('"+this.getMarkingDate()+"','%d-%m-%Y')";
			
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_employee_presenty_details", "employee_id", condition , getLaborIdName().split("-")[0]);
			
			isCustomerAdded = result[0];
			
			if(isCustomerAdded.equals("true"))
			{
				addActionError(this.getText("message.error.entryAlreadyAddedForThisEmployeeForThisDate"));
			}				
			
		}

    	this.getTypeOfMarkingMap().put("ABSENT", "ABSENT");
    	this.getTypeOfMarkingMap().put("HALFDAY", "HALF-DAY");
    	this.getTypeOfMarkingMap().put("OVERTIME", "OVER-TIME");
		
	}
	
	public String getMarkingDate() {
		return markingDate;
	}


	public void setMarkingDate(String markingDate) {
		this.markingDate = markingDate;
	}


	public String getLaborIdName() {
		return LaborIdName;
	}


	public void setLaborIdName(String laborIdName) {
		LaborIdName = laborIdName;
	}


	public String getTypeOfMarking() {
		return typeOfMarking;
	}


	public void setTypeOfMarking(String typeOfMarking) {
		this.typeOfMarking = typeOfMarking;
	}


	public String getDetails() {
		return details;
	}


	public void setDetails(String details) {
		this.details = details;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public Map<String, String> getTypeOfMarkingMap() {
		return typeOfMarkingMap;
	}
	public void setTypeOfMarkingMap(Map<String, String> typeOfMarkingMap) {
		this.typeOfMarkingMap = typeOfMarkingMap;
	}
	
	
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

}
