package com.stonecrusher.add;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class AddLaborPaymentDetails extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5871768542593266664L;
	
	
	private SessionMap<String,Object> sessionMap;  
	private String key;
	private String laborPaymentDate;
	private String laborId;
	private String laborName;
	private String laborMobile;
	private Float laborOutstandingAmount;
	private Float amount;
	private String typeOfPayment;
	private String accountId;
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private String details;
	private HttpSession session;
	private String addSideBarJs;
	private boolean paymentSaved;
	private String paymentId;

	public String execute() {
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	this.setAddSideBarJs("FALSE");
    			
				String user = (String) session.getAttribute("userFullName");
				String shortName = "";
				
				try
				{
					shortName = user.split(" ")[0];
				}catch(Exception e)
				{
					shortName = user;
				}
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet  resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					
					String laborId = EncryptionDecryption.decrypt(this.getKey());
					
					
					sql = "SELECT "
							+ "entry_id "
							+ "FROM "
							+ "crusher_employee_payment_details "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ "entry_id "
							+ "DESC LIMIT 1;";
					
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				int entryId = 0;
				
				if(resultSet.next())
				{
					if(!(resultSet.getString(1) == null))
					{
						entryId =resultSet.getInt(1);
						
						
						entryId = entryId+1;
					}
					else
					{
						entryId =1;
					}
				}
					
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(preparedStatement != null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				
				java.util.Date date = new java.util.Date();
      	      long t = date.getTime();	        	     
      	      java.sql.Time time = new java.sql.Time(t);
					
					sql = "INSERT "
							+ "INTO "
							+ "crusher_employee_payment_details "
							+ "("
							+ "entry_id,"
							+ "crusher_id,"
	        				+ "crusher_code,"
	        				+ "payment_date,"
							+ "payment_entry_time,"
							+ "employee_id,"
							+ "employee_name,"
							+ "payment_amount,"
							+ "payment_type,"
							+ "amount_debit_account_id,"
							+ "payment_details,"
							+ "entry_by) "
							+ "VALUES "
							+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?,?)";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setInt(1, entryId);
					preparedStatement.setString(2, crusherId);
	        		preparedStatement.setString(3, crusherCode);
	        		preparedStatement.setString(4, this.getLaborPaymentDate());
					preparedStatement.setTime(5, time);
					preparedStatement.setString(6, laborId);
					preparedStatement.setString(7, this.getLaborName());
					preparedStatement.setFloat(8, this.getAmount());
					preparedStatement.setString(9, this.getTypeOfPayment());
					preparedStatement.setString(10, this.getAccountId());
					preparedStatement.setString(11, this.getDetails()); 
					preparedStatement.setString(12, shortName);
					
					int rowCount = preparedStatement.executeUpdate();
					
					if (rowCount > 0) 
					{
						this.setPaymentId(""+entryId);
						
	        			if(this.getTypeOfPayment().equals("CHEQUE"))
	        			{
    	        			
    	        			if(preparedStatement != null)
    	        			{
    	        				preparedStatement.close();
    	        				preparedStatement = null;
    	        			}
    	        			
    	        			sql = "UPDATE "
    	        					+ "cheque_book_details_master "
    	        					+ "SET "
    	        					+ "cheuqe_pay_date = STR_TO_DATE(?,'%d-%m-%Y'),"
    	        					+ "cheque_payee = ?,"
    	        					+ "cheque_amount = ?,"
    	        					+ "cheque_status = 'GIVEN',"
    	        					+ "chaque_status_change_date = STR_TO_DATE(?,'%d-%m-%Y'),"
    	        					+ "reason_for_cheque_given = ?,"
    	        					+ "status_changed_by = ? "
    	        					+ "WHERE "
    	        					+ "cheque_number = ? "
    	        					+ "AND "
    	        					+ "cheque_book_bank_name = ? "
    	        					+ "AND "
    	        					+ "cheque_book_branch_name = ? "
    	        					+ "AND "
    								+ "crusher_id = ? "
    								+ "AND "
    								+ "crusher_code = ? ";
    	        			
    	        			preparedStatement = connection.prepareStatement(sql);
    	        			
    	        			preparedStatement.setString(1, this.getChequePayDate());
    	        			preparedStatement.setString(2, this.getChequePayee().trim().toUpperCase());
    	        			preparedStatement.setFloat(3, this.getAmount());
    	        			preparedStatement.setString(4, this.getLaborPaymentDate());
    	        			preparedStatement.setString(5, "EMPLOYEE PAYMENT TO "+this.getLaborName().trim().toUpperCase());
    	        			preparedStatement.setString(6, shortName);
    	        			preparedStatement.setString(7, this.getChequeNumber());
    	        			preparedStatement.setString(8, this.getBankName());
    	        			preparedStatement.setString(9, this.getBranchName());
    	        			preparedStatement.setString(10, crusherId);
    	    				preparedStatement.setString(11, crusherCode);
    	    				
    	        			int rowCountUpdated = preparedStatement.executeUpdate();
    	        			
    	        			if(rowCountUpdated > 0)
    	        			{
    	        				addActionMessage(this.getText("message.success.chequeDetailsUpdatedSuccessfully"));
    	        			}
    	        			else
    	        			{
    	        				addActionError(this.getText("message.error.couldNotUpdateChequeDetails"));
    	        			}
	        			}
	        		
	        			
	        			
	        			
	        			if(!this.getTypeOfPayment().equals("CHEQUE"))
	        			{

	        				sql = "SELECT "
									+ "entry_id "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY "
									+ "entry_id "
									+ "DESC LIMIT 1;";
							
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						int entryAccountId = 1;
					
						if(resultSet.next())
						{
							if(!(resultSet.getString(1) == null))
							{
								entryAccountId = Integer.parseInt(resultSet.getString(1));
								entryAccountId = entryAccountId + 1;
								
							}
							
						}
						else
						{	entryAccountId =1;
							
						}
						
		        		
	        				
	        				if(resultSet != null)
	    	        		{
	    	        			resultSet.close();
	    	        			resultSet = null;
	    	        		}
	    	        		if(preparedStatement!= null)
	    	        		{
	    	        			preparedStatement.close();
	    	        			preparedStatement = null;
	    	        		}
	        				
	    	        		String accountNumber = "";
	    	        		sql = "SELECT "
	    	        				+ "account_number "
	    	        				+ "FROM "
	    	        				+ "crusher_bank_account "
	    	        				+ "WHERE "
	    	        				+ "account_id  = ?"
	    	        				+ "AND "
    								+ "crusher_id = ? "
    								+ "AND "
    								+ "crusher_code = ? ";
	    	        			
	    	        		preparedStatement = connection.prepareStatement(sql);
	    	        		
	    	        		preparedStatement.setString(1, this.getAccountId());
	    	        		preparedStatement.setString(2, crusherId);
	    					preparedStatement.setString(3, crusherCode);
	    					
	    	        		resultSet = preparedStatement.executeQuery();
	    	        		if(resultSet.next())
	    	        		{
	    	        			accountNumber = resultSet.getString(1);
	    	        		}
	    	        		

	    	        		if(resultSet != null)
	    	        		{
	    	        			resultSet.close();
	    	        			resultSet = null;
	    	        		}
	    	        		if(preparedStatement!= null)
	    	        		{
	    	        			preparedStatement.close();
	    	        			preparedStatement = null;
	    	        		}
	    						
	    						sql = "INSERT "
	    								+ "INTO "
	    								+ "bank_account_credit_debit_master "
	    								+ "("
	    								+ "entry_id,"
	    								+ "crusher_id,"
	    		        				+ "crusher_code,"
	    		        				+ "account_id,"
	    								+ "account_number,"
	    								+ "entry_date,"
	    								+ "entry_time,"
	    								+ "entry_type,"
	    								+ "amount,"
	    								+ "payment_type,"
	    								+ "entry_by,"
	    								+ "entry_details,"
	    								+ "entry_source) "
	    								+ "VALUES "
	    								+ "(?,?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?,?,?,?)";
	    						
	    						preparedStatement = connection.prepareStatement(sql);
	    						
	    						preparedStatement.setInt(1, entryAccountId);
	    						preparedStatement.setString(2, crusherId);
	    		        		preparedStatement.setString(3, crusherCode);
	    		        		preparedStatement.setString(4, this.getAccountId());
	    						preparedStatement.setString(5, accountNumber);
	    						preparedStatement.setString(6, this.getLaborPaymentDate());
	    						preparedStatement.setTime(7, time);
	    						preparedStatement.setString(8, "DEBIT");
	    						preparedStatement.setFloat(9, this.getAmount());
	    						preparedStatement.setString(10, this.getTypeOfPayment());
	    						preparedStatement.setString(11, shortName);
	    						preparedStatement.setString(12, "EMPLOYEE PAYMENT TO "+this.getLaborName().trim().toUpperCase());
	    						preparedStatement.setString(13, "EMPLOYEE PAYMENT ");
								
	    						int rowInsetred = preparedStatement.executeUpdate();
	        				
	    						
	    						boolean isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getLaborPaymentDate(), this.getAmount(), shortName, connection, this.getSessionMap());
    							
	    						if(rowInsetred > 0 && isCloseingBalMaintained)
	    						{
	    							
	    							sql = "UPDATE "
	        	        					+ "crusher_employee_payment_details "
	        	        					+ "SET "
	        	        					+ "credit_debit_id = ? "
	        	        					+ "WHERE "
	    									+ "entry_id = ? "
	    									+ "AND "
	    									+ "crusher_id = ? "
	    									+ "AND "
	    									+ "crusher_code = ? ";
	        	        			
	        	        			
		    						preparedStatement = connection.prepareStatement(sql);
		    						
		    						preparedStatement.setInt(1, entryAccountId);
		    						preparedStatement.setInt(2, entryId);
		    						preparedStatement.setString(3, crusherId);
		    		        		preparedStatement.setString(4, crusherCode);
		    		        		
		    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
		        				
		    						
		    						
		    						if(rowCreditDebitIdInsetred > 0 )
		    						{
		    							this.setPaymentSaved(true);
	        		       				
		    	        				connection.commit();
		    	        				result = SUCCESS;
		    	        				addActionMessage(this.getText("message.success.employeePaymentDetailsAddedSuccessfully"));
		    						}
		    						
		    						
	    	        				
	    						}
	    						else
	    						{
	    							connection.rollback();
	    							result = ERROR;
	    							addActionError(this.getText("message.error.employeePaymentCouldNotBeAddedPlzTryAgain"));
	    						}
	        			}
	        			
	        			else if(this.getTypeOfPayment().equals("CHEQUE") && !hasActionErrors())
	        			{
	        				this.setPaymentSaved(true);
		       				
	        				addActionMessage(this.getText("message.success.employeePaymentDetailsAddedSuccessfully"));
	        				connection.commit();
	        				result = "success";
	        			}
	        			else
	        			{
	        				connection.rollback();
	        				result = "error";
	        				addActionError(this.getText("message.error.employeePaymentDetailsCouldNotBeAdded(cheque)PlzTryAgain"));
	        			}
						
					
						
					}
					else
					{
						connection.rollback();
						result = "error";
        				addActionError(this.getText("message.error.employeePaymentDetailsCouldNotBeAdded(cheque)PlzTryAgain"));
					}
					
				
				}catch (SQLException e) {
					e.printStackTrace();
					try {
						connection.rollback();
					} catch (SQLException e1) {}
					result = ERROR;
					addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
				} catch (IOException e) {
					
					result = ERROR;
					addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
				}finally {
				if(resultSet !=null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();
					 connection = null;
					}catch (SQLException e) {}
				}
				
				  
			}
	        }
	        
	     return result ;
	}

	@Override
	public void validate() {
		this.setAddSideBarJs("FALSE");
		
		session=ServletActionContext.getRequest().getSession(false);
    	paymentTypeList.add("CASH");
    	paymentTypeList.add("UPI");
    	paymentTypeList.add("RTGS");
    	paymentTypeList.add("NEFT");
    	paymentTypeList.add("CHEQUE");
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
    	
    	
    	if(this.getAmount() == null || this.getAmount().equals("") || this.getAmount()<0)
    	{
    		addActionError(this.getText("message.error.plzProvideCorrectAmount"));
    	}
    	
    	if(!hasActionErrors())
    	{
    		if(this.getTypeOfPayment() == null || this.getTypeOfPayment().equals(""))
    		{
    			addActionError(this.getText("message.error.plzProvideTypeOfPayment"));
    		}
    	}
    	
    		
    	if(!hasActionErrors()){
    		if(this.getAccountId() == null || this.getAccountId().equals(""))
    		{
    			addActionError(this.getText("message.error.plzSelectAccountForDebitEntry"));
    		}
    	}
    	
    	
		
	}
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getLaborPaymentDate() {
		return laborPaymentDate;
	}

	public void setLaborPaymentDate(String laborPaymentDate) {
		this.laborPaymentDate = laborPaymentDate;
	}

	public String getLaborId() {
		return laborId;
	}

	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}

	public String getLaborMobile() {
		return laborMobile;
	}

	public void setLaborMobile(String laborMobile) {
		this.laborMobile = laborMobile;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public Float getLaborOutstandingAmount() {
		return laborOutstandingAmount;
	}

	public void setLaborOutstandingAmount(Float laborOutstandingAmount) {
		this.laborOutstandingAmount = laborOutstandingAmount;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public List<String> getBankList() {
		return bankList;
	}

	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}

	public List<String> getBranchList() {
		return branchList;
	}

	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}

	public List<String> getChequeList() {
		return chequeList;
	}

	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public String getTypeOfPayment() {
		return typeOfPayment;
	}

	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public String getChequePayDate() {
		return chequePayDate;
	}

	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}

	public String getChequePayee() {
		return chequePayee;
	}

	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranchName() {
		return branchName;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}

	public String getChequeNumber() {
		return chequeNumber;
	}

	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public boolean isPaymentSaved() {
		return paymentSaved;
	}

	public void setPaymentSaved(boolean paymentSaved) {
		this.paymentSaved = paymentSaved;
	}

	public String getPaymentId() {
		return paymentId;
	}

	public void setPaymentId(String paymentId) {
		this.paymentId = paymentId;
	}

}
